{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetViewpoint: TAbstractX3DViewpointNode;
    procedure SetViewpoint(const Value: TAbstractX3DViewpointNode);
    function GetTextureProperties: TTexturePropertiesNode;
    procedure SetTextureProperties(const Value: TTexturePropertiesNode);
    function GetRepeatR: boolean;
    procedure SetRepeatR(const Value: boolean);
  public
    procedure SetDimensions(const Value: array of LongInt);
    procedure SetDimensions(const Value: TLongIntList);
    property Viewpoint: TAbstractX3DViewpointNode read GetViewpoint write SetViewpoint;
    property TextureProperties: TTexturePropertiesNode read GetTextureProperties write SetTextureProperties;
    property RepeatR: boolean read GetRepeatR write SetRepeatR;
    procedure SetDepthMap(const Value: array of boolean);
    procedure SetDepthMap(const Value: TBooleanList);

{$endif read_interface}

{$ifdef read_implementation}

{ TRenderedTextureNode ----------------------------------------------- }

procedure TRenderedTextureNode.SetDimensions(const Value: array of LongInt);
begin
  FdDimensions.Send(Value);
end;

procedure TRenderedTextureNode.SetDimensions(const Value: TLongIntList);
begin
  FdDimensions.Send(Value);
end;

function TRenderedTextureNode.GetViewpoint: TAbstractX3DViewpointNode;
begin
  if FdViewpoint.Value is TAbstractX3DViewpointNode then
    Result := TAbstractX3DViewpointNode(FdViewpoint.Value)
  else
    Result := nil;
end;

procedure TRenderedTextureNode.SetViewpoint(const Value: TAbstractX3DViewpointNode);
begin
  FdViewpoint.Send(Value);
end;

function TRenderedTextureNode.GetTextureProperties: TTexturePropertiesNode;
begin
  if FdTextureProperties.Value is TTexturePropertiesNode then
    Result := TTexturePropertiesNode(FdTextureProperties.Value)
  else
    Result := nil;
end;

procedure TRenderedTextureNode.SetTextureProperties(const Value: TTexturePropertiesNode);
begin
  FdTextureProperties.Send(Value);
end;

function TRenderedTextureNode.GetRepeatR: boolean;
begin
  Result := FdRepeatR.Value;
end;

procedure TRenderedTextureNode.SetRepeatR(const Value: boolean);
begin
  FdRepeatR.Send(Value);
end;

procedure TRenderedTextureNode.SetDepthMap(const Value: array of boolean);
begin
  FdDepthMap.Send(Value);
end;

procedure TRenderedTextureNode.SetDepthMap(const Value: TBooleanList);
begin
  FdDepthMap.Send(Value);
end;

{$endif read_implementation}
