// Copyright (c) 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_PRERENDER_PRERENDER_EVENTS_H_
#define CHROME_BROWSER_PRERENDER_PRERENDER_EVENTS_H_

namespace prerender {

// Events registered during prerendering used for debugging purposes and to
// gather metrics.
enum PrerenderEvent {
  PRERENDER_EVENT_SWAPIN_NO_DELEGATE = 0,
  PRERENDER_EVENT_SWAPIN_CANDIDATE = 1,
  PRERENDER_EVENT_SWAPIN_CANDIDATE_NAMESPACE_MATCHES = 2,
  PRERENDER_EVENT_SWAPIN_NO_MERGE_PENDING = 3,
  PRERENDER_EVENT_SWAPIN_MERGING_DISABLED = 4,
  PRERENDER_EVENT_SWAPIN_ISSUING_MERGE = 5,
  PRERENDER_EVENT_MERGE_FOR_SWAPIN_CANDIDATE = 6,
  PRERENDER_EVENT_MERGE_RESULT_NO_PENDING_SWAPIN = 7,
  // Obsolete: PRERENDER_EVENT_MERGE_RESULT_TIMEOUT_CB = 8,
  // Obsolete: PRERENDER_EVENT_MERGE_RESULT_RESULT_CB = 9,
  PRERENDER_EVENT_MERGE_RESULT_TIMED_OUT = 10,
  PRERENDER_EVENT_MERGE_RESULT_MERGE_DONE = 11,
  PRERENDER_EVENT_MERGE_RESULT_RESULT_NAMESPACE_NOT_FOUND = 12,
  PRERENDER_EVENT_MERGE_RESULT_RESULT_NAMESPACE_NOT_ALIAS = 13,
  PRERENDER_EVENT_MERGE_RESULT_RESULT_NOT_LOGGING = 14,
  PRERENDER_EVENT_MERGE_RESULT_RESULT_NO_TRANSACTIONS = 15,
  PRERENDER_EVENT_MERGE_RESULT_RESULT_TOO_MANY_TRANSACTIONS = 16,
  PRERENDER_EVENT_MERGE_RESULT_RESULT_NOT_MERGEABLE = 17,
  PRERENDER_EVENT_MERGE_RESULT_RESULT_MERGEABLE = 18,
  PRERENDER_EVENT_MERGE_RESULT_MERGE_FAILED = 19,
  PRERENDER_EVENT_MERGE_RESULT_SWAPPING_IN = 20,
  // Obsolete: PRERENDER_EVENT_MERGE_RESULT_SWAPIN_SUCCESSFUL = 21,
  PRERENDER_EVENT_MERGE_RESULT_SWAPIN_FAILED = 22,
  PRERENDER_EVENT_MAX,
};

// Return a human-readable name for |event|.
const char* NameFromPrerenderEvent(PrerenderEvent event);

}  // namespace prerender

#endif  // CHROME_BROWSER_PRERENDER_PRERENDER_EVENTS_H_
