package enhancement;

import java.io.*;
import java.net.*;

import com.db4o.instrumentation.classfilter.*;
import com.db4o.instrumentation.core.*;
import com.db4o.instrumentation.main.*;
import com.db4o.nativequery.main.*;
import com.db4o.ta.instrumentation.*;

/**
 * Starts EnhancerMain with load time instrumentation.
 */
public class EnhancerStarter {

	public static void main(String[] args) throws Exception {
		ClassFilter filter = new ByNameClassFilter("enhancement.", true);
		BloatClassEdit[] edits = { new TranslateNQToSODAEdit() , new InjectTransparentActivationEdit(filter) };
		URL[] urls = { new File("/work/workspaces/db4o/tatest/bin").toURI().toURL() };
		Db4oInstrumentationLauncher.launch(edits, urls, EnhancerMain.class.getName(), new String[]{});
	}
	// end main

}
