#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "control_file.hpp"

#include <sjr/deb822.h>

#include <fstream>

control_file::control_file(void)
{
	return;
}

control_file::control_file(std::string const &filename)
{
	merge(filename);
	return;
}

void control_file::merge(std::string const &filename)
{
	std::ifstream file;
	file.exceptions(std::ios::badbit);
	file.open(filename.c_str());
	merge(file);
	return;
}

void control_file::merge(std::istream &stream)
{
	while(stream)
	{
		sjr::deb822_parser input(stream);

		if(!input)
			continue;

		if(input->key == "Package")
		{
			binary_section section(input->value);
			++input;

			while(input)
			{
				section[input->key] = input->value;
				++input;
			}
			bin.push_back(section);
		}
		else if(input->key == "Source")
		{
			source_section section(input->value);
			++input;

			while(input)
			{
				section[input->key] = input->value;
				++input;
			}
			src = section;
		}
		else
			throw unknown_section_type(input->key);
	}
}

bool control_file::operator==(control_file const &rhs) const
{
	if(src != rhs.src)
		return false;
	if(bin != rhs.bin)
		return false;
	return true;
}

source_section const &control_file::source(void) const
{
	return *src;
}

source_section &control_file::source(void)
{
	return *src;
}

control_file::binary_iterator control_file::find_binary(package_name const &name)
{
	binary_iterator i = binaries_begin();
	while(i != binaries_end())
		if(name == i->name)
			break;
		else
			++i;
	return i;
}

control_file::binary_const_iterator control_file::find_binary(package_name const &name) const
{
	binary_const_iterator i = binaries_begin();
	while(i != binaries_end())
		if(name == i->name)
			break;
		else
			++i;
	return i;
}

control_file_ostream &operator<<(control_file_ostream &stream, control_file const &control)
{
	stream << control.source();
	for(control_file::binary_const_iterator i = control.binaries_begin(); i != control.binaries_end(); ++i)
		stream << section_break << *i;
	return stream;
}
control_file::unknown_section_type::unknown_section_type(
		std::string const &type) :
	std::logic_error(std::string("unknown section type ") + type)
{
	return;
}
