/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <glib.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <dirent.h>

#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/poll.h>
#include <sys/stat.h>

#include <errno.h>

#include <unistd.h>

#ifndef __DSYSLOG_INCLUDE_RECURSION_GUARD
#define __DSYSLOG_INCLUDE_RECURSION_GUARD

#include "sysconf.h"
#include "confparse.h"

#include "dsyslog_module.h"

#include "dsyslog_source.h"
#include "dsyslog_event.h"
#include "dsyslog_filter.h"
#include "dsyslog_output.h"
#include "dsyslog_cond.h"
#include "dsyslog_perfctr.h"
#include "dsyslog_template.h"

/* severity stuff */
extern gint dsyslog_facility_to_logcode(const gchar *facility);
extern gint dsyslog_severity_to_logcode(const gchar *facility);

#define DSYSLOG_SEVMASK		0x07
#define DSYSLOG_FACMASK		0x03f8
#define DSYSLOG_GET_SEVERITY(p) ((p) & DSYSLOG_SEVMASK)
#define DSYSLOG_GET_FACILITY(p)	(((p) & DSYSLOG_FACMASK) >> 3)

/* dsyslog internal logging. */
extern void dsyslog_log(const gchar *format, ...);

/* handy debugging macros. */
#define _DMSG(tag, msg, ...) dsyslog_log("(%-5s) %s:%d [%s]: " msg, tag, __FILE__, __LINE__, __PRETTY_FUNCTION__, ##__VA_ARGS__)

#ifndef NDEBUG
# define _DEBUG(...)         _DMSG("DEBUG", __VA_ARGS__)
#else
# define _DEBUG(...)         {}
#endif

#define _WARN(...)           _DMSG("WARN", __VA_ARGS__)
#define _INFO(...)           _DMSG("INFO", __VA_ARGS__)
#define _ERROR(...)          _DMSG("ERROR", __VA_ARGS__)
#define _ENTER		     _DEBUG("enter")
#define _LEAVE               _DEBUG("leave"); return 

/* SOMAXCONN sanity stuff */
#ifndef SOMAXCONN
# define DSYSLOG_SOMAXCONN      5
#else
# define DSYSLOG_SOMAXCONN      SOMAXCONN
#endif

typedef struct {
    gboolean nofork;
    gboolean version;
    gboolean configtest;
    gchar *cfg;
} dsyslog_options_t;

extern dsyslog_options_t options;

#endif
