/* $Id: TypeFactory.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TYPE_FACTORY_HPP_INCLUDED
#define __TYPE_FACTORY_HPP_INCLUDED

#include "frontend/ast/Types.hpp"
#include "intermediate/container/Type.hpp"
#include <string>
#include <list>
#include <map>

namespace intermediate {

//! generate builtin 
class TypeFactory {
public:
	/** create a type with a name and a number of elements.
	 *  @param typeName declared name of the type.
	 *  @param relements list of elements of a composite type.
	 */
	static Type* 
	getType(
		std::string typeName,
		std::list<TypeElement*> relements
	);

	/** return the type name that corresponds to a base type.
	 *  @param bt base type (either integer or real)
	 *  @return fitting name to be used in intermediate code.
	 */
	static std::string getTypeName(enum ast::BaseType bt);

	/** lookup a type by the intermediate code name.
	 *  @return the found type or NULL if no such type is known.
	 */
	static Type*
	lookupType(std::string typeName);

private:
	// FIXME use hash_map or s.th.
	typedef std::map<std::string, Type*> typesNameT;

	/** info about created types by name */
	static typesNameT typesByName;

	/** initialize typesByName with builtins */
	static typesNameT initialize(void);
};

}; /* namespace intermediate */

#endif /* __TYPE_FACTORY_HPP_INCLUDED */
