/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.HashMap;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;

public class StructureDataW
extends StructureData {
    protected Map<StructureMembers.Member, Array> memberData = new HashMap<StructureMembers.Member, Array>();

    public StructureDataW(StructureMembers members) {
        super(members);
    }

    public void setMemberData(StructureMembers.Member m, Array data) {
        if (data == null) {
            throw new IllegalArgumentException("data cant be null");
        }
        this.memberData.put(m, data);
    }

    public void setMemberData(String memberName, Array data) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        this.setMemberData(m, data);
    }

    public Array getArray(StructureMembers.Member m) {
        if (m == null) {
            throw new IllegalArgumentException("member is null");
        }
        return this.memberData.get(m);
    }

    public float convertScalarFloat(StructureMembers.Member m) {
        return this.getScalarFloat(m);
    }

    public double convertScalarDouble(StructureMembers.Member m) {
        return this.getScalarDouble(m);
    }

    public int convertScalarInt(StructureMembers.Member m) {
        return this.getScalarInt(m);
    }

    public double getScalarDouble(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getDouble(Index.scalarIndexImmutable);
    }

    public double[] getJavaArrayDouble(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (double[])data.getStorage();
    }

    public float getScalarFloat(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getFloat(Index.scalarIndexImmutable);
    }

    public float[] getJavaArrayFloat(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (float[])data.getStorage();
    }

    public byte getScalarByte(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getByte(Index.scalarIndexImmutable);
    }

    public byte[] getJavaArrayByte(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (byte[])data.getStorage();
    }

    public int getScalarInt(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getInt(Index.scalarIndexImmutable);
    }

    public int[] getJavaArrayInt(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (int[])data.getStorage();
    }

    public short getScalarShort(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getShort(Index.scalarIndexImmutable);
    }

    public short[] getJavaArrayShort(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (short[])data.getStorage();
    }

    public long getScalarLong(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getLong(Index.scalarIndexImmutable);
    }

    public long[] getJavaArrayLong(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (long[])data.getStorage();
    }

    public char getScalarChar(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getChar(Index.scalarIndexImmutable);
    }

    public char[] getJavaArrayChar(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (char[])data.getStorage();
    }

    public String getScalarString(StructureMembers.Member m) {
        int count;
        if (m.getDataType() == DataType.STRING) {
            Array data = this.getArray(m);
            return (String)data.getObject(0);
        }
        char[] ba = this.getJavaArrayChar(m);
        for (count = 0; count < ba.length && '\u0000' != ba[count]; ++count) {
        }
        return new String(ba, 0, count);
    }

    public String[] getJavaArrayString(StructureMembers.Member m) {
        if (m.getDataType() == DataType.STRING) {
            Array data = this.getArray(m);
            int n = m.getSize();
            String[] result = new String[n];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (String)data.getObject(i);
            }
            return result;
        }
        if (m.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)this.getArray(m);
            ArrayChar.StringIterator iter = data.getStringIterator();
            String[] result = new String[iter.getNumElems()];
            int count = 0;
            while (iter.hasNext()) {
                result[count++] = iter.next();
            }
            return result;
        }
        throw new IllegalArgumentException("getJavaArrayString: not String DataType :" + (Object)((Object)m.getDataType()));
    }

    public StructureData getScalarStructure(StructureMembers.Member m) {
        ArrayStructure data = (ArrayStructure)this.getArray(m);
        return data.getStructureData(0);
    }

    public ArrayStructure getArrayStructure(StructureMembers.Member m) {
        return (ArrayStructure)this.getArray(m);
    }

    public ArraySequence getArraySequence(StructureMembers.Member m) {
        return (ArraySequence)this.getArray(m);
    }
}

