//
// C++ Implementation: subscriberThread
//
// Description: 
//
//
// Author: Steve Merrony,,, <>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

/* This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> or
    write to the Free Software Foundation, 51 Franklin Street, Fifth Floor, 
    Boston, MA 02110-1301, USA
*/

#include <pthread.h>
#include <alsa/asoundlib.h>

#include <qevent.h>

#include "console.h"
#include "customEvents.h"
#include "subscriberThread.h"
#include "pistonEventData.h"
    
#include <iostream>
using namespace std;

SubscriberThread::SubscriberThread( volatile Console *shared_console ) {

  sconsole = shared_console;
  if (sconsole->verboseMode) cout << "MIDI Subscriber thread starting up\n";

}

SubscriberThread::~SubscriberThread() {

  cout << "Destroying MIDI Subscriber thread\n";
  pthread_exit( NULL );

}

static void* run(void* mops) {

  Console *tconsole = (Console *)mops;

  midi_port *ip, *op;
  ip = &(tconsole->inp_port);
  op = &(tconsole->out_port);
  snd_seq_event_t *ev;
  
  while (TRUE) {

    if (snd_seq_event_input( op->seq_handle, &ev ) < 0) {
      //cout << "Error fetching MIDI event - notes may have been lost (subscriber thread)\n";
    }
    else {
      switch (ev->type) {
	case SND_SEQ_EVENT_PORT_SUBSCRIBED:
	  cout << "MIDI port subscribed\n";
	  break;
	case SND_SEQ_EVENT_PORT_UNSUBSCRIBED:
	  int dest = ev->data.connect.dest.client;
	  cout << "MIDI port unsubscribed " << dest << endl;
	  break;
      }
      snd_seq_free_event( ev );
    }
  }
}

void SubscriberThread::start() {
  
  pthread_attr_t* attributes = 0;

  if (pthread_create(&thread, attributes, ::run, (void *)sconsole ))
    perror("creating subscriber thread failed:");
}

void SubscriberThread::stop(bool force = TRUE) {

  if (force) {
    pthread_cancel(thread);
  }
  
}
