-- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/objects/root.adb,v $
--  Description     : Root object of the database                            --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-April-2005                                          --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/02/03 14:59:52 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006 Michael Erdmann                                       --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  SDB distribution.                                                        --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE;  see file COPYING. If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --
with Ada.Text_IO;			use Ada.Text_IO;
with Ada.Strings.Unbounded;		use Ada.Strings.Unbounded;
with TAM.Persistent;			use TAM.Persistent;

with Objects;				use Objects;
with String_Table;			use String_Table;

package body Root is

   Version : constant String :=
         "$Id: root.adb,v 1.4 2007/02/03 14:59:52 merdmann Exp $";

   --------------
   -- Get_Root --
   --------------
   procedure Get_Root(
      This : in out Object) is
      ID   : Integer := Rootname("MyDB");
   begin
      if ID = 0 then
         declare
            GT   : String_Table.Object( Grouptable_Size );
            ACCT : String_Table.Object( AccTypeTable_Size );
         begin
            -- setup the account default types
            Put_Object( ACCT );
            This.Account_Types := OID( ACCT );

            Add( ACCT, "Business");
            Add( ACCT, "Private");

            -- setup the default group types
            Put_Object( GT );
            This.Group_Types := OID( GT );

            Add( GT, "Family");
            Add( GT, "Friends");

            -- save root object
            Put_Object( This );

            Rootname( "MyDB", OID(This) );
         end ;
      else
         Get_OBject( This, ID => ID );
      end if;

      Put_Line("Group Types: " & Integer'Image( This.Group_Types ) );
      Put_Line("Acct  Types: " & Integer'Image( This.Account_Types ) );
   end Get_Root;

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize is
   begin
      Connect;
      Get_Root( Root_Object );
   end Initialize;

   --------------
   -- Finalize --
   --------------
   procedure Finalize is
   begin
      null;
   end Finalize;


end Root;
