// Code generated by smithy-go-codegen DO NOT EDIT.

package b2bi

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/b2bi/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the partnerships associated with your Amazon Web Services account for
// your current or specified region. A partnership represents the connection
// between you and your trading partner. It ties together a profile and one or more
// trading capabilities.
func (c *Client) ListPartnerships(ctx context.Context, params *ListPartnershipsInput, optFns ...func(*Options)) (*ListPartnershipsOutput, error) {
	if params == nil {
		params = &ListPartnershipsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPartnerships", params, optFns, c.addOperationListPartnershipsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPartnershipsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPartnershipsInput struct {

	// Specifies the maximum number of capabilities to return.
	MaxResults *int32

	// When additional results are obtained from the command, a NextToken parameter is
	// returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string

	// Specifies the unique, system-generated identifier for the profile connected to
	// this partnership.
	ProfileId *string

	noSmithyDocumentSerde
}

type ListPartnershipsOutput struct {

	// Specifies a list of your partnerships.
	//
	// This member is required.
	Partnerships []types.PartnershipSummary

	// When additional results are obtained from the command, a NextToken parameter is
	// returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPartnershipsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListPartnerships{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListPartnerships{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPartnerships"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPartnerships(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPartnershipsAPIClient is a client that implements the ListPartnerships
// operation.
type ListPartnershipsAPIClient interface {
	ListPartnerships(context.Context, *ListPartnershipsInput, ...func(*Options)) (*ListPartnershipsOutput, error)
}

var _ ListPartnershipsAPIClient = (*Client)(nil)

// ListPartnershipsPaginatorOptions is the paginator options for ListPartnerships
type ListPartnershipsPaginatorOptions struct {
	// Specifies the maximum number of capabilities to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPartnershipsPaginator is a paginator for ListPartnerships
type ListPartnershipsPaginator struct {
	options   ListPartnershipsPaginatorOptions
	client    ListPartnershipsAPIClient
	params    *ListPartnershipsInput
	nextToken *string
	firstPage bool
}

// NewListPartnershipsPaginator returns a new ListPartnershipsPaginator
func NewListPartnershipsPaginator(client ListPartnershipsAPIClient, params *ListPartnershipsInput, optFns ...func(*ListPartnershipsPaginatorOptions)) *ListPartnershipsPaginator {
	if params == nil {
		params = &ListPartnershipsInput{}
	}

	options := ListPartnershipsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPartnershipsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPartnershipsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPartnerships page.
func (p *ListPartnershipsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPartnershipsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListPartnerships(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListPartnerships(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPartnerships",
	}
}
