// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Raised in case of an authentication or authorization failure.
type AccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a request is submitted that cannot be processed.
type BadRequestException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BadRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BadRequestException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BadRequestException"
	}
	return *e.ErrorCodeOverride
}
func (e *BadRequestException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a specified bulk-load job ID cannot be found.
type BulkLoadIdNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *BulkLoadIdNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BulkLoadIdNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BulkLoadIdNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BulkLoadIdNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *BulkLoadIdNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a user cancelled a request.
type CancelledByUserException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *CancelledByUserException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CancelledByUserException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CancelledByUserException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CancelledByUserException"
	}
	return *e.ErrorCodeOverride
}
func (e *CancelledByUserException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Raised when a request timed out in the client.
type ClientTimeoutException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *ClientTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClientTimeoutException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClientTimeoutException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClientTimeoutException"
	}
	return *e.ErrorCodeOverride
}
func (e *ClientTimeoutException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a request attempts to modify data that is concurrently being
// modified by another process.
type ConcurrentModificationException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentModificationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConcurrentModificationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConcurrentModificationException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Raised when a value in a request field did not satisfy required constraints.
type ConstraintViolationException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *ConstraintViolationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConstraintViolationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConstraintViolationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConstraintViolationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConstraintViolationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a request attempts to access an stream that has expired.
type ExpiredStreamException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *ExpiredStreamException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ExpiredStreamException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ExpiredStreamException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ExpiredStreamException"
	}
	return *e.ErrorCodeOverride
}
func (e *ExpiredStreamException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a request fails.
type FailureByQueryException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *FailureByQueryException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FailureByQueryException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FailureByQueryException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FailureByQueryException"
	}
	return *e.ErrorCodeOverride
}
func (e *FailureByQueryException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Raised when an argument in a request is not supported.
type IllegalArgumentException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *IllegalArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalArgumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalArgumentException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IllegalArgumentException"
	}
	return *e.ErrorCodeOverride
}
func (e *IllegalArgumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when the processing of the request failed unexpectedly.
type InternalFailureException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalFailureException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalFailureException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalFailureException"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalFailureException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Raised when an argument in a request has an invalid value.
type InvalidArgumentException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidArgumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidArgumentException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidArgumentException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidArgumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when invalid numerical data is encountered when servicing a request.
type InvalidNumericDataException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *InvalidNumericDataException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNumericDataException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNumericDataException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidNumericDataException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidNumericDataException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a parameter value is not valid.
type InvalidParameterException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when access is denied to a specified load URL.
type LoadUrlAccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *LoadUrlAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LoadUrlAccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LoadUrlAccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LoadUrlAccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *LoadUrlAccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a query is submitted that is syntactically incorrect or does not
// pass additional validation.
type MalformedQueryException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *MalformedQueryException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MalformedQueryException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MalformedQueryException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MalformedQueryException"
	}
	return *e.ErrorCodeOverride
}
func (e *MalformedQueryException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a request fails because of insufficient memory resources. The
// request can be retried.
type MemoryLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *MemoryLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MemoryLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MemoryLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MemoryLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *MemoryLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Raised when the HTTP method used by a request is not supported by the endpoint
// being used.
type MethodNotAllowedException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *MethodNotAllowedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MethodNotAllowedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MethodNotAllowedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MethodNotAllowedException"
	}
	return *e.ErrorCodeOverride
}
func (e *MethodNotAllowedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a required parameter is missing.
type MissingParameterException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *MissingParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MissingParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MissingParameterException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MissingParameterException"
	}
	return *e.ErrorCodeOverride
}
func (e *MissingParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a specified machine-learning resource could not be found.
type MLResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *MLResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MLResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MLResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MLResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *MLResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a parsing issue is encountered.
type ParsingException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *ParsingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParsingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParsingException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ParsingException"
	}
	return *e.ErrorCodeOverride
}
func (e *ParsingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a precondition for processing a request is not satisfied.
type PreconditionsFailedException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *PreconditionsFailedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PreconditionsFailedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PreconditionsFailedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PreconditionsFailedException"
	}
	return *e.ErrorCodeOverride
}
func (e *PreconditionsFailedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when the number of active queries exceeds what the server can process.
// The query in question can be retried when the system is less busy.
type QueryLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *QueryLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *QueryLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *QueryLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "QueryLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *QueryLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Raised when the size of a query exceeds the system limit.
type QueryLimitException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *QueryLimitException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *QueryLimitException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *QueryLimitException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "QueryLimitException"
	}
	return *e.ErrorCodeOverride
}
func (e *QueryLimitException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when the body of a query is too large.
type QueryTooLargeException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *QueryTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *QueryTooLargeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *QueryTooLargeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "QueryTooLargeException"
	}
	return *e.ErrorCodeOverride
}
func (e *QueryTooLargeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a request attempts to write to a read-only resource.
type ReadOnlyViolationException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *ReadOnlyViolationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReadOnlyViolationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReadOnlyViolationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReadOnlyViolationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ReadOnlyViolationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when there is a problem accessing Amazon S3.
type S3Exception struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *S3Exception) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *S3Exception) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *S3Exception) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "S3Exception"
	}
	return *e.ErrorCodeOverride
}
func (e *S3Exception) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when the server shuts down while processing a request.
type ServerShutdownException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *ServerShutdownException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServerShutdownException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServerShutdownException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServerShutdownException"
	}
	return *e.ErrorCodeOverride
}
func (e *ServerShutdownException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Raised when statistics needed to satisfy a request are not available.
type StatisticsNotAvailableException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *StatisticsNotAvailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StatisticsNotAvailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StatisticsNotAvailableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StatisticsNotAvailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *StatisticsNotAvailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when stream records requested by a query cannot be found.
type StreamRecordsNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *StreamRecordsNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StreamRecordsNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StreamRecordsNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StreamRecordsNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *StreamRecordsNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when the rate of requests exceeds the maximum throughput. Requests can
// be retried after encountering this exception.
type ThrottlingException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ThrottlingException"
	}
	return *e.ErrorCodeOverride
}
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Raised when the an operation exceeds the time limit allowed for it.
type TimeLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *TimeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TimeLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TimeLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TimeLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *TimeLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Raised when the number of requests being processed exceeds the limit.
type TooManyRequestsException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyRequestsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyRequestsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyRequestsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyRequestsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Raised when a request attempts to initiate an operation that is not supported.
type UnsupportedOperationException struct {
	Message *string

	ErrorCodeOverride *string

	DetailedMessage *string
	RequestId       *string
	Code            *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedOperationException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
