// Code generated by smithy-go-codegen DO NOT EDIT.

package appfabric

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/appfabric/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpBatchGetUserAccessTasks struct {
}

func (*validateOpBatchGetUserAccessTasks) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchGetUserAccessTasks) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchGetUserAccessTasksInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchGetUserAccessTasksInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpConnectAppAuthorization struct {
}

func (*validateOpConnectAppAuthorization) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpConnectAppAuthorization) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ConnectAppAuthorizationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpConnectAppAuthorizationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAppAuthorization struct {
}

func (*validateOpCreateAppAuthorization) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAppAuthorization) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAppAuthorizationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAppAuthorizationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAppBundle struct {
}

func (*validateOpCreateAppBundle) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAppBundle) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAppBundleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAppBundleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateIngestionDestination struct {
}

func (*validateOpCreateIngestionDestination) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateIngestionDestination) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateIngestionDestinationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateIngestionDestinationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateIngestion struct {
}

func (*validateOpCreateIngestion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateIngestion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateIngestionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateIngestionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAppAuthorization struct {
}

func (*validateOpDeleteAppAuthorization) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAppAuthorization) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAppAuthorizationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAppAuthorizationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAppBundle struct {
}

func (*validateOpDeleteAppBundle) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAppBundle) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAppBundleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAppBundleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteIngestionDestination struct {
}

func (*validateOpDeleteIngestionDestination) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteIngestionDestination) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteIngestionDestinationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteIngestionDestinationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteIngestion struct {
}

func (*validateOpDeleteIngestion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteIngestion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteIngestionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteIngestionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAppAuthorization struct {
}

func (*validateOpGetAppAuthorization) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAppAuthorization) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAppAuthorizationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAppAuthorizationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAppBundle struct {
}

func (*validateOpGetAppBundle) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAppBundle) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAppBundleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAppBundleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetIngestionDestination struct {
}

func (*validateOpGetIngestionDestination) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetIngestionDestination) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetIngestionDestinationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetIngestionDestinationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetIngestion struct {
}

func (*validateOpGetIngestion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetIngestion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetIngestionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetIngestionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAppAuthorizations struct {
}

func (*validateOpListAppAuthorizations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAppAuthorizations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAppAuthorizationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAppAuthorizationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListIngestionDestinations struct {
}

func (*validateOpListIngestionDestinations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListIngestionDestinations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListIngestionDestinationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListIngestionDestinationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListIngestions struct {
}

func (*validateOpListIngestions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListIngestions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListIngestionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListIngestionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartIngestion struct {
}

func (*validateOpStartIngestion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartIngestion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartIngestionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartIngestionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartUserAccessTasks struct {
}

func (*validateOpStartUserAccessTasks) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartUserAccessTasks) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartUserAccessTasksInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartUserAccessTasksInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopIngestion struct {
}

func (*validateOpStopIngestion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopIngestion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopIngestionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopIngestionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateAppAuthorization struct {
}

func (*validateOpUpdateAppAuthorization) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateAppAuthorization) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateAppAuthorizationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateAppAuthorizationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateIngestionDestination struct {
}

func (*validateOpUpdateIngestionDestination) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateIngestionDestination) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateIngestionDestinationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateIngestionDestinationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpBatchGetUserAccessTasksValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchGetUserAccessTasks{}, middleware.After)
}

func addOpConnectAppAuthorizationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpConnectAppAuthorization{}, middleware.After)
}

func addOpCreateAppAuthorizationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAppAuthorization{}, middleware.After)
}

func addOpCreateAppBundleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAppBundle{}, middleware.After)
}

func addOpCreateIngestionDestinationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateIngestionDestination{}, middleware.After)
}

func addOpCreateIngestionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateIngestion{}, middleware.After)
}

func addOpDeleteAppAuthorizationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAppAuthorization{}, middleware.After)
}

func addOpDeleteAppBundleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAppBundle{}, middleware.After)
}

func addOpDeleteIngestionDestinationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteIngestionDestination{}, middleware.After)
}

func addOpDeleteIngestionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteIngestion{}, middleware.After)
}

func addOpGetAppAuthorizationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAppAuthorization{}, middleware.After)
}

func addOpGetAppBundleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAppBundle{}, middleware.After)
}

func addOpGetIngestionDestinationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetIngestionDestination{}, middleware.After)
}

func addOpGetIngestionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetIngestion{}, middleware.After)
}

func addOpListAppAuthorizationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAppAuthorizations{}, middleware.After)
}

func addOpListIngestionDestinationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListIngestionDestinations{}, middleware.After)
}

func addOpListIngestionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListIngestions{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpStartIngestionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartIngestion{}, middleware.After)
}

func addOpStartUserAccessTasksValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartUserAccessTasks{}, middleware.After)
}

func addOpStopIngestionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopIngestion{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateAppAuthorizationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateAppAuthorization{}, middleware.After)
}

func addOpUpdateIngestionDestinationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateIngestionDestination{}, middleware.After)
}

func validateApiKeyCredential(v *types.ApiKeyCredential) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApiKeyCredential"}
	if v.ApiKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAuditLogDestinationConfiguration(v *types.AuditLogDestinationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AuditLogDestinationConfiguration"}
	if v.Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destination"))
	} else if v.Destination != nil {
		if err := validateDestination(v.Destination); err != nil {
			invalidParams.AddNested("Destination", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAuditLogProcessingConfiguration(v *types.AuditLogProcessingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AuditLogProcessingConfiguration"}
	if len(v.Schema) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Schema"))
	}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAuthRequest(v *types.AuthRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AuthRequest"}
	if v.RedirectUri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RedirectUri"))
	}
	if v.Code == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Code"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCredential(v types.Credential) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Credential"}
	switch uv := v.(type) {
	case *types.CredentialMemberApiKeyCredential:
		if err := validateApiKeyCredential(&uv.Value); err != nil {
			invalidParams.AddNested("[apiKeyCredential]", err.(smithy.InvalidParamsError))
		}

	case *types.CredentialMemberOauth2Credential:
		if err := validateOauth2Credential(&uv.Value); err != nil {
			invalidParams.AddNested("[oauth2Credential]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDestination(v types.Destination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Destination"}
	switch uv := v.(type) {
	case *types.DestinationMemberFirehoseStream:
		if err := validateFirehoseStream(&uv.Value); err != nil {
			invalidParams.AddNested("[firehoseStream]", err.(smithy.InvalidParamsError))
		}

	case *types.DestinationMemberS3Bucket:
		if err := validateS3Bucket(&uv.Value); err != nil {
			invalidParams.AddNested("[s3Bucket]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDestinationConfiguration(v types.DestinationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DestinationConfiguration"}
	switch uv := v.(type) {
	case *types.DestinationConfigurationMemberAuditLog:
		if err := validateAuditLogDestinationConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[auditLog]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFirehoseStream(v *types.FirehoseStream) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FirehoseStream"}
	if v.StreamName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StreamName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOauth2Credential(v *types.Oauth2Credential) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Oauth2Credential"}
	if v.ClientId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientId"))
	}
	if v.ClientSecret == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientSecret"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateProcessingConfiguration(v types.ProcessingConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ProcessingConfiguration"}
	switch uv := v.(type) {
	case *types.ProcessingConfigurationMemberAuditLog:
		if err := validateAuditLogProcessingConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[auditLog]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3Bucket(v *types.S3Bucket) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3Bucket"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTenant(v *types.Tenant) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tenant"}
	if v.TenantIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TenantIdentifier"))
	}
	if v.TenantDisplayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TenantDisplayName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchGetUserAccessTasksInput(v *BatchGetUserAccessTasksInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchGetUserAccessTasksInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.TaskIdList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaskIdList"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpConnectAppAuthorizationInput(v *ConnectAppAuthorizationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConnectAppAuthorizationInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.AppAuthorizationIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppAuthorizationIdentifier"))
	}
	if v.AuthRequest != nil {
		if err := validateAuthRequest(v.AuthRequest); err != nil {
			invalidParams.AddNested("AuthRequest", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAppAuthorizationInput(v *CreateAppAuthorizationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAppAuthorizationInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.App == nil {
		invalidParams.Add(smithy.NewErrParamRequired("App"))
	}
	if v.Credential == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Credential"))
	} else if v.Credential != nil {
		if err := validateCredential(v.Credential); err != nil {
			invalidParams.AddNested("Credential", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tenant == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tenant"))
	} else if v.Tenant != nil {
		if err := validateTenant(v.Tenant); err != nil {
			invalidParams.AddNested("Tenant", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.AuthType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AuthType"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAppBundleInput(v *CreateAppBundleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAppBundleInput"}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateIngestionDestinationInput(v *CreateIngestionDestinationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateIngestionDestinationInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.IngestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionIdentifier"))
	}
	if v.ProcessingConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProcessingConfiguration"))
	} else if v.ProcessingConfiguration != nil {
		if err := validateProcessingConfiguration(v.ProcessingConfiguration); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.DestinationConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationConfiguration"))
	} else if v.DestinationConfiguration != nil {
		if err := validateDestinationConfiguration(v.DestinationConfiguration); err != nil {
			invalidParams.AddNested("DestinationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateIngestionInput(v *CreateIngestionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateIngestionInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.App == nil {
		invalidParams.Add(smithy.NewErrParamRequired("App"))
	}
	if v.TenantId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TenantId"))
	}
	if len(v.IngestionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionType"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAppAuthorizationInput(v *DeleteAppAuthorizationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAppAuthorizationInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.AppAuthorizationIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppAuthorizationIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAppBundleInput(v *DeleteAppBundleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAppBundleInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteIngestionDestinationInput(v *DeleteIngestionDestinationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteIngestionDestinationInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.IngestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionIdentifier"))
	}
	if v.IngestionDestinationIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionDestinationIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteIngestionInput(v *DeleteIngestionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteIngestionInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.IngestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAppAuthorizationInput(v *GetAppAuthorizationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAppAuthorizationInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.AppAuthorizationIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppAuthorizationIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAppBundleInput(v *GetAppBundleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAppBundleInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetIngestionDestinationInput(v *GetIngestionDestinationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetIngestionDestinationInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.IngestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionIdentifier"))
	}
	if v.IngestionDestinationIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionDestinationIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetIngestionInput(v *GetIngestionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetIngestionInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.IngestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAppAuthorizationsInput(v *ListAppAuthorizationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAppAuthorizationsInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListIngestionDestinationsInput(v *ListIngestionDestinationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListIngestionDestinationsInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.IngestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListIngestionsInput(v *ListIngestionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListIngestionsInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartIngestionInput(v *StartIngestionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartIngestionInput"}
	if v.IngestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionIdentifier"))
	}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartUserAccessTasksInput(v *StartUserAccessTasksInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartUserAccessTasksInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.Email == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Email"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopIngestionInput(v *StopIngestionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopIngestionInput"}
	if v.IngestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionIdentifier"))
	}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateAppAuthorizationInput(v *UpdateAppAuthorizationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateAppAuthorizationInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.AppAuthorizationIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppAuthorizationIdentifier"))
	}
	if v.Credential != nil {
		if err := validateCredential(v.Credential); err != nil {
			invalidParams.AddNested("Credential", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tenant != nil {
		if err := validateTenant(v.Tenant); err != nil {
			invalidParams.AddNested("Tenant", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateIngestionDestinationInput(v *UpdateIngestionDestinationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateIngestionDestinationInput"}
	if v.AppBundleIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AppBundleIdentifier"))
	}
	if v.IngestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionIdentifier"))
	}
	if v.IngestionDestinationIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IngestionDestinationIdentifier"))
	}
	if v.DestinationConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationConfiguration"))
	} else if v.DestinationConfiguration != nil {
		if err := validateDestinationConfiguration(v.DestinationConfiguration); err != nil {
			invalidParams.AddNested("DestinationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
