// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes automated backups using the DbiResourceId value of the source DB
// instance or the Amazon Resource Name (ARN) of the automated backups.
func (c *Client) DeleteDBInstanceAutomatedBackup(ctx context.Context, params *DeleteDBInstanceAutomatedBackupInput, optFns ...func(*Options)) (*DeleteDBInstanceAutomatedBackupOutput, error) {
	if params == nil {
		params = &DeleteDBInstanceAutomatedBackupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteDBInstanceAutomatedBackup", params, optFns, c.addOperationDeleteDBInstanceAutomatedBackupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteDBInstanceAutomatedBackupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Parameter input for the DeleteDBInstanceAutomatedBackup operation.
type DeleteDBInstanceAutomatedBackupInput struct {

	// The Amazon Resource Name (ARN) of the automated backups to delete, for example,
	// arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE .
	//
	// This setting doesn't apply to RDS Custom.
	DBInstanceAutomatedBackupsArn *string

	// The identifier for the source DB instance, which can't be changed and which is
	// unique to an Amazon Web Services Region.
	DbiResourceId *string

	noSmithyDocumentSerde
}

type DeleteDBInstanceAutomatedBackupOutput struct {

	// An automated backup of a DB instance. It consists of system backups,
	// transaction logs, and the database instance properties that existed at the time
	// you deleted the source instance.
	DBInstanceAutomatedBackup *types.DBInstanceAutomatedBackup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteDBInstanceAutomatedBackupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDeleteDBInstanceAutomatedBackup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDeleteDBInstanceAutomatedBackup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteDBInstanceAutomatedBackup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteDBInstanceAutomatedBackup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteDBInstanceAutomatedBackup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteDBInstanceAutomatedBackup",
	}
}
