package desktopvirtualization

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ApplicationGroupAssignmentsClient is the client for the ApplicationGroupAssignments methods of the
// Desktopvirtualization service.
type ApplicationGroupAssignmentsClient struct {
	BaseClient
}

// NewApplicationGroupAssignmentsClient creates an instance of the ApplicationGroupAssignmentsClient client.
func NewApplicationGroupAssignmentsClient(subscriptionID string) ApplicationGroupAssignmentsClient {
	return NewApplicationGroupAssignmentsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewApplicationGroupAssignmentsClientWithBaseURI creates an instance of the ApplicationGroupAssignmentsClient client
// using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewApplicationGroupAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) ApplicationGroupAssignmentsClient {
	return ApplicationGroupAssignmentsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// WorkspaceLevelList list application group that user can use.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// workspaceName - the name of the workspace
// filter - oData filter expression. Valid properties for filtering are applicationGroupType.
func (client ApplicationGroupAssignmentsClient) WorkspaceLevelList(ctx context.Context, resourceGroupName string, workspaceName string, filter string) (result ApplicationGroupListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGroupAssignmentsClient.WorkspaceLevelList")
		defer func() {
			sc := -1
			if result.agl.Response.Response != nil {
				sc = result.agl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 3, Chain: nil}}}}); err != nil {
		return result, validation.NewError("desktopvirtualization.ApplicationGroupAssignmentsClient", "WorkspaceLevelList", err.Error())
	}

	result.fn = client.workspaceLevelListNextResults
	req, err := client.WorkspaceLevelListPreparer(ctx, resourceGroupName, workspaceName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "desktopvirtualization.ApplicationGroupAssignmentsClient", "WorkspaceLevelList", nil, "Failure preparing request")
		return
	}

	resp, err := client.WorkspaceLevelListSender(req)
	if err != nil {
		result.agl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "desktopvirtualization.ApplicationGroupAssignmentsClient", "WorkspaceLevelList", resp, "Failure sending request")
		return
	}

	result.agl, err = client.WorkspaceLevelListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "desktopvirtualization.ApplicationGroupAssignmentsClient", "WorkspaceLevelList", resp, "Failure responding to request")
	}

	return
}

// WorkspaceLevelListPreparer prepares the WorkspaceLevelList request.
func (client ApplicationGroupAssignmentsClient) WorkspaceLevelListPreparer(ctx context.Context, resourceGroupName string, workspaceName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2019-09-24-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/workspaces/{workspaceName}/userApplicationGroupAssignments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// WorkspaceLevelListSender sends the WorkspaceLevelList request. The method will close the
// http.Response Body if it receives an error.
func (client ApplicationGroupAssignmentsClient) WorkspaceLevelListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// WorkspaceLevelListResponder handles the response to the WorkspaceLevelList request. The method always
// closes the http.Response Body.
func (client ApplicationGroupAssignmentsClient) WorkspaceLevelListResponder(resp *http.Response) (result ApplicationGroupList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// workspaceLevelListNextResults retrieves the next set of results, if any.
func (client ApplicationGroupAssignmentsClient) workspaceLevelListNextResults(ctx context.Context, lastResults ApplicationGroupList) (result ApplicationGroupList, err error) {
	req, err := lastResults.applicationGroupListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "desktopvirtualization.ApplicationGroupAssignmentsClient", "workspaceLevelListNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.WorkspaceLevelListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "desktopvirtualization.ApplicationGroupAssignmentsClient", "workspaceLevelListNextResults", resp, "Failure sending next results request")
	}
	result, err = client.WorkspaceLevelListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "desktopvirtualization.ApplicationGroupAssignmentsClient", "workspaceLevelListNextResults", resp, "Failure responding to next results request")
	}
	return
}

// WorkspaceLevelListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ApplicationGroupAssignmentsClient) WorkspaceLevelListComplete(ctx context.Context, resourceGroupName string, workspaceName string, filter string) (result ApplicationGroupListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGroupAssignmentsClient.WorkspaceLevelList")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.WorkspaceLevelList(ctx, resourceGroupName, workspaceName, filter)
	return
}
