PHP Framework Interoperability Group
====================================

The idea behind the group is for project representatives to talk about the
commonalities between our projects and find ways we can work together. Our main
audience is each other, but we’re very aware that the rest of the PHP community
is watching. If other folks want to adopt what we’re doing they are welcome to
do so, but that is not the aim.

Proposing a Standard Recommendation
------------------------------------

To propose a PHP Standard Recommendation (PSR):

- fork this repo, create a branch, checkout that branch, add the PSR in
  `proposed/`, push the branch to Github, and send a pull request; or,

- create a ticket to start a discussion on Github; or,

- start a conversation on the [mailing list][].

[mailing list]: http://groups.google.com/group/php-fig/

GitHub usage
------------

All discussion regarding a PSR happens on the [mailing list][]. Issues filed
in GitHub are rarely monitored, and PRs are likely to be missed unless a message
is sent to the mailing list regarding them.  Reviews of a proposed PSR should be
conducted on the mailing list, not through PR comments for the same reason.

Please do not simply file an issue or PR and walk-away.  The most likely outcome
is that it will never get seen or addressed.

Requesting Membership
---------------------

You **do not** need to be a voting member to participate in discussion on
the [mailing list][].

To become a voting member, you must send an email to the [mailing list][].

- The subject line should read: `Membership Request: {$your_name} ({$project_name})`

- The body should include your name, the name of (and link to) the project you
  represent, and other details you feel are relevant.

- Current members will vote on your request.

Do not combine separate membership requests in a single thread; one request
per thread, please.

Language & Translations
-----------------------

All PSRs are written in British English or American English (Different specifications
may vary, but it is consistent within the same specification). The PHP FIG does not
offer official translations into other languages but other external entities are free
to translate the specifications in accordance with the license.

Voting Members
--------------

The current list of voting members is available on the [project website][].

[project website]: http://www.php-fig.org/
