// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/securitycenter/v1/asset.proto

package securitycenter

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Cloud Security Command Center's (Cloud SCC) representation of a Google Cloud
// Platform (GCP) resource.
//
// The Asset is a Cloud SCC resource that captures information about a single
// GCP resource. All modifications to an Asset are only within the context of
// Cloud SCC and don't affect the referenced GCP resource.
type Asset struct {
	// The relative resource name of this asset. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/assets/{asset_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Cloud SCC managed properties. These properties are managed by
	// Cloud SCC and cannot be modified by the user.
	SecurityCenterProperties *Asset_SecurityCenterProperties `protobuf:"bytes,2,opt,name=security_center_properties,json=securityCenterProperties,proto3" json:"security_center_properties,omitempty"`
	// Resource managed properties. These properties are managed and defined by
	// the GCP resource and cannot be modified by the user.
	ResourceProperties map[string]*_struct.Value `protobuf:"bytes,7,rep,name=resource_properties,json=resourceProperties,proto3" json:"resource_properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// User specified security marks. These marks are entirely managed by the user
	// and come from the SecurityMarks resource that belongs to the asset.
	SecurityMarks *SecurityMarks `protobuf:"bytes,8,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The time at which the asset was created in Cloud SCC.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time at which the asset was last updated, added, or deleted in Cloud
	// SCC.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// IAM Policy information associated with the GCP resource described by the
	// Cloud SCC asset. This information is managed and defined by the GCP
	// resource and cannot be modified by the user.
	IamPolicy            *Asset_IamPolicy `protobuf:"bytes,11,opt,name=iam_policy,json=iamPolicy,proto3" json:"iam_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Asset) Reset()         { *m = Asset{} }
func (m *Asset) String() string { return proto.CompactTextString(m) }
func (*Asset) ProtoMessage()    {}
func (*Asset) Descriptor() ([]byte, []int) {
	return fileDescriptor_8afac45fcf79e390, []int{0}
}

func (m *Asset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Asset.Unmarshal(m, b)
}
func (m *Asset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Asset.Marshal(b, m, deterministic)
}
func (m *Asset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Asset.Merge(m, src)
}
func (m *Asset) XXX_Size() int {
	return xxx_messageInfo_Asset.Size(m)
}
func (m *Asset) XXX_DiscardUnknown() {
	xxx_messageInfo_Asset.DiscardUnknown(m)
}

var xxx_messageInfo_Asset proto.InternalMessageInfo

func (m *Asset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Asset) GetSecurityCenterProperties() *Asset_SecurityCenterProperties {
	if m != nil {
		return m.SecurityCenterProperties
	}
	return nil
}

func (m *Asset) GetResourceProperties() map[string]*_struct.Value {
	if m != nil {
		return m.ResourceProperties
	}
	return nil
}

func (m *Asset) GetSecurityMarks() *SecurityMarks {
	if m != nil {
		return m.SecurityMarks
	}
	return nil
}

func (m *Asset) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Asset) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Asset) GetIamPolicy() *Asset_IamPolicy {
	if m != nil {
		return m.IamPolicy
	}
	return nil
}

// Cloud SCC managed properties. These properties are managed by Cloud SCC and
// cannot be modified by the user.
type Asset_SecurityCenterProperties struct {
	// The full resource name of the GCP resource this asset
	// represents. This field is immutable after create time. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The type of the GCP resource. Examples include: APPLICATION,
	// PROJECT, and ORGANIZATION. This is a case insensitive field defined by
	// Cloud SCC and/or the producer of the resource and is immutable
	// after create time.
	ResourceType string `protobuf:"bytes,2,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// The full resource name of the immediate parent of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceParent string `protobuf:"bytes,3,opt,name=resource_parent,json=resourceParent,proto3" json:"resource_parent,omitempty"`
	// The full resource name of the project the resource belongs to. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ResourceProject string `protobuf:"bytes,4,opt,name=resource_project,json=resourceProject,proto3" json:"resource_project,omitempty"`
	// Owners of the Google Cloud resource.
	ResourceOwners []string `protobuf:"bytes,5,rep,name=resource_owners,json=resourceOwners,proto3" json:"resource_owners,omitempty"`
	// The user defined display name for this resource.
	ResourceDisplayName string `protobuf:"bytes,6,opt,name=resource_display_name,json=resourceDisplayName,proto3" json:"resource_display_name,omitempty"`
	// The user defined display name for the parent of this resource.
	ResourceParentDisplayName string `protobuf:"bytes,7,opt,name=resource_parent_display_name,json=resourceParentDisplayName,proto3" json:"resource_parent_display_name,omitempty"`
	// The user defined display name for the project of this resource.
	ResourceProjectDisplayName string   `protobuf:"bytes,8,opt,name=resource_project_display_name,json=resourceProjectDisplayName,proto3" json:"resource_project_display_name,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *Asset_SecurityCenterProperties) Reset()         { *m = Asset_SecurityCenterProperties{} }
func (m *Asset_SecurityCenterProperties) String() string { return proto.CompactTextString(m) }
func (*Asset_SecurityCenterProperties) ProtoMessage()    {}
func (*Asset_SecurityCenterProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_8afac45fcf79e390, []int{0, 0}
}

func (m *Asset_SecurityCenterProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Asset_SecurityCenterProperties.Unmarshal(m, b)
}
func (m *Asset_SecurityCenterProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Asset_SecurityCenterProperties.Marshal(b, m, deterministic)
}
func (m *Asset_SecurityCenterProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Asset_SecurityCenterProperties.Merge(m, src)
}
func (m *Asset_SecurityCenterProperties) XXX_Size() int {
	return xxx_messageInfo_Asset_SecurityCenterProperties.Size(m)
}
func (m *Asset_SecurityCenterProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_Asset_SecurityCenterProperties.DiscardUnknown(m)
}

var xxx_messageInfo_Asset_SecurityCenterProperties proto.InternalMessageInfo

func (m *Asset_SecurityCenterProperties) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceParent() string {
	if m != nil {
		return m.ResourceParent
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceProject() string {
	if m != nil {
		return m.ResourceProject
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceOwners() []string {
	if m != nil {
		return m.ResourceOwners
	}
	return nil
}

func (m *Asset_SecurityCenterProperties) GetResourceDisplayName() string {
	if m != nil {
		return m.ResourceDisplayName
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceParentDisplayName() string {
	if m != nil {
		return m.ResourceParentDisplayName
	}
	return ""
}

func (m *Asset_SecurityCenterProperties) GetResourceProjectDisplayName() string {
	if m != nil {
		return m.ResourceProjectDisplayName
	}
	return ""
}

// IAM Policy information associated with the GCP resource described by the
// Cloud SCC asset. This information is managed and defined by the GCP
// resource and cannot be modified by the user.
type Asset_IamPolicy struct {
	// The JSON representation of the Policy associated with the asset.
	// See https://cloud.google.com/iam/reference/rest/v1/Policy for format
	// details.
	PolicyBlob           string   `protobuf:"bytes,1,opt,name=policy_blob,json=policyBlob,proto3" json:"policy_blob,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Asset_IamPolicy) Reset()         { *m = Asset_IamPolicy{} }
func (m *Asset_IamPolicy) String() string { return proto.CompactTextString(m) }
func (*Asset_IamPolicy) ProtoMessage()    {}
func (*Asset_IamPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_8afac45fcf79e390, []int{0, 1}
}

func (m *Asset_IamPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Asset_IamPolicy.Unmarshal(m, b)
}
func (m *Asset_IamPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Asset_IamPolicy.Marshal(b, m, deterministic)
}
func (m *Asset_IamPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Asset_IamPolicy.Merge(m, src)
}
func (m *Asset_IamPolicy) XXX_Size() int {
	return xxx_messageInfo_Asset_IamPolicy.Size(m)
}
func (m *Asset_IamPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_Asset_IamPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_Asset_IamPolicy proto.InternalMessageInfo

func (m *Asset_IamPolicy) GetPolicyBlob() string {
	if m != nil {
		return m.PolicyBlob
	}
	return ""
}

func init() {
	proto.RegisterType((*Asset)(nil), "google.cloud.securitycenter.v1.Asset")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.securitycenter.v1.Asset.ResourcePropertiesEntry")
	proto.RegisterType((*Asset_SecurityCenterProperties)(nil), "google.cloud.securitycenter.v1.Asset.SecurityCenterProperties")
	proto.RegisterType((*Asset_IamPolicy)(nil), "google.cloud.securitycenter.v1.Asset.IamPolicy")
}

func init() {
	proto.RegisterFile("google/cloud/securitycenter/v1/asset.proto", fileDescriptor_8afac45fcf79e390)
}

var fileDescriptor_8afac45fcf79e390 = []byte{
	// 680 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x54, 0xdf, 0x4e, 0xd4, 0x4e,
	0x14, 0xce, 0xee, 0xf2, 0x6f, 0xcf, 0xfe, 0xf8, 0x93, 0xf9, 0x45, 0x2d, 0x0d, 0xc2, 0x0a, 0x17,
	0xa2, 0x62, 0x9b, 0x85, 0x1b, 0x53, 0xa2, 0x06, 0xd0, 0x18, 0x13, 0x45, 0x52, 0x71, 0x2f, 0x0c,
	0x66, 0x33, 0x5b, 0xc6, 0xa6, 0xd2, 0x76, 0x9a, 0x99, 0x29, 0xa6, 0x22, 0x0f, 0xe2, 0x23, 0xe8,
	0xa3, 0xf8, 0x08, 0x3e, 0x02, 0x4f, 0x61, 0x3a, 0xd3, 0x76, 0xdb, 0x92, 0x75, 0xb9, 0x6a, 0xe7,
	0xcc, 0xf7, 0x7d, 0xe7, 0x9c, 0xf9, 0xce, 0x0c, 0x3c, 0x74, 0x29, 0x75, 0x7d, 0x62, 0x3a, 0x3e,
	0x8d, 0x4f, 0x4d, 0x4e, 0x9c, 0x98, 0x79, 0x22, 0x71, 0x48, 0x28, 0x08, 0x33, 0xcf, 0x7b, 0x26,
	0xe6, 0x9c, 0x08, 0x23, 0x62, 0x54, 0x50, 0xb4, 0xaa, 0xb0, 0x86, 0xc4, 0x1a, 0x55, 0xac, 0x71,
	0xde, 0xd3, 0x97, 0x33, 0x2d, 0x1c, 0x79, 0x26, 0x23, 0x9c, 0xc6, 0xcc, 0x21, 0x8a, 0xaa, 0xef,
	0x4c, 0x48, 0x93, 0x47, 0x06, 0x01, 0x66, 0x67, 0x3c, 0x23, 0xad, 0x64, 0x24, 0xb9, 0x1a, 0xc6,
	0x9f, 0x4d, 0x2e, 0x58, 0xec, 0x64, 0xd5, 0xe8, 0x6b, 0xf5, 0x5d, 0xe1, 0x05, 0x84, 0x0b, 0x1c,
	0x44, 0x35, 0x7a, 0x5a, 0x0e, 0x0e, 0x43, 0x2a, 0xb0, 0xf0, 0x68, 0x98, 0x89, 0xaf, 0xff, 0x6c,
	0xc3, 0xf4, 0x5e, 0xda, 0x1c, 0x42, 0x30, 0x15, 0xe2, 0x80, 0x68, 0x8d, 0x6e, 0x63, 0xb3, 0x6d,
	0xcb, 0x7f, 0xf4, 0x1d, 0xf4, 0xa2, 0x24, 0x55, 0xe5, 0x20, 0x62, 0x34, 0x22, 0x4c, 0x78, 0x84,
	0x6b, 0xcd, 0x6e, 0x63, 0xb3, 0xb3, 0xfd, 0xcc, 0xf8, 0xf7, 0x79, 0x18, 0x52, 0xde, 0x78, 0x9f,
	0xc5, 0x0f, 0x64, 0xfc, 0xa8, 0x50, 0xb1, 0x35, 0x3e, 0x66, 0x07, 0x85, 0xf0, 0x7f, 0x7e, 0x7e,
	0xe5, 0xb4, 0xb3, 0xdd, 0xd6, 0x66, 0x67, 0xfb, 0xe9, 0xcd, 0xd2, 0xda, 0x99, 0xc0, 0x48, 0xf6,
	0x65, 0x28, 0x58, 0x62, 0x23, 0x76, 0x6d, 0x03, 0x1d, 0xc3, 0x42, 0xd5, 0x00, 0x6d, 0x4e, 0x76,
	0xf8, 0x78, 0x52, 0xaa, 0xbc, 0xb7, 0xb7, 0x29, 0xc9, 0x9e, 0xe7, 0xe5, 0x25, 0xda, 0x85, 0x8e,
	0xc3, 0x08, 0x16, 0x64, 0x90, 0x3a, 0xa3, 0xb5, 0xa5, 0xa4, 0x9e, 0x4b, 0xe6, 0xb6, 0x19, 0xc7,
	0xb9, 0x6d, 0x36, 0x28, 0x78, 0x1a, 0x48, 0xc9, 0x71, 0x74, 0x5a, 0x90, 0x61, 0x32, 0x59, 0xc1,
	0x25, 0xf9, 0x10, 0xc0, 0xc3, 0xc1, 0x20, 0xa2, 0xbe, 0xe7, 0x24, 0x5a, 0x47, 0x72, 0xcd, 0x9b,
	0x1d, 0xdb, 0x6b, 0x1c, 0x1c, 0x49, 0x9a, 0xdd, 0xf6, 0xf2, 0x5f, 0xfd, 0x47, 0x0b, 0xb4, 0x71,
	0x36, 0xa2, 0x0d, 0x98, 0x2f, 0xcc, 0x2a, 0xcd, 0xd1, 0x7f, 0x79, 0xf0, 0x30, 0x9d, 0xa7, 0x32,
	0x48, 0x24, 0x11, 0x91, 0x23, 0x54, 0x02, 0x1d, 0x27, 0x11, 0x41, 0xf7, 0x61, 0x71, 0x64, 0x3b,
	0x66, 0x24, 0x14, 0x5a, 0x4b, 0xc2, 0x16, 0x0a, 0xcf, 0x64, 0x14, 0x3d, 0x80, 0xa5, 0xf2, 0x7c,
	0x7c, 0x21, 0x8e, 0xd0, 0xa6, 0x24, 0x72, 0xb1, 0xe4, 0x6e, 0x1a, 0xae, 0x68, 0xd2, 0xaf, 0x21,
	0x61, 0x5c, 0x9b, 0xee, 0xb6, 0xca, 0x9a, 0xef, 0x64, 0x14, 0x6d, 0xc3, 0xad, 0x02, 0x78, 0xea,
	0xf1, 0xc8, 0xc7, 0x89, 0x6a, 0x67, 0x46, 0x0a, 0x17, 0x03, 0xf9, 0x42, 0xed, 0xc9, 0xae, 0x9e,
	0xc3, 0x4a, 0xad, 0xe0, 0x2a, 0x75, 0x56, 0x52, 0x97, 0xab, 0xd5, 0x97, 0x05, 0xf6, 0xe0, 0x6e,
	0xbd, 0x91, 0xaa, 0xc2, 0x9c, 0x54, 0xd0, 0x6b, 0x5d, 0x95, 0x24, 0xf4, 0x2d, 0x68, 0x17, 0x9e,
	0xa1, 0x35, 0xe8, 0x28, 0xd3, 0x07, 0x43, 0x9f, 0x0e, 0x33, 0x27, 0x40, 0x85, 0xf6, 0x7d, 0x3a,
	0xd4, 0x3f, 0xc1, 0x9d, 0x31, 0x17, 0x03, 0x2d, 0x41, 0xeb, 0x8c, 0x24, 0x19, 0x27, 0xfd, 0x45,
	0x5b, 0x30, 0x7d, 0x8e, 0xfd, 0x98, 0x64, 0xf7, 0xfd, 0xf6, 0xb5, 0xe9, 0xeb, 0xa7, 0xbb, 0xb6,
	0x02, 0x59, 0xcd, 0x27, 0x0d, 0xeb, 0xc3, 0xd5, 0x9e, 0x0d, 0x1b, 0xb5, 0xd9, 0x52, 0x2c, 0x1c,
	0x79, 0xdc, 0x70, 0x68, 0x60, 0xaa, 0x47, 0xe7, 0x11, 0x65, 0x2e, 0x0e, 0xbd, 0x6f, 0xea, 0x4d,
	0x32, 0x2f, 0xca, 0xcb, 0x4b, 0xf5, 0xea, 0x72, 0xf3, 0x42, 0x7e, 0x2f, 0xf7, 0xff, 0x34, 0x60,
	0xdd, 0xa1, 0xc1, 0x84, 0x09, 0x3e, 0x6a, 0x7c, 0x7c, 0x93, 0x21, 0x5c, 0xea, 0xe3, 0xd0, 0x35,
	0x28, 0x73, 0x4d, 0x97, 0x84, 0xb2, 0x5e, 0x73, 0x54, 0xc6, 0xb8, 0x57, 0x78, 0xb7, 0x1a, 0xf9,
	0xd5, 0x5c, 0x7d, 0xa5, 0xe4, 0x0e, 0x64, 0xc2, 0xea, 0x0d, 0x30, 0xfa, 0xbd, 0xdf, 0x39, 0xe0,
	0x44, 0x02, 0x4e, 0xaa, 0x80, 0x93, 0x7e, 0xef, 0xaa, 0x79, 0x4f, 0x01, 0x2c, 0x4b, 0x22, 0x2c,
	0xab, 0x0a, 0xb1, 0xac, 0x7e, 0x6f, 0x38, 0x23, 0xcb, 0xdb, 0xf9, 0x1b, 0x00, 0x00, 0xff, 0xff,
	0xe3, 0x3f, 0x99, 0x99, 0x8a, 0x06, 0x00, 0x00,
}
