\Gromacs {#mainpage}
=======

\Gromacs is a versatile package to perform molecular dynamics, i.e. simulate
the Newtonian equations of motion for systems with hundreds, to millions
of particles.  See [www.gromacs.org](http://www.gromacs.org) for more
information.

This documentation generated by Doxygen is (mostly) extracted from the source
code, and provides documentation for understanding the source code.
The documentation can be generated with different levels of details.
This documentation has been generated to include
\if internal
all documentation, including internal functions and classes used for internal
implementation purposes.

The main audience for this level of detail are people who want to understand
detailed implementation of some area, or try to find some specific function
within the library.  If you are overwhelmed by the amount of details, the
[library API documentation](../html-lib/index.xhtml) skips functions not meant
to be used outside a single module.
\elseif libapi
documentation of functions in the library intended for reuse within the
library (a subset of these functions is also exposed as a public API).
Also overview documentation aimed at \Gromacs developers is included at this
level.

The main audience for this level of detail are users and developers who want to
understand the \Gromacs code in general.
If you only want to call \Gromacs, but not modify it, the
[public API documentation](../html-user/index.xhtml) provides a cleaner entry
point.
If you are interested in internal implementation details not described here,
you can try searching the [full documentation](../html-full/index.xhtml).
\else
documentation of functions exposed through installed headers and intended as
part of a public API.  Note that definition of the public API is very
preliminary, and subject to change.

The main audience for this level of detail are users of \Gromacs who are
interested in writing their own analysis tools that use \Gromacs as a library,
as well as other developers who want to link against \Gromacs.
To understand the inner workings of \Gromacs, or if you want to contribute to
\Gromacs, see the more detailed
[library API documentation](../html-lib/index.xhtml) or
[full documentation](../html-full/index.xhtml).
\endif

Currently, only parts of the code are documented here.  The following pages
give an overview of some of the topics that are documented:

 - \subpage page_analysisframework <br/>
   Provides an overview of the framework that the \Gromacs library provides for
   writing (trajectory) analysis tools.
 - \subpage page_onlinehelp <br/>
   Provides an overview of the formatting markup available in help texts.
 - \subpage page_usinglibrary <br/>
   Provides general guidance for writing software that uses the \Gromacs
   library.
\if libapi
 - \subpage page_wrapperbinary <br/>
   Provides an overview of how the `gmx` wrapper binary is implemented.
 - \subpage page_logging <br/>
   Documentation for logging and status output (for now, within mdrun).
 - \subpage page_simd <br/>
   Documentation about the new SIMD module that makes it possible to write
   highly accelerated CPU code that is still portable.
 - \subpage page_nbnxm <br/>
   Documentation about the non-bonded module which uses NxM atom clusters.
 - \subpage page_awh <br/>
   Documentation about the accelerated weight histogram (AWH) method,
   which is used for accelerating sampling along reaction coordinates.
 - \subpage page_mdmodules <br/>
   Documentation for work-in-progress modularization of parts of mdrun, that
   should make it easier to implement additional features as add-ons on top of
   a common interface.
 - \subpage page_refdata <br/>
   Documentation for writing tests that use reference data generated by the
   same test.
 - \subpage page_modularsimulator <br/>
   Documentation of the modular simulator approach.

 - \subpage page_modulegraph <br/>
   Automatically generated module dependency graph.
\endif

This list will hopefully expand over time.
