(**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the "hack" directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 *)

open FindRefsService

val to_json: result -> Hh_json.json

val get_refs : action -> bool -> ServerEnv.genv ->
  ServerEnv.env -> (string * Pos.t) list

val go : action -> bool -> ServerEnv.genv -> ServerEnv.env -> result

val go_from_file :
  (string * int * int * bool) -> ServerEnv.genv -> ServerEnv.env -> ide_result
