/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileSimple;
import org.hsqldb.rowio.RowInputBinary180;
import org.hsqldb.rowio.RowInputBinaryDecode;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary180;
import org.hsqldb.rowio.RowOutputBinaryEncode;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

public class DataFileCache {
    protected FileAccess fa;
    public static final int FLAG_ISSHADOWED = 1;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    public static final int FLAG_190 = 4;
    public static final int FLAG_HX = 5;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int LONG_EMPTY_INDEX_POS = 20;
    static final int FLAGS_POS = 28;
    static final int MIN_INITIAL_FREE_POS = 32;
    DataFileBlockManager freeBlocks;
    static final int initIOBufferSize = 4096;
    protected String dataFileName;
    protected String backupFileName;
    protected Database database;
    protected boolean logEvents = true;
    protected boolean fileModified;
    protected boolean cacheModified;
    protected int dataFileScale;
    protected boolean cacheReadonly;
    protected int cachedRowPadding;
    protected int initialFreePos;
    protected long fileStartFreePosition;
    protected boolean hasRowInfo = false;
    protected int storeCount;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    boolean is180;
    protected RandomAccessInterface dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public DataFileCache(Database database, String string) {
        this.initParams(database, string);
        this.cache = new Cache(this);
    }

    protected void initParams(Database database, String string) {
        this.dataFileName = string + ".data";
        this.backupFileName = string + ".backup";
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.dataFileScale = database.logger.getDataFileScale();
        this.cachedRowPadding = 8;
        if (this.dataFileScale > 8) {
            this.cachedRowPadding = this.dataFileScale;
        }
        this.initialFreePos = 32;
        if (this.initialFreePos < this.dataFileScale) {
            this.initialFreePos = this.dataFileScale;
        }
        this.cacheReadonly = database.logger.propFilesReadOnly;
        this.maxCacheRows = database.logger.propCacheMaxRows;
        this.maxCacheBytes = database.logger.propCacheMaxSize;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)database.logger.getDataFileFactor();
        this.dataFile = null;
        this.shadowFile = null;
    }

    public void open(boolean bl) {
        if (this.database.logger.isStoredFileAccess()) {
            this.openStoredFileAccess(bl);
            return;
        }
        this.fileFreePosition = this.initialFreePos;
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean bl2 = this.database.logger.propNioDataFile;
            int n = this.database.isFilesInJar() ? 2 : (bl2 ? 1 : 0);
            if (bl || this.database.isFilesInJar()) {
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                this.dataFile.seek(28L);
                int n2 = this.dataFile.readInt();
                boolean bl3 = this.is180 = !BitMap.isSet(n2, 4);
                if (BitMap.isSet(n2, 5)) {
                    throw Error.error(453);
                }
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.initBuffers();
                return;
            }
            long l = 0L;
            boolean bl4 = this.fa.isStreamElement(this.dataFileName);
            boolean bl5 = this.database.logger.propIncrementBackup;
            boolean bl6 = false;
            if (bl4) {
                int n3;
                this.dataFile = new ScaledRAFileSimple(this.database, this.dataFileName, "r");
                long l2 = this.dataFile.length();
                boolean bl7 = false;
                if (l2 > (long)this.initialFreePos) {
                    this.dataFile.seek(28L);
                    n3 = this.dataFile.readInt();
                    bl6 = BitMap.isSet(n3, 2);
                    bl5 = BitMap.isSet(n3, 1);
                    boolean bl8 = this.is180 = !BitMap.isSet(n3, 4);
                    if (BitMap.isSet(n3, 5)) {
                        bl7 = true;
                    }
                }
                this.dataFile.close();
                if (l2 > this.maxDataFileSize) {
                    throw Error.error(453, "requires large database support");
                }
                if (bl7) {
                    throw Error.error(453);
                }
                if (bl6 && bl5 && (n3 = (int)(this.fa.isStreamElement(this.backupFileName) ? 1 : 0)) != 0) {
                    bl6 = false;
                }
            }
            if (bl6) {
                if (bl5) {
                    this.deleteBackup();
                } else {
                    boolean bl9 = this.fa.isStreamElement(this.backupFileName);
                    if (!bl9) {
                        this.backupFile(false);
                    }
                }
            } else {
                bl4 = bl5 ? this.restoreBackupIncremental() : this.restoreBackup();
            }
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
            if (bl4) {
                this.dataFile.seek(28L);
                int n4 = this.dataFile.readInt();
                this.is180 = !BitMap.isSet(n4, 4);
                this.dataFile.seek(4L);
                l = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.openShadowFile();
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.freeBlocks = new DataFileBlockManager(this.database.logger.propMaxFreeBlocks, this.dataFileScale, 0, l);
            this.logInfoEvent("dataFileCache open end");
        }
        catch (Throwable throwable) {
            this.logSevereEvent("dataFileCache open failed", throwable);
            this.close(false);
            throw Error.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    void openStoredFileAccess(boolean bl) {
        this.fileFreePosition = this.initialFreePos;
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean bl2;
            int n = 3;
            if (bl) {
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                this.dataFile.seek(28L);
                int n2 = this.dataFile.readInt();
                this.is180 = !BitMap.isSet(n2, 4);
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.initBuffers();
                return;
            }
            long l = 0L;
            boolean bl3 = this.fa.isStreamElement(this.dataFileName);
            boolean bl4 = this.database.logger.propIncrementBackup;
            boolean bl5 = bl2 = this.database.getProperties().getDBModified() == 1;
            if (bl3 && bl2) {
                bl3 = bl4 ? this.restoreBackupIncremental() : this.restoreBackup();
            }
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
            if (bl3) {
                this.dataFile.seek(4L);
                l = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(28L);
                int n3 = this.dataFile.readInt();
                this.is180 = !BitMap.isSet(n3, 4);
                this.openShadowFile();
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.freeBlocks = new DataFileBlockManager(this.database.logger.propMaxFreeBlocks, this.dataFileScale, 0, l);
            this.logInfoEvent("dataFileCache open end");
        }
        catch (Throwable throwable) {
            this.logSevereEvent("dataFileCache open failed", throwable);
            this.close(false);
            throw Error.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    void initNewFile() throws IOException {
        this.fileFreePosition = this.initialFreePos;
        this.fileStartFreePosition = this.initialFreePos;
        this.dataFile.seek(12L);
        this.dataFile.writeLong(this.fileFreePosition);
        int n = 0;
        if (this.database.logger.propIncrementBackup) {
            n = BitMap.set(n, 1);
        }
        n = BitMap.set(n, 2);
        n = BitMap.set(n, 4);
        this.dataFile.seek(28L);
        this.dataFile.writeInt(n);
        this.dataFile.synch();
        this.is180 = false;
    }

    void openShadowFile() {
        if (this.database.logger.propIncrementBackup && this.fileFreePosition != (long)this.initialFreePos) {
            this.shadowFile = new RAShadowFile(this.database, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIncrementBackup(boolean bl) {
        this.writeLock.lock();
        try {
            this.dataFile.seek(28L);
            int n = this.dataFile.readInt();
            n = bl ? BitMap.set(n, 1) : BitMap.unset(n, 1);
            this.dataFile.seek(28L);
            this.dataFile.writeInt(n);
            this.dataFile.synch();
            this.fileModified = true;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("backupFile failed", throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean restoreBackup() {
        this.deleteFile();
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            if (fileAccess.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fileAccess, 1);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 26, new Object[]{throwable.toString(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            if (this.fa.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.database, this.backupFileName, this.dataFileName);
                this.deleteBackup();
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw Error.error(452, iOException);
        }
    }

    public void close(boolean bl) {
        this.writeLock.lock();
        try {
            boolean bl2;
            if (this.dataFile == null) {
                return;
            }
            if (bl) {
                this.commitChanges();
            } else if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file close");
            this.dataFile = null;
            if (!bl) {
                return;
            }
            boolean bl3 = bl2 = this.fileFreePosition == (long)this.initialFreePos;
            if (bl2) {
                this.deleteFile();
                this.deleteBackup();
            }
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("dataFileCache close failed", throwable);
            throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustStoreCount(int n) {
        this.writeLock.lock();
        try {
            this.storeCount += n;
            if (this.storeCount == 0) {
                this.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void commitChanges() {
        this.writeLock.lock();
        try {
            if (this.cacheReadonly) {
                return;
            }
            this.logInfoEvent("dataFileCache commit start");
            this.cache.saveAll();
            if (this.fileModified || this.freeBlocks.isModified()) {
                this.dataFile.seek(4L);
                this.dataFile.writeLong(this.freeBlocks.getLostBlocksSize());
                this.dataFile.seek(12L);
                this.dataFile.writeLong(this.fileFreePosition);
                this.dataFile.seek(28L);
                int n = this.dataFile.readInt();
                n = BitMap.set(n, 2);
                this.dataFile.seek(28L);
                this.dataFile.writeInt(n);
            }
            this.dataFile.synch();
            this.cache.logSynchEvent();
            this.fileModified = false;
            this.cacheModified = false;
            this.fileStartFreePosition = this.fileFreePosition;
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            this.logDetailEvent("dataFileCache commit end");
        }
        catch (Throwable throwable) {
            this.logSevereEvent("dataFileCache commit failed", throwable);
            throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null) {
            this.rowOut = this.is180 ? new RowOutputBinary180(4096, this.cachedRowPadding) : new RowOutputBinaryEncode(this.database.logger.getCrypto(), 4096, this.cachedRowPadding);
        }
        if (this.rowIn == null) {
            this.rowIn = this.is180 ? new RowInputBinary180(new byte[4096]) : new RowInputBinaryDecode(this.database.logger.getCrypto(), new byte[4096]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileDefrag defrag() {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dataFileDefrag = new DataFileDefrag(this.database, this, this.dataFileName);
            dataFileDefrag.process();
            this.close(true);
            this.cache.clear();
            if (!this.database.logger.propIncrementBackup) {
                this.backupFile(true);
            }
            this.database.schemaManager.setTempIndexRoots(dataFileDefrag.getIndexRoots());
            try {
                this.database.logger.log.writeScript(false);
            }
            finally {
                this.database.schemaManager.setTempIndexRoots(null);
            }
            this.database.getProperties().setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
            this.database.getProperties().setDBModified(2);
            this.database.logger.log.closeLog();
            this.database.logger.log.deleteLog();
            this.database.logger.log.renameNewScript();
            this.renameBackupFile();
            this.renameDataFile();
            this.database.getProperties().setDBModified(0);
            this.open(false);
            this.database.schemaManager.setIndexRoots(dataFileDefrag.getIndexRoots());
            if (this.database.logger.log.dbLogWriter != null) {
                this.database.logger.log.openLog();
            }
            this.database.getProperties().setDBModified(1);
            DataFileDefrag dataFileDefrag2 = dataFileDefrag;
            return dataFileDefrag2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long l, PersistentStore persistentStore) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = this.release(l);
            if (cachedObject != null) {
                int n = cachedObject.getStorageSize();
                this.freeBlocks.add(l, n);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removePersistence(CachedObject cachedObject) {
    }

    long setFilePos(CachedObject cachedObject) {
        int n = cachedObject.getStorageSize();
        long l = this.freeBlocks.get(n);
        if (l == -1L) {
            l = this.fileFreePosition / (long)this.dataFileScale;
            long l2 = this.fileFreePosition + (long)n;
            if (l2 > this.maxDataFileSize) {
                this.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
                throw Error.error(468);
            }
            boolean bl = this.dataFile.ensureLength(l2);
            if (!bl) {
                this.logSevereEvent("data file cannot be enlarged - disk spacee " + this.dataFileName, null);
                throw Error.error(468);
            }
            this.fileFreePosition = l2;
        }
        cachedObject.setPos(l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.cacheModified = true;
            long l = this.setFilePos(cachedObject);
            this.cache.put(l, cachedObject);
            if (cachedObject.getStorageSize() > 4096) {
                this.rowOut.reset(cachedObject.getStorageSize());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStorageSize(long l) {
        this.readLock.lock();
        try {
            CachedObject cachedObject = this.cache.get(l);
            if (cachedObject != null) {
                int n = cachedObject.getStorageSize();
                return n;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.readSize(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            long l = cachedObject.getPos();
            this.cache.replace(l, cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject cachedObject, PersistentStore persistentStore, boolean bl) {
        long l;
        this.readLock.lock();
        try {
            if (cachedObject.isInMemory()) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            l = cachedObject.getPos();
            if (l < 0L) {
                CachedObject cachedObject3 = null;
                return cachedObject3;
            }
            cachedObject = this.cache.get(l);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject4 = cachedObject;
                return cachedObject4;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(l, persistentStore, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(long l, PersistentStore persistentStore, boolean bl) {
        if (l < 0L) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject cachedObject = this.cache.get(l);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(l, persistentStore, bl);
    }

    private CachedObject getFromFile(long l, PersistentStore persistentStore, boolean bl) {
        CachedObject cachedObject = null;
        this.writeLock.lock();
        try {
            cachedObject = this.cache.get(l);
            if (cachedObject != null) {
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                return cachedObject2;
            }
            for (int i = 0; i < 2; ++i) {
                RowInputInterface rowInputInterface;
                block14: {
                    try {
                        rowInputInterface = this.readObject(l);
                        if (rowInputInterface != null) break block14;
                        CachedObject cachedObject3 = null;
                        return cachedObject3;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.cache.forceCleanUp();
                        System.gc();
                        this.logSevereEvent(this.dataFileName + " getFromFile out of mem " + l, outOfMemoryError);
                        if (i <= 0) continue;
                        throw outOfMemoryError;
                    }
                }
                cachedObject = persistentStore.get(rowInputInterface);
                break;
            }
            l = cachedObject.getPos();
            this.cache.put(l, cachedObject);
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            persistentStore.set(cachedObject);
            CachedObject cachedObject4 = cachedObject;
            return cachedObject4;
        }
        catch (HsqlException hsqlException) {
            this.logSevereEvent(this.dataFileName + " getFromFile " + l, hsqlException);
            throw hsqlException;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInputInterface getRaw(int n) {
        this.writeLock.lock();
        try {
            RowInputInterface rowInputInterface = this.readObject(n);
            return rowInputInterface;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected int readSize(long l) {
        this.writeLock.lock();
        try {
            this.dataFile.seek(l * (long)this.dataFileScale);
            int n = this.dataFile.readInt();
            return n;
        }
        catch (IOException iOException) {
            this.logSevereEvent("readSize", iOException, l);
            throw Error.error(466, iOException);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected RowInputInterface readObject(long l) {
        try {
            this.dataFile.seek(l * (long)this.dataFileScale);
            int n = this.dataFile.readInt();
            this.rowIn.resetRow(l, n);
            this.dataFile.read(this.rowIn.getBuffer(), 4, n - 4);
            return this.rowIn;
        }
        catch (IOException iOException) {
            this.logSevereEvent("readObject", iOException, l);
            throw Error.error(466, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject release(long l) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = this.cache.release(l);
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRows(CachedObject[] cachedObjectArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        try {
            this.copyShadow(cachedObjectArray, n, n2);
            this.setFileModified();
            for (int i = n; i < n + n2; ++i) {
                CachedObject cachedObject = cachedObjectArray[i];
                this.saveRowNoLock(cachedObject);
                cachedObjectArray[i] = null;
            }
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
        finally {
            this.initBuffers();
        }
    }

    public void saveRow(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.copyShadow(cachedObject);
            this.setFileModified();
            this.saveRowNoLock(cachedObject);
        }
        catch (Throwable throwable) {
            this.logSevereEvent("saveRow", throwable, cachedObject.getPos());
            throw Error.error(466, throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRowNoLock(CachedObject cachedObject) {
        try {
            this.rowOut.reset();
            cachedObject.write(this.rowOut);
            this.dataFile.seek(cachedObject.getPos() * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (IOException iOException) {
            this.logSevereEvent("saveRowNoLock", iOException, cachedObject.getPos());
            throw Error.error(466, iOException);
        }
    }

    protected void copyShadow(CachedObject[] cachedObjectArray, int n, int n2) throws IOException {
        if (this.shadowFile != null) {
            long l = this.cache.saveAllTimer.elapsedTime();
            for (int i = n; i < n + n2; ++i) {
                CachedObject cachedObject = cachedObjectArray[i];
                long l2 = cachedObject.getPos() * (long)this.dataFileScale;
                this.shadowFile.copy(l2, cachedObject.getStorageSize());
            }
            this.shadowFile.synch();
            l = this.cache.saveAllTimer.elapsedTime() - l;
            this.logDetailEvent("shadow copy [time, size] " + l + " " + this.shadowFile.getSavedLength());
        }
    }

    protected void copyShadow(CachedObject cachedObject) throws IOException {
        if (this.shadowFile != null) {
            long l = cachedObject.getPos() * (long)this.dataFileScale;
            this.shadowFile.copy(l, cachedObject.getStorageSize());
            this.shadowFile.synch();
        }
    }

    void backupFile(boolean bl) {
        this.writeLock.lock();
        try {
            if (this.database.logger.propIncrementBackup) {
                if (this.fa.isStreamElement(this.backupFileName)) {
                    this.deleteBackup();
                }
                return;
            }
            if (this.fa.isStreamElement(this.dataFileName)) {
                String string = bl ? this.dataFileName + ".new" : this.dataFileName;
                FileArchiver.archive(string, this.backupFileName + ".new", this.database.logger.getFileAccess(), 1);
            }
        }
        catch (IOException iOException) {
            this.logSevereEvent("backupFile failed", iOException);
            throw Error.error(466, iOException);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameBackupFile() {
        this.writeLock.lock();
        try {
            if (this.database.logger.propIncrementBackup) {
                this.deleteBackup();
                return;
            }
            if (this.fa.isStreamElement(this.backupFileName + ".new")) {
                this.deleteBackup();
                this.fa.renameElement(this.backupFileName + ".new", this.backupFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameDataFile() {
        this.writeLock.lock();
        try {
            if (this.fa.isStreamElement(this.dataFileName + ".new")) {
                this.deleteFile();
                this.fa.renameElement(this.dataFileName + ".new", this.dataFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFile() {
        this.writeLock.lock();
        try {
            this.fa.removeElement(this.dataFileName);
            if (this.database.logger.isStoredFileAccess()) {
                return;
            }
            if (this.fa.isStreamElement(this.dataFileName)) {
                this.database.logger.log.deleteOldDataFiles();
                this.fa.removeElement(this.dataFileName);
                if (this.fa.isStreamElement(this.dataFileName)) {
                    String string = FileUtil.newDiscardFileName(this.dataFileName);
                    this.fa.renameElement(this.dataFileName, string);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteBackup() {
        this.writeLock.lock();
        try {
            if (this.fa.isStreamElement(this.backupFileName)) {
                this.fa.removeElement(this.backupFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public int getFreeBlockCount() {
        return this.freeBlocks.size();
    }

    public int getTotalFreeBlockSize() {
        return 0;
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public int getAccessCount() {
        return this.cache.incrementAccessCount();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isModified() {
        return this.cacheModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFileModified() {
        this.writeLock.lock();
        try {
            if (!this.fileModified) {
                long l = this.cache.saveAllTimer.elapsedTime();
                this.cache.saveAllTimer.start();
                this.dataFile.seek(28L);
                int n = this.dataFile.readInt();
                n = BitMap.unset(n, 2);
                this.dataFile.seek(28L);
                this.dataFile.writeInt(n);
                this.dataFile.synch();
                this.cache.saveAllTimer.stop();
                this.logDetailEvent("flags set " + this.cache.saveAllTimer.elapsedTime());
                this.fileModified = true;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getFlags() {
        try {
            this.dataFile.seek(28L);
            int n = this.dataFile.readInt();
            return n;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }

    public RAShadowFile getShadowFile() {
        return this.shadowFile;
    }

    private void logSevereEvent(String string, Throwable throwable, long l) {
        if (this.logEvents) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(' ').append(l);
            string = stringBuffer.toString();
            this.database.logger.logSevereEvent(string, throwable);
        }
    }

    private void logSevereEvent(String string, Throwable throwable) {
        if (this.logEvents) {
            this.database.logger.logSevereEvent(string, throwable);
        }
    }

    public void logInfoEvent(String string) {
        if (this.logEvents) {
            this.database.logger.logInfoEvent(string);
        }
    }

    public void logDetailEvent(String string) {
        if (this.logEvents) {
            this.database.logger.logDetailEvent(string);
        }
    }
}

