///////
   //    RunInfo.h
   //    RunInfo Class declaration
   //
   //    Class to that contains all the general info about the run
   //    They will be stored into the 'htCheck' table of the database
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: RunInfo.h,v 1.8 2006-08-25 10:17:45 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 18.08.2000
///////

#ifndef __RUN_INFO_H
#define __RUN_INFO_H

#include "HtDateTime.h"

class RunInfo
{
   public:
   
      // Construction / Destruction
      RunInfo();
      virtual ~RunInfo();
      
      HtDateTime StartTime;        // Start time of scheduling
      HtDateTime FinishTime;       // Finish time of scheduling
      int        RetrievedUrls;    // Number of Urls that have been retrieved
      int        TotUrls;          // Total Urls to retrieve
      int        ScheduledUrls;    // Total Urls "seen"
      int        HTTPSeconds;      // Seconds of HTTP connections
      int        HTTPRequests;     // Number of HTTP requests
      int        HTTPBytes;        // Number of bytes retrieved by
                                   // HTTP connections
      int        TCPConnections;   // Number of TCP connections   
      int        ServerChanges;    // Number of Server changes
      int        AccessibilityChecks; // Accessibility checks enabled or not
      int        HtDigNotification; // ht://Dig notification enabled or not
      
};

#endif
