/* test-iagno.c generated by valac 0.40.0.6-2c488, the Vala compiler
 * generated from test-iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2013 Michael Catanzaro
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_TEST_IAGNO (test_iagno_get_type ())
#define TEST_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_IAGNO, TestIagno))
#define TEST_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_IAGNO, TestIagnoClass))
#define IS_TEST_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_IAGNO))
#define IS_TEST_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_IAGNO))
#define TEST_IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_IAGNO, TestIagnoClass))

typedef struct _TestIagno TestIagno;
typedef struct _TestIagnoClass TestIagnoClass;
typedef struct _TestIagnoPrivate TestIagnoPrivate;
enum  {
	TEST_IAGNO_0_PROPERTY,
	TEST_IAGNO_NUM_PROPERTIES
};
static GParamSpec* test_iagno_properties[TEST_IAGNO_NUM_PROPERTIES];

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_PLAYER (player_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TestIagno {
	GObject parent_instance;
	TestIagnoPrivate * priv;
};

struct _TestIagnoClass {
	GObjectClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;


static gpointer test_iagno_parent_class = NULL;

GType test_iagno_get_type (void) G_GNUC_CONST;
static void test_iagno_test_undo_after_pass (void);
GType game_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
Game* game_new_from_strings (gchar** setup,
                             int setup_length1,
                             Player to_move,
                             gint tmp_size);
Game* game_construct_from_strings (GType object_type,
                                   gchar** setup,
                                   int setup_length1,
                                   Player to_move,
                                   gint tmp_size);
gint game_get_number_of_moves (Game* self);
gint game_place_tile (Game* self,
                      gint x,
                      gint y,
                      gboolean apply);
gboolean game_get_current_player_can_move (Game* self);
void game_pass (Game* self);
void game_undo (Game* self,
                gint count);
gchar* game_to_string (Game* self);
static void test_iagno_test_undo_at_start (void);
Game* game_new (gboolean alternative_start,
                gint tmp_size);
Game* game_construct (GType object_type,
                      gboolean alternative_start,
                      gint tmp_size);
static void test_iagno_test_current_color_after_pass (void);
Player game_get_current_color (Game* self);
static void test_iagno_test_ai_search_1 (void);
GType computer_player_get_type (void) G_GNUC_CONST;
ComputerPlayer* computer_player_new (Game* game,
                                     gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type,
                                           Game* game,
                                           gint difficulty_level);
void computer_player_move (ComputerPlayer* self);
static void test_iagno_test_ai_search_2 (void);
static void test_iagno_test_ai_search_3 (void);
Player game_get_owner (Game* self,
                       gint x,
                       gint y);
static void test_iagno_test_ai_search_4 (void);
static void test_iagno_test_ai_search_5 (void);
gint test_iagno_main (gchar** args,
                      int args_length1);
static void _test_iagno_test_undo_after_pass_gtest_func (void);
static void _test_iagno_test_undo_at_start_gtest_func (void);
static void _test_iagno_test_current_color_after_pass_gtest_func (void);
static void _test_iagno_test_ai_search_1_gtest_func (void);
static void _test_iagno_test_ai_search_2_gtest_func (void);
static void _test_iagno_test_ai_search_3_gtest_func (void);
static void _test_iagno_test_ai_search_4_gtest_func (void);
static void _test_iagno_test_ai_search_5_gtest_func (void);
TestIagno* test_iagno_new (void);
TestIagno* test_iagno_construct (GType object_type);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static void
test_iagno_test_undo_after_pass (void)
{
	gchar** board = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint board_length1;
	gint _board_size_;
	Game* game = NULL;
	Game* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	_tmp0_ = g_strdup (" . . . . L L L L");
	_tmp1_ = g_strdup (" . . . L L L L D");
	_tmp2_ = g_strdup (" . . L L L L D .");
	_tmp3_ = g_strdup (" . . L L L D L L");
	_tmp4_ = g_strdup (" . L L L D L L L");
	_tmp5_ = g_strdup (" . L L D D L L L");
	_tmp6_ = g_strdup (" L L L L L L L L");
	_tmp7_ = g_strdup (" L L L L L L L L");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	board = _tmp8_;
	board_length1 = 8;
	_board_size_ = board_length1;
	_tmp9_ = game_new_from_strings (board, board_length1, PLAYER_DARK, 8);
	game = _tmp9_;
	_tmp10_ = game_get_number_of_moves (game);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp11_ == 0, "game.number_of_moves == 0");
	_vala_assert (game_place_tile (game, 7, 2, TRUE) > 0, "game.place_tile (7, 2) > 0");
	_tmp12_ = game_get_number_of_moves (game);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp13_ == 1, "game.number_of_moves == 1");
	_tmp14_ = game_get_current_player_can_move (game);
	_tmp15_ = _tmp14_;
	_vala_assert (!_tmp15_, "!game.current_player_can_move");
	game_pass (game);
	_tmp16_ = game_get_number_of_moves (game);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp17_ == 2, "game.number_of_moves == 2");
	game_undo (game, 2);
	_tmp18_ = game_get_number_of_moves (game);
	_tmp19_ = _tmp18_;
	_vala_assert (_tmp19_ == 0, "game.number_of_moves == 0");
	_tmp20_ = game_to_string (game);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_strip (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _vala_g_strjoinv ("\n", board, board_length1);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_strip (_tmp25_);
	_tmp27_ = _tmp26_;
	_vala_assert (g_strcmp0 (_tmp23_, _tmp27_) == 0, "game.to_string ().strip () == string.joinv (\"\\n\", board).strip ()");
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_vala_assert (game_place_tile (game, 7, 2, TRUE) > 0, "game.place_tile (7, 2) > 0");
	_tmp28_ = game_get_number_of_moves (game);
	_tmp29_ = _tmp28_;
	_vala_assert (_tmp29_ == 1, "game.number_of_moves == 1");
	_tmp30_ = game_get_current_player_can_move (game);
	_tmp31_ = _tmp30_;
	_vala_assert (!_tmp31_, "!game.current_player_can_move");
	game_undo (game, 1);
	_tmp32_ = game_get_number_of_moves (game);
	_tmp33_ = _tmp32_;
	_vala_assert (_tmp33_ == 0, "game.number_of_moves == 0");
	_tmp34_ = game_to_string (game);
	_tmp35_ = _tmp34_;
	_tmp36_ = string_strip (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _vala_g_strjoinv ("\n", board, board_length1);
	_tmp39_ = _tmp38_;
	_tmp40_ = string_strip (_tmp39_);
	_tmp41_ = _tmp40_;
	_vala_assert (g_strcmp0 (_tmp37_, _tmp41_) == 0, "game.to_string ().strip () == string.joinv (\"\\n\", board).strip ()");
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_object_unref0 (game);
	board = (_vala_array_free (board, board_length1, (GDestroyNotify) g_free), NULL);
}


static void
test_iagno_test_undo_at_start (void)
{
	Game* game = NULL;
	Game* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	_tmp0_ = game_new (FALSE, 8);
	game = _tmp0_;
	_tmp1_ = game_get_number_of_moves (game);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ == 0, "game.number_of_moves == 0");
	game_place_tile (game, 2, 3, TRUE);
	_tmp3_ = game_get_number_of_moves (game);
	_tmp4_ = _tmp3_;
	_vala_assert (_tmp4_ == 1, "game.number_of_moves == 1");
	game_place_tile (game, 2, 2, TRUE);
	_tmp5_ = game_get_number_of_moves (game);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp6_ == 2, "game.number_of_moves == 2");
	_g_object_unref0 (game);
}


static void
test_iagno_test_current_color_after_pass (void)
{
	gchar** board = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint board_length1;
	gint _board_size_;
	Game* game = NULL;
	Game* _tmp9_;
	Player _tmp10_;
	Player _tmp11_;
	Player _tmp12_;
	Player _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	Player _tmp16_;
	Player _tmp17_;
	_tmp0_ = g_strdup (" L . L L L L L L");
	_tmp1_ = g_strdup (" L L L L L L L L");
	_tmp2_ = g_strdup (" L . L L L L L L");
	_tmp3_ = g_strdup (" L D L L L L L L");
	_tmp4_ = g_strdup (" L D D L D L L L");
	_tmp5_ = g_strdup (" L D L D L L L L");
	_tmp6_ = g_strdup (" D D D D D L L L");
	_tmp7_ = g_strdup (" D D D D D D D D");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	board = _tmp8_;
	board_length1 = 8;
	_board_size_ = board_length1;
	_tmp9_ = game_new_from_strings (board, board_length1, PLAYER_DARK, 8);
	game = _tmp9_;
	_tmp10_ = game_get_current_color (game);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp11_ == PLAYER_DARK, "game.current_color == Player.DARK");
	_vala_assert (game_place_tile (game, 1, 2, TRUE) > 0, "game.place_tile (1, 2) > 0");
	_tmp12_ = game_get_current_color (game);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp13_ == PLAYER_LIGHT, "game.current_color == Player.LIGHT");
	_tmp14_ = game_get_current_player_can_move (game);
	_tmp15_ = _tmp14_;
	_vala_assert (!_tmp15_, "!game.current_player_can_move");
	game_pass (game);
	_tmp16_ = game_get_current_color (game);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp17_ == PLAYER_DARK, "game.current_color == Player.DARK");
	_g_object_unref0 (game);
	board = (_vala_array_free (board, board_length1, (GDestroyNotify) g_free), NULL);
}


static void
test_iagno_test_ai_search_1 (void)
{
	gchar** board = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint board_length1;
	gint _board_size_;
	Game* game = NULL;
	Game* _tmp9_;
	ComputerPlayer* ai = NULL;
	ComputerPlayer* _tmp10_;
	_tmp0_ = g_strdup (" L . . L L L L L");
	_tmp1_ = g_strdup (" L L D D D D D D");
	_tmp2_ = g_strdup (" D D D D D L D D");
	_tmp3_ = g_strdup (" L D L L L L L L");
	_tmp4_ = g_strdup (" L L D L D D L L");
	_tmp5_ = g_strdup (" L L D D L L L L");
	_tmp6_ = g_strdup (" L L L L L L L L");
	_tmp7_ = g_strdup (" L L L L L L L L");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	board = _tmp8_;
	board_length1 = 8;
	_board_size_ = board_length1;
	_tmp9_ = game_new_from_strings (board, board_length1, PLAYER_LIGHT, 8);
	game = _tmp9_;
	_tmp10_ = computer_player_new (game, 1);
	ai = _tmp10_;
	computer_player_move (ai);
	_g_object_unref0 (ai);
	_g_object_unref0 (game);
	board = (_vala_array_free (board, board_length1, (GDestroyNotify) g_free), NULL);
}


static void
test_iagno_test_ai_search_2 (void)
{
	gchar** board = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint board_length1;
	gint _board_size_;
	Game* game = NULL;
	Game* _tmp9_;
	ComputerPlayer* ai = NULL;
	ComputerPlayer* _tmp10_;
	_tmp0_ = g_strdup (" . . . . . . . .");
	_tmp1_ = g_strdup (" . . . . . . . .");
	_tmp2_ = g_strdup (" . . . D . . . .");
	_tmp3_ = g_strdup (" . . . D D . . .");
	_tmp4_ = g_strdup (" . . . D L L . .");
	_tmp5_ = g_strdup (" . . D D D . . .");
	_tmp6_ = g_strdup (" . . . D . . . .");
	_tmp7_ = g_strdup (" . . D . . . . .");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	board = _tmp8_;
	board_length1 = 8;
	_board_size_ = board_length1;
	_tmp9_ = game_new_from_strings (board, board_length1, PLAYER_LIGHT, 8);
	game = _tmp9_;
	_tmp10_ = computer_player_new (game, 1);
	ai = _tmp10_;
	computer_player_move (ai);
	_g_object_unref0 (ai);
	_g_object_unref0 (game);
	board = (_vala_array_free (board, board_length1, (GDestroyNotify) g_free), NULL);
}


static void
test_iagno_test_ai_search_3 (void)
{
	gchar** board = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint board_length1;
	gint _board_size_;
	Game* game = NULL;
	Game* _tmp9_;
	ComputerPlayer* ai = NULL;
	ComputerPlayer* _tmp10_;
	_tmp0_ = g_strdup (" D L . D D D D D");
	_tmp1_ = g_strdup (" D L D D D D D D");
	_tmp2_ = g_strdup (" D D L D L D D D");
	_tmp3_ = g_strdup (" D L D D L D D D");
	_tmp4_ = g_strdup (" D D L D L L L D");
	_tmp5_ = g_strdup (" D L D D L D L D");
	_tmp6_ = g_strdup (" L L L L L D D D");
	_tmp7_ = g_strdup (" D D D D D D D D");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	board = _tmp8_;
	board_length1 = 8;
	_board_size_ = board_length1;
	_tmp9_ = game_new_from_strings (board, board_length1, PLAYER_LIGHT, 8);
	game = _tmp9_;
	_tmp10_ = computer_player_new (game, 1);
	ai = _tmp10_;
	computer_player_move (ai);
	_vala_assert (game_get_owner (game, 2, 0) == PLAYER_LIGHT, "game.get_owner (2, 0) == Player.LIGHT");
	_g_object_unref0 (ai);
	_g_object_unref0 (game);
	board = (_vala_array_free (board, board_length1, (GDestroyNotify) g_free), NULL);
}


static void
test_iagno_test_ai_search_4 (void)
{
	gchar** board = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint board_length1;
	gint _board_size_;
	Game* game = NULL;
	Game* _tmp9_;
	ComputerPlayer* ai = NULL;
	ComputerPlayer* _tmp10_;
	_tmp0_ = g_strdup (" . . L D D D D D");
	_tmp1_ = g_strdup (" D L D L D L D D");
	_tmp2_ = g_strdup (" D D D L L D L D");
	_tmp3_ = g_strdup (" D D L L D L D D");
	_tmp4_ = g_strdup (" D L L L D D D D");
	_tmp5_ = g_strdup (" D L D L D L D D");
	_tmp6_ = g_strdup (" D D D L L D D D");
	_tmp7_ = g_strdup (" D D D L D D D D");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	board = _tmp8_;
	board_length1 = 8;
	_board_size_ = board_length1;
	_tmp9_ = game_new_from_strings (board, board_length1, PLAYER_LIGHT, 8);
	game = _tmp9_;
	_tmp10_ = computer_player_new (game, 1);
	ai = _tmp10_;
	computer_player_move (ai);
	_vala_assert (game_get_owner (game, 1, 0) == PLAYER_LIGHT, "game.get_owner (1, 0) == Player.LIGHT");
	_g_object_unref0 (ai);
	_g_object_unref0 (game);
	board = (_vala_array_free (board, board_length1, (GDestroyNotify) g_free), NULL);
}


static void
test_iagno_test_ai_search_5 (void)
{
	gchar** board = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint board_length1;
	gint _board_size_;
	Game* game = NULL;
	Game* _tmp9_;
	ComputerPlayer* ai = NULL;
	ComputerPlayer* _tmp10_;
	_tmp0_ = g_strdup (" . . . . . L . .");
	_tmp1_ = g_strdup (" . . . . L L . .");
	_tmp2_ = g_strdup (" . . L L L L . .");
	_tmp3_ = g_strdup (" . . L L L L . .");
	_tmp4_ = g_strdup (" . D D D L L L L");
	_tmp5_ = g_strdup (" . L . D L L L L");
	_tmp6_ = g_strdup (" . L L L D L L L");
	_tmp7_ = g_strdup (" . . L L L L L L");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	board = _tmp8_;
	board_length1 = 8;
	_board_size_ = board_length1;
	_tmp9_ = game_new_from_strings (board, board_length1, PLAYER_LIGHT, 8);
	game = _tmp9_;
	_tmp10_ = computer_player_new (game, 1);
	ai = _tmp10_;
	computer_player_move (ai);
	_g_object_unref0 (ai);
	_g_object_unref0 (game);
	board = (_vala_array_free (board, board_length1, (GDestroyNotify) g_free), NULL);
}


static void
_test_iagno_test_undo_after_pass_gtest_func (void)
{
	test_iagno_test_undo_after_pass ();
}


static void
_test_iagno_test_undo_at_start_gtest_func (void)
{
	test_iagno_test_undo_at_start ();
}


static void
_test_iagno_test_current_color_after_pass_gtest_func (void)
{
	test_iagno_test_current_color_after_pass ();
}


static void
_test_iagno_test_ai_search_1_gtest_func (void)
{
	test_iagno_test_ai_search_1 ();
}


static void
_test_iagno_test_ai_search_2_gtest_func (void)
{
	test_iagno_test_ai_search_2 ();
}


static void
_test_iagno_test_ai_search_3_gtest_func (void)
{
	test_iagno_test_ai_search_3 ();
}


static void
_test_iagno_test_ai_search_4_gtest_func (void)
{
	test_iagno_test_ai_search_4 ();
}


static void
_test_iagno_test_ai_search_5_gtest_func (void)
{
	test_iagno_test_ai_search_5 ();
}


gint
test_iagno_main (gchar** args,
                 int args_length1)
{
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/Iagno/Pass then Undo", _test_iagno_test_undo_after_pass_gtest_func);
	g_test_add_func ("/Iagno/Undo at Start", _test_iagno_test_undo_at_start_gtest_func);
	g_test_add_func ("/Iagno/Current Color after Pass", _test_iagno_test_current_color_after_pass_gtest_func);
	g_test_add_func ("/Iagno/AI Search 1", _test_iagno_test_ai_search_1_gtest_func);
	g_test_add_func ("/Iagno/AI Search 2", _test_iagno_test_ai_search_2_gtest_func);
	g_test_add_func ("/Iagno/AI Search 3", _test_iagno_test_ai_search_3_gtest_func);
	g_test_add_func ("/Iagno/AI Search 4", _test_iagno_test_ai_search_4_gtest_func);
	g_test_add_func ("/Iagno/AI Search 5", _test_iagno_test_ai_search_5_gtest_func);
	result = g_test_run ();
	return result;
}


int
main (int argc,
      char ** argv)
{
	return test_iagno_main (argv, argc);
}


TestIagno*
test_iagno_construct (GType object_type)
{
	TestIagno * self = NULL;
	self = (TestIagno*) g_object_new (object_type, NULL);
	return self;
}


TestIagno*
test_iagno_new (void)
{
	return test_iagno_construct (TYPE_TEST_IAGNO);
}


static void
test_iagno_class_init (TestIagnoClass * klass)
{
	test_iagno_parent_class = g_type_class_peek_parent (klass);
}


static void
test_iagno_instance_init (TestIagno * self)
{
}


GType
test_iagno_get_type (void)
{
	static volatile gsize test_iagno_type_id__volatile = 0;
	if (g_once_init_enter (&test_iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestIagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestIagno), 0, (GInstanceInitFunc) test_iagno_instance_init, NULL };
		GType test_iagno_type_id;
		test_iagno_type_id = g_type_register_static (G_TYPE_OBJECT, "TestIagno", &g_define_type_info, 0);
		g_once_init_leave (&test_iagno_type_id__volatile, test_iagno_type_id);
	}
	return test_iagno_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



