/*
 * Copyright (C) 2021-2022 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

// This is a generated file - please don't modify directly
#pragma once
#include "wsl_compute_helper_types_tokens.h"
#include "wsl_compute_helper_types_tokens_structs.h"

template <TOK StrT>
struct Marshaller;

template <typename GT_SUBSLICE_INFOT>
inline void marshall(TOKSTR_GT_SUBSLICE_INFO &dst, const GT_SUBSLICE_INFOT &src) {
    dst = {};
    dst.Enabled.setValue(src.Enabled);
    dst.EuEnabledCount.setValue(src.EuEnabledCount);
    dst.EuEnabledMask.setValue(src.EuEnabledMask);
}
template <>
struct Marshaller<TOK_S_GT_SUBSLICE_INFO> {
    template <typename GT_SUBSLICE_INFOT>
    static TOKSTR_GT_SUBSLICE_INFO marshall(const GT_SUBSLICE_INFOT &src) {
        TOKSTR_GT_SUBSLICE_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GT_DUALSUBSLICE_INFOT>
inline void marshall(TOKSTR_GT_DUALSUBSLICE_INFO &dst, const GT_DUALSUBSLICE_INFOT &src) {
    dst = {};
    dst.Enabled.setValue(src.Enabled);
    dst.SubSlice[0].Enabled.setValue(src.SubSlice[0].Enabled);
    dst.SubSlice[0].EuEnabledCount.setValue(src.SubSlice[0].EuEnabledCount);
    dst.SubSlice[0].EuEnabledMask.setValue(src.SubSlice[0].EuEnabledMask);
    dst.SubSlice[1].Enabled.setValue(src.SubSlice[1].Enabled);
    dst.SubSlice[1].EuEnabledCount.setValue(src.SubSlice[1].EuEnabledCount);
    dst.SubSlice[1].EuEnabledMask.setValue(src.SubSlice[1].EuEnabledMask);
}
template <>
struct Marshaller<TOK_S_GT_DUALSUBSLICE_INFO> {
    template <typename GT_DUALSUBSLICE_INFOT>
    static TOKSTR_GT_DUALSUBSLICE_INFO marshall(const GT_DUALSUBSLICE_INFOT &src) {
        TOKSTR_GT_DUALSUBSLICE_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GT_SLICE_INFOT>
inline void marshall(TOKSTR_GT_SLICE_INFO &dst, const GT_SLICE_INFOT &src) {
    dst = {};
    dst.Enabled.setValue(src.Enabled);
    dst.SubSliceInfo[0].Enabled.setValue(src.SubSliceInfo[0].Enabled);
    dst.SubSliceInfo[0].EuEnabledCount.setValue(src.SubSliceInfo[0].EuEnabledCount);
    dst.SubSliceInfo[0].EuEnabledMask.setValue(src.SubSliceInfo[0].EuEnabledMask);
    dst.SubSliceInfo[1].Enabled.setValue(src.SubSliceInfo[1].Enabled);
    dst.SubSliceInfo[1].EuEnabledCount.setValue(src.SubSliceInfo[1].EuEnabledCount);
    dst.SubSliceInfo[1].EuEnabledMask.setValue(src.SubSliceInfo[1].EuEnabledMask);
    dst.SubSliceInfo[2].Enabled.setValue(src.SubSliceInfo[2].Enabled);
    dst.SubSliceInfo[2].EuEnabledCount.setValue(src.SubSliceInfo[2].EuEnabledCount);
    dst.SubSliceInfo[2].EuEnabledMask.setValue(src.SubSliceInfo[2].EuEnabledMask);
    dst.SubSliceInfo[3].Enabled.setValue(src.SubSliceInfo[3].Enabled);
    dst.SubSliceInfo[3].EuEnabledCount.setValue(src.SubSliceInfo[3].EuEnabledCount);
    dst.SubSliceInfo[3].EuEnabledMask.setValue(src.SubSliceInfo[3].EuEnabledMask);
    dst.SubSliceInfo[4].Enabled.setValue(src.SubSliceInfo[4].Enabled);
    dst.SubSliceInfo[4].EuEnabledCount.setValue(src.SubSliceInfo[4].EuEnabledCount);
    dst.SubSliceInfo[4].EuEnabledMask.setValue(src.SubSliceInfo[4].EuEnabledMask);
    dst.SubSliceInfo[5].Enabled.setValue(src.SubSliceInfo[5].Enabled);
    dst.SubSliceInfo[5].EuEnabledCount.setValue(src.SubSliceInfo[5].EuEnabledCount);
    dst.SubSliceInfo[5].EuEnabledMask.setValue(src.SubSliceInfo[5].EuEnabledMask);
    dst.SubSliceInfo[6].Enabled.setValue(src.SubSliceInfo[6].Enabled);
    dst.SubSliceInfo[6].EuEnabledCount.setValue(src.SubSliceInfo[6].EuEnabledCount);
    dst.SubSliceInfo[6].EuEnabledMask.setValue(src.SubSliceInfo[6].EuEnabledMask);
    dst.SubSliceInfo[7].Enabled.setValue(src.SubSliceInfo[7].Enabled);
    dst.SubSliceInfo[7].EuEnabledCount.setValue(src.SubSliceInfo[7].EuEnabledCount);
    dst.SubSliceInfo[7].EuEnabledMask.setValue(src.SubSliceInfo[7].EuEnabledMask);
    dst.DSSInfo[0].Enabled.setValue(src.DSSInfo[0].Enabled);
    dst.DSSInfo[0].SubSlice[0].Enabled.setValue(src.DSSInfo[0].SubSlice[0].Enabled);
    dst.DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.DSSInfo[0].SubSlice[1].Enabled.setValue(src.DSSInfo[0].SubSlice[1].Enabled);
    dst.DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.DSSInfo[1].Enabled.setValue(src.DSSInfo[1].Enabled);
    dst.DSSInfo[1].SubSlice[0].Enabled.setValue(src.DSSInfo[1].SubSlice[0].Enabled);
    dst.DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.DSSInfo[1].SubSlice[1].Enabled.setValue(src.DSSInfo[1].SubSlice[1].Enabled);
    dst.DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.DSSInfo[2].Enabled.setValue(src.DSSInfo[2].Enabled);
    dst.DSSInfo[2].SubSlice[0].Enabled.setValue(src.DSSInfo[2].SubSlice[0].Enabled);
    dst.DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.DSSInfo[2].SubSlice[1].Enabled.setValue(src.DSSInfo[2].SubSlice[1].Enabled);
    dst.DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.DSSInfo[3].Enabled.setValue(src.DSSInfo[3].Enabled);
    dst.DSSInfo[3].SubSlice[0].Enabled.setValue(src.DSSInfo[3].SubSlice[0].Enabled);
    dst.DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.DSSInfo[3].SubSlice[1].Enabled.setValue(src.DSSInfo[3].SubSlice[1].Enabled);
    dst.DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.DSSInfo[4].Enabled.setValue(src.DSSInfo[4].Enabled);
    dst.DSSInfo[4].SubSlice[0].Enabled.setValue(src.DSSInfo[4].SubSlice[0].Enabled);
    dst.DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.DSSInfo[4].SubSlice[1].Enabled.setValue(src.DSSInfo[4].SubSlice[1].Enabled);
    dst.DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.DSSInfo[5].Enabled.setValue(src.DSSInfo[5].Enabled);
    dst.DSSInfo[5].SubSlice[0].Enabled.setValue(src.DSSInfo[5].SubSlice[0].Enabled);
    dst.DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.DSSInfo[5].SubSlice[1].Enabled.setValue(src.DSSInfo[5].SubSlice[1].Enabled);
    dst.DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SubSliceEnabledCount.setValue(src.SubSliceEnabledCount);
    dst.DualSubSliceEnabledCount.setValue(src.DualSubSliceEnabledCount);
}
template <>
struct Marshaller<TOK_S_GT_SLICE_INFO> {
    template <typename GT_SLICE_INFOT>
    static TOKSTR_GT_SLICE_INFO marshall(const GT_SLICE_INFOT &src) {
        TOKSTR_GT_SLICE_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GT_VEBOX_INFOT>
inline void marshall(TOKSTR_GT_VEBOX_INFO &dst, const GT_VEBOX_INFOT &src) {
    dst = {};
    dst.Instances.Bits.VEBox0Enabled.setValue(src.Instances.Bits.VEBox0Enabled);
    dst.Instances.Bits.VEBox1Enabled.setValue(src.Instances.Bits.VEBox1Enabled);
    dst.Instances.Bits.VEBox2Enabled.setValue(src.Instances.Bits.VEBox2Enabled);
    dst.Instances.Bits.VEBox3Enabled.setValue(src.Instances.Bits.VEBox3Enabled);
    dst.Instances.VEBoxEnableMask.setValue(src.Instances.VEBoxEnableMask);
    dst.SFCSupport.SfcSupportedBits.VEBox0.setValue(src.SFCSupport.SfcSupportedBits.VEBox0);
    dst.SFCSupport.SfcSupportedBits.VEBox1.setValue(src.SFCSupport.SfcSupportedBits.VEBox1);
    dst.SFCSupport.SfcSupportedBits.VEBox2.setValue(src.SFCSupport.SfcSupportedBits.VEBox2);
    dst.SFCSupport.SfcSupportedBits.VEBox3.setValue(src.SFCSupport.SfcSupportedBits.VEBox3);
    dst.SFCSupport.Value.setValue(src.SFCSupport.Value);
    dst.NumberOfVEBoxEnabled.setValue(src.NumberOfVEBoxEnabled);
    dst.IsValid.setValue(src.IsValid);
}
template <>
struct Marshaller<TOK_S_GT_VEBOX_INFO> {
    template <typename GT_VEBOX_INFOT>
    static TOKSTR_GT_VEBOX_INFO marshall(const GT_VEBOX_INFOT &src) {
        TOKSTR_GT_VEBOX_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GT_VDBOX_INFOT>
inline void marshall(TOKSTR_GT_VDBOX_INFO &dst, const GT_VDBOX_INFOT &src) {
    dst = {};
    dst.Instances.Bits.VDBox0Enabled.setValue(src.Instances.Bits.VDBox0Enabled);
    dst.Instances.Bits.VDBox1Enabled.setValue(src.Instances.Bits.VDBox1Enabled);
    dst.Instances.Bits.VDBox2Enabled.setValue(src.Instances.Bits.VDBox2Enabled);
    dst.Instances.Bits.VDBox3Enabled.setValue(src.Instances.Bits.VDBox3Enabled);
    dst.Instances.Bits.VDBox4Enabled.setValue(src.Instances.Bits.VDBox4Enabled);
    dst.Instances.Bits.VDBox5Enabled.setValue(src.Instances.Bits.VDBox5Enabled);
    dst.Instances.Bits.VDBox6Enabled.setValue(src.Instances.Bits.VDBox6Enabled);
    dst.Instances.Bits.VDBox7Enabled.setValue(src.Instances.Bits.VDBox7Enabled);
    dst.Instances.VDBoxEnableMask.setValue(src.Instances.VDBoxEnableMask);
    dst.SFCSupport.SfcSupportedBits.VDBox0.setValue(src.SFCSupport.SfcSupportedBits.VDBox0);
    dst.SFCSupport.SfcSupportedBits.VDBox1.setValue(src.SFCSupport.SfcSupportedBits.VDBox1);
    dst.SFCSupport.SfcSupportedBits.VDBox2.setValue(src.SFCSupport.SfcSupportedBits.VDBox2);
    dst.SFCSupport.SfcSupportedBits.VDBox3.setValue(src.SFCSupport.SfcSupportedBits.VDBox3);
    dst.SFCSupport.SfcSupportedBits.VDBox4.setValue(src.SFCSupport.SfcSupportedBits.VDBox4);
    dst.SFCSupport.SfcSupportedBits.VDBox5.setValue(src.SFCSupport.SfcSupportedBits.VDBox5);
    dst.SFCSupport.SfcSupportedBits.VDBox6.setValue(src.SFCSupport.SfcSupportedBits.VDBox6);
    dst.SFCSupport.SfcSupportedBits.VDBox7.setValue(src.SFCSupport.SfcSupportedBits.VDBox7);
    dst.SFCSupport.Value.setValue(src.SFCSupport.Value);
    dst.NumberOfVDBoxEnabled.setValue(src.NumberOfVDBoxEnabled);
    dst.IsValid.setValue(src.IsValid);
}
template <>
struct Marshaller<TOK_S_GT_VDBOX_INFO> {
    template <typename GT_VDBOX_INFOT>
    static TOKSTR_GT_VDBOX_INFO marshall(const GT_VDBOX_INFOT &src) {
        TOKSTR_GT_VDBOX_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GT_CCS_INFOT>
inline void marshall(TOKSTR_GT_CCS_INFO &dst, const GT_CCS_INFOT &src) {
    dst = {};
    dst.Instances.Bits.CCS0Enabled.setValue(src.Instances.Bits.CCS0Enabled);
    dst.Instances.Bits.CCS1Enabled.setValue(src.Instances.Bits.CCS1Enabled);
    dst.Instances.Bits.CCS2Enabled.setValue(src.Instances.Bits.CCS2Enabled);
    dst.Instances.Bits.CCS3Enabled.setValue(src.Instances.Bits.CCS3Enabled);
    dst.Instances.CCSEnableMask.setValue(src.Instances.CCSEnableMask);
    dst.NumberOfCCSEnabled.setValue(src.NumberOfCCSEnabled);
    dst.IsValid.setValue(src.IsValid);
}
template <>
struct Marshaller<TOK_S_GT_CCS_INFO> {
    template <typename GT_CCS_INFOT>
    static TOKSTR_GT_CCS_INFO marshall(const GT_CCS_INFOT &src) {
        TOKSTR_GT_CCS_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GT_MULTI_TILE_ARCH_INFOT>
inline void marshall(TOKSTR_GT_MULTI_TILE_ARCH_INFO &dst, const GT_MULTI_TILE_ARCH_INFOT &src) {
    dst = {};
    dst.TileCount.setValue(src.TileCount);
    dst.Tile0.setValue(src.Tile0);
    dst.Tile1.setValue(src.Tile1);
    dst.Tile2.setValue(src.Tile2);
    dst.Tile3.setValue(src.Tile3);
    dst.TileMask.setValue(src.TileMask);
    dst.IsValid.setValue(src.IsValid);
}
template <>
struct Marshaller<TOK_S_GT_MULTI_TILE_ARCH_INFO> {
    template <typename GT_MULTI_TILE_ARCH_INFOT>
    static TOKSTR_GT_MULTI_TILE_ARCH_INFO marshall(const GT_MULTI_TILE_ARCH_INFOT &src) {
        TOKSTR_GT_MULTI_TILE_ARCH_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GT_SQIDI_INFOT>
inline void marshall(TOKSTR_GT_SQIDI_INFO &dst, const GT_SQIDI_INFOT &src) {
    dst = {};
    dst.NumberofSQIDI.setValue(src.NumberofSQIDI);
    dst.NumberofDoorbellPerSQIDI.setValue(src.NumberofDoorbellPerSQIDI);
}
template <>
struct Marshaller<TOK_S_GT_SQIDI_INFO> {
    template <typename GT_SQIDI_INFOT>
    static TOKSTR_GT_SQIDI_INFO marshall(const GT_SQIDI_INFOT &src) {
        TOKSTR_GT_SQIDI_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename _GT_CACHE_TYPEST>
inline void marshall(TOKSTR__GT_CACHE_TYPES &dst, const _GT_CACHE_TYPEST &src) {
    dst = {};
    dst.L3.setValue(src.L3);
    dst.LLC.setValue(src.LLC);
    dst.eDRAM.setValue(src.eDRAM);
    dst.CacheTypeMask.setValue(src.CacheTypeMask);
}
template <>
struct Marshaller<TOK_S_GT_CACHE_TYPES> {
    template <typename _GT_CACHE_TYPEST>
    static TOKSTR__GT_CACHE_TYPES marshall(const _GT_CACHE_TYPEST &src) {
        TOKSTR__GT_CACHE_TYPES ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GT_SYSTEM_INFOT>
inline void marshall(TOKSTR_GT_SYSTEM_INFO &dst, const GT_SYSTEM_INFOT &src) {
    dst = {};
    dst.EUCount.setValue(src.EUCount);
    dst.ThreadCount.setValue(src.ThreadCount);
    dst.SliceCount.setValue(src.SliceCount);
    dst.SubSliceCount.setValue(src.SubSliceCount);
    dst.DualSubSliceCount.setValue(src.DualSubSliceCount);
    dst.L3CacheSizeInKb.setValue(src.L3CacheSizeInKb);
    dst.LLCCacheSizeInKb.setValue(src.LLCCacheSizeInKb);
    dst.EdramSizeInKb.setValue(src.EdramSizeInKb);
    dst.L3BankCount.setValue(src.L3BankCount);
    dst.MaxFillRate.setValue(src.MaxFillRate);
    dst.EuCountPerPoolMax.setValue(src.EuCountPerPoolMax);
    dst.EuCountPerPoolMin.setValue(src.EuCountPerPoolMin);
    dst.TotalVsThreads.setValue(src.TotalVsThreads);
    dst.TotalHsThreads.setValue(src.TotalHsThreads);
    dst.TotalDsThreads.setValue(src.TotalDsThreads);
    dst.TotalGsThreads.setValue(src.TotalGsThreads);
    dst.TotalPsThreadsWindowerRange.setValue(src.TotalPsThreadsWindowerRange);
    dst.TotalVsThreads_Pocs.setValue(src.TotalVsThreads_Pocs);
    dst.CsrSizeInMb.setValue(src.CsrSizeInMb);
    dst.MaxEuPerSubSlice.setValue(src.MaxEuPerSubSlice);
    dst.MaxSlicesSupported.setValue(src.MaxSlicesSupported);
    dst.MaxSubSlicesSupported.setValue(src.MaxSubSlicesSupported);
    dst.MaxDualSubSlicesSupported.setValue(src.MaxDualSubSlicesSupported);
    dst.IsL3HashModeEnabled.setValue(src.IsL3HashModeEnabled);
    dst.SliceInfo[0].Enabled.setValue(src.SliceInfo[0].Enabled);
    dst.SliceInfo[0].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[0].SubSliceInfo[0].Enabled);
    dst.SliceInfo[0].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[0].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[0].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[0].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[0].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[0].SubSliceInfo[1].Enabled);
    dst.SliceInfo[0].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[0].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[0].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[0].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[0].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[0].SubSliceInfo[2].Enabled);
    dst.SliceInfo[0].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[0].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[0].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[0].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[0].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[0].SubSliceInfo[3].Enabled);
    dst.SliceInfo[0].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[0].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[0].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[0].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[0].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[0].SubSliceInfo[4].Enabled);
    dst.SliceInfo[0].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[0].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[0].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[0].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[0].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[0].SubSliceInfo[5].Enabled);
    dst.SliceInfo[0].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[0].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[0].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[0].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[0].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[0].SubSliceInfo[6].Enabled);
    dst.SliceInfo[0].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[0].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[0].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[0].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[0].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[0].SubSliceInfo[7].Enabled);
    dst.SliceInfo[0].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[0].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[0].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[0].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[0].Enabled.setValue(src.SliceInfo[0].DSSInfo[0].Enabled);
    dst.SliceInfo[0].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[0].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[0].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[0].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[0].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[1].Enabled.setValue(src.SliceInfo[0].DSSInfo[1].Enabled);
    dst.SliceInfo[0].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[0].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[0].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[0].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[0].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[2].Enabled.setValue(src.SliceInfo[0].DSSInfo[2].Enabled);
    dst.SliceInfo[0].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[0].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[0].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[0].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[0].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[3].Enabled.setValue(src.SliceInfo[0].DSSInfo[3].Enabled);
    dst.SliceInfo[0].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[0].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[0].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[0].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[0].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[4].Enabled.setValue(src.SliceInfo[0].DSSInfo[4].Enabled);
    dst.SliceInfo[0].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[0].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[0].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[0].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[0].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[5].Enabled.setValue(src.SliceInfo[0].DSSInfo[5].Enabled);
    dst.SliceInfo[0].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[0].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[0].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[0].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[0].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[0].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[0].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[0].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[0].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[0].SubSliceEnabledCount.setValue(src.SliceInfo[0].SubSliceEnabledCount);
    dst.SliceInfo[0].DualSubSliceEnabledCount.setValue(src.SliceInfo[0].DualSubSliceEnabledCount);
    dst.SliceInfo[1].Enabled.setValue(src.SliceInfo[1].Enabled);
    dst.SliceInfo[1].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[1].SubSliceInfo[0].Enabled);
    dst.SliceInfo[1].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[1].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[1].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[1].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[1].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[1].SubSliceInfo[1].Enabled);
    dst.SliceInfo[1].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[1].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[1].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[1].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[1].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[1].SubSliceInfo[2].Enabled);
    dst.SliceInfo[1].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[1].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[1].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[1].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[1].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[1].SubSliceInfo[3].Enabled);
    dst.SliceInfo[1].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[1].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[1].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[1].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[1].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[1].SubSliceInfo[4].Enabled);
    dst.SliceInfo[1].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[1].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[1].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[1].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[1].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[1].SubSliceInfo[5].Enabled);
    dst.SliceInfo[1].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[1].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[1].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[1].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[1].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[1].SubSliceInfo[6].Enabled);
    dst.SliceInfo[1].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[1].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[1].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[1].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[1].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[1].SubSliceInfo[7].Enabled);
    dst.SliceInfo[1].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[1].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[1].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[1].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[0].Enabled.setValue(src.SliceInfo[1].DSSInfo[0].Enabled);
    dst.SliceInfo[1].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[1].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[1].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[1].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[1].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[1].Enabled.setValue(src.SliceInfo[1].DSSInfo[1].Enabled);
    dst.SliceInfo[1].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[1].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[1].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[1].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[1].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[2].Enabled.setValue(src.SliceInfo[1].DSSInfo[2].Enabled);
    dst.SliceInfo[1].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[1].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[1].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[1].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[1].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[3].Enabled.setValue(src.SliceInfo[1].DSSInfo[3].Enabled);
    dst.SliceInfo[1].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[1].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[1].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[1].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[1].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[4].Enabled.setValue(src.SliceInfo[1].DSSInfo[4].Enabled);
    dst.SliceInfo[1].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[1].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[1].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[1].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[1].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[5].Enabled.setValue(src.SliceInfo[1].DSSInfo[5].Enabled);
    dst.SliceInfo[1].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[1].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[1].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[1].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[1].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[1].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[1].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[1].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[1].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[1].SubSliceEnabledCount.setValue(src.SliceInfo[1].SubSliceEnabledCount);
    dst.SliceInfo[1].DualSubSliceEnabledCount.setValue(src.SliceInfo[1].DualSubSliceEnabledCount);
    dst.SliceInfo[2].Enabled.setValue(src.SliceInfo[2].Enabled);
    dst.SliceInfo[2].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[2].SubSliceInfo[0].Enabled);
    dst.SliceInfo[2].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[2].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[2].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[2].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[2].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[2].SubSliceInfo[1].Enabled);
    dst.SliceInfo[2].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[2].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[2].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[2].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[2].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[2].SubSliceInfo[2].Enabled);
    dst.SliceInfo[2].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[2].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[2].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[2].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[2].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[2].SubSliceInfo[3].Enabled);
    dst.SliceInfo[2].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[2].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[2].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[2].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[2].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[2].SubSliceInfo[4].Enabled);
    dst.SliceInfo[2].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[2].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[2].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[2].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[2].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[2].SubSliceInfo[5].Enabled);
    dst.SliceInfo[2].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[2].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[2].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[2].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[2].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[2].SubSliceInfo[6].Enabled);
    dst.SliceInfo[2].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[2].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[2].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[2].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[2].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[2].SubSliceInfo[7].Enabled);
    dst.SliceInfo[2].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[2].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[2].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[2].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[0].Enabled.setValue(src.SliceInfo[2].DSSInfo[0].Enabled);
    dst.SliceInfo[2].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[2].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[2].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[2].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[2].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[1].Enabled.setValue(src.SliceInfo[2].DSSInfo[1].Enabled);
    dst.SliceInfo[2].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[2].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[2].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[2].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[2].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[2].Enabled.setValue(src.SliceInfo[2].DSSInfo[2].Enabled);
    dst.SliceInfo[2].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[2].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[2].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[2].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[2].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[3].Enabled.setValue(src.SliceInfo[2].DSSInfo[3].Enabled);
    dst.SliceInfo[2].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[2].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[2].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[2].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[2].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[4].Enabled.setValue(src.SliceInfo[2].DSSInfo[4].Enabled);
    dst.SliceInfo[2].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[2].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[2].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[2].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[2].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[5].Enabled.setValue(src.SliceInfo[2].DSSInfo[5].Enabled);
    dst.SliceInfo[2].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[2].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[2].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[2].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[2].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[2].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[2].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[2].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[2].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[2].SubSliceEnabledCount.setValue(src.SliceInfo[2].SubSliceEnabledCount);
    dst.SliceInfo[2].DualSubSliceEnabledCount.setValue(src.SliceInfo[2].DualSubSliceEnabledCount);
    dst.SliceInfo[3].Enabled.setValue(src.SliceInfo[3].Enabled);
    dst.SliceInfo[3].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[3].SubSliceInfo[0].Enabled);
    dst.SliceInfo[3].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[3].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[3].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[3].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[3].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[3].SubSliceInfo[1].Enabled);
    dst.SliceInfo[3].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[3].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[3].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[3].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[3].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[3].SubSliceInfo[2].Enabled);
    dst.SliceInfo[3].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[3].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[3].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[3].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[3].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[3].SubSliceInfo[3].Enabled);
    dst.SliceInfo[3].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[3].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[3].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[3].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[3].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[3].SubSliceInfo[4].Enabled);
    dst.SliceInfo[3].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[3].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[3].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[3].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[3].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[3].SubSliceInfo[5].Enabled);
    dst.SliceInfo[3].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[3].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[3].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[3].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[3].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[3].SubSliceInfo[6].Enabled);
    dst.SliceInfo[3].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[3].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[3].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[3].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[3].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[3].SubSliceInfo[7].Enabled);
    dst.SliceInfo[3].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[3].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[3].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[3].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[0].Enabled.setValue(src.SliceInfo[3].DSSInfo[0].Enabled);
    dst.SliceInfo[3].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[3].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[3].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[3].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[3].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[1].Enabled.setValue(src.SliceInfo[3].DSSInfo[1].Enabled);
    dst.SliceInfo[3].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[3].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[3].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[3].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[3].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[2].Enabled.setValue(src.SliceInfo[3].DSSInfo[2].Enabled);
    dst.SliceInfo[3].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[3].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[3].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[3].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[3].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[3].Enabled.setValue(src.SliceInfo[3].DSSInfo[3].Enabled);
    dst.SliceInfo[3].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[3].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[3].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[3].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[3].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[4].Enabled.setValue(src.SliceInfo[3].DSSInfo[4].Enabled);
    dst.SliceInfo[3].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[3].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[3].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[3].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[3].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[5].Enabled.setValue(src.SliceInfo[3].DSSInfo[5].Enabled);
    dst.SliceInfo[3].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[3].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[3].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[3].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[3].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[3].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[3].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[3].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[3].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[3].SubSliceEnabledCount.setValue(src.SliceInfo[3].SubSliceEnabledCount);
    dst.SliceInfo[3].DualSubSliceEnabledCount.setValue(src.SliceInfo[3].DualSubSliceEnabledCount);
    dst.SliceInfo[4].Enabled.setValue(src.SliceInfo[4].Enabled);
    dst.SliceInfo[4].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[4].SubSliceInfo[0].Enabled);
    dst.SliceInfo[4].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[4].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[4].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[4].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[4].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[4].SubSliceInfo[1].Enabled);
    dst.SliceInfo[4].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[4].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[4].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[4].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[4].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[4].SubSliceInfo[2].Enabled);
    dst.SliceInfo[4].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[4].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[4].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[4].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[4].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[4].SubSliceInfo[3].Enabled);
    dst.SliceInfo[4].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[4].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[4].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[4].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[4].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[4].SubSliceInfo[4].Enabled);
    dst.SliceInfo[4].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[4].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[4].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[4].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[4].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[4].SubSliceInfo[5].Enabled);
    dst.SliceInfo[4].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[4].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[4].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[4].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[4].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[4].SubSliceInfo[6].Enabled);
    dst.SliceInfo[4].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[4].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[4].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[4].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[4].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[4].SubSliceInfo[7].Enabled);
    dst.SliceInfo[4].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[4].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[4].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[4].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[0].Enabled.setValue(src.SliceInfo[4].DSSInfo[0].Enabled);
    dst.SliceInfo[4].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[4].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[4].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[4].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[4].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[1].Enabled.setValue(src.SliceInfo[4].DSSInfo[1].Enabled);
    dst.SliceInfo[4].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[4].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[4].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[4].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[4].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[2].Enabled.setValue(src.SliceInfo[4].DSSInfo[2].Enabled);
    dst.SliceInfo[4].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[4].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[4].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[4].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[4].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[3].Enabled.setValue(src.SliceInfo[4].DSSInfo[3].Enabled);
    dst.SliceInfo[4].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[4].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[4].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[4].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[4].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[4].Enabled.setValue(src.SliceInfo[4].DSSInfo[4].Enabled);
    dst.SliceInfo[4].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[4].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[4].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[4].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[4].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[5].Enabled.setValue(src.SliceInfo[4].DSSInfo[5].Enabled);
    dst.SliceInfo[4].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[4].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[4].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[4].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[4].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[4].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[4].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[4].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[4].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[4].SubSliceEnabledCount.setValue(src.SliceInfo[4].SubSliceEnabledCount);
    dst.SliceInfo[4].DualSubSliceEnabledCount.setValue(src.SliceInfo[4].DualSubSliceEnabledCount);
    dst.SliceInfo[5].Enabled.setValue(src.SliceInfo[5].Enabled);
    dst.SliceInfo[5].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[5].SubSliceInfo[0].Enabled);
    dst.SliceInfo[5].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[5].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[5].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[5].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[5].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[5].SubSliceInfo[1].Enabled);
    dst.SliceInfo[5].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[5].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[5].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[5].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[5].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[5].SubSliceInfo[2].Enabled);
    dst.SliceInfo[5].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[5].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[5].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[5].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[5].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[5].SubSliceInfo[3].Enabled);
    dst.SliceInfo[5].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[5].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[5].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[5].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[5].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[5].SubSliceInfo[4].Enabled);
    dst.SliceInfo[5].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[5].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[5].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[5].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[5].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[5].SubSliceInfo[5].Enabled);
    dst.SliceInfo[5].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[5].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[5].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[5].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[5].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[5].SubSliceInfo[6].Enabled);
    dst.SliceInfo[5].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[5].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[5].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[5].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[5].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[5].SubSliceInfo[7].Enabled);
    dst.SliceInfo[5].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[5].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[5].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[5].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[0].Enabled.setValue(src.SliceInfo[5].DSSInfo[0].Enabled);
    dst.SliceInfo[5].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[5].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[5].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[5].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[5].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[1].Enabled.setValue(src.SliceInfo[5].DSSInfo[1].Enabled);
    dst.SliceInfo[5].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[5].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[5].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[5].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[5].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[2].Enabled.setValue(src.SliceInfo[5].DSSInfo[2].Enabled);
    dst.SliceInfo[5].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[5].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[5].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[5].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[5].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[3].Enabled.setValue(src.SliceInfo[5].DSSInfo[3].Enabled);
    dst.SliceInfo[5].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[5].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[5].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[5].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[5].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[4].Enabled.setValue(src.SliceInfo[5].DSSInfo[4].Enabled);
    dst.SliceInfo[5].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[5].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[5].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[5].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[5].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[5].Enabled.setValue(src.SliceInfo[5].DSSInfo[5].Enabled);
    dst.SliceInfo[5].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[5].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[5].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[5].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[5].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[5].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[5].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[5].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[5].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[5].SubSliceEnabledCount.setValue(src.SliceInfo[5].SubSliceEnabledCount);
    dst.SliceInfo[5].DualSubSliceEnabledCount.setValue(src.SliceInfo[5].DualSubSliceEnabledCount);
    dst.SliceInfo[6].Enabled.setValue(src.SliceInfo[6].Enabled);
    dst.SliceInfo[6].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[6].SubSliceInfo[0].Enabled);
    dst.SliceInfo[6].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[6].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[6].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[6].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[6].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[6].SubSliceInfo[1].Enabled);
    dst.SliceInfo[6].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[6].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[6].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[6].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[6].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[6].SubSliceInfo[2].Enabled);
    dst.SliceInfo[6].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[6].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[6].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[6].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[6].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[6].SubSliceInfo[3].Enabled);
    dst.SliceInfo[6].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[6].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[6].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[6].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[6].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[6].SubSliceInfo[4].Enabled);
    dst.SliceInfo[6].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[6].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[6].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[6].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[6].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[6].SubSliceInfo[5].Enabled);
    dst.SliceInfo[6].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[6].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[6].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[6].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[6].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[6].SubSliceInfo[6].Enabled);
    dst.SliceInfo[6].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[6].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[6].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[6].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[6].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[6].SubSliceInfo[7].Enabled);
    dst.SliceInfo[6].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[6].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[6].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[6].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[0].Enabled.setValue(src.SliceInfo[6].DSSInfo[0].Enabled);
    dst.SliceInfo[6].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[6].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[6].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[6].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[6].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[1].Enabled.setValue(src.SliceInfo[6].DSSInfo[1].Enabled);
    dst.SliceInfo[6].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[6].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[6].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[6].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[6].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[2].Enabled.setValue(src.SliceInfo[6].DSSInfo[2].Enabled);
    dst.SliceInfo[6].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[6].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[6].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[6].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[6].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[3].Enabled.setValue(src.SliceInfo[6].DSSInfo[3].Enabled);
    dst.SliceInfo[6].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[6].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[6].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[6].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[6].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[4].Enabled.setValue(src.SliceInfo[6].DSSInfo[4].Enabled);
    dst.SliceInfo[6].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[6].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[6].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[6].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[6].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[5].Enabled.setValue(src.SliceInfo[6].DSSInfo[5].Enabled);
    dst.SliceInfo[6].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[6].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[6].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[6].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[6].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[6].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[6].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[6].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[6].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[6].SubSliceEnabledCount.setValue(src.SliceInfo[6].SubSliceEnabledCount);
    dst.SliceInfo[6].DualSubSliceEnabledCount.setValue(src.SliceInfo[6].DualSubSliceEnabledCount);
    dst.SliceInfo[7].Enabled.setValue(src.SliceInfo[7].Enabled);
    dst.SliceInfo[7].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[7].SubSliceInfo[0].Enabled);
    dst.SliceInfo[7].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[7].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[7].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[7].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[7].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[7].SubSliceInfo[1].Enabled);
    dst.SliceInfo[7].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[7].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[7].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[7].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[7].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[7].SubSliceInfo[2].Enabled);
    dst.SliceInfo[7].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[7].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[7].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[7].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[7].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[7].SubSliceInfo[3].Enabled);
    dst.SliceInfo[7].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[7].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[7].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[7].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[7].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[7].SubSliceInfo[4].Enabled);
    dst.SliceInfo[7].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[7].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[7].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[7].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[7].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[7].SubSliceInfo[5].Enabled);
    dst.SliceInfo[7].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[7].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[7].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[7].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[7].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[7].SubSliceInfo[6].Enabled);
    dst.SliceInfo[7].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[7].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[7].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[7].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[7].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[7].SubSliceInfo[7].Enabled);
    dst.SliceInfo[7].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[7].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[7].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[7].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[0].Enabled.setValue(src.SliceInfo[7].DSSInfo[0].Enabled);
    dst.SliceInfo[7].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[7].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[7].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[7].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[7].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[1].Enabled.setValue(src.SliceInfo[7].DSSInfo[1].Enabled);
    dst.SliceInfo[7].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[7].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[7].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[7].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[7].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[2].Enabled.setValue(src.SliceInfo[7].DSSInfo[2].Enabled);
    dst.SliceInfo[7].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[7].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[7].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[7].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[7].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[3].Enabled.setValue(src.SliceInfo[7].DSSInfo[3].Enabled);
    dst.SliceInfo[7].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[7].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[7].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[7].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[7].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[4].Enabled.setValue(src.SliceInfo[7].DSSInfo[4].Enabled);
    dst.SliceInfo[7].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[7].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[7].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[7].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[7].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[5].Enabled.setValue(src.SliceInfo[7].DSSInfo[5].Enabled);
    dst.SliceInfo[7].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[7].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[7].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[7].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[7].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[7].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[7].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[7].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[7].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[7].SubSliceEnabledCount.setValue(src.SliceInfo[7].SubSliceEnabledCount);
    dst.SliceInfo[7].DualSubSliceEnabledCount.setValue(src.SliceInfo[7].DualSubSliceEnabledCount);
    dst.SliceInfo[8].Enabled.setValue(src.SliceInfo[8].Enabled);
    dst.SliceInfo[8].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[8].SubSliceInfo[0].Enabled);
    dst.SliceInfo[8].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[8].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[8].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[8].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[8].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[8].SubSliceInfo[1].Enabled);
    dst.SliceInfo[8].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[8].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[8].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[8].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[8].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[8].SubSliceInfo[2].Enabled);
    dst.SliceInfo[8].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[8].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[8].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[8].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[8].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[8].SubSliceInfo[3].Enabled);
    dst.SliceInfo[8].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[8].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[8].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[8].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[8].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[8].SubSliceInfo[4].Enabled);
    dst.SliceInfo[8].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[8].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[8].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[8].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[8].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[8].SubSliceInfo[5].Enabled);
    dst.SliceInfo[8].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[8].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[8].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[8].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[8].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[8].SubSliceInfo[6].Enabled);
    dst.SliceInfo[8].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[8].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[8].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[8].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[8].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[8].SubSliceInfo[7].Enabled);
    dst.SliceInfo[8].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[8].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[8].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[8].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[0].Enabled.setValue(src.SliceInfo[8].DSSInfo[0].Enabled);
    dst.SliceInfo[8].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[8].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[8].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[8].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[8].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[1].Enabled.setValue(src.SliceInfo[8].DSSInfo[1].Enabled);
    dst.SliceInfo[8].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[8].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[8].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[8].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[8].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[2].Enabled.setValue(src.SliceInfo[8].DSSInfo[2].Enabled);
    dst.SliceInfo[8].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[8].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[8].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[8].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[8].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[3].Enabled.setValue(src.SliceInfo[8].DSSInfo[3].Enabled);
    dst.SliceInfo[8].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[8].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[8].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[8].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[8].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[4].Enabled.setValue(src.SliceInfo[8].DSSInfo[4].Enabled);
    dst.SliceInfo[8].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[8].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[8].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[8].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[8].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[5].Enabled.setValue(src.SliceInfo[8].DSSInfo[5].Enabled);
    dst.SliceInfo[8].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[8].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[8].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[8].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[8].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[8].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[8].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[8].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[8].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[8].SubSliceEnabledCount.setValue(src.SliceInfo[8].SubSliceEnabledCount);
    dst.SliceInfo[8].DualSubSliceEnabledCount.setValue(src.SliceInfo[8].DualSubSliceEnabledCount);
    dst.SliceInfo[9].Enabled.setValue(src.SliceInfo[9].Enabled);
    dst.SliceInfo[9].SubSliceInfo[0].Enabled.setValue(src.SliceInfo[9].SubSliceInfo[0].Enabled);
    dst.SliceInfo[9].SubSliceInfo[0].EuEnabledCount.setValue(src.SliceInfo[9].SubSliceInfo[0].EuEnabledCount);
    dst.SliceInfo[9].SubSliceInfo[0].EuEnabledMask.setValue(src.SliceInfo[9].SubSliceInfo[0].EuEnabledMask);
    dst.SliceInfo[9].SubSliceInfo[1].Enabled.setValue(src.SliceInfo[9].SubSliceInfo[1].Enabled);
    dst.SliceInfo[9].SubSliceInfo[1].EuEnabledCount.setValue(src.SliceInfo[9].SubSliceInfo[1].EuEnabledCount);
    dst.SliceInfo[9].SubSliceInfo[1].EuEnabledMask.setValue(src.SliceInfo[9].SubSliceInfo[1].EuEnabledMask);
    dst.SliceInfo[9].SubSliceInfo[2].Enabled.setValue(src.SliceInfo[9].SubSliceInfo[2].Enabled);
    dst.SliceInfo[9].SubSliceInfo[2].EuEnabledCount.setValue(src.SliceInfo[9].SubSliceInfo[2].EuEnabledCount);
    dst.SliceInfo[9].SubSliceInfo[2].EuEnabledMask.setValue(src.SliceInfo[9].SubSliceInfo[2].EuEnabledMask);
    dst.SliceInfo[9].SubSliceInfo[3].Enabled.setValue(src.SliceInfo[9].SubSliceInfo[3].Enabled);
    dst.SliceInfo[9].SubSliceInfo[3].EuEnabledCount.setValue(src.SliceInfo[9].SubSliceInfo[3].EuEnabledCount);
    dst.SliceInfo[9].SubSliceInfo[3].EuEnabledMask.setValue(src.SliceInfo[9].SubSliceInfo[3].EuEnabledMask);
    dst.SliceInfo[9].SubSliceInfo[4].Enabled.setValue(src.SliceInfo[9].SubSliceInfo[4].Enabled);
    dst.SliceInfo[9].SubSliceInfo[4].EuEnabledCount.setValue(src.SliceInfo[9].SubSliceInfo[4].EuEnabledCount);
    dst.SliceInfo[9].SubSliceInfo[4].EuEnabledMask.setValue(src.SliceInfo[9].SubSliceInfo[4].EuEnabledMask);
    dst.SliceInfo[9].SubSliceInfo[5].Enabled.setValue(src.SliceInfo[9].SubSliceInfo[5].Enabled);
    dst.SliceInfo[9].SubSliceInfo[5].EuEnabledCount.setValue(src.SliceInfo[9].SubSliceInfo[5].EuEnabledCount);
    dst.SliceInfo[9].SubSliceInfo[5].EuEnabledMask.setValue(src.SliceInfo[9].SubSliceInfo[5].EuEnabledMask);
    dst.SliceInfo[9].SubSliceInfo[6].Enabled.setValue(src.SliceInfo[9].SubSliceInfo[6].Enabled);
    dst.SliceInfo[9].SubSliceInfo[6].EuEnabledCount.setValue(src.SliceInfo[9].SubSliceInfo[6].EuEnabledCount);
    dst.SliceInfo[9].SubSliceInfo[6].EuEnabledMask.setValue(src.SliceInfo[9].SubSliceInfo[6].EuEnabledMask);
    dst.SliceInfo[9].SubSliceInfo[7].Enabled.setValue(src.SliceInfo[9].SubSliceInfo[7].Enabled);
    dst.SliceInfo[9].SubSliceInfo[7].EuEnabledCount.setValue(src.SliceInfo[9].SubSliceInfo[7].EuEnabledCount);
    dst.SliceInfo[9].SubSliceInfo[7].EuEnabledMask.setValue(src.SliceInfo[9].SubSliceInfo[7].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[0].Enabled.setValue(src.SliceInfo[9].DSSInfo[0].Enabled);
    dst.SliceInfo[9].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SliceInfo[9].DSSInfo[0].SubSlice[0].Enabled);
    dst.SliceInfo[9].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SliceInfo[9].DSSInfo[0].SubSlice[1].Enabled);
    dst.SliceInfo[9].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[1].Enabled.setValue(src.SliceInfo[9].DSSInfo[1].Enabled);
    dst.SliceInfo[9].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SliceInfo[9].DSSInfo[1].SubSlice[0].Enabled);
    dst.SliceInfo[9].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SliceInfo[9].DSSInfo[1].SubSlice[1].Enabled);
    dst.SliceInfo[9].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[2].Enabled.setValue(src.SliceInfo[9].DSSInfo[2].Enabled);
    dst.SliceInfo[9].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SliceInfo[9].DSSInfo[2].SubSlice[0].Enabled);
    dst.SliceInfo[9].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SliceInfo[9].DSSInfo[2].SubSlice[1].Enabled);
    dst.SliceInfo[9].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[3].Enabled.setValue(src.SliceInfo[9].DSSInfo[3].Enabled);
    dst.SliceInfo[9].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SliceInfo[9].DSSInfo[3].SubSlice[0].Enabled);
    dst.SliceInfo[9].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SliceInfo[9].DSSInfo[3].SubSlice[1].Enabled);
    dst.SliceInfo[9].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[4].Enabled.setValue(src.SliceInfo[9].DSSInfo[4].Enabled);
    dst.SliceInfo[9].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SliceInfo[9].DSSInfo[4].SubSlice[0].Enabled);
    dst.SliceInfo[9].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SliceInfo[9].DSSInfo[4].SubSlice[1].Enabled);
    dst.SliceInfo[9].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[5].Enabled.setValue(src.SliceInfo[9].DSSInfo[5].Enabled);
    dst.SliceInfo[9].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SliceInfo[9].DSSInfo[5].SubSlice[0].Enabled);
    dst.SliceInfo[9].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SliceInfo[9].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SliceInfo[9].DSSInfo[5].SubSlice[1].Enabled);
    dst.SliceInfo[9].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SliceInfo[9].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SliceInfo[9].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SliceInfo[9].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SliceInfo[9].SubSliceEnabledCount.setValue(src.SliceInfo[9].SubSliceEnabledCount);
    dst.SliceInfo[9].DualSubSliceEnabledCount.setValue(src.SliceInfo[9].DualSubSliceEnabledCount);
    dst.IsDynamicallyPopulated.setValue(src.IsDynamicallyPopulated);
    dst.SqidiInfo.NumberofSQIDI.setValue(src.SqidiInfo.NumberofSQIDI);
    dst.SqidiInfo.NumberofDoorbellPerSQIDI.setValue(src.SqidiInfo.NumberofDoorbellPerSQIDI);
    dst.ReservedCCSWays.setValue(src.ReservedCCSWays);
    dst.CCSInfo.Instances.Bits.CCS0Enabled.setValue(src.CCSInfo.Instances.Bits.CCS0Enabled);
    dst.CCSInfo.Instances.Bits.CCS1Enabled.setValue(src.CCSInfo.Instances.Bits.CCS1Enabled);
    dst.CCSInfo.Instances.Bits.CCS2Enabled.setValue(src.CCSInfo.Instances.Bits.CCS2Enabled);
    dst.CCSInfo.Instances.Bits.CCS3Enabled.setValue(src.CCSInfo.Instances.Bits.CCS3Enabled);
    dst.CCSInfo.Instances.CCSEnableMask.setValue(src.CCSInfo.Instances.CCSEnableMask);
    dst.CCSInfo.NumberOfCCSEnabled.setValue(src.CCSInfo.NumberOfCCSEnabled);
    dst.CCSInfo.IsValid.setValue(src.CCSInfo.IsValid);
    dst.MultiTileArchInfo.TileCount.setValue(src.MultiTileArchInfo.TileCount);
    dst.MultiTileArchInfo.Tile0.setValue(src.MultiTileArchInfo.Tile0);
    dst.MultiTileArchInfo.Tile1.setValue(src.MultiTileArchInfo.Tile1);
    dst.MultiTileArchInfo.Tile2.setValue(src.MultiTileArchInfo.Tile2);
    dst.MultiTileArchInfo.Tile3.setValue(src.MultiTileArchInfo.Tile3);
    dst.MultiTileArchInfo.TileMask.setValue(src.MultiTileArchInfo.TileMask);
    dst.MultiTileArchInfo.IsValid.setValue(src.MultiTileArchInfo.IsValid);
    dst.VDBoxInfo.Instances.Bits.VDBox0Enabled.setValue(src.VDBoxInfo.Instances.Bits.VDBox0Enabled);
    dst.VDBoxInfo.Instances.Bits.VDBox1Enabled.setValue(src.VDBoxInfo.Instances.Bits.VDBox1Enabled);
    dst.VDBoxInfo.Instances.Bits.VDBox2Enabled.setValue(src.VDBoxInfo.Instances.Bits.VDBox2Enabled);
    dst.VDBoxInfo.Instances.Bits.VDBox3Enabled.setValue(src.VDBoxInfo.Instances.Bits.VDBox3Enabled);
    dst.VDBoxInfo.Instances.Bits.VDBox4Enabled.setValue(src.VDBoxInfo.Instances.Bits.VDBox4Enabled);
    dst.VDBoxInfo.Instances.Bits.VDBox5Enabled.setValue(src.VDBoxInfo.Instances.Bits.VDBox5Enabled);
    dst.VDBoxInfo.Instances.Bits.VDBox6Enabled.setValue(src.VDBoxInfo.Instances.Bits.VDBox6Enabled);
    dst.VDBoxInfo.Instances.Bits.VDBox7Enabled.setValue(src.VDBoxInfo.Instances.Bits.VDBox7Enabled);
    dst.VDBoxInfo.Instances.VDBoxEnableMask.setValue(src.VDBoxInfo.Instances.VDBoxEnableMask);
    dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox0.setValue(src.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox0);
    dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox1.setValue(src.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox1);
    dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox2.setValue(src.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox2);
    dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox3.setValue(src.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox3);
    dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox4.setValue(src.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox4);
    dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox5.setValue(src.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox5);
    dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox6.setValue(src.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox6);
    dst.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox7.setValue(src.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox7);
    dst.VDBoxInfo.SFCSupport.Value.setValue(src.VDBoxInfo.SFCSupport.Value);
    dst.VDBoxInfo.NumberOfVDBoxEnabled.setValue(src.VDBoxInfo.NumberOfVDBoxEnabled);
    dst.VDBoxInfo.IsValid.setValue(src.VDBoxInfo.IsValid);
    dst.VEBoxInfo.Instances.Bits.VEBox0Enabled.setValue(src.VEBoxInfo.Instances.Bits.VEBox0Enabled);
    dst.VEBoxInfo.Instances.Bits.VEBox1Enabled.setValue(src.VEBoxInfo.Instances.Bits.VEBox1Enabled);
    dst.VEBoxInfo.Instances.Bits.VEBox2Enabled.setValue(src.VEBoxInfo.Instances.Bits.VEBox2Enabled);
    dst.VEBoxInfo.Instances.Bits.VEBox3Enabled.setValue(src.VEBoxInfo.Instances.Bits.VEBox3Enabled);
    dst.VEBoxInfo.Instances.VEBoxEnableMask.setValue(src.VEBoxInfo.Instances.VEBoxEnableMask);
    dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox0.setValue(src.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox0);
    dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox1.setValue(src.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox1);
    dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox2.setValue(src.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox2);
    dst.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox3.setValue(src.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox3);
    dst.VEBoxInfo.SFCSupport.Value.setValue(src.VEBoxInfo.SFCSupport.Value);
    dst.VEBoxInfo.NumberOfVEBoxEnabled.setValue(src.VEBoxInfo.NumberOfVEBoxEnabled);
    dst.VEBoxInfo.IsValid.setValue(src.VEBoxInfo.IsValid);
    dst.NumThreadsPerEu.setValue(src.NumThreadsPerEu);
    dst.CacheTypes.L3.setValue(src.CacheTypes.L3);
    dst.CacheTypes.LLC.setValue(src.CacheTypes.LLC);
    dst.CacheTypes.eDRAM.setValue(src.CacheTypes.eDRAM);
    dst.CacheTypes.CacheTypeMask.setValue(src.CacheTypes.CacheTypeMask);
    dst.MaxVECS.setValue(src.MaxVECS);
}
template <>
struct Marshaller<TOK_S_GT_SYSTEM_INFO> {
    template <typename GT_SYSTEM_INFOT>
    static TOKSTR_GT_SYSTEM_INFO marshall(const GT_SYSTEM_INFOT &src) {
        TOKSTR_GT_SYSTEM_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename _SKU_FEATURE_TABLET>
inline void marshall(TOKSTR__SKU_FEATURE_TABLE &dst, const _SKU_FEATURE_TABLET &src) {
    dst = {};
    dst.FtrDesktop.setValue(src.FtrDesktop);
    dst.FtrULT.setValue(src.FtrULT);
    dst.FtrIVBM0M1Platform.setValue(src.FtrIVBM0M1Platform);
    dst.FtrChannelSwizzlingXOREnabled.setValue(src.FtrChannelSwizzlingXOREnabled);

    dst.Ftr5Slice.setValue(src.Ftr5Slice);
    dst.FtrLCIA.setValue(src.FtrLCIA);
    dst.FtrResourceStreamer.setValue(src.FtrResourceStreamer);
    dst.FtrCCSRing.setValue(src.FtrCCSRing);
    dst.FtrCCSNode.setValue(src.FtrCCSNode);
    dst.FtrCCSMultiInstance.setValue(src.FtrCCSMultiInstance);
    dst.FtrDisplayDisabled.setValue(src.FtrDisplayDisabled);
    dst.FtrSGTPVSKUStrapPresent.setValue(src.FtrSGTPVSKUStrapPresent);
    dst.FtrPooledEuEnabled.setValue(src.FtrPooledEuEnabled);
    dst.FtrGpGpuMidBatchPreempt.setValue(src.FtrGpGpuMidBatchPreempt);
    dst.FtrGpGpuThreadGroupLevelPreempt.setValue(src.FtrGpGpuThreadGroupLevelPreempt);
    dst.FtrGpGpuMidThreadLevelPreempt.setValue(src.FtrGpGpuMidThreadLevelPreempt);
    dst.Ftr3dMidBatchPreempt.setValue(src.Ftr3dMidBatchPreempt);
    dst.Ftr3dObjectLevelPreempt.setValue(src.Ftr3dObjectLevelPreempt);
    dst.FtrPerCtxtPreemptionGranularityControl.setValue(src.FtrPerCtxtPreemptionGranularityControl);
    dst.FtrPPGTT.setValue(src.FtrPPGTT);
    dst.FtrIA32eGfxPTEs.setValue(src.FtrIA32eGfxPTEs);
    dst.FtrMemTypeMocsDeferPAT.setValue(src.FtrMemTypeMocsDeferPAT);
    dst.FtrPml4Support.setValue(src.FtrPml4Support);
    dst.FtrSVM.setValue(src.FtrSVM);
    dst.FtrTileMappedResource.setValue(src.FtrTileMappedResource);
    dst.FtrTranslationTable.setValue(src.FtrTranslationTable);
    dst.FtrUserModeTranslationTable.setValue(src.FtrUserModeTranslationTable);
    dst.FtrNullPages.setValue(src.FtrNullPages);
    dst.FtrL3IACoherency.setValue(src.FtrL3IACoherency);
    dst.FtrEDram.setValue(src.FtrEDram);
    dst.FtrLLCBypass.setValue(src.FtrLLCBypass);
    dst.FtrCrystalwell.setValue(src.FtrCrystalwell);
    dst.FtrCentralCachePolicy.setValue(src.FtrCentralCachePolicy);
    dst.FtrIoMmuPageFaulting.setValue(src.FtrIoMmuPageFaulting);
    dst.FtrWddm2GpuMmu.setValue(src.FtrWddm2GpuMmu);
    dst.FtrWddm2Svm.setValue(src.FtrWddm2Svm);
    dst.FtrStandardMipTailFormat.setValue(src.FtrStandardMipTailFormat);
    dst.FtrWddm2_1_64kbPages.setValue(src.FtrWddm2_1_64kbPages);
    dst.FtrGttCacheInvalidation.setValue(src.FtrGttCacheInvalidation);
    dst.FtrE2ECompression.setValue(src.FtrE2ECompression);
    dst.FtrLinearCCS.setValue(src.FtrLinearCCS);
    dst.FtrLocalMemory.setValue(src.FtrLocalMemory);
    dst.FtrPpgtt64KBWalkOptimization.setValue(src.FtrPpgtt64KBWalkOptimization);
    dst.FtrTileY.setValue(src.FtrTileY);
    dst.FtrFlatPhysCCS.setValue(src.FtrFlatPhysCCS);
    dst.FtrMultiTileArch.setValue(src.FtrMultiTileArch);
    dst.FtrLocalMemoryAllows4KB.setValue(src.FtrLocalMemoryAllows4KB);
    dst.FtrDisplayXTiling.setValue(src.FtrDisplayXTiling);
    dst.FtrCameraCaptureCaching.setValue(src.FtrCameraCaptureCaching);
    dst.FtrKmdDaf.setValue(src.FtrKmdDaf);
    dst.FtrFrameBufferLLC.setValue(src.FtrFrameBufferLLC);
    dst.FtrDriverFLR.setValue(src.FtrDriverFLR);
    dst.FtrAstcLdr2D.setValue(src.FtrAstcLdr2D);
    dst.FtrAstcHdr2D.setValue(src.FtrAstcHdr2D);
    dst.FtrAstc3D.setValue(src.FtrAstc3D);
    dst.FtrFbc.setValue(src.FtrFbc);
    dst.FtrFbc2AddressTranslation.setValue(src.FtrFbc2AddressTranslation);
    dst.FtrFbcBlitterTracking.setValue(src.FtrFbcBlitterTracking);
    dst.FtrFbcCpuTracking.setValue(src.FtrFbcCpuTracking);
    dst.FtrRendComp.setValue(src.FtrRendComp);
    dst.FtrDisplayYTiling.setValue(src.FtrDisplayYTiling);
    dst.FtrS3D.setValue(src.FtrS3D);
    dst.FtrDisplayEngineS3d.setValue(src.FtrDisplayEngineS3d);
    dst.FtrSimulationMode.setValue(src.FtrSimulationMode);
    dst.FtrEnableGuC.setValue(src.FtrEnableGuC);
    dst.FtrVgt.setValue(src.FtrVgt);
    dst.FtrAssignedGpuTile.setValue(src.FtrAssignedGpuTile);
}
template <>
struct Marshaller<TOK_S_SKU_FEATURE_TABLE> {
    template <typename _SKU_FEATURE_TABLET>
    static TOKSTR__SKU_FEATURE_TABLE marshall(const _SKU_FEATURE_TABLET &src) {
        TOKSTR__SKU_FEATURE_TABLE ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename _WA_TABLET>
inline void marshall(TOKSTR__WA_TABLE &dst, const _WA_TABLET &src) {
    dst = {};
    dst.WaDoNotUseMIReportPerfCount.setValue(src.WaDoNotUseMIReportPerfCount);
    dst.WaAlignIndexBuffer.setValue(src.WaAlignIndexBuffer);
    dst.WaSendMIFLUSHBeforeVFE.setValue(src.WaSendMIFLUSHBeforeVFE);
    dst.WaDisablePerCtxtPreemptionGranularityControl.setValue(src.WaDisablePerCtxtPreemptionGranularityControl);
    dst.WaEnablePreemptionGranularityControlByUMD.setValue(src.WaEnablePreemptionGranularityControlByUMD);
    dst.WaDisableLSQCROPERFforOCL.setValue(src.WaDisableLSQCROPERFforOCL);
    dst.WaValign2For96bppFormats.setValue(src.WaValign2For96bppFormats);
    dst.WaValign2ForR8G8B8UINTFormat.setValue(src.WaValign2ForR8G8B8UINTFormat);
    dst.WaReportPerfCountUseGlobalContextID.setValue(src.WaReportPerfCountUseGlobalContextID);
    dst.WaForcePcBbFullCfgRestore.setValue(src.WaForcePcBbFullCfgRestore);
    dst.WaCSRUncachable.setValue(src.WaCSRUncachable);
    dst.WaDisableFusedThreadScheduling.setValue(src.WaDisableFusedThreadScheduling);
    dst.WaModifyVFEStateAfterGPGPUPreemption.setValue(src.WaModifyVFEStateAfterGPGPUPreemption);
    dst.WaCursor16K.setValue(src.WaCursor16K);
    dst.Wa8kAlignforAsyncFlip.setValue(src.Wa8kAlignforAsyncFlip);
    dst.Wa29BitDisplayAddrLimit.setValue(src.Wa29BitDisplayAddrLimit);
    dst.WaAlignContextImage.setValue(src.WaAlignContextImage);
    dst.WaForceGlobalGTT.setValue(src.WaForceGlobalGTT);
    dst.WaReportPerfCountForceGlobalGTT.setValue(src.WaReportPerfCountForceGlobalGTT);
    dst.WaOaAddressTranslation.setValue(src.WaOaAddressTranslation);
    dst.Wa2RowVerticalAlignment.setValue(src.Wa2RowVerticalAlignment);
    dst.WaPpgttAliasGlobalGttSpace.setValue(src.WaPpgttAliasGlobalGttSpace);
    dst.WaClearFenceRegistersAtDriverInit.setValue(src.WaClearFenceRegistersAtDriverInit);
    dst.WaRestrictPitch128KB.setValue(src.WaRestrictPitch128KB);
    dst.WaAvoidLLC.setValue(src.WaAvoidLLC);
    dst.WaAvoidL3.setValue(src.WaAvoidL3);
    dst.Wa16TileFencesOnly.setValue(src.Wa16TileFencesOnly);
    dst.Wa16MBOABufferAlignment.setValue(src.Wa16MBOABufferAlignment);
    dst.WaTranslationTableUnavailable.setValue(src.WaTranslationTableUnavailable);
    dst.WaNoMinimizedTrivialSurfacePadding.setValue(src.WaNoMinimizedTrivialSurfacePadding);
    dst.WaNoBufferSamplerPadding.setValue(src.WaNoBufferSamplerPadding);
    dst.WaSurfaceStatePlanarYOffsetAlignBy2.setValue(src.WaSurfaceStatePlanarYOffsetAlignBy2);
    dst.WaGttCachingOffByDefault.setValue(src.WaGttCachingOffByDefault);
    dst.WaTouchAllSvmMemory.setValue(src.WaTouchAllSvmMemory);
    dst.WaIOBAddressMustBeValidInHwContext.setValue(src.WaIOBAddressMustBeValidInHwContext);
    dst.WaFlushTlbAfterCpuGgttWrites.setValue(src.WaFlushTlbAfterCpuGgttWrites);
    dst.WaMsaa8xTileYDepthPitchAlignment.setValue(src.WaMsaa8xTileYDepthPitchAlignment);
    dst.WaDisableNullPageAsDummy.setValue(src.WaDisableNullPageAsDummy);
    dst.WaUseVAlign16OnTileXYBpp816.setValue(src.WaUseVAlign16OnTileXYBpp816);
    dst.WaGttPat0.setValue(src.WaGttPat0);
    dst.WaGttPat0WB.setValue(src.WaGttPat0WB);
    dst.WaMemTypeIsMaxOfPatAndMocs.setValue(src.WaMemTypeIsMaxOfPatAndMocs);
    dst.WaGttPat0GttWbOverOsIommuEllcOnly.setValue(src.WaGttPat0GttWbOverOsIommuEllcOnly);
    dst.WaAddDummyPageForDisplayPrefetch.setValue(src.WaAddDummyPageForDisplayPrefetch);
    dst.WaLLCCachingUnsupported.setValue(src.WaLLCCachingUnsupported);
    dst.WaDoubleFastClearWidthAlignment.setValue(src.WaDoubleFastClearWidthAlignment);
    dst.WaCompressedResourceRequiresConstVA21.setValue(src.WaCompressedResourceRequiresConstVA21);
    dst.WaDisregardPlatformChecks.setValue(src.WaDisregardPlatformChecks);
    dst.WaLosslessCompressionSurfaceStride.setValue(src.WaLosslessCompressionSurfaceStride);
    dst.WaFbcLinearSurfaceStride.setValue(src.WaFbcLinearSurfaceStride);
    dst.Wa4kAlignUVOffsetNV12LinearSurface.setValue(src.Wa4kAlignUVOffsetNV12LinearSurface);
    dst.WaAstcCorruptionForOddCompressedBlockSizeX.setValue(src.WaAstcCorruptionForOddCompressedBlockSizeX);
    dst.WaAuxTable16KGranular.setValue(src.WaAuxTable16KGranular);
    dst.WaEncryptedEdramOnlyPartials.setValue(src.WaEncryptedEdramOnlyPartials);
    dst.WaDisableEdramForDisplayRT.setValue(src.WaDisableEdramForDisplayRT);
    dst.WaLimit128BMediaCompr.setValue(src.WaLimit128BMediaCompr);
    dst.WaUntypedBufferCompression.setValue(src.WaUntypedBufferCompression);
    dst.WaSamplerCacheFlushBetweenRedescribedSurfaceReads.setValue(src.WaSamplerCacheFlushBetweenRedescribedSurfaceReads);
    dst.WaAlignYUVResourceToLCU.setValue(src.WaAlignYUVResourceToLCU);
    dst.Wa32bppTileY2DColorNoHAlign4.setValue(src.Wa32bppTileY2DColorNoHAlign4);
}
template <>
struct Marshaller<TOK_S_WA_TABLE> {
    template <typename _WA_TABLET>
    static TOKSTR__WA_TABLE marshall(const _WA_TABLET &src) {
        TOKSTR__WA_TABLE ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename PLATFORM_STRT>
inline void marshall(TOKSTR_PLATFORM_STR &dst, const PLATFORM_STRT &src) {
    dst = {};
    dst.eProductFamily.setValue(src.eProductFamily);
    dst.ePCHProductFamily.setValue(src.ePCHProductFamily);
    dst.eDisplayCoreFamily.setValue(src.eDisplayCoreFamily);
    dst.eRenderCoreFamily.setValue(src.eRenderCoreFamily);
    dst.ePlatformType.setValue(src.ePlatformType);
    dst.usDeviceID.setValue(src.usDeviceID);
    dst.usRevId.setValue(src.usRevId);
    dst.usDeviceID_PCH.setValue(src.usDeviceID_PCH);
    dst.usRevId_PCH.setValue(src.usRevId_PCH);
    dst.eGTType.setValue(src.eGTType);
}
template <>
struct Marshaller<TOK_S_PLATFORM_STR> {
    template <typename PLATFORM_STRT>
    static TOKSTR_PLATFORM_STR marshall(const PLATFORM_STRT &src) {
        TOKSTR_PLATFORM_STR ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename __KMD_CAPS_INFOT>
inline void marshall(TOKSTR___KMD_CAPS_INFO &dst, const __KMD_CAPS_INFOT &src) {
    dst = {};
    dst.Gamma_Rgb256x3x16.setValue(src.Gamma_Rgb256x3x16);
    dst.GDIAcceleration.setValue(src.GDIAcceleration);
    dst.OsManagedHwContext.setValue(src.OsManagedHwContext);
    dst.GraphicsPreemptionGranularity.setValue(src.GraphicsPreemptionGranularity);
    dst.ComputePreemptionGranularity.setValue(src.ComputePreemptionGranularity);
    dst.InstrumentationIsEnabled.setValue(src.InstrumentationIsEnabled);
    dst.DriverStoreEnabled.setValue(src.DriverStoreEnabled);
}
template <>
struct Marshaller<TOK_S_KMD_CAPS_INFO> {
    template <typename __KMD_CAPS_INFOT>
    static TOKSTR___KMD_CAPS_INFO marshall(const __KMD_CAPS_INFOT &src) {
        TOKSTR___KMD_CAPS_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename __KMD_OVERLAY_OVERRIDET>
inline void marshall(TOKSTR___KMD_OVERLAY_OVERRIDE &dst, const __KMD_OVERLAY_OVERRIDET &src) {
    dst = {};
    dst.OverrideOverlayCaps.setValue(src.OverrideOverlayCaps);
    dst.RGBOverlay.setValue(src.RGBOverlay);
    dst.YUY2Overlay.setValue(src.YUY2Overlay);
}
template <>
struct Marshaller<TOK_S_KMD_OVERLAY_OVERRIDE> {
    template <typename __KMD_OVERLAY_OVERRIDET>
    static TOKSTR___KMD_OVERLAY_OVERRIDE marshall(const __KMD_OVERLAY_OVERRIDET &src) {
        TOKSTR___KMD_OVERLAY_OVERRIDE ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename __KMD_OVERLAY_CAPS_INFOT>
inline void marshall(TOKSTR___KMD_OVERLAY_CAPS_INFO &dst, const __KMD_OVERLAY_CAPS_INFOT &src) {
    dst = {};
    dst.Caps.FullRangeRGB.setValue(src.Caps.FullRangeRGB);
    dst.Caps.LimitedRangeRGB.setValue(src.Caps.LimitedRangeRGB);
    dst.Caps.YCbCr_BT601.setValue(src.Caps.YCbCr_BT601);
    dst.Caps.YCbCr_BT709.setValue(src.Caps.YCbCr_BT709);
    dst.Caps.YCbCr_BT601_xvYCC.setValue(src.Caps.YCbCr_BT601_xvYCC);
    dst.Caps.YCbCr_BT709_xvYCC.setValue(src.Caps.YCbCr_BT709_xvYCC);
    dst.Caps.StretchX.setValue(src.Caps.StretchX);
    dst.Caps.StretchY.setValue(src.Caps.StretchY);
    dst.CapsValue.setValue(src.CapsValue);
    dst.OVOverride.OverrideOverlayCaps.setValue(src.OVOverride.OverrideOverlayCaps);
    dst.OVOverride.RGBOverlay.setValue(src.OVOverride.RGBOverlay);
    dst.OVOverride.YUY2Overlay.setValue(src.OVOverride.YUY2Overlay);
    dst.MaxOverlayDisplayWidth.setValue(src.MaxOverlayDisplayWidth);
    dst.MaxOverlayDisplayHeight.setValue(src.MaxOverlayDisplayHeight);
    dst.HWScalerExists.setValue(src.HWScalerExists);
    dst.MaxHWScalerStride.setValue(src.MaxHWScalerStride);
}
template <>
struct Marshaller<TOK_S_KMD_OVERLAY_CAPS_INFO> {
    template <typename __KMD_OVERLAY_CAPS_INFOT>
    static TOKSTR___KMD_OVERLAY_CAPS_INFO marshall(const __KMD_OVERLAY_CAPS_INFOT &src) {
        TOKSTR___KMD_OVERLAY_CAPS_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename FRAME_RATET>
inline void marshall(TOKSTR_FRAME_RATE &dst, const FRAME_RATET &src) {
    dst = {};
    dst.uiNumerator.setValue(src.uiNumerator);
    dst.uiDenominator.setValue(src.uiDenominator);
}
template <>
struct Marshaller<TOK_S_FRAME_RATE> {
    template <typename FRAME_RATET>
    static TOKSTR_FRAME_RATE marshall(const FRAME_RATET &src) {
        TOKSTR_FRAME_RATE ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename _KM_DEFERRED_WAIT_INFOT>
inline void marshall(TOKSTR__KM_DEFERRED_WAIT_INFO &dst, const _KM_DEFERRED_WAIT_INFOT &src) {
    dst = {};
    dst.FeatureSupported.setValue(src.FeatureSupported);
    dst.ActiveDisplay.setValue(src.ActiveDisplay);
}
template <>
struct Marshaller<TOK_S_KM_DEFERRED_WAIT_INFO> {
    template <typename _KM_DEFERRED_WAIT_INFOT>
    static TOKSTR__KM_DEFERRED_WAIT_INFO marshall(const _KM_DEFERRED_WAIT_INFOT &src) {
        TOKSTR__KM_DEFERRED_WAIT_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename __GMM_GFX_PARTITIONINGT>
inline void marshall(TOKSTR___GMM_GFX_PARTITIONING &dst, const __GMM_GFX_PARTITIONINGT &src) {
    dst = {};
    dst.Standard.Base.setValue(src.Standard.Base);
    dst.Standard.Limit.setValue(src.Standard.Limit);
    dst.Standard64KB.Base.setValue(src.Standard64KB.Base);
    dst.Standard64KB.Limit.setValue(src.Standard64KB.Limit);
    dst.SVM.Base.setValue(src.SVM.Base);
    dst.SVM.Limit.setValue(src.SVM.Limit);
    dst.Heap32[0].Base.setValue(src.Heap32[0].Base);
    dst.Heap32[0].Limit.setValue(src.Heap32[0].Limit);
    dst.Heap32[1].Base.setValue(src.Heap32[1].Base);
    dst.Heap32[1].Limit.setValue(src.Heap32[1].Limit);
    dst.Heap32[2].Base.setValue(src.Heap32[2].Base);
    dst.Heap32[2].Limit.setValue(src.Heap32[2].Limit);
    dst.Heap32[3].Base.setValue(src.Heap32[3].Base);
    dst.Heap32[3].Limit.setValue(src.Heap32[3].Limit);
}
template <>
struct Marshaller<TOK_S_GMM_GFX_PARTITIONING> {
    template <typename __GMM_GFX_PARTITIONINGT>
    static TOKSTR___GMM_GFX_PARTITIONING marshall(const __GMM_GFX_PARTITIONINGT &src) {
        TOKSTR___GMM_GFX_PARTITIONING ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename _ADAPTER_BDF_T>
inline void marshall(TOKSTR__ADAPTER_BDF_ &dst, const _ADAPTER_BDF_T &src) {
    dst = {};
    dst.Bus.setValue(src.Bus);
    dst.Device.setValue(src.Device);
    dst.Function.setValue(src.Function);
    dst.Data.setValue(src.Data);
}
template <>
struct Marshaller<TOK_S_ADAPTER_BDF> {
    template <typename _ADAPTER_BDF_T>
    static TOKSTR__ADAPTER_BDF_ marshall(const _ADAPTER_BDF_T &src) {
        TOKSTR__ADAPTER_BDF_ ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename _ADAPTER_INFOT>
inline void marshall(TOKSTR__ADAPTER_INFO &dst, const _ADAPTER_INFOT &src) {
    dst = {};
    dst.KmdVersionInfo.setValue(src.KmdVersionInfo);
    WCH_SAFE_COPY(dst.DeviceRegistryPath.getValue<char>(), dst.DeviceRegistryPath.getValueSizeInBytes(), src.DeviceRegistryPath, sizeof(src.DeviceRegistryPath));
    dst.GfxPlatform.eProductFamily.setValue(src.GfxPlatform.eProductFamily);
    dst.GfxPlatform.ePCHProductFamily.setValue(src.GfxPlatform.ePCHProductFamily);
    dst.GfxPlatform.eDisplayCoreFamily.setValue(src.GfxPlatform.eDisplayCoreFamily);
    dst.GfxPlatform.eRenderCoreFamily.setValue(src.GfxPlatform.eRenderCoreFamily);
    dst.GfxPlatform.ePlatformType.setValue(src.GfxPlatform.ePlatformType);
    dst.GfxPlatform.usDeviceID.setValue(src.GfxPlatform.usDeviceID);
    dst.GfxPlatform.usRevId.setValue(src.GfxPlatform.usRevId);
    dst.GfxPlatform.usDeviceID_PCH.setValue(src.GfxPlatform.usDeviceID_PCH);
    dst.GfxPlatform.usRevId_PCH.setValue(src.GfxPlatform.usRevId_PCH);
    dst.GfxPlatform.eGTType.setValue(src.GfxPlatform.eGTType);
    dst.SkuTable.FtrDesktop.setValue(src.SkuTable.FtrDesktop);
    dst.SkuTable.FtrULT.setValue(src.SkuTable.FtrULT);
    dst.SkuTable.FtrIVBM0M1Platform.setValue(src.SkuTable.FtrIVBM0M1Platform);
    dst.SkuTable.FtrChannelSwizzlingXOREnabled.setValue(src.SkuTable.FtrChannelSwizzlingXOREnabled);
    dst.SkuTable.Ftr5Slice.setValue(src.SkuTable.Ftr5Slice);
    dst.SkuTable.FtrLCIA.setValue(src.SkuTable.FtrLCIA);
    dst.SkuTable.FtrResourceStreamer.setValue(src.SkuTable.FtrResourceStreamer);
    dst.SkuTable.FtrCCSRing.setValue(src.SkuTable.FtrCCSRing);
    dst.SkuTable.FtrCCSNode.setValue(src.SkuTable.FtrCCSNode);
    dst.SkuTable.FtrCCSMultiInstance.setValue(src.SkuTable.FtrCCSMultiInstance);
    dst.SkuTable.FtrDisplayDisabled.setValue(src.SkuTable.FtrDisplayDisabled);
    dst.SkuTable.FtrSGTPVSKUStrapPresent.setValue(src.SkuTable.FtrSGTPVSKUStrapPresent);
    dst.SkuTable.FtrPooledEuEnabled.setValue(src.SkuTable.FtrPooledEuEnabled);
    dst.SkuTable.FtrGpGpuMidBatchPreempt.setValue(src.SkuTable.FtrGpGpuMidBatchPreempt);
    dst.SkuTable.FtrGpGpuThreadGroupLevelPreempt.setValue(src.SkuTable.FtrGpGpuThreadGroupLevelPreempt);
    dst.SkuTable.FtrGpGpuMidThreadLevelPreempt.setValue(src.SkuTable.FtrGpGpuMidThreadLevelPreempt);
    dst.SkuTable.Ftr3dMidBatchPreempt.setValue(src.SkuTable.Ftr3dMidBatchPreempt);
    dst.SkuTable.Ftr3dObjectLevelPreempt.setValue(src.SkuTable.Ftr3dObjectLevelPreempt);
    dst.SkuTable.FtrPerCtxtPreemptionGranularityControl.setValue(src.SkuTable.FtrPerCtxtPreemptionGranularityControl);
    dst.SkuTable.FtrPPGTT.setValue(src.SkuTable.FtrPPGTT);
    dst.SkuTable.FtrIA32eGfxPTEs.setValue(src.SkuTable.FtrIA32eGfxPTEs);
    dst.SkuTable.FtrMemTypeMocsDeferPAT.setValue(src.SkuTable.FtrMemTypeMocsDeferPAT);
    dst.SkuTable.FtrPml4Support.setValue(src.SkuTable.FtrPml4Support);
    dst.SkuTable.FtrSVM.setValue(src.SkuTable.FtrSVM);
    dst.SkuTable.FtrTileMappedResource.setValue(src.SkuTable.FtrTileMappedResource);
    dst.SkuTable.FtrTranslationTable.setValue(src.SkuTable.FtrTranslationTable);
    dst.SkuTable.FtrUserModeTranslationTable.setValue(src.SkuTable.FtrUserModeTranslationTable);
    dst.SkuTable.FtrNullPages.setValue(src.SkuTable.FtrNullPages);
    dst.SkuTable.FtrL3IACoherency.setValue(src.SkuTable.FtrL3IACoherency);
    dst.SkuTable.FtrEDram.setValue(src.SkuTable.FtrEDram);
    dst.SkuTable.FtrLLCBypass.setValue(src.SkuTable.FtrLLCBypass);
    dst.SkuTable.FtrCrystalwell.setValue(src.SkuTable.FtrCrystalwell);
    dst.SkuTable.FtrCentralCachePolicy.setValue(src.SkuTable.FtrCentralCachePolicy);
    dst.SkuTable.FtrIoMmuPageFaulting.setValue(src.SkuTable.FtrIoMmuPageFaulting);
    dst.SkuTable.FtrWddm2GpuMmu.setValue(src.SkuTable.FtrWddm2GpuMmu);
    dst.SkuTable.FtrWddm2Svm.setValue(src.SkuTable.FtrWddm2Svm);
    dst.SkuTable.FtrStandardMipTailFormat.setValue(src.SkuTable.FtrStandardMipTailFormat);
    dst.SkuTable.FtrWddm2_1_64kbPages.setValue(src.SkuTable.FtrWddm2_1_64kbPages);
    dst.SkuTable.FtrGttCacheInvalidation.setValue(src.SkuTable.FtrGttCacheInvalidation);
    dst.SkuTable.FtrE2ECompression.setValue(src.SkuTable.FtrE2ECompression);
    dst.SkuTable.FtrLinearCCS.setValue(src.SkuTable.FtrLinearCCS);
    dst.SkuTable.FtrLocalMemory.setValue(src.SkuTable.FtrLocalMemory);
    dst.SkuTable.FtrPpgtt64KBWalkOptimization.setValue(src.SkuTable.FtrPpgtt64KBWalkOptimization);
    dst.SkuTable.FtrTileY.setValue(src.SkuTable.FtrTileY);
    dst.SkuTable.FtrFlatPhysCCS.setValue(src.SkuTable.FtrFlatPhysCCS);
    dst.SkuTable.FtrMultiTileArch.setValue(src.SkuTable.FtrMultiTileArch);
    dst.SkuTable.FtrLocalMemoryAllows4KB.setValue(src.SkuTable.FtrLocalMemoryAllows4KB);
    dst.SkuTable.FtrDisplayXTiling.setValue(src.SkuTable.FtrDisplayXTiling);
    dst.SkuTable.FtrCameraCaptureCaching.setValue(src.SkuTable.FtrCameraCaptureCaching);
    dst.SkuTable.FtrKmdDaf.setValue(src.SkuTable.FtrKmdDaf);
    dst.SkuTable.FtrFrameBufferLLC.setValue(src.SkuTable.FtrFrameBufferLLC);
    dst.SkuTable.FtrDriverFLR.setValue(src.SkuTable.FtrDriverFLR);
    dst.SkuTable.FtrAstcLdr2D.setValue(src.SkuTable.FtrAstcLdr2D);
    dst.SkuTable.FtrAstcHdr2D.setValue(src.SkuTable.FtrAstcHdr2D);
    dst.SkuTable.FtrAstc3D.setValue(src.SkuTable.FtrAstc3D);
    dst.SkuTable.FtrFbc.setValue(src.SkuTable.FtrFbc);
    dst.SkuTable.FtrFbc2AddressTranslation.setValue(src.SkuTable.FtrFbc2AddressTranslation);
    dst.SkuTable.FtrFbcBlitterTracking.setValue(src.SkuTable.FtrFbcBlitterTracking);
    dst.SkuTable.FtrFbcCpuTracking.setValue(src.SkuTable.FtrFbcCpuTracking);
    dst.SkuTable.FtrRendComp.setValue(src.SkuTable.FtrRendComp);
    dst.SkuTable.FtrDisplayYTiling.setValue(src.SkuTable.FtrDisplayYTiling);
    dst.SkuTable.FtrS3D.setValue(src.SkuTable.FtrS3D);
    dst.SkuTable.FtrDisplayEngineS3d.setValue(src.SkuTable.FtrDisplayEngineS3d);
    dst.SkuTable.FtrSimulationMode.setValue(src.SkuTable.FtrSimulationMode);
    dst.SkuTable.FtrEnableGuC.setValue(src.SkuTable.FtrEnableGuC);
    dst.SkuTable.FtrVgt.setValue(src.SkuTable.FtrVgt);
    dst.SkuTable.FtrAssignedGpuTile.setValue(src.SkuTable.FtrAssignedGpuTile);
    dst.WaTable.WaDoNotUseMIReportPerfCount.setValue(src.WaTable.WaDoNotUseMIReportPerfCount);
    dst.WaTable.WaAlignIndexBuffer.setValue(src.WaTable.WaAlignIndexBuffer);
    dst.WaTable.WaSendMIFLUSHBeforeVFE.setValue(src.WaTable.WaSendMIFLUSHBeforeVFE);
    dst.WaTable.WaDisablePerCtxtPreemptionGranularityControl.setValue(src.WaTable.WaDisablePerCtxtPreemptionGranularityControl);
    dst.WaTable.WaEnablePreemptionGranularityControlByUMD.setValue(src.WaTable.WaEnablePreemptionGranularityControlByUMD);
    dst.WaTable.WaDisableLSQCROPERFforOCL.setValue(src.WaTable.WaDisableLSQCROPERFforOCL);
    dst.WaTable.WaValign2For96bppFormats.setValue(src.WaTable.WaValign2For96bppFormats);
    dst.WaTable.WaValign2ForR8G8B8UINTFormat.setValue(src.WaTable.WaValign2ForR8G8B8UINTFormat);
    dst.WaTable.WaReportPerfCountUseGlobalContextID.setValue(src.WaTable.WaReportPerfCountUseGlobalContextID);
    dst.WaTable.WaForcePcBbFullCfgRestore.setValue(src.WaTable.WaForcePcBbFullCfgRestore);
    dst.WaTable.WaCSRUncachable.setValue(src.WaTable.WaCSRUncachable);
    dst.WaTable.WaDisableFusedThreadScheduling.setValue(src.WaTable.WaDisableFusedThreadScheduling);
    dst.WaTable.WaModifyVFEStateAfterGPGPUPreemption.setValue(src.WaTable.WaModifyVFEStateAfterGPGPUPreemption);
    dst.WaTable.WaCursor16K.setValue(src.WaTable.WaCursor16K);
    dst.WaTable.Wa8kAlignforAsyncFlip.setValue(src.WaTable.Wa8kAlignforAsyncFlip);
    dst.WaTable.Wa29BitDisplayAddrLimit.setValue(src.WaTable.Wa29BitDisplayAddrLimit);
    dst.WaTable.WaAlignContextImage.setValue(src.WaTable.WaAlignContextImage);
    dst.WaTable.WaForceGlobalGTT.setValue(src.WaTable.WaForceGlobalGTT);
    dst.WaTable.WaReportPerfCountForceGlobalGTT.setValue(src.WaTable.WaReportPerfCountForceGlobalGTT);
    dst.WaTable.WaOaAddressTranslation.setValue(src.WaTable.WaOaAddressTranslation);
    dst.WaTable.Wa2RowVerticalAlignment.setValue(src.WaTable.Wa2RowVerticalAlignment);
    dst.WaTable.WaPpgttAliasGlobalGttSpace.setValue(src.WaTable.WaPpgttAliasGlobalGttSpace);
    dst.WaTable.WaClearFenceRegistersAtDriverInit.setValue(src.WaTable.WaClearFenceRegistersAtDriverInit);
    dst.WaTable.WaRestrictPitch128KB.setValue(src.WaTable.WaRestrictPitch128KB);
    dst.WaTable.WaAvoidLLC.setValue(src.WaTable.WaAvoidLLC);
    dst.WaTable.WaAvoidL3.setValue(src.WaTable.WaAvoidL3);
    dst.WaTable.Wa16TileFencesOnly.setValue(src.WaTable.Wa16TileFencesOnly);
    dst.WaTable.Wa16MBOABufferAlignment.setValue(src.WaTable.Wa16MBOABufferAlignment);
    dst.WaTable.WaTranslationTableUnavailable.setValue(src.WaTable.WaTranslationTableUnavailable);
    dst.WaTable.WaNoMinimizedTrivialSurfacePadding.setValue(src.WaTable.WaNoMinimizedTrivialSurfacePadding);
    dst.WaTable.WaNoBufferSamplerPadding.setValue(src.WaTable.WaNoBufferSamplerPadding);
    dst.WaTable.WaSurfaceStatePlanarYOffsetAlignBy2.setValue(src.WaTable.WaSurfaceStatePlanarYOffsetAlignBy2);
    dst.WaTable.WaGttCachingOffByDefault.setValue(src.WaTable.WaGttCachingOffByDefault);
    dst.WaTable.WaTouchAllSvmMemory.setValue(src.WaTable.WaTouchAllSvmMemory);
    dst.WaTable.WaIOBAddressMustBeValidInHwContext.setValue(src.WaTable.WaIOBAddressMustBeValidInHwContext);
    dst.WaTable.WaFlushTlbAfterCpuGgttWrites.setValue(src.WaTable.WaFlushTlbAfterCpuGgttWrites);
    dst.WaTable.WaMsaa8xTileYDepthPitchAlignment.setValue(src.WaTable.WaMsaa8xTileYDepthPitchAlignment);
    dst.WaTable.WaDisableNullPageAsDummy.setValue(src.WaTable.WaDisableNullPageAsDummy);
    dst.WaTable.WaUseVAlign16OnTileXYBpp816.setValue(src.WaTable.WaUseVAlign16OnTileXYBpp816);
    dst.WaTable.WaGttPat0.setValue(src.WaTable.WaGttPat0);
    dst.WaTable.WaGttPat0WB.setValue(src.WaTable.WaGttPat0WB);
    dst.WaTable.WaMemTypeIsMaxOfPatAndMocs.setValue(src.WaTable.WaMemTypeIsMaxOfPatAndMocs);
    dst.WaTable.WaGttPat0GttWbOverOsIommuEllcOnly.setValue(src.WaTable.WaGttPat0GttWbOverOsIommuEllcOnly);
    dst.WaTable.WaAddDummyPageForDisplayPrefetch.setValue(src.WaTable.WaAddDummyPageForDisplayPrefetch);
    dst.WaTable.WaLLCCachingUnsupported.setValue(src.WaTable.WaLLCCachingUnsupported);
    dst.WaTable.WaDoubleFastClearWidthAlignment.setValue(src.WaTable.WaDoubleFastClearWidthAlignment);
    dst.WaTable.WaCompressedResourceRequiresConstVA21.setValue(src.WaTable.WaCompressedResourceRequiresConstVA21);
    dst.WaTable.WaDisregardPlatformChecks.setValue(src.WaTable.WaDisregardPlatformChecks);
    dst.WaTable.WaLosslessCompressionSurfaceStride.setValue(src.WaTable.WaLosslessCompressionSurfaceStride);
    dst.WaTable.WaFbcLinearSurfaceStride.setValue(src.WaTable.WaFbcLinearSurfaceStride);
    dst.WaTable.Wa4kAlignUVOffsetNV12LinearSurface.setValue(src.WaTable.Wa4kAlignUVOffsetNV12LinearSurface);
    dst.WaTable.WaAstcCorruptionForOddCompressedBlockSizeX.setValue(src.WaTable.WaAstcCorruptionForOddCompressedBlockSizeX);
    dst.WaTable.WaAuxTable16KGranular.setValue(src.WaTable.WaAuxTable16KGranular);
    dst.WaTable.WaEncryptedEdramOnlyPartials.setValue(src.WaTable.WaEncryptedEdramOnlyPartials);
    dst.WaTable.WaDisableEdramForDisplayRT.setValue(src.WaTable.WaDisableEdramForDisplayRT);
    dst.WaTable.WaLimit128BMediaCompr.setValue(src.WaTable.WaLimit128BMediaCompr);
    dst.WaTable.WaUntypedBufferCompression.setValue(src.WaTable.WaUntypedBufferCompression);
    dst.WaTable.WaSamplerCacheFlushBetweenRedescribedSurfaceReads.setValue(src.WaTable.WaSamplerCacheFlushBetweenRedescribedSurfaceReads);
    dst.WaTable.WaAlignYUVResourceToLCU.setValue(src.WaTable.WaAlignYUVResourceToLCU);
    dst.WaTable.Wa32bppTileY2DColorNoHAlign4.setValue(src.WaTable.Wa32bppTileY2DColorNoHAlign4);
    dst.GfxTimeStampFreq.setValue(src.GfxTimeStampFreq);
    dst.GfxCoreFrequency.setValue(src.GfxCoreFrequency);
    dst.FSBFrequency.setValue(src.FSBFrequency);
    dst.MinRenderFreq.setValue(src.MinRenderFreq);
    dst.MaxRenderFreq.setValue(src.MaxRenderFreq);
    dst.PackageTdp.setValue(src.PackageTdp);
    dst.MaxFillRate.setValue(src.MaxFillRate);
    dst.NumberOfEUs.setValue(src.NumberOfEUs);
    dst.dwReleaseTarget.setValue(src.dwReleaseTarget);
    dst.SizeOfDmaBuffer.setValue(src.SizeOfDmaBuffer);
    dst.PatchLocationListSize.setValue(src.PatchLocationListSize);
    dst.AllocationListSize.setValue(src.AllocationListSize);
    dst.SmallPatchLocationListSize.setValue(src.SmallPatchLocationListSize);
    dst.DefaultCmdBufferSize.setValue(src.DefaultCmdBufferSize);
    dst.GfxMemorySize.setValue(src.GfxMemorySize);
    dst.SystemMemorySize.setValue(src.SystemMemorySize);
    dst.CacheLineSize.setValue(src.CacheLineSize);
    dst.ProcessorFamily.setValue(src.ProcessorFamily);
    dst.IsHTSupported.setValue(src.IsHTSupported);
    dst.IsMutiCoreCpu.setValue(src.IsMutiCoreCpu);
    dst.IsVTDSupported.setValue(src.IsVTDSupported);
    dst.RegistryPathLength.setValue(src.RegistryPathLength);
    dst.DedicatedVideoMemory.setValue(src.DedicatedVideoMemory);
    dst.SystemSharedMemory.setValue(src.SystemSharedMemory);
    dst.SystemVideoMemory.setValue(src.SystemVideoMemory);
    dst.OutputFrameRate.uiNumerator.setValue(src.OutputFrameRate.uiNumerator);
    dst.OutputFrameRate.uiDenominator.setValue(src.OutputFrameRate.uiDenominator);
    dst.InputFrameRate.uiNumerator.setValue(src.InputFrameRate.uiNumerator);
    dst.InputFrameRate.uiDenominator.setValue(src.InputFrameRate.uiDenominator);
    dst.Caps.Gamma_Rgb256x3x16.setValue(src.Caps.Gamma_Rgb256x3x16);
    dst.Caps.GDIAcceleration.setValue(src.Caps.GDIAcceleration);
    dst.Caps.OsManagedHwContext.setValue(src.Caps.OsManagedHwContext);
    dst.Caps.GraphicsPreemptionGranularity.setValue(src.Caps.GraphicsPreemptionGranularity);
    dst.Caps.ComputePreemptionGranularity.setValue(src.Caps.ComputePreemptionGranularity);
    dst.Caps.InstrumentationIsEnabled.setValue(src.Caps.InstrumentationIsEnabled);
    dst.Caps.DriverStoreEnabled.setValue(src.Caps.DriverStoreEnabled);
    dst.OverlayCaps.Caps.FullRangeRGB.setValue(src.OverlayCaps.Caps.FullRangeRGB);
    dst.OverlayCaps.Caps.LimitedRangeRGB.setValue(src.OverlayCaps.Caps.LimitedRangeRGB);
    dst.OverlayCaps.Caps.YCbCr_BT601.setValue(src.OverlayCaps.Caps.YCbCr_BT601);
    dst.OverlayCaps.Caps.YCbCr_BT709.setValue(src.OverlayCaps.Caps.YCbCr_BT709);
    dst.OverlayCaps.Caps.YCbCr_BT601_xvYCC.setValue(src.OverlayCaps.Caps.YCbCr_BT601_xvYCC);
    dst.OverlayCaps.Caps.YCbCr_BT709_xvYCC.setValue(src.OverlayCaps.Caps.YCbCr_BT709_xvYCC);
    dst.OverlayCaps.Caps.StretchX.setValue(src.OverlayCaps.Caps.StretchX);
    dst.OverlayCaps.Caps.StretchY.setValue(src.OverlayCaps.Caps.StretchY);
    dst.OverlayCaps.CapsValue.setValue(src.OverlayCaps.CapsValue);
    dst.OverlayCaps.OVOverride.OverrideOverlayCaps.setValue(src.OverlayCaps.OVOverride.OverrideOverlayCaps);
    dst.OverlayCaps.OVOverride.RGBOverlay.setValue(src.OverlayCaps.OVOverride.RGBOverlay);
    dst.OverlayCaps.OVOverride.YUY2Overlay.setValue(src.OverlayCaps.OVOverride.YUY2Overlay);
    dst.OverlayCaps.MaxOverlayDisplayWidth.setValue(src.OverlayCaps.MaxOverlayDisplayWidth);
    dst.OverlayCaps.MaxOverlayDisplayHeight.setValue(src.OverlayCaps.MaxOverlayDisplayHeight);
    dst.OverlayCaps.HWScalerExists.setValue(src.OverlayCaps.HWScalerExists);
    dst.OverlayCaps.MaxHWScalerStride.setValue(src.OverlayCaps.MaxHWScalerStride);
    dst.SystemInfo.EUCount.setValue(src.SystemInfo.EUCount);
    dst.SystemInfo.ThreadCount.setValue(src.SystemInfo.ThreadCount);
    dst.SystemInfo.SliceCount.setValue(src.SystemInfo.SliceCount);
    dst.SystemInfo.SubSliceCount.setValue(src.SystemInfo.SubSliceCount);
    dst.SystemInfo.DualSubSliceCount.setValue(src.SystemInfo.DualSubSliceCount);
    dst.SystemInfo.L3CacheSizeInKb.setValue(src.SystemInfo.L3CacheSizeInKb);
    dst.SystemInfo.LLCCacheSizeInKb.setValue(src.SystemInfo.LLCCacheSizeInKb);
    dst.SystemInfo.EdramSizeInKb.setValue(src.SystemInfo.EdramSizeInKb);
    dst.SystemInfo.L3BankCount.setValue(src.SystemInfo.L3BankCount);
    dst.SystemInfo.MaxFillRate.setValue(src.SystemInfo.MaxFillRate);
    dst.SystemInfo.EuCountPerPoolMax.setValue(src.SystemInfo.EuCountPerPoolMax);
    dst.SystemInfo.EuCountPerPoolMin.setValue(src.SystemInfo.EuCountPerPoolMin);
    dst.SystemInfo.TotalVsThreads.setValue(src.SystemInfo.TotalVsThreads);
    dst.SystemInfo.TotalHsThreads.setValue(src.SystemInfo.TotalHsThreads);
    dst.SystemInfo.TotalDsThreads.setValue(src.SystemInfo.TotalDsThreads);
    dst.SystemInfo.TotalGsThreads.setValue(src.SystemInfo.TotalGsThreads);
    dst.SystemInfo.TotalPsThreadsWindowerRange.setValue(src.SystemInfo.TotalPsThreadsWindowerRange);
    dst.SystemInfo.TotalVsThreads_Pocs.setValue(src.SystemInfo.TotalVsThreads_Pocs);
    dst.SystemInfo.CsrSizeInMb.setValue(src.SystemInfo.CsrSizeInMb);
    dst.SystemInfo.MaxEuPerSubSlice.setValue(src.SystemInfo.MaxEuPerSubSlice);
    dst.SystemInfo.MaxSlicesSupported.setValue(src.SystemInfo.MaxSlicesSupported);
    dst.SystemInfo.MaxSubSlicesSupported.setValue(src.SystemInfo.MaxSubSlicesSupported);
    dst.SystemInfo.MaxDualSubSlicesSupported.setValue(src.SystemInfo.MaxDualSubSlicesSupported);
    dst.SystemInfo.IsL3HashModeEnabled.setValue(src.SystemInfo.IsL3HashModeEnabled);
    dst.SystemInfo.SliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[0].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[0].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[0].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[0].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[0].DualSubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[1].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[1].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[1].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[1].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[1].DualSubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[2].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[2].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[2].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[2].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[2].DualSubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[3].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[3].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[3].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[3].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[3].DualSubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[4].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[4].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[4].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[4].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[4].DualSubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[5].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[5].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[5].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[5].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[5].DualSubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[6].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[6].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[6].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[6].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[6].DualSubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[7].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[7].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[7].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[7].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[7].DualSubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[8].Enabled.setValue(src.SystemInfo.SliceInfo[8].Enabled);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[8].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[8].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[8].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[8].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[8].DualSubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[9].Enabled.setValue(src.SystemInfo.SliceInfo[9].Enabled);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[2].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[2].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[2].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[2].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[3].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[3].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[3].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[3].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[4].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[4].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[4].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[4].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[5].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[5].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[5].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[5].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[6].Enabled.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[6].Enabled);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[6].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[6].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[6].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[6].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[7].Enabled.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[7].Enabled);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[7].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[7].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].SubSliceInfo[7].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].SubSliceInfo[7].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[0].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[0].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[0].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[1].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[1].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[1].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[2].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[2].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[2].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[3].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[3].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[3].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[4].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[4].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[4].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[5].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[5].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[0].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[0].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[0].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[0].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[0].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[0].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[1].Enabled.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[1].Enabled);
    dst.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[1].EuEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[1].EuEnabledCount);
    dst.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[1].EuEnabledMask.setValue(src.SystemInfo.SliceInfo[9].DSSInfo[5].SubSlice[1].EuEnabledMask);
    dst.SystemInfo.SliceInfo[9].SubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[9].SubSliceEnabledCount);
    dst.SystemInfo.SliceInfo[9].DualSubSliceEnabledCount.setValue(src.SystemInfo.SliceInfo[9].DualSubSliceEnabledCount);
    dst.SystemInfo.IsDynamicallyPopulated.setValue(src.SystemInfo.IsDynamicallyPopulated);
    dst.SystemInfo.SqidiInfo.NumberofSQIDI.setValue(src.SystemInfo.SqidiInfo.NumberofSQIDI);
    dst.SystemInfo.SqidiInfo.NumberofDoorbellPerSQIDI.setValue(src.SystemInfo.SqidiInfo.NumberofDoorbellPerSQIDI);
    dst.SystemInfo.ReservedCCSWays.setValue(src.SystemInfo.ReservedCCSWays);
    dst.SystemInfo.CCSInfo.Instances.Bits.CCS0Enabled.setValue(src.SystemInfo.CCSInfo.Instances.Bits.CCS0Enabled);
    dst.SystemInfo.CCSInfo.Instances.Bits.CCS1Enabled.setValue(src.SystemInfo.CCSInfo.Instances.Bits.CCS1Enabled);
    dst.SystemInfo.CCSInfo.Instances.Bits.CCS2Enabled.setValue(src.SystemInfo.CCSInfo.Instances.Bits.CCS2Enabled);
    dst.SystemInfo.CCSInfo.Instances.Bits.CCS3Enabled.setValue(src.SystemInfo.CCSInfo.Instances.Bits.CCS3Enabled);
    dst.SystemInfo.CCSInfo.Instances.CCSEnableMask.setValue(src.SystemInfo.CCSInfo.Instances.CCSEnableMask);
    dst.SystemInfo.CCSInfo.NumberOfCCSEnabled.setValue(src.SystemInfo.CCSInfo.NumberOfCCSEnabled);
    dst.SystemInfo.CCSInfo.IsValid.setValue(src.SystemInfo.CCSInfo.IsValid);
    dst.SystemInfo.MultiTileArchInfo.TileCount.setValue(src.SystemInfo.MultiTileArchInfo.TileCount);
    dst.SystemInfo.MultiTileArchInfo.Tile0.setValue(src.SystemInfo.MultiTileArchInfo.Tile0);
    dst.SystemInfo.MultiTileArchInfo.Tile1.setValue(src.SystemInfo.MultiTileArchInfo.Tile1);
    dst.SystemInfo.MultiTileArchInfo.Tile2.setValue(src.SystemInfo.MultiTileArchInfo.Tile2);
    dst.SystemInfo.MultiTileArchInfo.Tile3.setValue(src.SystemInfo.MultiTileArchInfo.Tile3);
    dst.SystemInfo.MultiTileArchInfo.TileMask.setValue(src.SystemInfo.MultiTileArchInfo.TileMask);
    dst.SystemInfo.MultiTileArchInfo.IsValid.setValue(src.SystemInfo.MultiTileArchInfo.IsValid);
    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox0Enabled.setValue(src.SystemInfo.VDBoxInfo.Instances.Bits.VDBox0Enabled);
    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox1Enabled.setValue(src.SystemInfo.VDBoxInfo.Instances.Bits.VDBox1Enabled);
    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox2Enabled.setValue(src.SystemInfo.VDBoxInfo.Instances.Bits.VDBox2Enabled);
    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox3Enabled.setValue(src.SystemInfo.VDBoxInfo.Instances.Bits.VDBox3Enabled);
    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox4Enabled.setValue(src.SystemInfo.VDBoxInfo.Instances.Bits.VDBox4Enabled);
    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox5Enabled.setValue(src.SystemInfo.VDBoxInfo.Instances.Bits.VDBox5Enabled);
    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox6Enabled.setValue(src.SystemInfo.VDBoxInfo.Instances.Bits.VDBox6Enabled);
    dst.SystemInfo.VDBoxInfo.Instances.Bits.VDBox7Enabled.setValue(src.SystemInfo.VDBoxInfo.Instances.Bits.VDBox7Enabled);
    dst.SystemInfo.VDBoxInfo.Instances.VDBoxEnableMask.setValue(src.SystemInfo.VDBoxInfo.Instances.VDBoxEnableMask);
    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox0.setValue(src.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox0);
    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox1.setValue(src.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox1);
    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox2.setValue(src.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox2);
    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox3.setValue(src.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox3);
    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox4.setValue(src.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox4);
    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox5.setValue(src.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox5);
    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox6.setValue(src.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox6);
    dst.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox7.setValue(src.SystemInfo.VDBoxInfo.SFCSupport.SfcSupportedBits.VDBox7);
    dst.SystemInfo.VDBoxInfo.SFCSupport.Value.setValue(src.SystemInfo.VDBoxInfo.SFCSupport.Value);
    dst.SystemInfo.VDBoxInfo.NumberOfVDBoxEnabled.setValue(src.SystemInfo.VDBoxInfo.NumberOfVDBoxEnabled);
    dst.SystemInfo.VDBoxInfo.IsValid.setValue(src.SystemInfo.VDBoxInfo.IsValid);
    dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox0Enabled.setValue(src.SystemInfo.VEBoxInfo.Instances.Bits.VEBox0Enabled);
    dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox1Enabled.setValue(src.SystemInfo.VEBoxInfo.Instances.Bits.VEBox1Enabled);
    dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox2Enabled.setValue(src.SystemInfo.VEBoxInfo.Instances.Bits.VEBox2Enabled);
    dst.SystemInfo.VEBoxInfo.Instances.Bits.VEBox3Enabled.setValue(src.SystemInfo.VEBoxInfo.Instances.Bits.VEBox3Enabled);
    dst.SystemInfo.VEBoxInfo.Instances.VEBoxEnableMask.setValue(src.SystemInfo.VEBoxInfo.Instances.VEBoxEnableMask);
    dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox0.setValue(src.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox0);
    dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox1.setValue(src.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox1);
    dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox2.setValue(src.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox2);
    dst.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox3.setValue(src.SystemInfo.VEBoxInfo.SFCSupport.SfcSupportedBits.VEBox3);
    dst.SystemInfo.VEBoxInfo.SFCSupport.Value.setValue(src.SystemInfo.VEBoxInfo.SFCSupport.Value);
    dst.SystemInfo.VEBoxInfo.NumberOfVEBoxEnabled.setValue(src.SystemInfo.VEBoxInfo.NumberOfVEBoxEnabled);
    dst.SystemInfo.VEBoxInfo.IsValid.setValue(src.SystemInfo.VEBoxInfo.IsValid);
    dst.SystemInfo.NumThreadsPerEu.setValue(src.SystemInfo.NumThreadsPerEu);
    dst.SystemInfo.CacheTypes.L3.setValue(src.SystemInfo.CacheTypes.L3);
    dst.SystemInfo.CacheTypes.LLC.setValue(src.SystemInfo.CacheTypes.LLC);
    dst.SystemInfo.CacheTypes.eDRAM.setValue(src.SystemInfo.CacheTypes.eDRAM);
    dst.SystemInfo.CacheTypes.CacheTypeMask.setValue(src.SystemInfo.CacheTypes.CacheTypeMask);
    dst.SystemInfo.MaxVECS.setValue(src.SystemInfo.MaxVECS);
    dst.DeferredWaitInfo.FeatureSupported.setValue(src.DeferredWaitInfo.FeatureSupported);
    dst.DeferredWaitInfo.ActiveDisplay.setValue(src.DeferredWaitInfo.ActiveDisplay);
    dst.GfxPartition.Standard.Base.setValue(src.GfxPartition.Standard.Base);
    dst.GfxPartition.Standard.Limit.setValue(src.GfxPartition.Standard.Limit);
    dst.GfxPartition.Standard64KB.Base.setValue(src.GfxPartition.Standard64KB.Base);
    dst.GfxPartition.Standard64KB.Limit.setValue(src.GfxPartition.Standard64KB.Limit);
    dst.GfxPartition.SVM.Base.setValue(src.GfxPartition.SVM.Base);
    dst.GfxPartition.SVM.Limit.setValue(src.GfxPartition.SVM.Limit);
    dst.GfxPartition.Heap32[0].Base.setValue(src.GfxPartition.Heap32[0].Base);
    dst.GfxPartition.Heap32[0].Limit.setValue(src.GfxPartition.Heap32[0].Limit);
    dst.GfxPartition.Heap32[1].Base.setValue(src.GfxPartition.Heap32[1].Base);
    dst.GfxPartition.Heap32[1].Limit.setValue(src.GfxPartition.Heap32[1].Limit);
    dst.GfxPartition.Heap32[2].Base.setValue(src.GfxPartition.Heap32[2].Base);
    dst.GfxPartition.Heap32[2].Limit.setValue(src.GfxPartition.Heap32[2].Limit);
    dst.GfxPartition.Heap32[3].Base.setValue(src.GfxPartition.Heap32[3].Base);
    dst.GfxPartition.Heap32[3].Limit.setValue(src.GfxPartition.Heap32[3].Limit);
    dst.stAdapterBDF.Bus.setValue(src.stAdapterBDF.Bus);
    dst.stAdapterBDF.Device.setValue(src.stAdapterBDF.Device);
    dst.stAdapterBDF.Function.setValue(src.stAdapterBDF.Function);
    dst.stAdapterBDF.Data.setValue(src.stAdapterBDF.Data);
}
template <>
struct Marshaller<TOK_S_ADAPTER_INFO> {
    template <typename _ADAPTER_INFOT>
    static TOKSTR__ADAPTER_INFO marshall(const _ADAPTER_INFOT &src) {
        TOKSTR__ADAPTER_INFO ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename _CREATECONTEXT_PVTDATAT>
inline void marshall(TOKSTR__CREATECONTEXT_PVTDATA &dst, const _CREATECONTEXT_PVTDATAT &src) {
    dst = {};
    dst.pHwContextId.setValue(src.pHwContextId);
    dst.NumberOfHwContextIds.setValue(src.NumberOfHwContextIds);
    dst.ProcessID.setValue(src.ProcessID);
    dst.IsProtectedProcess.setValue(src.IsProtectedProcess);
    dst.IsDwm.setValue(src.IsDwm);
    dst.IsMediaUsage.setValue(src.IsMediaUsage);
    dst.GpuVAContext.setValue(src.GpuVAContext);
    dst.NoRingFlushes.setValue(src.NoRingFlushes);
}
template <>
struct Marshaller<TOK_S_CREATECONTEXT_PVTDATA> {
    template <typename _CREATECONTEXT_PVTDATAT>
    static TOKSTR__CREATECONTEXT_PVTDATA marshall(const _CREATECONTEXT_PVTDATAT &src) {
        TOKSTR__CREATECONTEXT_PVTDATA ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename COMMAND_BUFFER_HEADER_RECT>
inline void marshall(TOKSTR_COMMAND_BUFFER_HEADER_REC &dst, const COMMAND_BUFFER_HEADER_RECT &src) {
    dst = {};
    dst.UmdContextType.setValue(src.UmdContextType);
    dst.UmdPatchList.setValue(src.UmdPatchList);
    dst.UmdRequestedSliceState.setValue(src.UmdRequestedSliceState);
    dst.UmdRequestedSubsliceCount.setValue(src.UmdRequestedSubsliceCount);
    dst.UmdRequestedEUCount.setValue(src.UmdRequestedEUCount);
    dst.UsesResourceStreamer.setValue(src.UsesResourceStreamer);
    dst.NeedsMidBatchPreEmptionSupport.setValue(src.NeedsMidBatchPreEmptionSupport);
    dst.UsesGPGPUPipeline.setValue(src.UsesGPGPUPipeline);
    dst.RequiresCoherency.setValue(src.RequiresCoherency);
    dst.PerfTag.setValue(src.PerfTag);
    dst.MonitorFenceVA.setValue(src.MonitorFenceVA);
    dst.MonitorFenceValue.setValue(src.MonitorFenceValue);
}
template <>
struct Marshaller<TOK_S_COMMAND_BUFFER_HEADER_REC> {
    template <typename COMMAND_BUFFER_HEADER_RECT>
    static TOKSTR_COMMAND_BUFFER_HEADER_REC marshall(const COMMAND_BUFFER_HEADER_RECT &src) {
        TOKSTR_COMMAND_BUFFER_HEADER_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_RESOURCE_FLAG_RECT>
inline void marshall(TOKSTR_GMM_RESOURCE_FLAG_REC &dst, const GMM_RESOURCE_FLAG_RECT &src) {
    dst = {};
    dst.Gpu.CameraCapture.setValue(src.Gpu.CameraCapture);
    dst.Gpu.CCS.setValue(src.Gpu.CCS);
    dst.Gpu.ColorDiscard.setValue(src.Gpu.ColorDiscard);
    dst.Gpu.ColorSeparation.setValue(src.Gpu.ColorSeparation);
    dst.Gpu.ColorSeparationRGBX.setValue(src.Gpu.ColorSeparationRGBX);
    dst.Gpu.Constant.setValue(src.Gpu.Constant);
    dst.Gpu.Depth.setValue(src.Gpu.Depth);
    dst.Gpu.FlipChain.setValue(src.Gpu.FlipChain);
    dst.Gpu.FlipChainPreferred.setValue(src.Gpu.FlipChainPreferred);
    dst.Gpu.HistoryBuffer.setValue(src.Gpu.HistoryBuffer);
    dst.Gpu.HiZ.setValue(src.Gpu.HiZ);
    dst.Gpu.Index.setValue(src.Gpu.Index);
    dst.Gpu.IndirectClearColor.setValue(src.Gpu.IndirectClearColor);
    dst.Gpu.InstructionFlat.setValue(src.Gpu.InstructionFlat);
    dst.Gpu.InterlacedScan.setValue(src.Gpu.InterlacedScan);
    dst.Gpu.MCS.setValue(src.Gpu.MCS);
    dst.Gpu.MMC.setValue(src.Gpu.MMC);
    dst.Gpu.MotionComp.setValue(src.Gpu.MotionComp);
    dst.Gpu.NoRestriction.setValue(src.Gpu.NoRestriction);
    dst.Gpu.Overlay.setValue(src.Gpu.Overlay);
    dst.Gpu.Presentable.setValue(src.Gpu.Presentable);
    dst.Gpu.ProceduralTexture.setValue(src.Gpu.ProceduralTexture);
    dst.Gpu.Query.setValue(src.Gpu.Query);
    dst.Gpu.RenderTarget.setValue(src.Gpu.RenderTarget);
    dst.Gpu.S3d.setValue(src.Gpu.S3d);
    dst.Gpu.S3dDx.setValue(src.Gpu.S3dDx);
    dst.Gpu.__S3dNonPacked.setValue(src.Gpu.__S3dNonPacked);
    dst.Gpu.__S3dWidi.setValue(src.Gpu.__S3dWidi);
    dst.Gpu.ScratchFlat.setValue(src.Gpu.ScratchFlat);
    dst.Gpu.SeparateStencil.setValue(src.Gpu.SeparateStencil);
    dst.Gpu.State.setValue(src.Gpu.State);
    dst.Gpu.StateDx9ConstantBuffer.setValue(src.Gpu.StateDx9ConstantBuffer);
    dst.Gpu.Stream.setValue(src.Gpu.Stream);
    dst.Gpu.TextApi.setValue(src.Gpu.TextApi);
    dst.Gpu.Texture.setValue(src.Gpu.Texture);
    dst.Gpu.TiledResource.setValue(src.Gpu.TiledResource);
    dst.Gpu.TilePool.setValue(src.Gpu.TilePool);
    dst.Gpu.UnifiedAuxSurface.setValue(src.Gpu.UnifiedAuxSurface);
    dst.Gpu.Vertex.setValue(src.Gpu.Vertex);
    dst.Gpu.Video.setValue(src.Gpu.Video);
    dst.Gpu.__NonMsaaTileXCcs.setValue(src.Gpu.__NonMsaaTileXCcs);
    dst.Gpu.__NonMsaaTileYCcs.setValue(src.Gpu.__NonMsaaTileYCcs);
    dst.Gpu.__MsaaTileMcs.setValue(src.Gpu.__MsaaTileMcs);
    dst.Gpu.__NonMsaaLinearCCS.setValue(src.Gpu.__NonMsaaLinearCCS);
    dst.Gpu.__Remaining.setValue(src.Gpu.__Remaining);
    dst.Info.AllowVirtualPadding.setValue(src.Info.AllowVirtualPadding);
    dst.Info.BigPage.setValue(src.Info.BigPage);
    dst.Info.Cacheable.setValue(src.Info.Cacheable);
    dst.Info.ContigPhysMemoryForiDART.setValue(src.Info.ContigPhysMemoryForiDART);
    dst.Info.CornerTexelMode.setValue(src.Info.CornerTexelMode);
    dst.Info.ExistingSysMem.setValue(src.Info.ExistingSysMem);
    dst.Info.ForceResidency.setValue(src.Info.ForceResidency);
    dst.Info.Gfdt.setValue(src.Info.Gfdt);
    dst.Info.GttMapType.setValue(src.Info.GttMapType);
    dst.Info.HardwareProtected.setValue(src.Info.HardwareProtected);
    dst.Info.KernelModeMapped.setValue(src.Info.KernelModeMapped);
    dst.Info.LayoutBelow.setValue(src.Info.LayoutBelow);
    dst.Info.LayoutMono.setValue(src.Info.LayoutMono);
    dst.Info.LayoutRight.setValue(src.Info.LayoutRight);
    dst.Info.LocalOnly.setValue(src.Info.LocalOnly);
    dst.Info.Linear.setValue(src.Info.Linear);
    dst.Info.MediaCompressed.setValue(src.Info.MediaCompressed);
    dst.Info.NoOptimizationPadding.setValue(src.Info.NoOptimizationPadding);
    dst.Info.NoPhysMemory.setValue(src.Info.NoPhysMemory);
    dst.Info.NotLockable.setValue(src.Info.NotLockable);
    dst.Info.NonLocalOnly.setValue(src.Info.NonLocalOnly);
    dst.Info.StdSwizzle.setValue(src.Info.StdSwizzle);
    dst.Info.PseudoStdSwizzle.setValue(src.Info.PseudoStdSwizzle);
    dst.Info.Undefined64KBSwizzle.setValue(src.Info.Undefined64KBSwizzle);
    dst.Info.RedecribedPlanes.setValue(src.Info.RedecribedPlanes);
    dst.Info.RenderCompressed.setValue(src.Info.RenderCompressed);
    dst.Info.Rotated.setValue(src.Info.Rotated);
    dst.Info.Shared.setValue(src.Info.Shared);
    dst.Info.SoftwareProtected.setValue(src.Info.SoftwareProtected);
    dst.Info.SVM.setValue(src.Info.SVM);
    dst.Info.Tile4.setValue(src.Info.Tile4);
    dst.Info.Tile64.setValue(src.Info.Tile64);
    dst.Info.TiledW.setValue(src.Info.TiledW);
    dst.Info.TiledX.setValue(src.Info.TiledX);
    dst.Info.TiledY.setValue(src.Info.TiledY);
    dst.Info.TiledYf.setValue(src.Info.TiledYf);
    dst.Info.TiledYs.setValue(src.Info.TiledYs);
    dst.Info.WddmProtected.setValue(src.Info.WddmProtected);
    dst.Info.XAdapter.setValue(src.Info.XAdapter);
    dst.Info.__PreallocatedResInfo.setValue(src.Info.__PreallocatedResInfo);
    dst.Info.__PreWddm2SVM.setValue(src.Info.__PreWddm2SVM);
    dst.Wa.GTMfx2ndLevelBatchRingSizeAlign.setValue(src.Wa.GTMfx2ndLevelBatchRingSizeAlign);
    dst.Wa.ILKNeedAvcMprRowStore32KAlign.setValue(src.Wa.ILKNeedAvcMprRowStore32KAlign);
    dst.Wa.ILKNeedAvcDmvBuffer32KAlign.setValue(src.Wa.ILKNeedAvcDmvBuffer32KAlign);
    dst.Wa.NoBufferSamplerPadding.setValue(src.Wa.NoBufferSamplerPadding);
    dst.Wa.NoLegacyPlanarLinearVideoRestrictions.setValue(src.Wa.NoLegacyPlanarLinearVideoRestrictions);
    dst.Wa.CHVAstcSkipVirtualMips.setValue(src.Wa.CHVAstcSkipVirtualMips);
    dst.Wa.DisablePackedMipTail.setValue(src.Wa.DisablePackedMipTail);
    dst.Wa.__ForceOtherHVALIGN4.setValue(src.Wa.__ForceOtherHVALIGN4);
    dst.Wa.DisableDisplayCcsClearColor.setValue(src.Wa.DisableDisplayCcsClearColor);
    dst.Wa.DisableDisplayCcsCompression.setValue(src.Wa.DisableDisplayCcsCompression);
    dst.Wa.PreGen12FastClearOnly.setValue(src.Wa.PreGen12FastClearOnly);
    dst.Wa.ForceStdAllocAlign.setValue(src.Wa.ForceStdAllocAlign);
    dst.Wa.DeniableLocalOnlyForCompression.setValue(src.Wa.DeniableLocalOnlyForCompression);
}
template <>
struct Marshaller<TOK_S_GMM_RESOURCE_FLAG_REC> {
    template <typename GMM_RESOURCE_FLAG_RECT>
    static TOKSTR_GMM_RESOURCE_FLAG_REC marshall(const GMM_RESOURCE_FLAG_RECT &src) {
        TOKSTR_GMM_RESOURCE_FLAG_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_RESOURCE_MSAA_INFO_RECT>
inline void marshall(TOKSTR_GMM_RESOURCE_MSAA_INFO_REC &dst, const GMM_RESOURCE_MSAA_INFO_RECT &src) {
    dst = {};
    dst.SamplePattern.setValue(src.SamplePattern);
    dst.NumSamples.setValue(src.NumSamples);
}
template <>
struct Marshaller<TOK_S_GMM_RESOURCE_MSAA_INFO_REC> {
    template <typename GMM_RESOURCE_MSAA_INFO_RECT>
    static TOKSTR_GMM_RESOURCE_MSAA_INFO_REC marshall(const GMM_RESOURCE_MSAA_INFO_RECT &src) {
        TOKSTR_GMM_RESOURCE_MSAA_INFO_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_RESOURCE_ALIGNMENT_RECT>
inline void marshall(TOKSTR_GMM_RESOURCE_ALIGNMENT_REC &dst, const GMM_RESOURCE_ALIGNMENT_RECT &src) {
    dst = {};
    dst.ArraySpacingSingleLod.setValue(src.ArraySpacingSingleLod);
    dst.BaseAlignment.setValue(src.BaseAlignment);
    dst.HAlign.setValue(src.HAlign);
    dst.VAlign.setValue(src.VAlign);
    dst.DAlign.setValue(src.DAlign);
    dst.MipTailStartLod.setValue(src.MipTailStartLod);
    dst.PackedMipStartLod.setValue(src.PackedMipStartLod);
    dst.PackedMipWidth.setValue(src.PackedMipWidth);
    dst.PackedMipHeight.setValue(src.PackedMipHeight);
    dst.QPitch.setValue(src.QPitch);
}
template <>
struct Marshaller<TOK_S_GMM_RESOURCE_ALIGNMENT_REC> {
    template <typename GMM_RESOURCE_ALIGNMENT_RECT>
    static TOKSTR_GMM_RESOURCE_ALIGNMENT_REC marshall(const GMM_RESOURCE_ALIGNMENT_RECT &src) {
        TOKSTR_GMM_RESOURCE_ALIGNMENT_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_S3D_INFO_RECT>
inline void marshall(TOKSTR_GMM_S3D_INFO_REC &dst, const GMM_S3D_INFO_RECT &src) {
    dst = {};
    dst.DisplayModeHeight.setValue(src.DisplayModeHeight);
    dst.NumBlankActiveLines.setValue(src.NumBlankActiveLines);
    dst.RFrameOffset.setValue(src.RFrameOffset);
    dst.BlankAreaOffset.setValue(src.BlankAreaOffset);
    dst.TallBufferHeight.setValue(src.TallBufferHeight);
    dst.TallBufferSize.setValue(src.TallBufferSize);
    dst.IsRFrame.setValue(src.IsRFrame);
}
template <>
struct Marshaller<TOK_S_GMM_S3D_INFO_REC> {
    template <typename GMM_S3D_INFO_RECT>
    static TOKSTR_GMM_S3D_INFO_REC marshall(const GMM_S3D_INFO_RECT &src) {
        TOKSTR_GMM_S3D_INFO_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_MULTI_TILE_ARCH_RECT>
inline void marshall(TOKSTR_GMM_MULTI_TILE_ARCH_REC &dst, const GMM_MULTI_TILE_ARCH_RECT &src) {
    dst = {};
    dst.Enable.setValue(src.Enable);
    dst.TileInstanced.setValue(src.TileInstanced);
    dst.GpuVaMappingSet.setValue(src.GpuVaMappingSet);
    dst.LocalMemEligibilitySet.setValue(src.LocalMemEligibilitySet);
    dst.LocalMemPreferredSet.setValue(src.LocalMemPreferredSet);
}
template <>
struct Marshaller<TOK_S_GMM_MULTI_TILE_ARCH_REC> {
    template <typename GMM_MULTI_TILE_ARCH_RECT>
    static TOKSTR_GMM_MULTI_TILE_ARCH_REC marshall(const GMM_MULTI_TILE_ARCH_RECT &src) {
        TOKSTR_GMM_MULTI_TILE_ARCH_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_PLANAR_OFFSET_INFO_RECT>
inline void marshall(TOKSTR_GMM_PLANAR_OFFSET_INFO_REC &dst, const GMM_PLANAR_OFFSET_INFO_RECT &src) {
    dst = {};
    dst.ArrayQPitch.setValue(src.ArrayQPitch);
    WCH_SAFE_COPY(dst.X.getValue<char>(), dst.X.getValueSizeInBytes(), src.X, sizeof(src.X));
    WCH_SAFE_COPY(dst.Y.getValue<char>(), dst.Y.getValueSizeInBytes(), src.Y, sizeof(src.Y));
    WCH_SAFE_COPY(dst.UnAligned.Height.getValue<char>(), dst.UnAligned.Height.getValueSizeInBytes(), src.UnAligned.Height, sizeof(src.UnAligned.Height));
    dst.NoOfPlanes.setValue(src.NoOfPlanes);
    dst.IsTileAlignedPlanes.setValue(src.IsTileAlignedPlanes);
}
template <>
struct Marshaller<TOK_S_GMM_PLANAR_OFFSET_INFO_REC> {
    template <typename GMM_PLANAR_OFFSET_INFO_RECT>
    static TOKSTR_GMM_PLANAR_OFFSET_INFO_REC marshall(const GMM_PLANAR_OFFSET_INFO_RECT &src) {
        TOKSTR_GMM_PLANAR_OFFSET_INFO_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_2D_TEXTURE_OFFSET_INFO_RECT>
inline void marshall(TOKSTR_GMM_2D_TEXTURE_OFFSET_INFO_REC &dst, const GMM_2D_TEXTURE_OFFSET_INFO_RECT &src) {
    dst = {};
    dst.ArrayQPitchLock.setValue(src.ArrayQPitchLock);
    dst.ArrayQPitchRender.setValue(src.ArrayQPitchRender);
    WCH_SAFE_COPY(dst.Offset.getValue<char>(), dst.Offset.getValueSizeInBytes(), src.Offset, sizeof(src.Offset));
}
template <>
struct Marshaller<TOK_S_GMM_2D_TEXTURE_OFFSET_INFO_REC> {
    template <typename GMM_2D_TEXTURE_OFFSET_INFO_RECT>
    static TOKSTR_GMM_2D_TEXTURE_OFFSET_INFO_REC marshall(const GMM_2D_TEXTURE_OFFSET_INFO_RECT &src) {
        TOKSTR_GMM_2D_TEXTURE_OFFSET_INFO_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_3D_TEXTURE_OFFSET_INFO_RECT>
inline void marshall(TOKSTR_GMM_3D_TEXTURE_OFFSET_INFO_REC &dst, const GMM_3D_TEXTURE_OFFSET_INFO_RECT &src) {
    dst = {};
    dst.Mip0SlicePitch.setValue(src.Mip0SlicePitch);
    WCH_SAFE_COPY(dst.Offset.getValue<char>(), dst.Offset.getValueSizeInBytes(), src.Offset, sizeof(src.Offset));
}
template <>
struct Marshaller<TOK_S_GMM_3D_TEXTURE_OFFSET_INFO_REC> {
    template <typename GMM_3D_TEXTURE_OFFSET_INFO_RECT>
    static TOKSTR_GMM_3D_TEXTURE_OFFSET_INFO_REC marshall(const GMM_3D_TEXTURE_OFFSET_INFO_RECT &src) {
        TOKSTR_GMM_3D_TEXTURE_OFFSET_INFO_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_OFFSET_INFO_RECT>
inline void marshall(TOKSTR_GMM_OFFSET_INFO_REC &dst, const GMM_OFFSET_INFO_RECT &src) {
    dst = {};
    dst.Texture3DOffsetInfo.Mip0SlicePitch.setValue(src.Texture3DOffsetInfo.Mip0SlicePitch);
    WCH_SAFE_COPY(dst.Texture3DOffsetInfo.Offset.getValue<char>(), dst.Texture3DOffsetInfo.Offset.getValueSizeInBytes(), src.Texture3DOffsetInfo.Offset, sizeof(src.Texture3DOffsetInfo.Offset));
    dst.Texture2DOffsetInfo.ArrayQPitchLock.setValue(src.Texture2DOffsetInfo.ArrayQPitchLock);
    dst.Texture2DOffsetInfo.ArrayQPitchRender.setValue(src.Texture2DOffsetInfo.ArrayQPitchRender);
    WCH_SAFE_COPY(dst.Texture2DOffsetInfo.Offset.getValue<char>(), dst.Texture2DOffsetInfo.Offset.getValueSizeInBytes(), src.Texture2DOffsetInfo.Offset, sizeof(src.Texture2DOffsetInfo.Offset));
    dst.Plane.ArrayQPitch.setValue(src.Plane.ArrayQPitch);
    WCH_SAFE_COPY(dst.Plane.X.getValue<char>(), dst.Plane.X.getValueSizeInBytes(), src.Plane.X, sizeof(src.Plane.X));
    WCH_SAFE_COPY(dst.Plane.Y.getValue<char>(), dst.Plane.Y.getValueSizeInBytes(), src.Plane.Y, sizeof(src.Plane.Y));
    WCH_SAFE_COPY(dst.Plane.UnAligned.Height.getValue<char>(), dst.Plane.UnAligned.Height.getValueSizeInBytes(), src.Plane.UnAligned.Height, sizeof(src.Plane.UnAligned.Height));
    dst.Plane.NoOfPlanes.setValue(src.Plane.NoOfPlanes);
    dst.Plane.IsTileAlignedPlanes.setValue(src.Plane.IsTileAlignedPlanes);
}
template <>
struct Marshaller<TOK_S_GMM_OFFSET_INFO_REC> {
    template <typename GMM_OFFSET_INFO_RECT>
    static TOKSTR_GMM_OFFSET_INFO_REC marshall(const GMM_OFFSET_INFO_RECT &src) {
        TOKSTR_GMM_OFFSET_INFO_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_TEXTURE_INFO_RECT>
inline void marshall(TOKSTR_GMM_TEXTURE_INFO_REC &dst, const GMM_TEXTURE_INFO_RECT &src) {
    dst = {};
    dst.Type.setValue(src.Type);
    dst.Format.setValue(src.Format);
    dst.BitsPerPixel.setValue(src.BitsPerPixel);
    dst.Flags.Gpu.CameraCapture.setValue(src.Flags.Gpu.CameraCapture);
    dst.Flags.Gpu.CCS.setValue(src.Flags.Gpu.CCS);
    dst.Flags.Gpu.ColorDiscard.setValue(src.Flags.Gpu.ColorDiscard);
    dst.Flags.Gpu.ColorSeparation.setValue(src.Flags.Gpu.ColorSeparation);
    dst.Flags.Gpu.ColorSeparationRGBX.setValue(src.Flags.Gpu.ColorSeparationRGBX);
    dst.Flags.Gpu.Constant.setValue(src.Flags.Gpu.Constant);
    dst.Flags.Gpu.Depth.setValue(src.Flags.Gpu.Depth);
    dst.Flags.Gpu.FlipChain.setValue(src.Flags.Gpu.FlipChain);
    dst.Flags.Gpu.FlipChainPreferred.setValue(src.Flags.Gpu.FlipChainPreferred);
    dst.Flags.Gpu.HistoryBuffer.setValue(src.Flags.Gpu.HistoryBuffer);
    dst.Flags.Gpu.HiZ.setValue(src.Flags.Gpu.HiZ);
    dst.Flags.Gpu.Index.setValue(src.Flags.Gpu.Index);
    dst.Flags.Gpu.IndirectClearColor.setValue(src.Flags.Gpu.IndirectClearColor);
    dst.Flags.Gpu.InstructionFlat.setValue(src.Flags.Gpu.InstructionFlat);
    dst.Flags.Gpu.InterlacedScan.setValue(src.Flags.Gpu.InterlacedScan);
    dst.Flags.Gpu.MCS.setValue(src.Flags.Gpu.MCS);
    dst.Flags.Gpu.MMC.setValue(src.Flags.Gpu.MMC);
    dst.Flags.Gpu.MotionComp.setValue(src.Flags.Gpu.MotionComp);
    dst.Flags.Gpu.NoRestriction.setValue(src.Flags.Gpu.NoRestriction);
    dst.Flags.Gpu.Overlay.setValue(src.Flags.Gpu.Overlay);
    dst.Flags.Gpu.Presentable.setValue(src.Flags.Gpu.Presentable);
    dst.Flags.Gpu.ProceduralTexture.setValue(src.Flags.Gpu.ProceduralTexture);
    dst.Flags.Gpu.Query.setValue(src.Flags.Gpu.Query);
    dst.Flags.Gpu.RenderTarget.setValue(src.Flags.Gpu.RenderTarget);
    dst.Flags.Gpu.S3d.setValue(src.Flags.Gpu.S3d);
    dst.Flags.Gpu.S3dDx.setValue(src.Flags.Gpu.S3dDx);
    dst.Flags.Gpu.__S3dNonPacked.setValue(src.Flags.Gpu.__S3dNonPacked);
    dst.Flags.Gpu.__S3dWidi.setValue(src.Flags.Gpu.__S3dWidi);
    dst.Flags.Gpu.ScratchFlat.setValue(src.Flags.Gpu.ScratchFlat);
    dst.Flags.Gpu.SeparateStencil.setValue(src.Flags.Gpu.SeparateStencil);
    dst.Flags.Gpu.State.setValue(src.Flags.Gpu.State);
    dst.Flags.Gpu.StateDx9ConstantBuffer.setValue(src.Flags.Gpu.StateDx9ConstantBuffer);
    dst.Flags.Gpu.Stream.setValue(src.Flags.Gpu.Stream);
    dst.Flags.Gpu.TextApi.setValue(src.Flags.Gpu.TextApi);
    dst.Flags.Gpu.Texture.setValue(src.Flags.Gpu.Texture);
    dst.Flags.Gpu.TiledResource.setValue(src.Flags.Gpu.TiledResource);
    dst.Flags.Gpu.TilePool.setValue(src.Flags.Gpu.TilePool);
    dst.Flags.Gpu.UnifiedAuxSurface.setValue(src.Flags.Gpu.UnifiedAuxSurface);
    dst.Flags.Gpu.Vertex.setValue(src.Flags.Gpu.Vertex);
    dst.Flags.Gpu.Video.setValue(src.Flags.Gpu.Video);
    dst.Flags.Gpu.__NonMsaaTileXCcs.setValue(src.Flags.Gpu.__NonMsaaTileXCcs);
    dst.Flags.Gpu.__NonMsaaTileYCcs.setValue(src.Flags.Gpu.__NonMsaaTileYCcs);
    dst.Flags.Gpu.__MsaaTileMcs.setValue(src.Flags.Gpu.__MsaaTileMcs);
    dst.Flags.Gpu.__NonMsaaLinearCCS.setValue(src.Flags.Gpu.__NonMsaaLinearCCS);
    dst.Flags.Gpu.__Remaining.setValue(src.Flags.Gpu.__Remaining);
    dst.Flags.Info.AllowVirtualPadding.setValue(src.Flags.Info.AllowVirtualPadding);
    dst.Flags.Info.BigPage.setValue(src.Flags.Info.BigPage);
    dst.Flags.Info.Cacheable.setValue(src.Flags.Info.Cacheable);
    dst.Flags.Info.ContigPhysMemoryForiDART.setValue(src.Flags.Info.ContigPhysMemoryForiDART);
    dst.Flags.Info.CornerTexelMode.setValue(src.Flags.Info.CornerTexelMode);
    dst.Flags.Info.ExistingSysMem.setValue(src.Flags.Info.ExistingSysMem);
    dst.Flags.Info.ForceResidency.setValue(src.Flags.Info.ForceResidency);
    dst.Flags.Info.Gfdt.setValue(src.Flags.Info.Gfdt);
    dst.Flags.Info.GttMapType.setValue(src.Flags.Info.GttMapType);
    dst.Flags.Info.HardwareProtected.setValue(src.Flags.Info.HardwareProtected);
    dst.Flags.Info.KernelModeMapped.setValue(src.Flags.Info.KernelModeMapped);
    dst.Flags.Info.LayoutBelow.setValue(src.Flags.Info.LayoutBelow);
    dst.Flags.Info.LayoutMono.setValue(src.Flags.Info.LayoutMono);
    dst.Flags.Info.LayoutRight.setValue(src.Flags.Info.LayoutRight);
    dst.Flags.Info.LocalOnly.setValue(src.Flags.Info.LocalOnly);
    dst.Flags.Info.Linear.setValue(src.Flags.Info.Linear);
    dst.Flags.Info.MediaCompressed.setValue(src.Flags.Info.MediaCompressed);
    dst.Flags.Info.NoOptimizationPadding.setValue(src.Flags.Info.NoOptimizationPadding);
    dst.Flags.Info.NoPhysMemory.setValue(src.Flags.Info.NoPhysMemory);
    dst.Flags.Info.NotLockable.setValue(src.Flags.Info.NotLockable);
    dst.Flags.Info.NonLocalOnly.setValue(src.Flags.Info.NonLocalOnly);
    dst.Flags.Info.StdSwizzle.setValue(src.Flags.Info.StdSwizzle);
    dst.Flags.Info.PseudoStdSwizzle.setValue(src.Flags.Info.PseudoStdSwizzle);
    dst.Flags.Info.Undefined64KBSwizzle.setValue(src.Flags.Info.Undefined64KBSwizzle);
    dst.Flags.Info.RedecribedPlanes.setValue(src.Flags.Info.RedecribedPlanes);
    dst.Flags.Info.RenderCompressed.setValue(src.Flags.Info.RenderCompressed);
    dst.Flags.Info.Rotated.setValue(src.Flags.Info.Rotated);
    dst.Flags.Info.Shared.setValue(src.Flags.Info.Shared);
    dst.Flags.Info.SoftwareProtected.setValue(src.Flags.Info.SoftwareProtected);
    dst.Flags.Info.SVM.setValue(src.Flags.Info.SVM);
    dst.Flags.Info.Tile4.setValue(src.Flags.Info.Tile4);
    dst.Flags.Info.Tile64.setValue(src.Flags.Info.Tile64);
    dst.Flags.Info.TiledW.setValue(src.Flags.Info.TiledW);
    dst.Flags.Info.TiledX.setValue(src.Flags.Info.TiledX);
    dst.Flags.Info.TiledY.setValue(src.Flags.Info.TiledY);
    dst.Flags.Info.TiledYf.setValue(src.Flags.Info.TiledYf);
    dst.Flags.Info.TiledYs.setValue(src.Flags.Info.TiledYs);
    dst.Flags.Info.WddmProtected.setValue(src.Flags.Info.WddmProtected);
    dst.Flags.Info.XAdapter.setValue(src.Flags.Info.XAdapter);
    dst.Flags.Info.__PreallocatedResInfo.setValue(src.Flags.Info.__PreallocatedResInfo);
    dst.Flags.Info.__PreWddm2SVM.setValue(src.Flags.Info.__PreWddm2SVM);
    dst.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign.setValue(src.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign);
    dst.Flags.Wa.ILKNeedAvcMprRowStore32KAlign.setValue(src.Flags.Wa.ILKNeedAvcMprRowStore32KAlign);
    dst.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign.setValue(src.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign);
    dst.Flags.Wa.NoBufferSamplerPadding.setValue(src.Flags.Wa.NoBufferSamplerPadding);
    dst.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions.setValue(src.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions);
    dst.Flags.Wa.CHVAstcSkipVirtualMips.setValue(src.Flags.Wa.CHVAstcSkipVirtualMips);
    dst.Flags.Wa.DisablePackedMipTail.setValue(src.Flags.Wa.DisablePackedMipTail);
    dst.Flags.Wa.__ForceOtherHVALIGN4.setValue(src.Flags.Wa.__ForceOtherHVALIGN4);
    dst.Flags.Wa.DisableDisplayCcsClearColor.setValue(src.Flags.Wa.DisableDisplayCcsClearColor);
    dst.Flags.Wa.DisableDisplayCcsCompression.setValue(src.Flags.Wa.DisableDisplayCcsCompression);
    dst.Flags.Wa.PreGen12FastClearOnly.setValue(src.Flags.Wa.PreGen12FastClearOnly);
    dst.Flags.Wa.ForceStdAllocAlign.setValue(src.Flags.Wa.ForceStdAllocAlign);
    dst.Flags.Wa.DeniableLocalOnlyForCompression.setValue(src.Flags.Wa.DeniableLocalOnlyForCompression);
    dst.BaseWidth.setValue(src.BaseWidth);
    dst.BaseHeight.setValue(src.BaseHeight);
    dst.Depth.setValue(src.Depth);
    dst.MaxLod.setValue(src.MaxLod);
    dst.ArraySize.setValue(src.ArraySize);
    dst.CpTag.setValue(src.CpTag);
    dst.CachePolicy.Usage.setValue(src.CachePolicy.Usage);
    dst.MSAA.SamplePattern.setValue(src.MSAA.SamplePattern);
    dst.MSAA.NumSamples.setValue(src.MSAA.NumSamples);
    dst.Alignment.ArraySpacingSingleLod.setValue(src.Alignment.ArraySpacingSingleLod);
    dst.Alignment.BaseAlignment.setValue(src.Alignment.BaseAlignment);
    dst.Alignment.HAlign.setValue(src.Alignment.HAlign);
    dst.Alignment.VAlign.setValue(src.Alignment.VAlign);
    dst.Alignment.DAlign.setValue(src.Alignment.DAlign);
    dst.Alignment.MipTailStartLod.setValue(src.Alignment.MipTailStartLod);
    dst.Alignment.PackedMipStartLod.setValue(src.Alignment.PackedMipStartLod);
    dst.Alignment.PackedMipWidth.setValue(src.Alignment.PackedMipWidth);
    dst.Alignment.PackedMipHeight.setValue(src.Alignment.PackedMipHeight);
    dst.Alignment.QPitch.setValue(src.Alignment.QPitch);
    WCH_SAFE_COPY(dst.MmcMode.getValue<char>(), dst.MmcMode.getValueSizeInBytes(), src.MmcMode, sizeof(src.MmcMode));
    WCH_SAFE_COPY(dst.MmcHint.getValue<char>(), dst.MmcHint.getValueSizeInBytes(), src.MmcHint, sizeof(src.MmcHint));
    dst.Pitch.setValue(src.Pitch);
    dst.OverridePitch.setValue(src.OverridePitch);
    dst.Size.setValue(src.Size);
    dst.CCSize.setValue(src.CCSize);
    dst.UnpaddedSize.setValue(src.UnpaddedSize);
    dst.SizeReportToOS.setValue(src.SizeReportToOS);
    dst.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch.setValue(src.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch);
    WCH_SAFE_COPY(dst.OffsetInfo.Texture3DOffsetInfo.Offset.getValue<char>(), dst.OffsetInfo.Texture3DOffsetInfo.Offset.getValueSizeInBytes(), src.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(src.OffsetInfo.Texture3DOffsetInfo.Offset));
    dst.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock.setValue(src.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock);
    dst.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender.setValue(src.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender);
    WCH_SAFE_COPY(dst.OffsetInfo.Texture2DOffsetInfo.Offset.getValue<char>(), dst.OffsetInfo.Texture2DOffsetInfo.Offset.getValueSizeInBytes(), src.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(src.OffsetInfo.Texture2DOffsetInfo.Offset));
    dst.OffsetInfo.Plane.ArrayQPitch.setValue(src.OffsetInfo.Plane.ArrayQPitch);
    WCH_SAFE_COPY(dst.OffsetInfo.Plane.X.getValue<char>(), dst.OffsetInfo.Plane.X.getValueSizeInBytes(), src.OffsetInfo.Plane.X, sizeof(src.OffsetInfo.Plane.X));
    WCH_SAFE_COPY(dst.OffsetInfo.Plane.Y.getValue<char>(), dst.OffsetInfo.Plane.Y.getValueSizeInBytes(), src.OffsetInfo.Plane.Y, sizeof(src.OffsetInfo.Plane.Y));
    WCH_SAFE_COPY(dst.OffsetInfo.Plane.UnAligned.Height.getValue<char>(), dst.OffsetInfo.Plane.UnAligned.Height.getValueSizeInBytes(), src.OffsetInfo.Plane.UnAligned.Height, sizeof(src.OffsetInfo.Plane.UnAligned.Height));
    dst.OffsetInfo.Plane.NoOfPlanes.setValue(src.OffsetInfo.Plane.NoOfPlanes);
    dst.OffsetInfo.Plane.IsTileAlignedPlanes.setValue(src.OffsetInfo.Plane.IsTileAlignedPlanes);
    dst.TileMode.setValue(src.TileMode);
    dst.CCSModeAlign.setValue(src.CCSModeAlign);
    dst.LegacyFlags.setValue(src.LegacyFlags);
    dst.S3d.DisplayModeHeight.setValue(src.S3d.DisplayModeHeight);
    dst.S3d.NumBlankActiveLines.setValue(src.S3d.NumBlankActiveLines);
    dst.S3d.RFrameOffset.setValue(src.S3d.RFrameOffset);
    dst.S3d.BlankAreaOffset.setValue(src.S3d.BlankAreaOffset);
    dst.S3d.TallBufferHeight.setValue(src.S3d.TallBufferHeight);
    dst.S3d.TallBufferSize.setValue(src.S3d.TallBufferSize);
    dst.S3d.IsRFrame.setValue(src.S3d.IsRFrame);
    dst.SegmentOverride.Seg1.setValue(src.SegmentOverride.Seg1);
    dst.SegmentOverride.Evict.setValue(src.SegmentOverride.Evict);
    dst.MaximumRenamingListLength.setValue(src.MaximumRenamingListLength);
#if _DEBUG || _RELEASE_INTERNAL
    dst.Platform.eProductFamily.setValue(src.Platform.eProductFamily);
    dst.Platform.ePCHProductFamily.setValue(src.Platform.ePCHProductFamily);
    dst.Platform.eDisplayCoreFamily.setValue(src.Platform.eDisplayCoreFamily);
    dst.Platform.eRenderCoreFamily.setValue(src.Platform.eRenderCoreFamily);
    dst.Platform.ePlatformType.setValue(src.Platform.ePlatformType);
    dst.Platform.usDeviceID.setValue(src.Platform.usDeviceID);
    dst.Platform.usRevId.setValue(src.Platform.usRevId);
    dst.Platform.usDeviceID_PCH.setValue(src.Platform.usDeviceID_PCH);
    dst.Platform.usRevId_PCH.setValue(src.Platform.usRevId_PCH);
    dst.Platform.eGTType.setValue(src.Platform.eGTType);
#endif
    dst.ExistingSysMem.IsGmmAllocated.setValue(src.ExistingSysMem.IsGmmAllocated);
    dst.ExistingSysMem.IsPageAligned.setValue(src.ExistingSysMem.IsPageAligned);
#if !(_DEBUG || _RELEASE_INTERNAL)
    dst.__Platform.eProductFamily.setValue(src.__Platform.eProductFamily);
    dst.__Platform.ePCHProductFamily.setValue(src.__Platform.ePCHProductFamily);
    dst.__Platform.eDisplayCoreFamily.setValue(src.__Platform.eDisplayCoreFamily);
    dst.__Platform.eRenderCoreFamily.setValue(src.__Platform.eRenderCoreFamily);
    dst.__Platform.ePlatformType.setValue(src.__Platform.ePlatformType);
    dst.__Platform.usDeviceID.setValue(src.__Platform.usDeviceID);
    dst.__Platform.usRevId.setValue(src.__Platform.usRevId);
    dst.__Platform.usDeviceID_PCH.setValue(src.__Platform.usDeviceID_PCH);
    dst.__Platform.usRevId_PCH.setValue(src.__Platform.usRevId_PCH);
    dst.__Platform.eGTType.setValue(src.__Platform.eGTType);
#endif
}
template <>
struct Marshaller<TOK_S_GMM_TEXTURE_INFO_REC> {
    template <typename GMM_TEXTURE_INFO_RECT>
    static TOKSTR_GMM_TEXTURE_INFO_REC marshall(const GMM_TEXTURE_INFO_RECT &src) {
        TOKSTR_GMM_TEXTURE_INFO_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GMM_EXISTING_SYS_MEM_RECT>
inline void marshall(TOKSTR_GMM_EXISTING_SYS_MEM_REC &dst, const GMM_EXISTING_SYS_MEM_RECT &src) {
    dst = {};
    dst.pExistingSysMem.setValue(src.pExistingSysMem);
    dst.pVirtAddress.setValue(src.pVirtAddress);
    dst.pGfxAlignedVirtAddress.setValue(src.pGfxAlignedVirtAddress);
    dst.Size.setValue(src.Size);
    dst.IsGmmAllocated.setValue(src.IsGmmAllocated);
}
template <>
struct Marshaller<TOK_S_GMM_EXISTING_SYS_MEM_REC> {
    template <typename GMM_EXISTING_SYS_MEM_RECT>
    static TOKSTR_GMM_EXISTING_SYS_MEM_REC marshall(const GMM_EXISTING_SYS_MEM_RECT &src) {
        TOKSTR_GMM_EXISTING_SYS_MEM_REC ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GmmResourceInfoCommonStructT>
inline void marshall(TOKSTR_GmmResourceInfoCommonStruct &dst, const GmmResourceInfoCommonStructT &src) {
    dst = {};
    dst.ClientType.setValue(src.ClientType);
    dst.Surf.Type.setValue(src.Surf.Type);
    dst.Surf.Format.setValue(src.Surf.Format);
    dst.Surf.BitsPerPixel.setValue(src.Surf.BitsPerPixel);
    dst.Surf.Flags.Gpu.CameraCapture.setValue(src.Surf.Flags.Gpu.CameraCapture);
    dst.Surf.Flags.Gpu.CCS.setValue(src.Surf.Flags.Gpu.CCS);
    dst.Surf.Flags.Gpu.ColorDiscard.setValue(src.Surf.Flags.Gpu.ColorDiscard);
    dst.Surf.Flags.Gpu.ColorSeparation.setValue(src.Surf.Flags.Gpu.ColorSeparation);
    dst.Surf.Flags.Gpu.ColorSeparationRGBX.setValue(src.Surf.Flags.Gpu.ColorSeparationRGBX);
    dst.Surf.Flags.Gpu.Constant.setValue(src.Surf.Flags.Gpu.Constant);
    dst.Surf.Flags.Gpu.Depth.setValue(src.Surf.Flags.Gpu.Depth);
    dst.Surf.Flags.Gpu.FlipChain.setValue(src.Surf.Flags.Gpu.FlipChain);
    dst.Surf.Flags.Gpu.FlipChainPreferred.setValue(src.Surf.Flags.Gpu.FlipChainPreferred);
    dst.Surf.Flags.Gpu.HistoryBuffer.setValue(src.Surf.Flags.Gpu.HistoryBuffer);
    dst.Surf.Flags.Gpu.HiZ.setValue(src.Surf.Flags.Gpu.HiZ);
    dst.Surf.Flags.Gpu.Index.setValue(src.Surf.Flags.Gpu.Index);
    dst.Surf.Flags.Gpu.IndirectClearColor.setValue(src.Surf.Flags.Gpu.IndirectClearColor);
    dst.Surf.Flags.Gpu.InstructionFlat.setValue(src.Surf.Flags.Gpu.InstructionFlat);
    dst.Surf.Flags.Gpu.InterlacedScan.setValue(src.Surf.Flags.Gpu.InterlacedScan);
    dst.Surf.Flags.Gpu.MCS.setValue(src.Surf.Flags.Gpu.MCS);
    dst.Surf.Flags.Gpu.MMC.setValue(src.Surf.Flags.Gpu.MMC);
    dst.Surf.Flags.Gpu.MotionComp.setValue(src.Surf.Flags.Gpu.MotionComp);
    dst.Surf.Flags.Gpu.NoRestriction.setValue(src.Surf.Flags.Gpu.NoRestriction);
    dst.Surf.Flags.Gpu.Overlay.setValue(src.Surf.Flags.Gpu.Overlay);
    dst.Surf.Flags.Gpu.Presentable.setValue(src.Surf.Flags.Gpu.Presentable);
    dst.Surf.Flags.Gpu.ProceduralTexture.setValue(src.Surf.Flags.Gpu.ProceduralTexture);
    dst.Surf.Flags.Gpu.Query.setValue(src.Surf.Flags.Gpu.Query);
    dst.Surf.Flags.Gpu.RenderTarget.setValue(src.Surf.Flags.Gpu.RenderTarget);
    dst.Surf.Flags.Gpu.S3d.setValue(src.Surf.Flags.Gpu.S3d);
    dst.Surf.Flags.Gpu.S3dDx.setValue(src.Surf.Flags.Gpu.S3dDx);
    dst.Surf.Flags.Gpu.__S3dNonPacked.setValue(src.Surf.Flags.Gpu.__S3dNonPacked);
    dst.Surf.Flags.Gpu.__S3dWidi.setValue(src.Surf.Flags.Gpu.__S3dWidi);
    dst.Surf.Flags.Gpu.ScratchFlat.setValue(src.Surf.Flags.Gpu.ScratchFlat);
    dst.Surf.Flags.Gpu.SeparateStencil.setValue(src.Surf.Flags.Gpu.SeparateStencil);
    dst.Surf.Flags.Gpu.State.setValue(src.Surf.Flags.Gpu.State);
    dst.Surf.Flags.Gpu.StateDx9ConstantBuffer.setValue(src.Surf.Flags.Gpu.StateDx9ConstantBuffer);
    dst.Surf.Flags.Gpu.Stream.setValue(src.Surf.Flags.Gpu.Stream);
    dst.Surf.Flags.Gpu.TextApi.setValue(src.Surf.Flags.Gpu.TextApi);
    dst.Surf.Flags.Gpu.Texture.setValue(src.Surf.Flags.Gpu.Texture);
    dst.Surf.Flags.Gpu.TiledResource.setValue(src.Surf.Flags.Gpu.TiledResource);
    dst.Surf.Flags.Gpu.TilePool.setValue(src.Surf.Flags.Gpu.TilePool);
    dst.Surf.Flags.Gpu.UnifiedAuxSurface.setValue(src.Surf.Flags.Gpu.UnifiedAuxSurface);
    dst.Surf.Flags.Gpu.Vertex.setValue(src.Surf.Flags.Gpu.Vertex);
    dst.Surf.Flags.Gpu.Video.setValue(src.Surf.Flags.Gpu.Video);
    dst.Surf.Flags.Gpu.__NonMsaaTileXCcs.setValue(src.Surf.Flags.Gpu.__NonMsaaTileXCcs);
    dst.Surf.Flags.Gpu.__NonMsaaTileYCcs.setValue(src.Surf.Flags.Gpu.__NonMsaaTileYCcs);
    dst.Surf.Flags.Gpu.__MsaaTileMcs.setValue(src.Surf.Flags.Gpu.__MsaaTileMcs);
    dst.Surf.Flags.Gpu.__NonMsaaLinearCCS.setValue(src.Surf.Flags.Gpu.__NonMsaaLinearCCS);
    dst.Surf.Flags.Gpu.__Remaining.setValue(src.Surf.Flags.Gpu.__Remaining);
    dst.Surf.Flags.Info.AllowVirtualPadding.setValue(src.Surf.Flags.Info.AllowVirtualPadding);
    dst.Surf.Flags.Info.BigPage.setValue(src.Surf.Flags.Info.BigPage);
    dst.Surf.Flags.Info.Cacheable.setValue(src.Surf.Flags.Info.Cacheable);
    dst.Surf.Flags.Info.ContigPhysMemoryForiDART.setValue(src.Surf.Flags.Info.ContigPhysMemoryForiDART);
    dst.Surf.Flags.Info.CornerTexelMode.setValue(src.Surf.Flags.Info.CornerTexelMode);
    dst.Surf.Flags.Info.ExistingSysMem.setValue(src.Surf.Flags.Info.ExistingSysMem);
    dst.Surf.Flags.Info.ForceResidency.setValue(src.Surf.Flags.Info.ForceResidency);
    dst.Surf.Flags.Info.Gfdt.setValue(src.Surf.Flags.Info.Gfdt);
    dst.Surf.Flags.Info.GttMapType.setValue(src.Surf.Flags.Info.GttMapType);
    dst.Surf.Flags.Info.HardwareProtected.setValue(src.Surf.Flags.Info.HardwareProtected);
    dst.Surf.Flags.Info.KernelModeMapped.setValue(src.Surf.Flags.Info.KernelModeMapped);
    dst.Surf.Flags.Info.LayoutBelow.setValue(src.Surf.Flags.Info.LayoutBelow);
    dst.Surf.Flags.Info.LayoutMono.setValue(src.Surf.Flags.Info.LayoutMono);
    dst.Surf.Flags.Info.LayoutRight.setValue(src.Surf.Flags.Info.LayoutRight);
    dst.Surf.Flags.Info.LocalOnly.setValue(src.Surf.Flags.Info.LocalOnly);
    dst.Surf.Flags.Info.Linear.setValue(src.Surf.Flags.Info.Linear);
    dst.Surf.Flags.Info.MediaCompressed.setValue(src.Surf.Flags.Info.MediaCompressed);
    dst.Surf.Flags.Info.NoOptimizationPadding.setValue(src.Surf.Flags.Info.NoOptimizationPadding);
    dst.Surf.Flags.Info.NoPhysMemory.setValue(src.Surf.Flags.Info.NoPhysMemory);
    dst.Surf.Flags.Info.NotLockable.setValue(src.Surf.Flags.Info.NotLockable);
    dst.Surf.Flags.Info.NonLocalOnly.setValue(src.Surf.Flags.Info.NonLocalOnly);
    dst.Surf.Flags.Info.StdSwizzle.setValue(src.Surf.Flags.Info.StdSwizzle);
    dst.Surf.Flags.Info.PseudoStdSwizzle.setValue(src.Surf.Flags.Info.PseudoStdSwizzle);
    dst.Surf.Flags.Info.Undefined64KBSwizzle.setValue(src.Surf.Flags.Info.Undefined64KBSwizzle);
    dst.Surf.Flags.Info.RedecribedPlanes.setValue(src.Surf.Flags.Info.RedecribedPlanes);
    dst.Surf.Flags.Info.RenderCompressed.setValue(src.Surf.Flags.Info.RenderCompressed);
    dst.Surf.Flags.Info.Rotated.setValue(src.Surf.Flags.Info.Rotated);
    dst.Surf.Flags.Info.Shared.setValue(src.Surf.Flags.Info.Shared);
    dst.Surf.Flags.Info.SoftwareProtected.setValue(src.Surf.Flags.Info.SoftwareProtected);
    dst.Surf.Flags.Info.SVM.setValue(src.Surf.Flags.Info.SVM);
    dst.Surf.Flags.Info.Tile4.setValue(src.Surf.Flags.Info.Tile4);
    dst.Surf.Flags.Info.Tile64.setValue(src.Surf.Flags.Info.Tile64);
    dst.Surf.Flags.Info.TiledW.setValue(src.Surf.Flags.Info.TiledW);
    dst.Surf.Flags.Info.TiledX.setValue(src.Surf.Flags.Info.TiledX);
    dst.Surf.Flags.Info.TiledY.setValue(src.Surf.Flags.Info.TiledY);
    dst.Surf.Flags.Info.TiledYf.setValue(src.Surf.Flags.Info.TiledYf);
    dst.Surf.Flags.Info.TiledYs.setValue(src.Surf.Flags.Info.TiledYs);
    dst.Surf.Flags.Info.WddmProtected.setValue(src.Surf.Flags.Info.WddmProtected);
    dst.Surf.Flags.Info.XAdapter.setValue(src.Surf.Flags.Info.XAdapter);
    dst.Surf.Flags.Info.__PreallocatedResInfo.setValue(src.Surf.Flags.Info.__PreallocatedResInfo);
    dst.Surf.Flags.Info.__PreWddm2SVM.setValue(src.Surf.Flags.Info.__PreWddm2SVM);
    dst.Surf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign.setValue(src.Surf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign);
    dst.Surf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign.setValue(src.Surf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign);
    dst.Surf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign.setValue(src.Surf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign);
    dst.Surf.Flags.Wa.NoBufferSamplerPadding.setValue(src.Surf.Flags.Wa.NoBufferSamplerPadding);
    dst.Surf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions.setValue(src.Surf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions);
    dst.Surf.Flags.Wa.CHVAstcSkipVirtualMips.setValue(src.Surf.Flags.Wa.CHVAstcSkipVirtualMips);
    dst.Surf.Flags.Wa.DisablePackedMipTail.setValue(src.Surf.Flags.Wa.DisablePackedMipTail);
    dst.Surf.Flags.Wa.__ForceOtherHVALIGN4.setValue(src.Surf.Flags.Wa.__ForceOtherHVALIGN4);
    dst.Surf.Flags.Wa.DisableDisplayCcsClearColor.setValue(src.Surf.Flags.Wa.DisableDisplayCcsClearColor);
    dst.Surf.Flags.Wa.DisableDisplayCcsCompression.setValue(src.Surf.Flags.Wa.DisableDisplayCcsCompression);
    dst.Surf.Flags.Wa.PreGen12FastClearOnly.setValue(src.Surf.Flags.Wa.PreGen12FastClearOnly);
    dst.Surf.Flags.Wa.ForceStdAllocAlign.setValue(src.Surf.Flags.Wa.ForceStdAllocAlign);
    dst.Surf.Flags.Wa.DeniableLocalOnlyForCompression.setValue(src.Surf.Flags.Wa.DeniableLocalOnlyForCompression);
    dst.Surf.BaseWidth.setValue(src.Surf.BaseWidth);
    dst.Surf.BaseHeight.setValue(src.Surf.BaseHeight);
    dst.Surf.Depth.setValue(src.Surf.Depth);
    dst.Surf.MaxLod.setValue(src.Surf.MaxLod);
    dst.Surf.ArraySize.setValue(src.Surf.ArraySize);
    dst.Surf.CpTag.setValue(src.Surf.CpTag);
    dst.Surf.CachePolicy.Usage.setValue(src.Surf.CachePolicy.Usage);
    dst.Surf.MSAA.SamplePattern.setValue(src.Surf.MSAA.SamplePattern);
    dst.Surf.MSAA.NumSamples.setValue(src.Surf.MSAA.NumSamples);
    dst.Surf.Alignment.ArraySpacingSingleLod.setValue(src.Surf.Alignment.ArraySpacingSingleLod);
    dst.Surf.Alignment.BaseAlignment.setValue(src.Surf.Alignment.BaseAlignment);
    dst.Surf.Alignment.HAlign.setValue(src.Surf.Alignment.HAlign);
    dst.Surf.Alignment.VAlign.setValue(src.Surf.Alignment.VAlign);
    dst.Surf.Alignment.DAlign.setValue(src.Surf.Alignment.DAlign);
    dst.Surf.Alignment.MipTailStartLod.setValue(src.Surf.Alignment.MipTailStartLod);
    dst.Surf.Alignment.PackedMipStartLod.setValue(src.Surf.Alignment.PackedMipStartLod);
    dst.Surf.Alignment.PackedMipWidth.setValue(src.Surf.Alignment.PackedMipWidth);
    dst.Surf.Alignment.PackedMipHeight.setValue(src.Surf.Alignment.PackedMipHeight);
    dst.Surf.Alignment.QPitch.setValue(src.Surf.Alignment.QPitch);
    WCH_SAFE_COPY(dst.Surf.MmcMode.getValue<char>(), dst.Surf.MmcMode.getValueSizeInBytes(), src.Surf.MmcMode, sizeof(src.Surf.MmcMode));
    WCH_SAFE_COPY(dst.Surf.MmcHint.getValue<char>(), dst.Surf.MmcHint.getValueSizeInBytes(), src.Surf.MmcHint, sizeof(src.Surf.MmcHint));
    dst.Surf.Pitch.setValue(src.Surf.Pitch);
    dst.Surf.OverridePitch.setValue(src.Surf.OverridePitch);
    dst.Surf.Size.setValue(src.Surf.Size);
    dst.Surf.CCSize.setValue(src.Surf.CCSize);
    dst.Surf.UnpaddedSize.setValue(src.Surf.UnpaddedSize);
    dst.Surf.SizeReportToOS.setValue(src.Surf.SizeReportToOS);
    dst.Surf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch.setValue(src.Surf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch);
    WCH_SAFE_COPY(dst.Surf.OffsetInfo.Texture3DOffsetInfo.Offset.getValue<char>(), dst.Surf.OffsetInfo.Texture3DOffsetInfo.Offset.getValueSizeInBytes(), src.Surf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(src.Surf.OffsetInfo.Texture3DOffsetInfo.Offset));
    dst.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock.setValue(src.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock);
    dst.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender.setValue(src.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender);
    WCH_SAFE_COPY(dst.Surf.OffsetInfo.Texture2DOffsetInfo.Offset.getValue<char>(), dst.Surf.OffsetInfo.Texture2DOffsetInfo.Offset.getValueSizeInBytes(), src.Surf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(src.Surf.OffsetInfo.Texture2DOffsetInfo.Offset));
    dst.Surf.OffsetInfo.Plane.ArrayQPitch.setValue(src.Surf.OffsetInfo.Plane.ArrayQPitch);
    WCH_SAFE_COPY(dst.Surf.OffsetInfo.Plane.X.getValue<char>(), dst.Surf.OffsetInfo.Plane.X.getValueSizeInBytes(), src.Surf.OffsetInfo.Plane.X, sizeof(src.Surf.OffsetInfo.Plane.X));
    WCH_SAFE_COPY(dst.Surf.OffsetInfo.Plane.Y.getValue<char>(), dst.Surf.OffsetInfo.Plane.Y.getValueSizeInBytes(), src.Surf.OffsetInfo.Plane.Y, sizeof(src.Surf.OffsetInfo.Plane.Y));
    WCH_SAFE_COPY(dst.Surf.OffsetInfo.Plane.UnAligned.Height.getValue<char>(), dst.Surf.OffsetInfo.Plane.UnAligned.Height.getValueSizeInBytes(), src.Surf.OffsetInfo.Plane.UnAligned.Height, sizeof(src.Surf.OffsetInfo.Plane.UnAligned.Height));
    dst.Surf.OffsetInfo.Plane.NoOfPlanes.setValue(src.Surf.OffsetInfo.Plane.NoOfPlanes);
    dst.Surf.OffsetInfo.Plane.IsTileAlignedPlanes.setValue(src.Surf.OffsetInfo.Plane.IsTileAlignedPlanes);
    dst.Surf.TileMode.setValue(src.Surf.TileMode);
    dst.Surf.CCSModeAlign.setValue(src.Surf.CCSModeAlign);
    dst.Surf.LegacyFlags.setValue(src.Surf.LegacyFlags);
    dst.Surf.S3d.DisplayModeHeight.setValue(src.Surf.S3d.DisplayModeHeight);
    dst.Surf.S3d.NumBlankActiveLines.setValue(src.Surf.S3d.NumBlankActiveLines);
    dst.Surf.S3d.RFrameOffset.setValue(src.Surf.S3d.RFrameOffset);
    dst.Surf.S3d.BlankAreaOffset.setValue(src.Surf.S3d.BlankAreaOffset);
    dst.Surf.S3d.TallBufferHeight.setValue(src.Surf.S3d.TallBufferHeight);
    dst.Surf.S3d.TallBufferSize.setValue(src.Surf.S3d.TallBufferSize);
    dst.Surf.S3d.IsRFrame.setValue(src.Surf.S3d.IsRFrame);
    dst.Surf.SegmentOverride.Seg1.setValue(src.Surf.SegmentOverride.Seg1);
    dst.Surf.SegmentOverride.Evict.setValue(src.Surf.SegmentOverride.Evict);
    dst.Surf.MaximumRenamingListLength.setValue(src.Surf.MaximumRenamingListLength);
#if _DEBUG || _RELEASE_INTERNAL
    dst.Surf.Platform.eProductFamily.setValue(src.Surf.Platform.eProductFamily);
    dst.Surf.Platform.ePCHProductFamily.setValue(src.Surf.Platform.ePCHProductFamily);
    dst.Surf.Platform.eDisplayCoreFamily.setValue(src.Surf.Platform.eDisplayCoreFamily);
    dst.Surf.Platform.eRenderCoreFamily.setValue(src.Surf.Platform.eRenderCoreFamily);
    dst.Surf.Platform.ePlatformType.setValue(src.Surf.Platform.ePlatformType);
    dst.Surf.Platform.usDeviceID.setValue(src.Surf.Platform.usDeviceID);
    dst.Surf.Platform.usRevId.setValue(src.Surf.Platform.usRevId);
    dst.Surf.Platform.usDeviceID_PCH.setValue(src.Surf.Platform.usDeviceID_PCH);
    dst.Surf.Platform.usRevId_PCH.setValue(src.Surf.Platform.usRevId_PCH);
    dst.Surf.Platform.eGTType.setValue(src.Surf.Platform.eGTType);
#endif
    dst.Surf.ExistingSysMem.IsGmmAllocated.setValue(src.Surf.ExistingSysMem.IsGmmAllocated);
    dst.Surf.ExistingSysMem.IsPageAligned.setValue(src.Surf.ExistingSysMem.IsPageAligned);
#if !(_DEBUG || _RELEASE_INTERNAL)
    dst.Surf.__Platform.eProductFamily.setValue(src.Surf.__Platform.eProductFamily);
    dst.Surf.__Platform.ePCHProductFamily.setValue(src.Surf.__Platform.ePCHProductFamily);
    dst.Surf.__Platform.eDisplayCoreFamily.setValue(src.Surf.__Platform.eDisplayCoreFamily);
    dst.Surf.__Platform.eRenderCoreFamily.setValue(src.Surf.__Platform.eRenderCoreFamily);
    dst.Surf.__Platform.ePlatformType.setValue(src.Surf.__Platform.ePlatformType);
    dst.Surf.__Platform.usDeviceID.setValue(src.Surf.__Platform.usDeviceID);
    dst.Surf.__Platform.usRevId.setValue(src.Surf.__Platform.usRevId);
    dst.Surf.__Platform.usDeviceID_PCH.setValue(src.Surf.__Platform.usDeviceID_PCH);
    dst.Surf.__Platform.usRevId_PCH.setValue(src.Surf.__Platform.usRevId_PCH);
    dst.Surf.__Platform.eGTType.setValue(src.Surf.__Platform.eGTType);
#endif
    dst.AuxSurf.Type.setValue(src.AuxSurf.Type);
    dst.AuxSurf.Format.setValue(src.AuxSurf.Format);
    dst.AuxSurf.BitsPerPixel.setValue(src.AuxSurf.BitsPerPixel);
    dst.AuxSurf.Flags.Gpu.CameraCapture.setValue(src.AuxSurf.Flags.Gpu.CameraCapture);
    dst.AuxSurf.Flags.Gpu.CCS.setValue(src.AuxSurf.Flags.Gpu.CCS);
    dst.AuxSurf.Flags.Gpu.ColorDiscard.setValue(src.AuxSurf.Flags.Gpu.ColorDiscard);
    dst.AuxSurf.Flags.Gpu.ColorSeparation.setValue(src.AuxSurf.Flags.Gpu.ColorSeparation);
    dst.AuxSurf.Flags.Gpu.ColorSeparationRGBX.setValue(src.AuxSurf.Flags.Gpu.ColorSeparationRGBX);
    dst.AuxSurf.Flags.Gpu.Constant.setValue(src.AuxSurf.Flags.Gpu.Constant);
    dst.AuxSurf.Flags.Gpu.Depth.setValue(src.AuxSurf.Flags.Gpu.Depth);
    dst.AuxSurf.Flags.Gpu.FlipChain.setValue(src.AuxSurf.Flags.Gpu.FlipChain);
    dst.AuxSurf.Flags.Gpu.FlipChainPreferred.setValue(src.AuxSurf.Flags.Gpu.FlipChainPreferred);
    dst.AuxSurf.Flags.Gpu.HistoryBuffer.setValue(src.AuxSurf.Flags.Gpu.HistoryBuffer);
    dst.AuxSurf.Flags.Gpu.HiZ.setValue(src.AuxSurf.Flags.Gpu.HiZ);
    dst.AuxSurf.Flags.Gpu.Index.setValue(src.AuxSurf.Flags.Gpu.Index);
    dst.AuxSurf.Flags.Gpu.IndirectClearColor.setValue(src.AuxSurf.Flags.Gpu.IndirectClearColor);
    dst.AuxSurf.Flags.Gpu.InstructionFlat.setValue(src.AuxSurf.Flags.Gpu.InstructionFlat);
    dst.AuxSurf.Flags.Gpu.InterlacedScan.setValue(src.AuxSurf.Flags.Gpu.InterlacedScan);
    dst.AuxSurf.Flags.Gpu.MCS.setValue(src.AuxSurf.Flags.Gpu.MCS);
    dst.AuxSurf.Flags.Gpu.MMC.setValue(src.AuxSurf.Flags.Gpu.MMC);
    dst.AuxSurf.Flags.Gpu.MotionComp.setValue(src.AuxSurf.Flags.Gpu.MotionComp);
    dst.AuxSurf.Flags.Gpu.NoRestriction.setValue(src.AuxSurf.Flags.Gpu.NoRestriction);
    dst.AuxSurf.Flags.Gpu.Overlay.setValue(src.AuxSurf.Flags.Gpu.Overlay);
    dst.AuxSurf.Flags.Gpu.Presentable.setValue(src.AuxSurf.Flags.Gpu.Presentable);
    dst.AuxSurf.Flags.Gpu.ProceduralTexture.setValue(src.AuxSurf.Flags.Gpu.ProceduralTexture);
    dst.AuxSurf.Flags.Gpu.Query.setValue(src.AuxSurf.Flags.Gpu.Query);
    dst.AuxSurf.Flags.Gpu.RenderTarget.setValue(src.AuxSurf.Flags.Gpu.RenderTarget);
    dst.AuxSurf.Flags.Gpu.S3d.setValue(src.AuxSurf.Flags.Gpu.S3d);
    dst.AuxSurf.Flags.Gpu.S3dDx.setValue(src.AuxSurf.Flags.Gpu.S3dDx);
    dst.AuxSurf.Flags.Gpu.__S3dNonPacked.setValue(src.AuxSurf.Flags.Gpu.__S3dNonPacked);
    dst.AuxSurf.Flags.Gpu.__S3dWidi.setValue(src.AuxSurf.Flags.Gpu.__S3dWidi);
    dst.AuxSurf.Flags.Gpu.ScratchFlat.setValue(src.AuxSurf.Flags.Gpu.ScratchFlat);
    dst.AuxSurf.Flags.Gpu.SeparateStencil.setValue(src.AuxSurf.Flags.Gpu.SeparateStencil);
    dst.AuxSurf.Flags.Gpu.State.setValue(src.AuxSurf.Flags.Gpu.State);
    dst.AuxSurf.Flags.Gpu.StateDx9ConstantBuffer.setValue(src.AuxSurf.Flags.Gpu.StateDx9ConstantBuffer);
    dst.AuxSurf.Flags.Gpu.Stream.setValue(src.AuxSurf.Flags.Gpu.Stream);
    dst.AuxSurf.Flags.Gpu.TextApi.setValue(src.AuxSurf.Flags.Gpu.TextApi);
    dst.AuxSurf.Flags.Gpu.Texture.setValue(src.AuxSurf.Flags.Gpu.Texture);
    dst.AuxSurf.Flags.Gpu.TiledResource.setValue(src.AuxSurf.Flags.Gpu.TiledResource);
    dst.AuxSurf.Flags.Gpu.TilePool.setValue(src.AuxSurf.Flags.Gpu.TilePool);
    dst.AuxSurf.Flags.Gpu.UnifiedAuxSurface.setValue(src.AuxSurf.Flags.Gpu.UnifiedAuxSurface);
    dst.AuxSurf.Flags.Gpu.Vertex.setValue(src.AuxSurf.Flags.Gpu.Vertex);
    dst.AuxSurf.Flags.Gpu.Video.setValue(src.AuxSurf.Flags.Gpu.Video);
    dst.AuxSurf.Flags.Gpu.__NonMsaaTileXCcs.setValue(src.AuxSurf.Flags.Gpu.__NonMsaaTileXCcs);
    dst.AuxSurf.Flags.Gpu.__NonMsaaTileYCcs.setValue(src.AuxSurf.Flags.Gpu.__NonMsaaTileYCcs);
    dst.AuxSurf.Flags.Gpu.__MsaaTileMcs.setValue(src.AuxSurf.Flags.Gpu.__MsaaTileMcs);
    dst.AuxSurf.Flags.Gpu.__NonMsaaLinearCCS.setValue(src.AuxSurf.Flags.Gpu.__NonMsaaLinearCCS);
    dst.AuxSurf.Flags.Gpu.__Remaining.setValue(src.AuxSurf.Flags.Gpu.__Remaining);
    dst.AuxSurf.Flags.Info.AllowVirtualPadding.setValue(src.AuxSurf.Flags.Info.AllowVirtualPadding);
    dst.AuxSurf.Flags.Info.BigPage.setValue(src.AuxSurf.Flags.Info.BigPage);
    dst.AuxSurf.Flags.Info.Cacheable.setValue(src.AuxSurf.Flags.Info.Cacheable);
    dst.AuxSurf.Flags.Info.ContigPhysMemoryForiDART.setValue(src.AuxSurf.Flags.Info.ContigPhysMemoryForiDART);
    dst.AuxSurf.Flags.Info.CornerTexelMode.setValue(src.AuxSurf.Flags.Info.CornerTexelMode);
    dst.AuxSurf.Flags.Info.ExistingSysMem.setValue(src.AuxSurf.Flags.Info.ExistingSysMem);
    dst.AuxSurf.Flags.Info.ForceResidency.setValue(src.AuxSurf.Flags.Info.ForceResidency);
    dst.AuxSurf.Flags.Info.Gfdt.setValue(src.AuxSurf.Flags.Info.Gfdt);
    dst.AuxSurf.Flags.Info.GttMapType.setValue(src.AuxSurf.Flags.Info.GttMapType);
    dst.AuxSurf.Flags.Info.HardwareProtected.setValue(src.AuxSurf.Flags.Info.HardwareProtected);
    dst.AuxSurf.Flags.Info.KernelModeMapped.setValue(src.AuxSurf.Flags.Info.KernelModeMapped);
    dst.AuxSurf.Flags.Info.LayoutBelow.setValue(src.AuxSurf.Flags.Info.LayoutBelow);
    dst.AuxSurf.Flags.Info.LayoutMono.setValue(src.AuxSurf.Flags.Info.LayoutMono);
    dst.AuxSurf.Flags.Info.LayoutRight.setValue(src.AuxSurf.Flags.Info.LayoutRight);
    dst.AuxSurf.Flags.Info.LocalOnly.setValue(src.AuxSurf.Flags.Info.LocalOnly);
    dst.AuxSurf.Flags.Info.Linear.setValue(src.AuxSurf.Flags.Info.Linear);
    dst.AuxSurf.Flags.Info.MediaCompressed.setValue(src.AuxSurf.Flags.Info.MediaCompressed);
    dst.AuxSurf.Flags.Info.NoOptimizationPadding.setValue(src.AuxSurf.Flags.Info.NoOptimizationPadding);
    dst.AuxSurf.Flags.Info.NoPhysMemory.setValue(src.AuxSurf.Flags.Info.NoPhysMemory);
    dst.AuxSurf.Flags.Info.NotLockable.setValue(src.AuxSurf.Flags.Info.NotLockable);
    dst.AuxSurf.Flags.Info.NonLocalOnly.setValue(src.AuxSurf.Flags.Info.NonLocalOnly);
    dst.AuxSurf.Flags.Info.StdSwizzle.setValue(src.AuxSurf.Flags.Info.StdSwizzle);
    dst.AuxSurf.Flags.Info.PseudoStdSwizzle.setValue(src.AuxSurf.Flags.Info.PseudoStdSwizzle);
    dst.AuxSurf.Flags.Info.Undefined64KBSwizzle.setValue(src.AuxSurf.Flags.Info.Undefined64KBSwizzle);
    dst.AuxSurf.Flags.Info.RedecribedPlanes.setValue(src.AuxSurf.Flags.Info.RedecribedPlanes);
    dst.AuxSurf.Flags.Info.RenderCompressed.setValue(src.AuxSurf.Flags.Info.RenderCompressed);
    dst.AuxSurf.Flags.Info.Rotated.setValue(src.AuxSurf.Flags.Info.Rotated);
    dst.AuxSurf.Flags.Info.Shared.setValue(src.AuxSurf.Flags.Info.Shared);
    dst.AuxSurf.Flags.Info.SoftwareProtected.setValue(src.AuxSurf.Flags.Info.SoftwareProtected);
    dst.AuxSurf.Flags.Info.SVM.setValue(src.AuxSurf.Flags.Info.SVM);
    dst.AuxSurf.Flags.Info.Tile4.setValue(src.AuxSurf.Flags.Info.Tile4);
    dst.AuxSurf.Flags.Info.Tile64.setValue(src.AuxSurf.Flags.Info.Tile64);
    dst.AuxSurf.Flags.Info.TiledW.setValue(src.AuxSurf.Flags.Info.TiledW);
    dst.AuxSurf.Flags.Info.TiledX.setValue(src.AuxSurf.Flags.Info.TiledX);
    dst.AuxSurf.Flags.Info.TiledY.setValue(src.AuxSurf.Flags.Info.TiledY);
    dst.AuxSurf.Flags.Info.TiledYf.setValue(src.AuxSurf.Flags.Info.TiledYf);
    dst.AuxSurf.Flags.Info.TiledYs.setValue(src.AuxSurf.Flags.Info.TiledYs);
    dst.AuxSurf.Flags.Info.WddmProtected.setValue(src.AuxSurf.Flags.Info.WddmProtected);
    dst.AuxSurf.Flags.Info.XAdapter.setValue(src.AuxSurf.Flags.Info.XAdapter);
    dst.AuxSurf.Flags.Info.__PreallocatedResInfo.setValue(src.AuxSurf.Flags.Info.__PreallocatedResInfo);
    dst.AuxSurf.Flags.Info.__PreWddm2SVM.setValue(src.AuxSurf.Flags.Info.__PreWddm2SVM);
    dst.AuxSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign.setValue(src.AuxSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign);
    dst.AuxSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign.setValue(src.AuxSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign);
    dst.AuxSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign.setValue(src.AuxSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign);
    dst.AuxSurf.Flags.Wa.NoBufferSamplerPadding.setValue(src.AuxSurf.Flags.Wa.NoBufferSamplerPadding);
    dst.AuxSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions.setValue(src.AuxSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions);
    dst.AuxSurf.Flags.Wa.CHVAstcSkipVirtualMips.setValue(src.AuxSurf.Flags.Wa.CHVAstcSkipVirtualMips);
    dst.AuxSurf.Flags.Wa.DisablePackedMipTail.setValue(src.AuxSurf.Flags.Wa.DisablePackedMipTail);
    dst.AuxSurf.Flags.Wa.__ForceOtherHVALIGN4.setValue(src.AuxSurf.Flags.Wa.__ForceOtherHVALIGN4);
    dst.AuxSurf.Flags.Wa.DisableDisplayCcsClearColor.setValue(src.AuxSurf.Flags.Wa.DisableDisplayCcsClearColor);
    dst.AuxSurf.Flags.Wa.DisableDisplayCcsCompression.setValue(src.AuxSurf.Flags.Wa.DisableDisplayCcsCompression);
    dst.AuxSurf.Flags.Wa.PreGen12FastClearOnly.setValue(src.AuxSurf.Flags.Wa.PreGen12FastClearOnly);
    dst.AuxSurf.Flags.Wa.ForceStdAllocAlign.setValue(src.AuxSurf.Flags.Wa.ForceStdAllocAlign);
    dst.AuxSurf.Flags.Wa.DeniableLocalOnlyForCompression.setValue(src.AuxSurf.Flags.Wa.DeniableLocalOnlyForCompression);
    dst.AuxSurf.BaseWidth.setValue(src.AuxSurf.BaseWidth);
    dst.AuxSurf.BaseHeight.setValue(src.AuxSurf.BaseHeight);
    dst.AuxSurf.Depth.setValue(src.AuxSurf.Depth);
    dst.AuxSurf.MaxLod.setValue(src.AuxSurf.MaxLod);
    dst.AuxSurf.ArraySize.setValue(src.AuxSurf.ArraySize);
    dst.AuxSurf.CpTag.setValue(src.AuxSurf.CpTag);
    dst.AuxSurf.CachePolicy.Usage.setValue(src.AuxSurf.CachePolicy.Usage);
    dst.AuxSurf.MSAA.SamplePattern.setValue(src.AuxSurf.MSAA.SamplePattern);
    dst.AuxSurf.MSAA.NumSamples.setValue(src.AuxSurf.MSAA.NumSamples);
    dst.AuxSurf.Alignment.ArraySpacingSingleLod.setValue(src.AuxSurf.Alignment.ArraySpacingSingleLod);
    dst.AuxSurf.Alignment.BaseAlignment.setValue(src.AuxSurf.Alignment.BaseAlignment);
    dst.AuxSurf.Alignment.HAlign.setValue(src.AuxSurf.Alignment.HAlign);
    dst.AuxSurf.Alignment.VAlign.setValue(src.AuxSurf.Alignment.VAlign);
    dst.AuxSurf.Alignment.DAlign.setValue(src.AuxSurf.Alignment.DAlign);
    dst.AuxSurf.Alignment.MipTailStartLod.setValue(src.AuxSurf.Alignment.MipTailStartLod);
    dst.AuxSurf.Alignment.PackedMipStartLod.setValue(src.AuxSurf.Alignment.PackedMipStartLod);
    dst.AuxSurf.Alignment.PackedMipWidth.setValue(src.AuxSurf.Alignment.PackedMipWidth);
    dst.AuxSurf.Alignment.PackedMipHeight.setValue(src.AuxSurf.Alignment.PackedMipHeight);
    dst.AuxSurf.Alignment.QPitch.setValue(src.AuxSurf.Alignment.QPitch);
    WCH_SAFE_COPY(dst.AuxSurf.MmcMode.getValue<char>(), dst.AuxSurf.MmcMode.getValueSizeInBytes(), src.AuxSurf.MmcMode, sizeof(src.AuxSurf.MmcMode));
    WCH_SAFE_COPY(dst.AuxSurf.MmcHint.getValue<char>(), dst.AuxSurf.MmcHint.getValueSizeInBytes(), src.AuxSurf.MmcHint, sizeof(src.AuxSurf.MmcHint));
    dst.AuxSurf.Pitch.setValue(src.AuxSurf.Pitch);
    dst.AuxSurf.OverridePitch.setValue(src.AuxSurf.OverridePitch);
    dst.AuxSurf.Size.setValue(src.AuxSurf.Size);
    dst.AuxSurf.CCSize.setValue(src.AuxSurf.CCSize);
    dst.AuxSurf.UnpaddedSize.setValue(src.AuxSurf.UnpaddedSize);
    dst.AuxSurf.SizeReportToOS.setValue(src.AuxSurf.SizeReportToOS);
    dst.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch.setValue(src.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch);
    WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset.getValue<char>(), dst.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset.getValueSizeInBytes(), src.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(src.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset));
    dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock.setValue(src.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock);
    dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender.setValue(src.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender);
    WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset.getValue<char>(), dst.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset.getValueSizeInBytes(), src.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(src.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset));
    dst.AuxSurf.OffsetInfo.Plane.ArrayQPitch.setValue(src.AuxSurf.OffsetInfo.Plane.ArrayQPitch);
    WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Plane.X.getValue<char>(), dst.AuxSurf.OffsetInfo.Plane.X.getValueSizeInBytes(), src.AuxSurf.OffsetInfo.Plane.X, sizeof(src.AuxSurf.OffsetInfo.Plane.X));
    WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Plane.Y.getValue<char>(), dst.AuxSurf.OffsetInfo.Plane.Y.getValueSizeInBytes(), src.AuxSurf.OffsetInfo.Plane.Y, sizeof(src.AuxSurf.OffsetInfo.Plane.Y));
    WCH_SAFE_COPY(dst.AuxSurf.OffsetInfo.Plane.UnAligned.Height.getValue<char>(), dst.AuxSurf.OffsetInfo.Plane.UnAligned.Height.getValueSizeInBytes(), src.AuxSurf.OffsetInfo.Plane.UnAligned.Height, sizeof(src.AuxSurf.OffsetInfo.Plane.UnAligned.Height));
    dst.AuxSurf.OffsetInfo.Plane.NoOfPlanes.setValue(src.AuxSurf.OffsetInfo.Plane.NoOfPlanes);
    dst.AuxSurf.OffsetInfo.Plane.IsTileAlignedPlanes.setValue(src.AuxSurf.OffsetInfo.Plane.IsTileAlignedPlanes);
    dst.AuxSurf.TileMode.setValue(src.AuxSurf.TileMode);
    dst.AuxSurf.CCSModeAlign.setValue(src.AuxSurf.CCSModeAlign);
    dst.AuxSurf.LegacyFlags.setValue(src.AuxSurf.LegacyFlags);
    dst.AuxSurf.S3d.DisplayModeHeight.setValue(src.AuxSurf.S3d.DisplayModeHeight);
    dst.AuxSurf.S3d.NumBlankActiveLines.setValue(src.AuxSurf.S3d.NumBlankActiveLines);
    dst.AuxSurf.S3d.RFrameOffset.setValue(src.AuxSurf.S3d.RFrameOffset);
    dst.AuxSurf.S3d.BlankAreaOffset.setValue(src.AuxSurf.S3d.BlankAreaOffset);
    dst.AuxSurf.S3d.TallBufferHeight.setValue(src.AuxSurf.S3d.TallBufferHeight);
    dst.AuxSurf.S3d.TallBufferSize.setValue(src.AuxSurf.S3d.TallBufferSize);
    dst.AuxSurf.S3d.IsRFrame.setValue(src.AuxSurf.S3d.IsRFrame);
    dst.AuxSurf.SegmentOverride.Seg1.setValue(src.AuxSurf.SegmentOverride.Seg1);
    dst.AuxSurf.SegmentOverride.Evict.setValue(src.AuxSurf.SegmentOverride.Evict);
    dst.AuxSurf.MaximumRenamingListLength.setValue(src.AuxSurf.MaximumRenamingListLength);
#if _DEBUG || _RELEASE_INTERNAL
    dst.AuxSurf.Platform.eProductFamily.setValue(src.AuxSurf.Platform.eProductFamily);
    dst.AuxSurf.Platform.ePCHProductFamily.setValue(src.AuxSurf.Platform.ePCHProductFamily);
    dst.AuxSurf.Platform.eDisplayCoreFamily.setValue(src.AuxSurf.Platform.eDisplayCoreFamily);
    dst.AuxSurf.Platform.eRenderCoreFamily.setValue(src.AuxSurf.Platform.eRenderCoreFamily);
    dst.AuxSurf.Platform.ePlatformType.setValue(src.AuxSurf.Platform.ePlatformType);
    dst.AuxSurf.Platform.usDeviceID.setValue(src.AuxSurf.Platform.usDeviceID);
    dst.AuxSurf.Platform.usRevId.setValue(src.AuxSurf.Platform.usRevId);
    dst.AuxSurf.Platform.usDeviceID_PCH.setValue(src.AuxSurf.Platform.usDeviceID_PCH);
    dst.AuxSurf.Platform.usRevId_PCH.setValue(src.AuxSurf.Platform.usRevId_PCH);
    dst.AuxSurf.Platform.eGTType.setValue(src.AuxSurf.Platform.eGTType);
#endif
    dst.AuxSurf.ExistingSysMem.IsGmmAllocated.setValue(src.AuxSurf.ExistingSysMem.IsGmmAllocated);
    dst.AuxSurf.ExistingSysMem.IsPageAligned.setValue(src.AuxSurf.ExistingSysMem.IsPageAligned);
#if !(_DEBUG || _RELEASE_INTERNAL)
    dst.AuxSurf.__Platform.eProductFamily.setValue(src.AuxSurf.__Platform.eProductFamily);
    dst.AuxSurf.__Platform.ePCHProductFamily.setValue(src.AuxSurf.__Platform.ePCHProductFamily);
    dst.AuxSurf.__Platform.eDisplayCoreFamily.setValue(src.AuxSurf.__Platform.eDisplayCoreFamily);
    dst.AuxSurf.__Platform.eRenderCoreFamily.setValue(src.AuxSurf.__Platform.eRenderCoreFamily);
    dst.AuxSurf.__Platform.ePlatformType.setValue(src.AuxSurf.__Platform.ePlatformType);
    dst.AuxSurf.__Platform.usDeviceID.setValue(src.AuxSurf.__Platform.usDeviceID);
    dst.AuxSurf.__Platform.usRevId.setValue(src.AuxSurf.__Platform.usRevId);
    dst.AuxSurf.__Platform.usDeviceID_PCH.setValue(src.AuxSurf.__Platform.usDeviceID_PCH);
    dst.AuxSurf.__Platform.usRevId_PCH.setValue(src.AuxSurf.__Platform.usRevId_PCH);
    dst.AuxSurf.__Platform.eGTType.setValue(src.AuxSurf.__Platform.eGTType);
#endif
    dst.AuxSecSurf.Type.setValue(src.AuxSecSurf.Type);
    dst.AuxSecSurf.Format.setValue(src.AuxSecSurf.Format);
    dst.AuxSecSurf.BitsPerPixel.setValue(src.AuxSecSurf.BitsPerPixel);
    dst.AuxSecSurf.Flags.Gpu.CameraCapture.setValue(src.AuxSecSurf.Flags.Gpu.CameraCapture);
    dst.AuxSecSurf.Flags.Gpu.CCS.setValue(src.AuxSecSurf.Flags.Gpu.CCS);
    dst.AuxSecSurf.Flags.Gpu.ColorDiscard.setValue(src.AuxSecSurf.Flags.Gpu.ColorDiscard);
    dst.AuxSecSurf.Flags.Gpu.ColorSeparation.setValue(src.AuxSecSurf.Flags.Gpu.ColorSeparation);
    dst.AuxSecSurf.Flags.Gpu.ColorSeparationRGBX.setValue(src.AuxSecSurf.Flags.Gpu.ColorSeparationRGBX);
    dst.AuxSecSurf.Flags.Gpu.Constant.setValue(src.AuxSecSurf.Flags.Gpu.Constant);
    dst.AuxSecSurf.Flags.Gpu.Depth.setValue(src.AuxSecSurf.Flags.Gpu.Depth);
    dst.AuxSecSurf.Flags.Gpu.FlipChain.setValue(src.AuxSecSurf.Flags.Gpu.FlipChain);
    dst.AuxSecSurf.Flags.Gpu.FlipChainPreferred.setValue(src.AuxSecSurf.Flags.Gpu.FlipChainPreferred);
    dst.AuxSecSurf.Flags.Gpu.HistoryBuffer.setValue(src.AuxSecSurf.Flags.Gpu.HistoryBuffer);
    dst.AuxSecSurf.Flags.Gpu.HiZ.setValue(src.AuxSecSurf.Flags.Gpu.HiZ);
    dst.AuxSecSurf.Flags.Gpu.Index.setValue(src.AuxSecSurf.Flags.Gpu.Index);
    dst.AuxSecSurf.Flags.Gpu.IndirectClearColor.setValue(src.AuxSecSurf.Flags.Gpu.IndirectClearColor);
    dst.AuxSecSurf.Flags.Gpu.InstructionFlat.setValue(src.AuxSecSurf.Flags.Gpu.InstructionFlat);
    dst.AuxSecSurf.Flags.Gpu.InterlacedScan.setValue(src.AuxSecSurf.Flags.Gpu.InterlacedScan);
    dst.AuxSecSurf.Flags.Gpu.MCS.setValue(src.AuxSecSurf.Flags.Gpu.MCS);
    dst.AuxSecSurf.Flags.Gpu.MMC.setValue(src.AuxSecSurf.Flags.Gpu.MMC);
    dst.AuxSecSurf.Flags.Gpu.MotionComp.setValue(src.AuxSecSurf.Flags.Gpu.MotionComp);
    dst.AuxSecSurf.Flags.Gpu.NoRestriction.setValue(src.AuxSecSurf.Flags.Gpu.NoRestriction);
    dst.AuxSecSurf.Flags.Gpu.Overlay.setValue(src.AuxSecSurf.Flags.Gpu.Overlay);
    dst.AuxSecSurf.Flags.Gpu.Presentable.setValue(src.AuxSecSurf.Flags.Gpu.Presentable);
    dst.AuxSecSurf.Flags.Gpu.ProceduralTexture.setValue(src.AuxSecSurf.Flags.Gpu.ProceduralTexture);
    dst.AuxSecSurf.Flags.Gpu.Query.setValue(src.AuxSecSurf.Flags.Gpu.Query);
    dst.AuxSecSurf.Flags.Gpu.RenderTarget.setValue(src.AuxSecSurf.Flags.Gpu.RenderTarget);
    dst.AuxSecSurf.Flags.Gpu.S3d.setValue(src.AuxSecSurf.Flags.Gpu.S3d);
    dst.AuxSecSurf.Flags.Gpu.S3dDx.setValue(src.AuxSecSurf.Flags.Gpu.S3dDx);
    dst.AuxSecSurf.Flags.Gpu.__S3dNonPacked.setValue(src.AuxSecSurf.Flags.Gpu.__S3dNonPacked);
    dst.AuxSecSurf.Flags.Gpu.__S3dWidi.setValue(src.AuxSecSurf.Flags.Gpu.__S3dWidi);
    dst.AuxSecSurf.Flags.Gpu.ScratchFlat.setValue(src.AuxSecSurf.Flags.Gpu.ScratchFlat);
    dst.AuxSecSurf.Flags.Gpu.SeparateStencil.setValue(src.AuxSecSurf.Flags.Gpu.SeparateStencil);
    dst.AuxSecSurf.Flags.Gpu.State.setValue(src.AuxSecSurf.Flags.Gpu.State);
    dst.AuxSecSurf.Flags.Gpu.StateDx9ConstantBuffer.setValue(src.AuxSecSurf.Flags.Gpu.StateDx9ConstantBuffer);
    dst.AuxSecSurf.Flags.Gpu.Stream.setValue(src.AuxSecSurf.Flags.Gpu.Stream);
    dst.AuxSecSurf.Flags.Gpu.TextApi.setValue(src.AuxSecSurf.Flags.Gpu.TextApi);
    dst.AuxSecSurf.Flags.Gpu.Texture.setValue(src.AuxSecSurf.Flags.Gpu.Texture);
    dst.AuxSecSurf.Flags.Gpu.TiledResource.setValue(src.AuxSecSurf.Flags.Gpu.TiledResource);
    dst.AuxSecSurf.Flags.Gpu.TilePool.setValue(src.AuxSecSurf.Flags.Gpu.TilePool);
    dst.AuxSecSurf.Flags.Gpu.UnifiedAuxSurface.setValue(src.AuxSecSurf.Flags.Gpu.UnifiedAuxSurface);
    dst.AuxSecSurf.Flags.Gpu.Vertex.setValue(src.AuxSecSurf.Flags.Gpu.Vertex);
    dst.AuxSecSurf.Flags.Gpu.Video.setValue(src.AuxSecSurf.Flags.Gpu.Video);
    dst.AuxSecSurf.Flags.Gpu.__NonMsaaTileXCcs.setValue(src.AuxSecSurf.Flags.Gpu.__NonMsaaTileXCcs);
    dst.AuxSecSurf.Flags.Gpu.__NonMsaaTileYCcs.setValue(src.AuxSecSurf.Flags.Gpu.__NonMsaaTileYCcs);
    dst.AuxSecSurf.Flags.Gpu.__MsaaTileMcs.setValue(src.AuxSecSurf.Flags.Gpu.__MsaaTileMcs);
    dst.AuxSecSurf.Flags.Gpu.__NonMsaaLinearCCS.setValue(src.AuxSecSurf.Flags.Gpu.__NonMsaaLinearCCS);
    dst.AuxSecSurf.Flags.Gpu.__Remaining.setValue(src.AuxSecSurf.Flags.Gpu.__Remaining);
    dst.AuxSecSurf.Flags.Info.AllowVirtualPadding.setValue(src.AuxSecSurf.Flags.Info.AllowVirtualPadding);
    dst.AuxSecSurf.Flags.Info.BigPage.setValue(src.AuxSecSurf.Flags.Info.BigPage);
    dst.AuxSecSurf.Flags.Info.Cacheable.setValue(src.AuxSecSurf.Flags.Info.Cacheable);
    dst.AuxSecSurf.Flags.Info.ContigPhysMemoryForiDART.setValue(src.AuxSecSurf.Flags.Info.ContigPhysMemoryForiDART);
    dst.AuxSecSurf.Flags.Info.CornerTexelMode.setValue(src.AuxSecSurf.Flags.Info.CornerTexelMode);
    dst.AuxSecSurf.Flags.Info.ExistingSysMem.setValue(src.AuxSecSurf.Flags.Info.ExistingSysMem);
    dst.AuxSecSurf.Flags.Info.ForceResidency.setValue(src.AuxSecSurf.Flags.Info.ForceResidency);
    dst.AuxSecSurf.Flags.Info.Gfdt.setValue(src.AuxSecSurf.Flags.Info.Gfdt);
    dst.AuxSecSurf.Flags.Info.GttMapType.setValue(src.AuxSecSurf.Flags.Info.GttMapType);
    dst.AuxSecSurf.Flags.Info.HardwareProtected.setValue(src.AuxSecSurf.Flags.Info.HardwareProtected);
    dst.AuxSecSurf.Flags.Info.KernelModeMapped.setValue(src.AuxSecSurf.Flags.Info.KernelModeMapped);
    dst.AuxSecSurf.Flags.Info.LayoutBelow.setValue(src.AuxSecSurf.Flags.Info.LayoutBelow);
    dst.AuxSecSurf.Flags.Info.LayoutMono.setValue(src.AuxSecSurf.Flags.Info.LayoutMono);
    dst.AuxSecSurf.Flags.Info.LayoutRight.setValue(src.AuxSecSurf.Flags.Info.LayoutRight);
    dst.AuxSecSurf.Flags.Info.LocalOnly.setValue(src.AuxSecSurf.Flags.Info.LocalOnly);
    dst.AuxSecSurf.Flags.Info.Linear.setValue(src.AuxSecSurf.Flags.Info.Linear);
    dst.AuxSecSurf.Flags.Info.MediaCompressed.setValue(src.AuxSecSurf.Flags.Info.MediaCompressed);
    dst.AuxSecSurf.Flags.Info.NoOptimizationPadding.setValue(src.AuxSecSurf.Flags.Info.NoOptimizationPadding);
    dst.AuxSecSurf.Flags.Info.NoPhysMemory.setValue(src.AuxSecSurf.Flags.Info.NoPhysMemory);
    dst.AuxSecSurf.Flags.Info.NotLockable.setValue(src.AuxSecSurf.Flags.Info.NotLockable);
    dst.AuxSecSurf.Flags.Info.NonLocalOnly.setValue(src.AuxSecSurf.Flags.Info.NonLocalOnly);
    dst.AuxSecSurf.Flags.Info.StdSwizzle.setValue(src.AuxSecSurf.Flags.Info.StdSwizzle);
    dst.AuxSecSurf.Flags.Info.PseudoStdSwizzle.setValue(src.AuxSecSurf.Flags.Info.PseudoStdSwizzle);
    dst.AuxSecSurf.Flags.Info.Undefined64KBSwizzle.setValue(src.AuxSecSurf.Flags.Info.Undefined64KBSwizzle);
    dst.AuxSecSurf.Flags.Info.RedecribedPlanes.setValue(src.AuxSecSurf.Flags.Info.RedecribedPlanes);
    dst.AuxSecSurf.Flags.Info.RenderCompressed.setValue(src.AuxSecSurf.Flags.Info.RenderCompressed);
    dst.AuxSecSurf.Flags.Info.Rotated.setValue(src.AuxSecSurf.Flags.Info.Rotated);
    dst.AuxSecSurf.Flags.Info.Shared.setValue(src.AuxSecSurf.Flags.Info.Shared);
    dst.AuxSecSurf.Flags.Info.SoftwareProtected.setValue(src.AuxSecSurf.Flags.Info.SoftwareProtected);
    dst.AuxSecSurf.Flags.Info.SVM.setValue(src.AuxSecSurf.Flags.Info.SVM);
    dst.AuxSecSurf.Flags.Info.Tile4.setValue(src.AuxSecSurf.Flags.Info.Tile4);
    dst.AuxSecSurf.Flags.Info.Tile64.setValue(src.AuxSecSurf.Flags.Info.Tile64);
    dst.AuxSecSurf.Flags.Info.TiledW.setValue(src.AuxSecSurf.Flags.Info.TiledW);
    dst.AuxSecSurf.Flags.Info.TiledX.setValue(src.AuxSecSurf.Flags.Info.TiledX);
    dst.AuxSecSurf.Flags.Info.TiledY.setValue(src.AuxSecSurf.Flags.Info.TiledY);
    dst.AuxSecSurf.Flags.Info.TiledYf.setValue(src.AuxSecSurf.Flags.Info.TiledYf);
    dst.AuxSecSurf.Flags.Info.TiledYs.setValue(src.AuxSecSurf.Flags.Info.TiledYs);
    dst.AuxSecSurf.Flags.Info.WddmProtected.setValue(src.AuxSecSurf.Flags.Info.WddmProtected);
    dst.AuxSecSurf.Flags.Info.XAdapter.setValue(src.AuxSecSurf.Flags.Info.XAdapter);
    dst.AuxSecSurf.Flags.Info.__PreallocatedResInfo.setValue(src.AuxSecSurf.Flags.Info.__PreallocatedResInfo);
    dst.AuxSecSurf.Flags.Info.__PreWddm2SVM.setValue(src.AuxSecSurf.Flags.Info.__PreWddm2SVM);
    dst.AuxSecSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign.setValue(src.AuxSecSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign);
    dst.AuxSecSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign.setValue(src.AuxSecSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign);
    dst.AuxSecSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign.setValue(src.AuxSecSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign);
    dst.AuxSecSurf.Flags.Wa.NoBufferSamplerPadding.setValue(src.AuxSecSurf.Flags.Wa.NoBufferSamplerPadding);
    dst.AuxSecSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions.setValue(src.AuxSecSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions);
    dst.AuxSecSurf.Flags.Wa.CHVAstcSkipVirtualMips.setValue(src.AuxSecSurf.Flags.Wa.CHVAstcSkipVirtualMips);
    dst.AuxSecSurf.Flags.Wa.DisablePackedMipTail.setValue(src.AuxSecSurf.Flags.Wa.DisablePackedMipTail);
    dst.AuxSecSurf.Flags.Wa.__ForceOtherHVALIGN4.setValue(src.AuxSecSurf.Flags.Wa.__ForceOtherHVALIGN4);
    dst.AuxSecSurf.Flags.Wa.DisableDisplayCcsClearColor.setValue(src.AuxSecSurf.Flags.Wa.DisableDisplayCcsClearColor);
    dst.AuxSecSurf.Flags.Wa.DisableDisplayCcsCompression.setValue(src.AuxSecSurf.Flags.Wa.DisableDisplayCcsCompression);
    dst.AuxSecSurf.Flags.Wa.PreGen12FastClearOnly.setValue(src.AuxSecSurf.Flags.Wa.PreGen12FastClearOnly);
    dst.AuxSecSurf.Flags.Wa.ForceStdAllocAlign.setValue(src.AuxSecSurf.Flags.Wa.ForceStdAllocAlign);
    dst.AuxSecSurf.Flags.Wa.DeniableLocalOnlyForCompression.setValue(src.AuxSecSurf.Flags.Wa.DeniableLocalOnlyForCompression);
    dst.AuxSecSurf.BaseWidth.setValue(src.AuxSecSurf.BaseWidth);
    dst.AuxSecSurf.BaseHeight.setValue(src.AuxSecSurf.BaseHeight);
    dst.AuxSecSurf.Depth.setValue(src.AuxSecSurf.Depth);
    dst.AuxSecSurf.MaxLod.setValue(src.AuxSecSurf.MaxLod);
    dst.AuxSecSurf.ArraySize.setValue(src.AuxSecSurf.ArraySize);
    dst.AuxSecSurf.CpTag.setValue(src.AuxSecSurf.CpTag);
    dst.AuxSecSurf.CachePolicy.Usage.setValue(src.AuxSecSurf.CachePolicy.Usage);
    dst.AuxSecSurf.MSAA.SamplePattern.setValue(src.AuxSecSurf.MSAA.SamplePattern);
    dst.AuxSecSurf.MSAA.NumSamples.setValue(src.AuxSecSurf.MSAA.NumSamples);
    dst.AuxSecSurf.Alignment.ArraySpacingSingleLod.setValue(src.AuxSecSurf.Alignment.ArraySpacingSingleLod);
    dst.AuxSecSurf.Alignment.BaseAlignment.setValue(src.AuxSecSurf.Alignment.BaseAlignment);
    dst.AuxSecSurf.Alignment.HAlign.setValue(src.AuxSecSurf.Alignment.HAlign);
    dst.AuxSecSurf.Alignment.VAlign.setValue(src.AuxSecSurf.Alignment.VAlign);
    dst.AuxSecSurf.Alignment.DAlign.setValue(src.AuxSecSurf.Alignment.DAlign);
    dst.AuxSecSurf.Alignment.MipTailStartLod.setValue(src.AuxSecSurf.Alignment.MipTailStartLod);
    dst.AuxSecSurf.Alignment.PackedMipStartLod.setValue(src.AuxSecSurf.Alignment.PackedMipStartLod);
    dst.AuxSecSurf.Alignment.PackedMipWidth.setValue(src.AuxSecSurf.Alignment.PackedMipWidth);
    dst.AuxSecSurf.Alignment.PackedMipHeight.setValue(src.AuxSecSurf.Alignment.PackedMipHeight);
    dst.AuxSecSurf.Alignment.QPitch.setValue(src.AuxSecSurf.Alignment.QPitch);
    WCH_SAFE_COPY(dst.AuxSecSurf.MmcMode.getValue<char>(), dst.AuxSecSurf.MmcMode.getValueSizeInBytes(), src.AuxSecSurf.MmcMode, sizeof(src.AuxSecSurf.MmcMode));
    WCH_SAFE_COPY(dst.AuxSecSurf.MmcHint.getValue<char>(), dst.AuxSecSurf.MmcHint.getValueSizeInBytes(), src.AuxSecSurf.MmcHint, sizeof(src.AuxSecSurf.MmcHint));
    dst.AuxSecSurf.Pitch.setValue(src.AuxSecSurf.Pitch);
    dst.AuxSecSurf.OverridePitch.setValue(src.AuxSecSurf.OverridePitch);
    dst.AuxSecSurf.Size.setValue(src.AuxSecSurf.Size);
    dst.AuxSecSurf.CCSize.setValue(src.AuxSecSurf.CCSize);
    dst.AuxSecSurf.UnpaddedSize.setValue(src.AuxSecSurf.UnpaddedSize);
    dst.AuxSecSurf.SizeReportToOS.setValue(src.AuxSecSurf.SizeReportToOS);
    dst.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch.setValue(src.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch);
    WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset.getValue<char>(), dst.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset.getValueSizeInBytes(), src.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(src.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset));
    dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock.setValue(src.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock);
    dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender.setValue(src.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender);
    WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset.getValue<char>(), dst.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset.getValueSizeInBytes(), src.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(src.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset));
    dst.AuxSecSurf.OffsetInfo.Plane.ArrayQPitch.setValue(src.AuxSecSurf.OffsetInfo.Plane.ArrayQPitch);
    WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Plane.X.getValue<char>(), dst.AuxSecSurf.OffsetInfo.Plane.X.getValueSizeInBytes(), src.AuxSecSurf.OffsetInfo.Plane.X, sizeof(src.AuxSecSurf.OffsetInfo.Plane.X));
    WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Plane.Y.getValue<char>(), dst.AuxSecSurf.OffsetInfo.Plane.Y.getValueSizeInBytes(), src.AuxSecSurf.OffsetInfo.Plane.Y, sizeof(src.AuxSecSurf.OffsetInfo.Plane.Y));
    WCH_SAFE_COPY(dst.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height.getValue<char>(), dst.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height.getValueSizeInBytes(), src.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height, sizeof(src.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height));
    dst.AuxSecSurf.OffsetInfo.Plane.NoOfPlanes.setValue(src.AuxSecSurf.OffsetInfo.Plane.NoOfPlanes);
    dst.AuxSecSurf.OffsetInfo.Plane.IsTileAlignedPlanes.setValue(src.AuxSecSurf.OffsetInfo.Plane.IsTileAlignedPlanes);
    dst.AuxSecSurf.TileMode.setValue(src.AuxSecSurf.TileMode);
    dst.AuxSecSurf.CCSModeAlign.setValue(src.AuxSecSurf.CCSModeAlign);
    dst.AuxSecSurf.LegacyFlags.setValue(src.AuxSecSurf.LegacyFlags);
    dst.AuxSecSurf.S3d.DisplayModeHeight.setValue(src.AuxSecSurf.S3d.DisplayModeHeight);
    dst.AuxSecSurf.S3d.NumBlankActiveLines.setValue(src.AuxSecSurf.S3d.NumBlankActiveLines);
    dst.AuxSecSurf.S3d.RFrameOffset.setValue(src.AuxSecSurf.S3d.RFrameOffset);
    dst.AuxSecSurf.S3d.BlankAreaOffset.setValue(src.AuxSecSurf.S3d.BlankAreaOffset);
    dst.AuxSecSurf.S3d.TallBufferHeight.setValue(src.AuxSecSurf.S3d.TallBufferHeight);
    dst.AuxSecSurf.S3d.TallBufferSize.setValue(src.AuxSecSurf.S3d.TallBufferSize);
    dst.AuxSecSurf.S3d.IsRFrame.setValue(src.AuxSecSurf.S3d.IsRFrame);
    dst.AuxSecSurf.SegmentOverride.Seg1.setValue(src.AuxSecSurf.SegmentOverride.Seg1);
    dst.AuxSecSurf.SegmentOverride.Evict.setValue(src.AuxSecSurf.SegmentOverride.Evict);
    dst.AuxSecSurf.MaximumRenamingListLength.setValue(src.AuxSecSurf.MaximumRenamingListLength);
#if _DEBUG || _RELEASE_INTERNAL
    dst.AuxSecSurf.Platform.eProductFamily.setValue(src.AuxSecSurf.Platform.eProductFamily);
    dst.AuxSecSurf.Platform.ePCHProductFamily.setValue(src.AuxSecSurf.Platform.ePCHProductFamily);
    dst.AuxSecSurf.Platform.eDisplayCoreFamily.setValue(src.AuxSecSurf.Platform.eDisplayCoreFamily);
    dst.AuxSecSurf.Platform.eRenderCoreFamily.setValue(src.AuxSecSurf.Platform.eRenderCoreFamily);
    dst.AuxSecSurf.Platform.ePlatformType.setValue(src.AuxSecSurf.Platform.ePlatformType);
    dst.AuxSecSurf.Platform.usDeviceID.setValue(src.AuxSecSurf.Platform.usDeviceID);
    dst.AuxSecSurf.Platform.usRevId.setValue(src.AuxSecSurf.Platform.usRevId);
    dst.AuxSecSurf.Platform.usDeviceID_PCH.setValue(src.AuxSecSurf.Platform.usDeviceID_PCH);
    dst.AuxSecSurf.Platform.usRevId_PCH.setValue(src.AuxSecSurf.Platform.usRevId_PCH);
    dst.AuxSecSurf.Platform.eGTType.setValue(src.AuxSecSurf.Platform.eGTType);
#endif
    dst.AuxSecSurf.ExistingSysMem.IsGmmAllocated.setValue(src.AuxSecSurf.ExistingSysMem.IsGmmAllocated);
    dst.AuxSecSurf.ExistingSysMem.IsPageAligned.setValue(src.AuxSecSurf.ExistingSysMem.IsPageAligned);
#if !(_DEBUG || _RELEASE_INTERNAL)
    dst.AuxSecSurf.__Platform.eProductFamily.setValue(src.AuxSecSurf.__Platform.eProductFamily);
    dst.AuxSecSurf.__Platform.ePCHProductFamily.setValue(src.AuxSecSurf.__Platform.ePCHProductFamily);
    dst.AuxSecSurf.__Platform.eDisplayCoreFamily.setValue(src.AuxSecSurf.__Platform.eDisplayCoreFamily);
    dst.AuxSecSurf.__Platform.eRenderCoreFamily.setValue(src.AuxSecSurf.__Platform.eRenderCoreFamily);
    dst.AuxSecSurf.__Platform.ePlatformType.setValue(src.AuxSecSurf.__Platform.ePlatformType);
    dst.AuxSecSurf.__Platform.usDeviceID.setValue(src.AuxSecSurf.__Platform.usDeviceID);
    dst.AuxSecSurf.__Platform.usRevId.setValue(src.AuxSecSurf.__Platform.usRevId);
    dst.AuxSecSurf.__Platform.usDeviceID_PCH.setValue(src.AuxSecSurf.__Platform.usDeviceID_PCH);
    dst.AuxSecSurf.__Platform.usRevId_PCH.setValue(src.AuxSecSurf.__Platform.usRevId_PCH);
    dst.AuxSecSurf.__Platform.eGTType.setValue(src.AuxSecSurf.__Platform.eGTType);
#endif
    dst.RotateInfo.setValue(src.RotateInfo);
    dst.ExistingSysMem.pExistingSysMem.setValue(src.ExistingSysMem.pExistingSysMem);
    dst.ExistingSysMem.pVirtAddress.setValue(src.ExistingSysMem.pVirtAddress);
    dst.ExistingSysMem.pGfxAlignedVirtAddress.setValue(src.ExistingSysMem.pGfxAlignedVirtAddress);
    dst.ExistingSysMem.Size.setValue(src.ExistingSysMem.Size);
    dst.ExistingSysMem.IsGmmAllocated.setValue(src.ExistingSysMem.IsGmmAllocated);
    dst.SvmAddress.setValue(src.SvmAddress);
    dst.pPrivateData.setValue(src.pPrivateData);
    dst.MultiTileArch.Enable.setValue(src.MultiTileArch.Enable);
    dst.MultiTileArch.TileInstanced.setValue(src.MultiTileArch.TileInstanced);
    dst.MultiTileArch.GpuVaMappingSet.setValue(src.MultiTileArch.GpuVaMappingSet);
    dst.MultiTileArch.LocalMemEligibilitySet.setValue(src.MultiTileArch.LocalMemEligibilitySet);
    dst.MultiTileArch.LocalMemPreferredSet.setValue(src.MultiTileArch.LocalMemPreferredSet);
}
template <>
struct Marshaller<TOK_S_GMM_RESOURCE_INFO_COMMON_STRUCT> {
    template <typename GmmResourceInfoCommonStructT>
    static TOKSTR_GmmResourceInfoCommonStruct marshall(const GmmResourceInfoCommonStructT &src) {
        TOKSTR_GmmResourceInfoCommonStruct ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GmmResourceInfoWinStructT>
inline void marshall(TOKSTR_GmmResourceInfoWinStruct &dst, const GmmResourceInfoWinStructT &src) {
    dst = {};
    dst.GmmResourceInfoCommon.ClientType.setValue(src.GmmResourceInfoCommon.ClientType);
    dst.GmmResourceInfoCommon.Surf.Type.setValue(src.GmmResourceInfoCommon.Surf.Type);
    dst.GmmResourceInfoCommon.Surf.Format.setValue(src.GmmResourceInfoCommon.Surf.Format);
    dst.GmmResourceInfoCommon.Surf.BitsPerPixel.setValue(src.GmmResourceInfoCommon.Surf.BitsPerPixel);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.CameraCapture.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.CameraCapture);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.CCS.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.CCS);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorDiscard.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorDiscard);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorSeparation.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorSeparation);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorSeparationRGBX.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.ColorSeparationRGBX);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Constant.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Constant);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Depth.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Depth);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.FlipChain.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.FlipChain);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.FlipChainPreferred.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.FlipChainPreferred);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.HistoryBuffer.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.HistoryBuffer);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.HiZ.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.HiZ);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Index.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Index);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.IndirectClearColor.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.IndirectClearColor);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.InstructionFlat.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.InstructionFlat);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.InterlacedScan.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.InterlacedScan);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.MCS.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.MCS);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.MMC.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.MMC);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.MotionComp.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.MotionComp);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.NoRestriction.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.NoRestriction);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Overlay.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Overlay);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Presentable.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Presentable);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ProceduralTexture.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.ProceduralTexture);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Query.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Query);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.RenderTarget.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.RenderTarget);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.S3d.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.S3d);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.S3dDx.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.S3dDx);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__S3dNonPacked.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.__S3dNonPacked);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__S3dWidi.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.__S3dWidi);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.ScratchFlat.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.ScratchFlat);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.SeparateStencil.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.SeparateStencil);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.State.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.State);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.StateDx9ConstantBuffer.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.StateDx9ConstantBuffer);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Stream.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Stream);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.TextApi.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.TextApi);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Texture.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Texture);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.TiledResource.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.TiledResource);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.TilePool.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.TilePool);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.UnifiedAuxSurface.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.UnifiedAuxSurface);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Vertex.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Vertex);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.Video.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.Video);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaTileXCcs.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaTileXCcs);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaTileYCcs.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaTileYCcs);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__MsaaTileMcs.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.__MsaaTileMcs);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaLinearCCS.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.__NonMsaaLinearCCS);
    dst.GmmResourceInfoCommon.Surf.Flags.Gpu.__Remaining.setValue(src.GmmResourceInfoCommon.Surf.Flags.Gpu.__Remaining);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.AllowVirtualPadding.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.AllowVirtualPadding);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.BigPage.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.BigPage);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.Cacheable.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.Cacheable);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.ContigPhysMemoryForiDART.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.ContigPhysMemoryForiDART);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.CornerTexelMode.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.CornerTexelMode);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.ExistingSysMem.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.ExistingSysMem);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.ForceResidency.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.ForceResidency);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.Gfdt.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.Gfdt);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.GttMapType.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.GttMapType);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.HardwareProtected.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.HardwareProtected);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.KernelModeMapped.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.KernelModeMapped);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.LayoutBelow.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.LayoutBelow);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.LayoutMono.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.LayoutMono);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.LayoutRight.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.LayoutRight);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.LocalOnly.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.LocalOnly);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.Linear.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.Linear);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.MediaCompressed.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.MediaCompressed);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.NoOptimizationPadding.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.NoOptimizationPadding);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.NoPhysMemory.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.NoPhysMemory);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.NotLockable.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.NotLockable);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.NonLocalOnly.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.NonLocalOnly);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.StdSwizzle.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.StdSwizzle);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.PseudoStdSwizzle.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.PseudoStdSwizzle);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.Undefined64KBSwizzle.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.Undefined64KBSwizzle);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.RedecribedPlanes.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.RedecribedPlanes);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.RenderCompressed.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.RenderCompressed);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.Rotated.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.Rotated);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.Shared.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.Shared);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.SoftwareProtected.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.SoftwareProtected);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.SVM.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.SVM);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.Tile4.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.Tile4);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.Tile64.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.Tile64);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledW.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.TiledW);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledX.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.TiledX);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledY.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.TiledY);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledYf.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.TiledYf);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.TiledYs.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.TiledYs);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.WddmProtected.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.WddmProtected);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.XAdapter.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.XAdapter);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.__PreallocatedResInfo.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.__PreallocatedResInfo);
    dst.GmmResourceInfoCommon.Surf.Flags.Info.__PreWddm2SVM.setValue(src.GmmResourceInfoCommon.Surf.Flags.Info.__PreWddm2SVM);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.NoBufferSamplerPadding.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.NoBufferSamplerPadding);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.CHVAstcSkipVirtualMips.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.CHVAstcSkipVirtualMips);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.DisablePackedMipTail.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.DisablePackedMipTail);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.__ForceOtherHVALIGN4.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.__ForceOtherHVALIGN4);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.DisableDisplayCcsClearColor.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.DisableDisplayCcsClearColor);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.DisableDisplayCcsCompression.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.DisableDisplayCcsCompression);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.PreGen12FastClearOnly.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.PreGen12FastClearOnly);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.ForceStdAllocAlign.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.ForceStdAllocAlign);
    dst.GmmResourceInfoCommon.Surf.Flags.Wa.DeniableLocalOnlyForCompression.setValue(src.GmmResourceInfoCommon.Surf.Flags.Wa.DeniableLocalOnlyForCompression);
    dst.GmmResourceInfoCommon.Surf.BaseWidth.setValue(src.GmmResourceInfoCommon.Surf.BaseWidth);
    dst.GmmResourceInfoCommon.Surf.BaseHeight.setValue(src.GmmResourceInfoCommon.Surf.BaseHeight);
    dst.GmmResourceInfoCommon.Surf.Depth.setValue(src.GmmResourceInfoCommon.Surf.Depth);
    dst.GmmResourceInfoCommon.Surf.MaxLod.setValue(src.GmmResourceInfoCommon.Surf.MaxLod);
    dst.GmmResourceInfoCommon.Surf.ArraySize.setValue(src.GmmResourceInfoCommon.Surf.ArraySize);
    dst.GmmResourceInfoCommon.Surf.CpTag.setValue(src.GmmResourceInfoCommon.Surf.CpTag);
    dst.GmmResourceInfoCommon.Surf.CachePolicy.Usage.setValue(src.GmmResourceInfoCommon.Surf.CachePolicy.Usage);
    dst.GmmResourceInfoCommon.Surf.MSAA.SamplePattern.setValue(src.GmmResourceInfoCommon.Surf.MSAA.SamplePattern);
    dst.GmmResourceInfoCommon.Surf.MSAA.NumSamples.setValue(src.GmmResourceInfoCommon.Surf.MSAA.NumSamples);
    dst.GmmResourceInfoCommon.Surf.Alignment.ArraySpacingSingleLod.setValue(src.GmmResourceInfoCommon.Surf.Alignment.ArraySpacingSingleLod);
    dst.GmmResourceInfoCommon.Surf.Alignment.BaseAlignment.setValue(src.GmmResourceInfoCommon.Surf.Alignment.BaseAlignment);
    dst.GmmResourceInfoCommon.Surf.Alignment.HAlign.setValue(src.GmmResourceInfoCommon.Surf.Alignment.HAlign);
    dst.GmmResourceInfoCommon.Surf.Alignment.VAlign.setValue(src.GmmResourceInfoCommon.Surf.Alignment.VAlign);
    dst.GmmResourceInfoCommon.Surf.Alignment.DAlign.setValue(src.GmmResourceInfoCommon.Surf.Alignment.DAlign);
    dst.GmmResourceInfoCommon.Surf.Alignment.MipTailStartLod.setValue(src.GmmResourceInfoCommon.Surf.Alignment.MipTailStartLod);
    dst.GmmResourceInfoCommon.Surf.Alignment.PackedMipStartLod.setValue(src.GmmResourceInfoCommon.Surf.Alignment.PackedMipStartLod);
    dst.GmmResourceInfoCommon.Surf.Alignment.PackedMipWidth.setValue(src.GmmResourceInfoCommon.Surf.Alignment.PackedMipWidth);
    dst.GmmResourceInfoCommon.Surf.Alignment.PackedMipHeight.setValue(src.GmmResourceInfoCommon.Surf.Alignment.PackedMipHeight);
    dst.GmmResourceInfoCommon.Surf.Alignment.QPitch.setValue(src.GmmResourceInfoCommon.Surf.Alignment.QPitch);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.MmcMode.getValue<char>(), dst.GmmResourceInfoCommon.Surf.MmcMode.getValueSizeInBytes(), src.GmmResourceInfoCommon.Surf.MmcMode, sizeof(src.GmmResourceInfoCommon.Surf.MmcMode));
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.MmcHint.getValue<char>(), dst.GmmResourceInfoCommon.Surf.MmcHint.getValueSizeInBytes(), src.GmmResourceInfoCommon.Surf.MmcHint, sizeof(src.GmmResourceInfoCommon.Surf.MmcHint));
    dst.GmmResourceInfoCommon.Surf.Pitch.setValue(src.GmmResourceInfoCommon.Surf.Pitch);
    dst.GmmResourceInfoCommon.Surf.OverridePitch.setValue(src.GmmResourceInfoCommon.Surf.OverridePitch);
    dst.GmmResourceInfoCommon.Surf.Size.setValue(src.GmmResourceInfoCommon.Surf.Size);
    dst.GmmResourceInfoCommon.Surf.CCSize.setValue(src.GmmResourceInfoCommon.Surf.CCSize);
    dst.GmmResourceInfoCommon.Surf.UnpaddedSize.setValue(src.GmmResourceInfoCommon.Surf.UnpaddedSize);
    dst.GmmResourceInfoCommon.Surf.SizeReportToOS.setValue(src.GmmResourceInfoCommon.Surf.SizeReportToOS);
    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch.setValue(src.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Offset.getValue<char>(), dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Offset.getValueSizeInBytes(), src.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(src.GmmResourceInfoCommon.Surf.OffsetInfo.Texture3DOffsetInfo.Offset));
    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock.setValue(src.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock);
    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender.setValue(src.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.Offset.getValue<char>(), dst.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.Offset.getValueSizeInBytes(), src.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(src.GmmResourceInfoCommon.Surf.OffsetInfo.Texture2DOffsetInfo.Offset));
    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.ArrayQPitch.setValue(src.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.ArrayQPitch);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.X.getValue<char>(), dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.X.getValueSizeInBytes(), src.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.X, sizeof(src.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.X));
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.Y.getValue<char>(), dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.Y.getValueSizeInBytes(), src.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.Y, sizeof(src.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.Y));
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.UnAligned.Height.getValue<char>(), dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.UnAligned.Height.getValueSizeInBytes(), src.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.UnAligned.Height, sizeof(src.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.UnAligned.Height));
    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.NoOfPlanes.setValue(src.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.NoOfPlanes);
    dst.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.IsTileAlignedPlanes.setValue(src.GmmResourceInfoCommon.Surf.OffsetInfo.Plane.IsTileAlignedPlanes);
    dst.GmmResourceInfoCommon.Surf.TileMode.setValue(src.GmmResourceInfoCommon.Surf.TileMode);
    dst.GmmResourceInfoCommon.Surf.CCSModeAlign.setValue(src.GmmResourceInfoCommon.Surf.CCSModeAlign);
    dst.GmmResourceInfoCommon.Surf.LegacyFlags.setValue(src.GmmResourceInfoCommon.Surf.LegacyFlags);
    dst.GmmResourceInfoCommon.Surf.S3d.DisplayModeHeight.setValue(src.GmmResourceInfoCommon.Surf.S3d.DisplayModeHeight);
    dst.GmmResourceInfoCommon.Surf.S3d.NumBlankActiveLines.setValue(src.GmmResourceInfoCommon.Surf.S3d.NumBlankActiveLines);
    dst.GmmResourceInfoCommon.Surf.S3d.RFrameOffset.setValue(src.GmmResourceInfoCommon.Surf.S3d.RFrameOffset);
    dst.GmmResourceInfoCommon.Surf.S3d.BlankAreaOffset.setValue(src.GmmResourceInfoCommon.Surf.S3d.BlankAreaOffset);
    dst.GmmResourceInfoCommon.Surf.S3d.TallBufferHeight.setValue(src.GmmResourceInfoCommon.Surf.S3d.TallBufferHeight);
    dst.GmmResourceInfoCommon.Surf.S3d.TallBufferSize.setValue(src.GmmResourceInfoCommon.Surf.S3d.TallBufferSize);
    dst.GmmResourceInfoCommon.Surf.S3d.IsRFrame.setValue(src.GmmResourceInfoCommon.Surf.S3d.IsRFrame);
    dst.GmmResourceInfoCommon.Surf.SegmentOverride.Seg1.setValue(src.GmmResourceInfoCommon.Surf.SegmentOverride.Seg1);
    dst.GmmResourceInfoCommon.Surf.SegmentOverride.Evict.setValue(src.GmmResourceInfoCommon.Surf.SegmentOverride.Evict);
    dst.GmmResourceInfoCommon.Surf.MaximumRenamingListLength.setValue(src.GmmResourceInfoCommon.Surf.MaximumRenamingListLength);
#if _DEBUG || _RELEASE_INTERNAL
    dst.GmmResourceInfoCommon.Surf.Platform.eProductFamily.setValue(src.GmmResourceInfoCommon.Surf.Platform.eProductFamily);
    dst.GmmResourceInfoCommon.Surf.Platform.ePCHProductFamily.setValue(src.GmmResourceInfoCommon.Surf.Platform.ePCHProductFamily);
    dst.GmmResourceInfoCommon.Surf.Platform.eDisplayCoreFamily.setValue(src.GmmResourceInfoCommon.Surf.Platform.eDisplayCoreFamily);
    dst.GmmResourceInfoCommon.Surf.Platform.eRenderCoreFamily.setValue(src.GmmResourceInfoCommon.Surf.Platform.eRenderCoreFamily);
    dst.GmmResourceInfoCommon.Surf.Platform.ePlatformType.setValue(src.GmmResourceInfoCommon.Surf.Platform.ePlatformType);
    dst.GmmResourceInfoCommon.Surf.Platform.usDeviceID.setValue(src.GmmResourceInfoCommon.Surf.Platform.usDeviceID);
    dst.GmmResourceInfoCommon.Surf.Platform.usRevId.setValue(src.GmmResourceInfoCommon.Surf.Platform.usRevId);
    dst.GmmResourceInfoCommon.Surf.Platform.usDeviceID_PCH.setValue(src.GmmResourceInfoCommon.Surf.Platform.usDeviceID_PCH);
    dst.GmmResourceInfoCommon.Surf.Platform.usRevId_PCH.setValue(src.GmmResourceInfoCommon.Surf.Platform.usRevId_PCH);
    dst.GmmResourceInfoCommon.Surf.Platform.eGTType.setValue(src.GmmResourceInfoCommon.Surf.Platform.eGTType);
#endif
    dst.GmmResourceInfoCommon.Surf.ExistingSysMem.IsGmmAllocated.setValue(src.GmmResourceInfoCommon.Surf.ExistingSysMem.IsGmmAllocated);
    dst.GmmResourceInfoCommon.Surf.ExistingSysMem.IsPageAligned.setValue(src.GmmResourceInfoCommon.Surf.ExistingSysMem.IsPageAligned);
#if !(_DEBUG || _RELEASE_INTERNAL)
    dst.GmmResourceInfoCommon.Surf.__Platform.eProductFamily.setValue(src.GmmResourceInfoCommon.Surf.__Platform.eProductFamily);
    dst.GmmResourceInfoCommon.Surf.__Platform.ePCHProductFamily.setValue(src.GmmResourceInfoCommon.Surf.__Platform.ePCHProductFamily);
    dst.GmmResourceInfoCommon.Surf.__Platform.eDisplayCoreFamily.setValue(src.GmmResourceInfoCommon.Surf.__Platform.eDisplayCoreFamily);
    dst.GmmResourceInfoCommon.Surf.__Platform.eRenderCoreFamily.setValue(src.GmmResourceInfoCommon.Surf.__Platform.eRenderCoreFamily);
    dst.GmmResourceInfoCommon.Surf.__Platform.ePlatformType.setValue(src.GmmResourceInfoCommon.Surf.__Platform.ePlatformType);
    dst.GmmResourceInfoCommon.Surf.__Platform.usDeviceID.setValue(src.GmmResourceInfoCommon.Surf.__Platform.usDeviceID);
    dst.GmmResourceInfoCommon.Surf.__Platform.usRevId.setValue(src.GmmResourceInfoCommon.Surf.__Platform.usRevId);
    dst.GmmResourceInfoCommon.Surf.__Platform.usDeviceID_PCH.setValue(src.GmmResourceInfoCommon.Surf.__Platform.usDeviceID_PCH);
    dst.GmmResourceInfoCommon.Surf.__Platform.usRevId_PCH.setValue(src.GmmResourceInfoCommon.Surf.__Platform.usRevId_PCH);
    dst.GmmResourceInfoCommon.Surf.__Platform.eGTType.setValue(src.GmmResourceInfoCommon.Surf.__Platform.eGTType);
#endif
    dst.GmmResourceInfoCommon.AuxSurf.Type.setValue(src.GmmResourceInfoCommon.AuxSurf.Type);
    dst.GmmResourceInfoCommon.AuxSurf.Format.setValue(src.GmmResourceInfoCommon.AuxSurf.Format);
    dst.GmmResourceInfoCommon.AuxSurf.BitsPerPixel.setValue(src.GmmResourceInfoCommon.AuxSurf.BitsPerPixel);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.CameraCapture.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.CameraCapture);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.CCS.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.CCS);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorDiscard.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorDiscard);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorSeparation.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorSeparation);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorSeparationRGBX.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ColorSeparationRGBX);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Constant.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Constant);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Depth.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Depth);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.FlipChain.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.FlipChain);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.FlipChainPreferred.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.FlipChainPreferred);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.HistoryBuffer.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.HistoryBuffer);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.HiZ.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.HiZ);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Index.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Index);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.IndirectClearColor.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.IndirectClearColor);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.InstructionFlat.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.InstructionFlat);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.InterlacedScan.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.InterlacedScan);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MCS.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MCS);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MMC.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MMC);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MotionComp.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.MotionComp);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.NoRestriction.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.NoRestriction);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Overlay.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Overlay);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Presentable.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Presentable);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ProceduralTexture.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ProceduralTexture);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Query.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Query);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.RenderTarget.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.RenderTarget);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.S3d.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.S3d);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.S3dDx.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.S3dDx);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__S3dNonPacked.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__S3dNonPacked);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__S3dWidi.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__S3dWidi);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ScratchFlat.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.ScratchFlat);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.SeparateStencil.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.SeparateStencil);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.State.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.State);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.StateDx9ConstantBuffer.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.StateDx9ConstantBuffer);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Stream.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Stream);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TextApi.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TextApi);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Texture.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Texture);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TiledResource.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TiledResource);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TilePool.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.TilePool);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.UnifiedAuxSurface.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.UnifiedAuxSurface);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Vertex.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Vertex);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Video.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.Video);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaTileXCcs.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaTileXCcs);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaTileYCcs.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaTileYCcs);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__MsaaTileMcs.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__MsaaTileMcs);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaLinearCCS.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__NonMsaaLinearCCS);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__Remaining.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Gpu.__Remaining);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.AllowVirtualPadding.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.AllowVirtualPadding);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.BigPage.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.BigPage);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Cacheable.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.Cacheable);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.ContigPhysMemoryForiDART.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.ContigPhysMemoryForiDART);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.CornerTexelMode.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.CornerTexelMode);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.ExistingSysMem.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.ExistingSysMem);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.ForceResidency.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.ForceResidency);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Gfdt.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.Gfdt);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.GttMapType.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.GttMapType);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.HardwareProtected.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.HardwareProtected);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.KernelModeMapped.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.KernelModeMapped);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutBelow.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutBelow);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutMono.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutMono);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutRight.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.LayoutRight);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.LocalOnly.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.LocalOnly);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Linear.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.Linear);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.MediaCompressed.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.MediaCompressed);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NoOptimizationPadding.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.NoOptimizationPadding);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NoPhysMemory.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.NoPhysMemory);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NotLockable.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.NotLockable);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.NonLocalOnly.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.NonLocalOnly);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.StdSwizzle.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.StdSwizzle);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.PseudoStdSwizzle.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.PseudoStdSwizzle);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Undefined64KBSwizzle.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.Undefined64KBSwizzle);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.RedecribedPlanes.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.RedecribedPlanes);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.RenderCompressed.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.RenderCompressed);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Rotated.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.Rotated);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Shared.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.Shared);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.SoftwareProtected.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.SoftwareProtected);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.SVM.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.SVM);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Tile4.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.Tile4);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.Tile64.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.Tile64);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledW.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledW);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledX.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledX);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledY.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledY);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledYf.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledYf);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledYs.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.TiledYs);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.WddmProtected.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.WddmProtected);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.XAdapter.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.XAdapter);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.__PreallocatedResInfo.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.__PreallocatedResInfo);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Info.__PreWddm2SVM.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Info.__PreWddm2SVM);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.NoBufferSamplerPadding.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.NoBufferSamplerPadding);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.CHVAstcSkipVirtualMips.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.CHVAstcSkipVirtualMips);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisablePackedMipTail.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisablePackedMipTail);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.__ForceOtherHVALIGN4.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.__ForceOtherHVALIGN4);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisableDisplayCcsClearColor.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisableDisplayCcsClearColor);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisableDisplayCcsCompression.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DisableDisplayCcsCompression);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.PreGen12FastClearOnly.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.PreGen12FastClearOnly);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ForceStdAllocAlign.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.ForceStdAllocAlign);
    dst.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DeniableLocalOnlyForCompression.setValue(src.GmmResourceInfoCommon.AuxSurf.Flags.Wa.DeniableLocalOnlyForCompression);
    dst.GmmResourceInfoCommon.AuxSurf.BaseWidth.setValue(src.GmmResourceInfoCommon.AuxSurf.BaseWidth);
    dst.GmmResourceInfoCommon.AuxSurf.BaseHeight.setValue(src.GmmResourceInfoCommon.AuxSurf.BaseHeight);
    dst.GmmResourceInfoCommon.AuxSurf.Depth.setValue(src.GmmResourceInfoCommon.AuxSurf.Depth);
    dst.GmmResourceInfoCommon.AuxSurf.MaxLod.setValue(src.GmmResourceInfoCommon.AuxSurf.MaxLod);
    dst.GmmResourceInfoCommon.AuxSurf.ArraySize.setValue(src.GmmResourceInfoCommon.AuxSurf.ArraySize);
    dst.GmmResourceInfoCommon.AuxSurf.CpTag.setValue(src.GmmResourceInfoCommon.AuxSurf.CpTag);
    dst.GmmResourceInfoCommon.AuxSurf.CachePolicy.Usage.setValue(src.GmmResourceInfoCommon.AuxSurf.CachePolicy.Usage);
    dst.GmmResourceInfoCommon.AuxSurf.MSAA.SamplePattern.setValue(src.GmmResourceInfoCommon.AuxSurf.MSAA.SamplePattern);
    dst.GmmResourceInfoCommon.AuxSurf.MSAA.NumSamples.setValue(src.GmmResourceInfoCommon.AuxSurf.MSAA.NumSamples);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.ArraySpacingSingleLod.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.ArraySpacingSingleLod);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.BaseAlignment.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.BaseAlignment);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.HAlign.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.HAlign);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.VAlign.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.VAlign);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.DAlign.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.DAlign);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.MipTailStartLod.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.MipTailStartLod);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipStartLod.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipStartLod);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipWidth.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipWidth);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipHeight.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.PackedMipHeight);
    dst.GmmResourceInfoCommon.AuxSurf.Alignment.QPitch.setValue(src.GmmResourceInfoCommon.AuxSurf.Alignment.QPitch);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.MmcMode.getValue<char>(), dst.GmmResourceInfoCommon.AuxSurf.MmcMode.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSurf.MmcMode, sizeof(src.GmmResourceInfoCommon.AuxSurf.MmcMode));
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.MmcHint.getValue<char>(), dst.GmmResourceInfoCommon.AuxSurf.MmcHint.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSurf.MmcHint, sizeof(src.GmmResourceInfoCommon.AuxSurf.MmcHint));
    dst.GmmResourceInfoCommon.AuxSurf.Pitch.setValue(src.GmmResourceInfoCommon.AuxSurf.Pitch);
    dst.GmmResourceInfoCommon.AuxSurf.OverridePitch.setValue(src.GmmResourceInfoCommon.AuxSurf.OverridePitch);
    dst.GmmResourceInfoCommon.AuxSurf.Size.setValue(src.GmmResourceInfoCommon.AuxSurf.Size);
    dst.GmmResourceInfoCommon.AuxSurf.CCSize.setValue(src.GmmResourceInfoCommon.AuxSurf.CCSize);
    dst.GmmResourceInfoCommon.AuxSurf.UnpaddedSize.setValue(src.GmmResourceInfoCommon.AuxSurf.UnpaddedSize);
    dst.GmmResourceInfoCommon.AuxSurf.SizeReportToOS.setValue(src.GmmResourceInfoCommon.AuxSurf.SizeReportToOS);
    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch.setValue(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset.getValue<char>(), dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture3DOffsetInfo.Offset));
    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock.setValue(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock);
    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender.setValue(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset.getValue<char>(), dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Texture2DOffsetInfo.Offset));
    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.ArrayQPitch.setValue(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.ArrayQPitch);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.X.getValue<char>(), dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.X.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.X, sizeof(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.X));
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.Y.getValue<char>(), dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.Y.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.Y, sizeof(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.Y));
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.UnAligned.Height.getValue<char>(), dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.UnAligned.Height.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.UnAligned.Height, sizeof(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.UnAligned.Height));
    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.NoOfPlanes.setValue(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.NoOfPlanes);
    dst.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.IsTileAlignedPlanes.setValue(src.GmmResourceInfoCommon.AuxSurf.OffsetInfo.Plane.IsTileAlignedPlanes);
    dst.GmmResourceInfoCommon.AuxSurf.TileMode.setValue(src.GmmResourceInfoCommon.AuxSurf.TileMode);
    dst.GmmResourceInfoCommon.AuxSurf.CCSModeAlign.setValue(src.GmmResourceInfoCommon.AuxSurf.CCSModeAlign);
    dst.GmmResourceInfoCommon.AuxSurf.LegacyFlags.setValue(src.GmmResourceInfoCommon.AuxSurf.LegacyFlags);
    dst.GmmResourceInfoCommon.AuxSurf.S3d.DisplayModeHeight.setValue(src.GmmResourceInfoCommon.AuxSurf.S3d.DisplayModeHeight);
    dst.GmmResourceInfoCommon.AuxSurf.S3d.NumBlankActiveLines.setValue(src.GmmResourceInfoCommon.AuxSurf.S3d.NumBlankActiveLines);
    dst.GmmResourceInfoCommon.AuxSurf.S3d.RFrameOffset.setValue(src.GmmResourceInfoCommon.AuxSurf.S3d.RFrameOffset);
    dst.GmmResourceInfoCommon.AuxSurf.S3d.BlankAreaOffset.setValue(src.GmmResourceInfoCommon.AuxSurf.S3d.BlankAreaOffset);
    dst.GmmResourceInfoCommon.AuxSurf.S3d.TallBufferHeight.setValue(src.GmmResourceInfoCommon.AuxSurf.S3d.TallBufferHeight);
    dst.GmmResourceInfoCommon.AuxSurf.S3d.TallBufferSize.setValue(src.GmmResourceInfoCommon.AuxSurf.S3d.TallBufferSize);
    dst.GmmResourceInfoCommon.AuxSurf.S3d.IsRFrame.setValue(src.GmmResourceInfoCommon.AuxSurf.S3d.IsRFrame);
    dst.GmmResourceInfoCommon.AuxSurf.SegmentOverride.Seg1.setValue(src.GmmResourceInfoCommon.AuxSurf.SegmentOverride.Seg1);
    dst.GmmResourceInfoCommon.AuxSurf.SegmentOverride.Evict.setValue(src.GmmResourceInfoCommon.AuxSurf.SegmentOverride.Evict);
    dst.GmmResourceInfoCommon.AuxSurf.MaximumRenamingListLength.setValue(src.GmmResourceInfoCommon.AuxSurf.MaximumRenamingListLength);
#if _DEBUG || _RELEASE_INTERNAL
    dst.GmmResourceInfoCommon.AuxSurf.Platform.eProductFamily.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.eProductFamily);
    dst.GmmResourceInfoCommon.AuxSurf.Platform.ePCHProductFamily.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.ePCHProductFamily);
    dst.GmmResourceInfoCommon.AuxSurf.Platform.eDisplayCoreFamily.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.eDisplayCoreFamily);
    dst.GmmResourceInfoCommon.AuxSurf.Platform.eRenderCoreFamily.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.eRenderCoreFamily);
    dst.GmmResourceInfoCommon.AuxSurf.Platform.ePlatformType.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.ePlatformType);
    dst.GmmResourceInfoCommon.AuxSurf.Platform.usDeviceID.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.usDeviceID);
    dst.GmmResourceInfoCommon.AuxSurf.Platform.usRevId.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.usRevId);
    dst.GmmResourceInfoCommon.AuxSurf.Platform.usDeviceID_PCH.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.usDeviceID_PCH);
    dst.GmmResourceInfoCommon.AuxSurf.Platform.usRevId_PCH.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.usRevId_PCH);
    dst.GmmResourceInfoCommon.AuxSurf.Platform.eGTType.setValue(src.GmmResourceInfoCommon.AuxSurf.Platform.eGTType);
#endif
    dst.GmmResourceInfoCommon.AuxSurf.ExistingSysMem.IsGmmAllocated.setValue(src.GmmResourceInfoCommon.AuxSurf.ExistingSysMem.IsGmmAllocated);
    dst.GmmResourceInfoCommon.AuxSurf.ExistingSysMem.IsPageAligned.setValue(src.GmmResourceInfoCommon.AuxSurf.ExistingSysMem.IsPageAligned);
#if !(_DEBUG || _RELEASE_INTERNAL)
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.eProductFamily.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.eProductFamily);
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.ePCHProductFamily.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.ePCHProductFamily);
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.eDisplayCoreFamily.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.eDisplayCoreFamily);
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.eRenderCoreFamily.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.eRenderCoreFamily);
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.ePlatformType.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.ePlatformType);
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.usDeviceID.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.usDeviceID);
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.usRevId.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.usRevId);
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.usDeviceID_PCH.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.usDeviceID_PCH);
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.usRevId_PCH.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.usRevId_PCH);
    dst.GmmResourceInfoCommon.AuxSurf.__Platform.eGTType.setValue(src.GmmResourceInfoCommon.AuxSurf.__Platform.eGTType);
#endif
    dst.GmmResourceInfoCommon.AuxSecSurf.Type.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Type);
    dst.GmmResourceInfoCommon.AuxSecSurf.Format.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Format);
    dst.GmmResourceInfoCommon.AuxSecSurf.BitsPerPixel.setValue(src.GmmResourceInfoCommon.AuxSecSurf.BitsPerPixel);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.CameraCapture.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.CameraCapture);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.CCS.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.CCS);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ColorDiscard.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ColorDiscard);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ColorSeparation.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ColorSeparation);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ColorSeparationRGBX.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ColorSeparationRGBX);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Constant.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Constant);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Depth.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Depth);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.FlipChain.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.FlipChain);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.FlipChainPreferred.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.FlipChainPreferred);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.HistoryBuffer.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.HistoryBuffer);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.HiZ.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.HiZ);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Index.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Index);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.IndirectClearColor.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.IndirectClearColor);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.InstructionFlat.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.InstructionFlat);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.InterlacedScan.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.InterlacedScan);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.MCS.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.MCS);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.MMC.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.MMC);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.MotionComp.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.MotionComp);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.NoRestriction.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.NoRestriction);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Overlay.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Overlay);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Presentable.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Presentable);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ProceduralTexture.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ProceduralTexture);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Query.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Query);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.RenderTarget.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.RenderTarget);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.S3d.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.S3d);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.S3dDx.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.S3dDx);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__S3dNonPacked.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__S3dNonPacked);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__S3dWidi.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__S3dWidi);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ScratchFlat.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.ScratchFlat);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.SeparateStencil.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.SeparateStencil);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.State.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.State);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.StateDx9ConstantBuffer.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.StateDx9ConstantBuffer);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Stream.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Stream);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.TextApi.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.TextApi);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Texture.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Texture);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.TiledResource.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.TiledResource);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.TilePool.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.TilePool);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.UnifiedAuxSurface.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.UnifiedAuxSurface);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Vertex.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Vertex);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Video.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.Video);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__NonMsaaTileXCcs.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__NonMsaaTileXCcs);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__NonMsaaTileYCcs.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__NonMsaaTileYCcs);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__MsaaTileMcs.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__MsaaTileMcs);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__NonMsaaLinearCCS.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__NonMsaaLinearCCS);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__Remaining.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Gpu.__Remaining);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.AllowVirtualPadding.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.AllowVirtualPadding);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.BigPage.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.BigPage);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Cacheable.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Cacheable);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.ContigPhysMemoryForiDART.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.ContigPhysMemoryForiDART);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.CornerTexelMode.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.CornerTexelMode);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.ExistingSysMem.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.ExistingSysMem);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.ForceResidency.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.ForceResidency);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Gfdt.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Gfdt);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.GttMapType.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.GttMapType);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.HardwareProtected.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.HardwareProtected);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.KernelModeMapped.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.KernelModeMapped);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.LayoutBelow.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.LayoutBelow);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.LayoutMono.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.LayoutMono);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.LayoutRight.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.LayoutRight);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.LocalOnly.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.LocalOnly);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Linear.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Linear);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.MediaCompressed.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.MediaCompressed);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.NoOptimizationPadding.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.NoOptimizationPadding);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.NoPhysMemory.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.NoPhysMemory);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.NotLockable.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.NotLockable);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.NonLocalOnly.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.NonLocalOnly);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.StdSwizzle.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.StdSwizzle);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.PseudoStdSwizzle.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.PseudoStdSwizzle);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Undefined64KBSwizzle.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Undefined64KBSwizzle);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.RedecribedPlanes.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.RedecribedPlanes);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.RenderCompressed.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.RenderCompressed);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Rotated.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Rotated);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Shared.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Shared);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.SoftwareProtected.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.SoftwareProtected);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.SVM.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.SVM);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Tile4.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Tile4);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Tile64.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.Tile64);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledW.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledW);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledX.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledX);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledY.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledY);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledYf.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledYf);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledYs.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.TiledYs);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.WddmProtected.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.WddmProtected);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.XAdapter.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.XAdapter);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.__PreallocatedResInfo.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.__PreallocatedResInfo);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.__PreWddm2SVM.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Info.__PreWddm2SVM);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.GTMfx2ndLevelBatchRingSizeAlign);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.ILKNeedAvcMprRowStore32KAlign);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.ILKNeedAvcDmvBuffer32KAlign);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.NoBufferSamplerPadding.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.NoBufferSamplerPadding);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.NoLegacyPlanarLinearVideoRestrictions);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.CHVAstcSkipVirtualMips.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.CHVAstcSkipVirtualMips);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.DisablePackedMipTail.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.DisablePackedMipTail);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.__ForceOtherHVALIGN4.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.__ForceOtherHVALIGN4);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.DisableDisplayCcsClearColor.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.DisableDisplayCcsClearColor);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.DisableDisplayCcsCompression.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.DisableDisplayCcsCompression);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.PreGen12FastClearOnly.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.PreGen12FastClearOnly);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.ForceStdAllocAlign.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.ForceStdAllocAlign);
    dst.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.DeniableLocalOnlyForCompression.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Flags.Wa.DeniableLocalOnlyForCompression);
    dst.GmmResourceInfoCommon.AuxSecSurf.BaseWidth.setValue(src.GmmResourceInfoCommon.AuxSecSurf.BaseWidth);
    dst.GmmResourceInfoCommon.AuxSecSurf.BaseHeight.setValue(src.GmmResourceInfoCommon.AuxSecSurf.BaseHeight);
    dst.GmmResourceInfoCommon.AuxSecSurf.Depth.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Depth);
    dst.GmmResourceInfoCommon.AuxSecSurf.MaxLod.setValue(src.GmmResourceInfoCommon.AuxSecSurf.MaxLod);
    dst.GmmResourceInfoCommon.AuxSecSurf.ArraySize.setValue(src.GmmResourceInfoCommon.AuxSecSurf.ArraySize);
    dst.GmmResourceInfoCommon.AuxSecSurf.CpTag.setValue(src.GmmResourceInfoCommon.AuxSecSurf.CpTag);
    dst.GmmResourceInfoCommon.AuxSecSurf.CachePolicy.Usage.setValue(src.GmmResourceInfoCommon.AuxSecSurf.CachePolicy.Usage);
    dst.GmmResourceInfoCommon.AuxSecSurf.MSAA.SamplePattern.setValue(src.GmmResourceInfoCommon.AuxSecSurf.MSAA.SamplePattern);
    dst.GmmResourceInfoCommon.AuxSecSurf.MSAA.NumSamples.setValue(src.GmmResourceInfoCommon.AuxSecSurf.MSAA.NumSamples);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.ArraySpacingSingleLod.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.ArraySpacingSingleLod);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.BaseAlignment.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.BaseAlignment);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.HAlign.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.HAlign);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.VAlign.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.VAlign);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.DAlign.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.DAlign);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.MipTailStartLod.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.MipTailStartLod);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.PackedMipStartLod.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.PackedMipStartLod);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.PackedMipWidth.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.PackedMipWidth);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.PackedMipHeight.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.PackedMipHeight);
    dst.GmmResourceInfoCommon.AuxSecSurf.Alignment.QPitch.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Alignment.QPitch);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSecSurf.MmcMode.getValue<char>(), dst.GmmResourceInfoCommon.AuxSecSurf.MmcMode.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSecSurf.MmcMode, sizeof(src.GmmResourceInfoCommon.AuxSecSurf.MmcMode));
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSecSurf.MmcHint.getValue<char>(), dst.GmmResourceInfoCommon.AuxSecSurf.MmcHint.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSecSurf.MmcHint, sizeof(src.GmmResourceInfoCommon.AuxSecSurf.MmcHint));
    dst.GmmResourceInfoCommon.AuxSecSurf.Pitch.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Pitch);
    dst.GmmResourceInfoCommon.AuxSecSurf.OverridePitch.setValue(src.GmmResourceInfoCommon.AuxSecSurf.OverridePitch);
    dst.GmmResourceInfoCommon.AuxSecSurf.Size.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Size);
    dst.GmmResourceInfoCommon.AuxSecSurf.CCSize.setValue(src.GmmResourceInfoCommon.AuxSecSurf.CCSize);
    dst.GmmResourceInfoCommon.AuxSecSurf.UnpaddedSize.setValue(src.GmmResourceInfoCommon.AuxSecSurf.UnpaddedSize);
    dst.GmmResourceInfoCommon.AuxSecSurf.SizeReportToOS.setValue(src.GmmResourceInfoCommon.AuxSecSurf.SizeReportToOS);
    dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch.setValue(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Mip0SlicePitch);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset.getValue<char>(), dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset, sizeof(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture3DOffsetInfo.Offset));
    dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock.setValue(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchLock);
    dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender.setValue(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.ArrayQPitchRender);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset.getValue<char>(), dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset, sizeof(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Texture2DOffsetInfo.Offset));
    dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.ArrayQPitch.setValue(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.ArrayQPitch);
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.X.getValue<char>(), dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.X.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.X, sizeof(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.X));
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.Y.getValue<char>(), dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.Y.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.Y, sizeof(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.Y));
    WCH_SAFE_COPY(dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height.getValue<char>(), dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height.getValueSizeInBytes(), src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height, sizeof(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.UnAligned.Height));
    dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.NoOfPlanes.setValue(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.NoOfPlanes);
    dst.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.IsTileAlignedPlanes.setValue(src.GmmResourceInfoCommon.AuxSecSurf.OffsetInfo.Plane.IsTileAlignedPlanes);
    dst.GmmResourceInfoCommon.AuxSecSurf.TileMode.setValue(src.GmmResourceInfoCommon.AuxSecSurf.TileMode);
    dst.GmmResourceInfoCommon.AuxSecSurf.CCSModeAlign.setValue(src.GmmResourceInfoCommon.AuxSecSurf.CCSModeAlign);
    dst.GmmResourceInfoCommon.AuxSecSurf.LegacyFlags.setValue(src.GmmResourceInfoCommon.AuxSecSurf.LegacyFlags);
    dst.GmmResourceInfoCommon.AuxSecSurf.S3d.DisplayModeHeight.setValue(src.GmmResourceInfoCommon.AuxSecSurf.S3d.DisplayModeHeight);
    dst.GmmResourceInfoCommon.AuxSecSurf.S3d.NumBlankActiveLines.setValue(src.GmmResourceInfoCommon.AuxSecSurf.S3d.NumBlankActiveLines);
    dst.GmmResourceInfoCommon.AuxSecSurf.S3d.RFrameOffset.setValue(src.GmmResourceInfoCommon.AuxSecSurf.S3d.RFrameOffset);
    dst.GmmResourceInfoCommon.AuxSecSurf.S3d.BlankAreaOffset.setValue(src.GmmResourceInfoCommon.AuxSecSurf.S3d.BlankAreaOffset);
    dst.GmmResourceInfoCommon.AuxSecSurf.S3d.TallBufferHeight.setValue(src.GmmResourceInfoCommon.AuxSecSurf.S3d.TallBufferHeight);
    dst.GmmResourceInfoCommon.AuxSecSurf.S3d.TallBufferSize.setValue(src.GmmResourceInfoCommon.AuxSecSurf.S3d.TallBufferSize);
    dst.GmmResourceInfoCommon.AuxSecSurf.S3d.IsRFrame.setValue(src.GmmResourceInfoCommon.AuxSecSurf.S3d.IsRFrame);
    dst.GmmResourceInfoCommon.AuxSecSurf.SegmentOverride.Seg1.setValue(src.GmmResourceInfoCommon.AuxSecSurf.SegmentOverride.Seg1);
    dst.GmmResourceInfoCommon.AuxSecSurf.SegmentOverride.Evict.setValue(src.GmmResourceInfoCommon.AuxSecSurf.SegmentOverride.Evict);
    dst.GmmResourceInfoCommon.AuxSecSurf.MaximumRenamingListLength.setValue(src.GmmResourceInfoCommon.AuxSecSurf.MaximumRenamingListLength);
#if _DEBUG || _RELEASE_INTERNAL
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.eProductFamily.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.eProductFamily);
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.ePCHProductFamily.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.ePCHProductFamily);
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.eDisplayCoreFamily.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.eDisplayCoreFamily);
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.eRenderCoreFamily.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.eRenderCoreFamily);
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.ePlatformType.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.ePlatformType);
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.usDeviceID.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.usDeviceID);
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.usRevId.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.usRevId);
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.usDeviceID_PCH.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.usDeviceID_PCH);
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.usRevId_PCH.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.usRevId_PCH);
    dst.GmmResourceInfoCommon.AuxSecSurf.Platform.eGTType.setValue(src.GmmResourceInfoCommon.AuxSecSurf.Platform.eGTType);
#endif
    dst.GmmResourceInfoCommon.AuxSecSurf.ExistingSysMem.IsGmmAllocated.setValue(src.GmmResourceInfoCommon.AuxSecSurf.ExistingSysMem.IsGmmAllocated);
    dst.GmmResourceInfoCommon.AuxSecSurf.ExistingSysMem.IsPageAligned.setValue(src.GmmResourceInfoCommon.AuxSecSurf.ExistingSysMem.IsPageAligned);
#if !(_DEBUG || _RELEASE_INTERNAL)
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.eProductFamily.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.eProductFamily);
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.ePCHProductFamily.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.ePCHProductFamily);
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.eDisplayCoreFamily.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.eDisplayCoreFamily);
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.eRenderCoreFamily.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.eRenderCoreFamily);
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.ePlatformType.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.ePlatformType);
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.usDeviceID.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.usDeviceID);
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.usRevId.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.usRevId);
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.usDeviceID_PCH.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.usDeviceID_PCH);
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.usRevId_PCH.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.usRevId_PCH);
    dst.GmmResourceInfoCommon.AuxSecSurf.__Platform.eGTType.setValue(src.GmmResourceInfoCommon.AuxSecSurf.__Platform.eGTType);
#endif
    dst.GmmResourceInfoCommon.RotateInfo.setValue(src.GmmResourceInfoCommon.RotateInfo);
    dst.GmmResourceInfoCommon.ExistingSysMem.pExistingSysMem.setValue(src.GmmResourceInfoCommon.ExistingSysMem.pExistingSysMem);
    dst.GmmResourceInfoCommon.ExistingSysMem.pVirtAddress.setValue(src.GmmResourceInfoCommon.ExistingSysMem.pVirtAddress);
    dst.GmmResourceInfoCommon.ExistingSysMem.pGfxAlignedVirtAddress.setValue(src.GmmResourceInfoCommon.ExistingSysMem.pGfxAlignedVirtAddress);
    dst.GmmResourceInfoCommon.ExistingSysMem.Size.setValue(src.GmmResourceInfoCommon.ExistingSysMem.Size);
    dst.GmmResourceInfoCommon.ExistingSysMem.IsGmmAllocated.setValue(src.GmmResourceInfoCommon.ExistingSysMem.IsGmmAllocated);
    dst.GmmResourceInfoCommon.SvmAddress.setValue(src.GmmResourceInfoCommon.SvmAddress);
    dst.GmmResourceInfoCommon.pPrivateData.setValue(src.GmmResourceInfoCommon.pPrivateData);
    dst.GmmResourceInfoCommon.MultiTileArch.Enable.setValue(src.GmmResourceInfoCommon.MultiTileArch.Enable);
    dst.GmmResourceInfoCommon.MultiTileArch.TileInstanced.setValue(src.GmmResourceInfoCommon.MultiTileArch.TileInstanced);
    dst.GmmResourceInfoCommon.MultiTileArch.GpuVaMappingSet.setValue(src.GmmResourceInfoCommon.MultiTileArch.GpuVaMappingSet);
    dst.GmmResourceInfoCommon.MultiTileArch.LocalMemEligibilitySet.setValue(src.GmmResourceInfoCommon.MultiTileArch.LocalMemEligibilitySet);
    dst.GmmResourceInfoCommon.MultiTileArch.LocalMemPreferredSet.setValue(src.GmmResourceInfoCommon.MultiTileArch.LocalMemPreferredSet);
}
template <>
struct Marshaller<TOK_S_GMM_RESOURCE_INFO_WIN_STRUCT> {
    template <typename GmmResourceInfoWinStructT>
    static TOKSTR_GmmResourceInfoWinStruct marshall(const GmmResourceInfoWinStructT &src) {
        TOKSTR_GmmResourceInfoWinStruct ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GFX_ESCAPE_HEADERT>
inline void marshall(TOKSTR_GFX_ESCAPE_HEADER &dst, const GFX_ESCAPE_HEADERT &src) {
    dst = {};
    dst.Size.setValue(src.Size);
    dst.CheckSum.setValue(src.CheckSum);
    dst.EscapeCode.setValue(src.EscapeCode);
    dst.ulReserved.setValue(src.ulReserved);
    dst.ulReserved1.setValue(src.ulReserved1);
    dst.usEscapeVersion.setValue(src.usEscapeVersion);
    dst.usFileVersion.setValue(src.usFileVersion);
    dst.ulMajorEscapeCode.setValue(src.ulMajorEscapeCode);
    dst.uiMinorEscapeCode.setValue(src.uiMinorEscapeCode);
}
template <>
struct Marshaller<TOK_S_GFX_ESCAPE_HEADER> {
    template <typename GFX_ESCAPE_HEADERT>
    static TOKSTR_GFX_ESCAPE_HEADER marshall(const GFX_ESCAPE_HEADERT &src) {
        TOKSTR_GFX_ESCAPE_HEADER ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GTDIBaseInStructT>
inline void marshall(TOKSTR_GTDIBaseInStruct &dst, const GTDIBaseInStructT &src) {
    dst = {};
    dst.Function.setValue(src.Function);
}
template <>
struct Marshaller<TOK_S_GTDIBASE_IN_STRUCT> {
    template <typename GTDIBaseInStructT>
    static TOKSTR_GTDIBaseInStruct marshall(const GTDIBaseInStructT &src) {
        TOKSTR_GTDIBaseInStruct ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename GTDIGetGpuCpuTimestampsOutStructT>
inline void marshall(TOKSTR_GTDIGetGpuCpuTimestampsOutStruct &dst, const GTDIGetGpuCpuTimestampsOutStructT &src) {
    dst = {};
    dst.RetCode.setValue(src.RetCode);
    dst.gpuPerfTicks.setValue(src.gpuPerfTicks);
    dst.cpuPerfTicks.setValue(src.cpuPerfTicks);
    dst.gpuPerfFreq.setValue(src.gpuPerfFreq);
    dst.cpuPerfFreq.setValue(src.cpuPerfFreq);
}
template <>
struct Marshaller<TOK_S_GTDIGET_GPU_CPU_TIMESTAMPS_OUT_STRUCT> {
    template <typename GTDIGetGpuCpuTimestampsOutStructT>
    static TOKSTR_GTDIGetGpuCpuTimestampsOutStruct marshall(const GTDIGetGpuCpuTimestampsOutStructT &src) {
        TOKSTR_GTDIGetGpuCpuTimestampsOutStruct ret = {};
        ::marshall(ret, src);
        return ret;
    }
};

template <typename TimeStampDataHeaderT>
inline void marshall(TOKSTR_TimeStampDataHeader &dst, const TimeStampDataHeaderT &src) {
    dst = {};
    dst.m_Header.Size.setValue(src.m_Header.Size);
    dst.m_Header.CheckSum.setValue(src.m_Header.CheckSum);
    dst.m_Header.EscapeCode.setValue(src.m_Header.EscapeCode);
    dst.m_Header.ulReserved.setValue(src.m_Header.ulReserved);
    dst.m_Header.ulReserved1.setValue(src.m_Header.ulReserved1);
    dst.m_Header.usEscapeVersion.setValue(src.m_Header.usEscapeVersion);
    dst.m_Header.usFileVersion.setValue(src.m_Header.usFileVersion);
    dst.m_Header.ulMajorEscapeCode.setValue(src.m_Header.ulMajorEscapeCode);
    dst.m_Header.uiMinorEscapeCode.setValue(src.m_Header.uiMinorEscapeCode);
    dst.m_Data.m_In.Function.setValue(src.m_Data.m_In.Function);
    dst.m_Data.m_Out.RetCode.setValue(src.m_Data.m_Out.RetCode);
    dst.m_Data.m_Out.gpuPerfTicks.setValue(src.m_Data.m_Out.gpuPerfTicks);
    dst.m_Data.m_Out.cpuPerfTicks.setValue(src.m_Data.m_Out.cpuPerfTicks);
    dst.m_Data.m_Out.gpuPerfFreq.setValue(src.m_Data.m_Out.gpuPerfFreq);
    dst.m_Data.m_Out.cpuPerfFreq.setValue(src.m_Data.m_Out.cpuPerfFreq);
}
template <>
struct Marshaller<TOK_S_TIME_STAMP_DATA_HEADER> {
    template <typename TimeStampDataHeaderT>
    static TOKSTR_TimeStampDataHeader marshall(const TimeStampDataHeaderT &src) {
        TOKSTR_TimeStampDataHeader ret = {};
        ::marshall(ret, src);
        return ret;
    }
};
