/***************************************
  $Header: /cvs/src/jbofihe/errorscan.c,v 1.1 2000/04/19 21:30:01 richard Exp $

  Scan syntax tree for suspicious constructions that are hard to
  detect during the parse phase.
  ***************************************/

/**********************************************************************
 * Copyright (C) Richard P. Curnow  1998-2001
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 *********************************************************************/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "functions.h"

/* ================================================== */

void
error_scan(TreeNode *x)
{
  struct nonterm *nt;
  TreeNode *c;
  int i, nc;

  if (x->type == N_NONTERM) {
    nt = &x->data.nonterm;
    nc = nt->nchildren;
    for (i=0; i<nc; i++) {
      c = nt->children[i];
      error_scan(c);
    }

    if (nt->type == FRAGMENT) {
      TreeNode *c1;
      c1 = child_ref(x, 0);
      if ((c1->type == N_NONTERM) &&
          (c1->data.nonterm.type == TERMS)) {
        fprintf(stderr, "Warning: Sentence may be missing selbri at line %d column %d?\n",
                x->start_line, x->start_column);
      }
    }


  } else {
    

  }

}

/* ================================================== */
