/***************************************
  $Header: /cvs/src/jbofihe/output.h,v 1.2 2001/05/28 21:30:15 richard Exp $

  Header file shared between generic output code and the backend
  drivers.
  ***************************************/

/**********************************************************************
 * Copyright (C) Richard P. Curnow  1998-2001
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 *********************************************************************/

#ifndef OUTPUT_H
#define OUTPUT_H    /*+ To stop multiple inclusions. +*/

#include "nodes.h"

typedef struct {
  void (*initialise)(void);
  void (*prologue)(void);
  void (*epilogue)(void);
  void (*open_bracket)(BracketType type, int subscript);
  void (*close_bracket)(BracketType type, int subscript);
  void (*set_eols)(int);
  void (*lojban_text)(char *);
  void (*translation)(char *);
  void (*start_tags)(void);
  void (*end_tags)(void);
  void (*start_tag)(void);
  void (*write_tag_text)(char *, char *, char *, int);
  void (*write_partial_tag_text)(char *);
} DriverVector;

#endif /* OUTPUT_H */
