Jane Street Build Tools
=======================

This repository contains a few helpers that are used to build Jane
Street packages.

## opam2oasis_install

This is a small library that we use to generate opam `.install` files
from the `setup.log` file generated by oasis.

We don't use oasis for installing files as it is hard to change the
destination directory dynamically; you need to fiddle with ocamlfind
variables and a few other things. On the contrary `opam-installer` is
very convenient for that.

To use it you need to create a small OCaml script and invoke it after
a successful compilation. You can look at any Jane Street package to
see an example of use. We always name this script `install.ml` and use
these rules in our makefiles:

```makefile
SETUP := setup.exe
NAME := core_kernel
PREFIX = $(shell grep ^prefix= setup.data | cut -d\" -f 2)

build: $(SETUP) setup.data
	./$(SETUP) -build $(BUILDFLAGS)
	$(MAKE) $(NAME).install

$(NAME).install: install.ml setup.log setup.data
	ocaml -I "$(OCAML_TOPLEVEL_PATH)" install.ml

install: $(NAME).install
	opam-installer -i --prefix $(PREFIX) $(NAME).install

uninstall: $(NAME).install
	opam-installer -u --prefix $(PREFIX) $(NAME).install

```

For instance here is the `install.ml` file for
[core_kernel](https://github.com/janestreet/core_kernel):

```ocaml
#use "topfind";;
#require "js-build-tools.oasis2opam_install";;

open Oasis2opam_install;;

generate ~package:"core_kernel"
  [ oasis_lib "core_kernel"
  ; file "META" ~section:"lib"
  ; file "include/core_params.h" ~section:"lib"
  ; file "include/jane_common.h" ~section:"lib"
  ; file "include/ocaml_utils.h" ~section:"lib"
  ; file "include/unix_utils.h" ~section:"lib"
  ; file "src/time_ns_stubs.h" ~section:"lib"
  ; file "_build/namespace_wrappers/result_lib.cmi" ~section:"lib"
  ]
```

To see what you can use, you can look at the
[API](oasis2opam-install/oasis2opam_install.mli).

## `js-build-tools.ocamlbuild_goodies`

This is an ocamlbuild plugin containing several hacks and utilities
that we often need.

The most interesting bit is `track_external_deps`, it setup things so
that ocamlbuild tracks ocamlfind packages. For instance you are
working on two packages `a` and `b` simultaneously and `b` depends on
`a`, whenever you reinstall `a` you would normally need to do `make
clean` in `b`. With this plugin you don't need to, ocamlbuild will
properly rebuild things in `b` if needed.
