/* k3d_constants.h
 *  various constants or "magic" numbers
 * see http://en.wikipedia.org/wiki/Mathematical_constant
 *  2006-03-13 dan@3-e.net
 *
 * need to check the max number of digits.
 * need to make case of names uniform.
 * Some of these may be in a Math.h else where...
 */


#define M_E 2.7182818284590452354	/* e, euler's number */
#define Euler 0.57721566490153286060651209008240243 /* Y, Euler-Mascheroni constant */

#define GoldenRatio  1.61803398874989484820458683436563811  /* the Golden Ratio */

#define Pi 3.14159265358979323846264338327950288 /* Pi , Archimedes' constant or Ludolph's number */
#define TWOPI (2*Pi)

#define VERY_SMALL 0.0001


