//--------------------------------------------------------------------------
//
// "" for ʳβʳβ
// 
//
//      Programed by Suikyo
//
//  2002.04.18  Phase 8.0.0   ľ
//
//--------------------------------------------------------------------------
#ifndef LEXER_H__
#define LEXER_H__
//--------------------------------------------------------------------------
#include "config.h"
//--------------------------------------------------------------------------
#include "libkawari/kawari_log.h"
//--------------------------------------------------------------------------
#include <iostream>
#include <string>
#include <vector>
//--------------------------------------------------------------------------
class Token;
class TKawariLexer;
class TKawariPreProcessor;
//--------------------------------------------------------------------------
class Token {
public:
	// üʸϡʸɤΤޤintˤʤä֤롣
	enum Type {
		T_ERROR = 0x100,	//
		T_LITERAL,		//
		T_QLITERAL,		//
		T_SPACE,		// ' ', '\t'
		T_EOL,			// CR, LF, CRLF
		T_SPECIAL,		// special marks (in peek() only)
		T_MODESWITCH,	// '=xxxxx'
		T_EOF,
		T_DUMMY
	} type;
	std::string str;
	Token (Type t, const std::string &s) : type(t), str(s) {}
	Token (void) : type(T_DUMMY), str("") {}
	Token &set (Type t) { type=t; return *this; }
	Token &set (const std::string &s) { str=s; return *this; }
	Token &set (Type t, const std::string &s)
		{ type=t; str=s; return *this; }
	Token &set (Type t, const char &ch)
		{ type=t; str+=ch; return *this; }
};

//-------------------------------------------------------------------------
// class TKawariLexer;
//
class TKawariLexer{
public:
	// 󥹥ȥ饯
	TKawariLexer (std::istream &input, TKawariLogger &lgr,
				  std::string filename="<unknown>",
				  bool preprocess=true, int lineno=0);

	// LexerΥ⡼
	enum Mode {
		ID_MODE = 0,			// ȥ̾⡼
		LITERAL_MODE = 1,		// ʸ⡼(ȥ)
		LITERAL_MODE2 = 2,		// ʸ⡼(饤󥹥ץ)
		LITERAL_MODE3 = 3		// ʸ⡼(֥å)
	};

	// Υȡ󤬤뤫
	bool hasNext(void);

	// ΥȡΥפ֤
	// ɤǥݥ󥿤ʤʤ
	// mode : LexerΥ⡼ɻ(LITERAL_MODE, ID_MODE)
	Token::Type peek(Mode mode=LITERAL_MODE);

	// Υȡ֤
	// mode : LexerΥ⡼ɻ(LITERAL_MODE, ID_MODE)
	Token next(Mode mode=LITERAL_MODE);

	// !!! check type before use this !!!
	// Υƥȡ֤
	// ٥ƥǤʤä顢""֤롣ͽʬäƤˤȤȡ
	// mode : LexerΥ⡼ɻ(LITERAL_MODE, ID_MODE)
	std::string getLiteral(Mode mode=LITERAL_MODE);

	// !!! check type, before use this !!!
	// Υȥƥȡ(ǥ)֤
	// ȥƥǤʤä""֤롣
	std::string getQuotedLiteral(void);

	// !!! check type before use this !!!
	// [0-9]+
	// ʸ
	std::string getDecimalLiteral(void);

	// 1ʸå
	int skip(void);

	// ʸμޤǥå (ʸˡ顼)
	// noret : Ԥʤtrue
	bool simpleSkipTo(char ch, bool noret=true);

	// ե֤̾
	const std::string &getFileName(void) const;

	// ߤιֹ֤
	int getLineNo(void) const;

	// ߹ԤλĤ֤
	std::string getRestOfLine(void);

	// ⡼ɥåΥꥻå
	inline void ResetModeSwitch(void);

	// ӥ᥽å
	// (ʸȲʸ)ΥȡɤФ
	void skipWS(void);

	// ӥ᥽å
	// (ʸȲʸ)ΥȡɤФ
	// μΥȡΥפ֤
	Token::Type skipWS(Mode m);

	// ӥ᥽å
	// ʸΥȡɤФμΥȡΥפ֤
	// ʸФʤ
	Token::Type skipS(Mode m=LITERAL_MODE);

	// Ĺ꡼ɥݥ󥿤᤹
	bool UngetChars(unsigned int length);

	// ӥ᥽å
	// ʸǥ
	static std::string DecodeQuotedString(const std::string &orgsen);

	// ӥ᥽å
	// ʸ򥨥ȥ̾ǻѲǽʸ˥󥳡ɤ
	static std::string EncodeEntryName(const std::string &orgsen);

	~TKawariLexer ();

	// ѥ륨顼
	void error(const std::string &message);

	// ѥ륨顼
	void warning(const std::string &message);

private:
	// ʸȡ󥿥פ
	Token::Type checkType(Mode m, char ch) const;

	class TKawariPreProcessor *pp;
	std::string fn;

	TKawariLogger &logger;
};
//---------------------------------------------------------------------------
// ץץå
//
class TKawariPreProcessor {
public:
	TKawariPreProcessor(std::istream &input, int lineno=0, bool preprocess=true)
		: is(input), pp(preprocess), mc(false), isMS(false), ln(lineno), pos(0) {}
	bool peek(char &ch);
	bool getch(char &ch);
	bool eof(void);
	std::string getline(void);
	bool unget(void);
	int getLineNo(void){ return ln; }

	int getColumn(void){ return pos; }

	// ХåեΰڤФ
	std::string substring(int index, int length);

	virtual ~TKawariPreProcessor() {}

	// ߡ⡼Ԥ
	bool IsWaitingModeSwitch(void){ return isMS; }

	// ⡼ɥե饰Υꥻå
	void ResetModeSwitch(void){ isMS=false; }

private:
	bool processNextLine(void);
	// ϥȥ꡼
	std::istream &is;
	// pre-process뤫ݤΥե饰
	bool pp;
	// ʣԥȤΥե饰
	bool mc;

	// Mode Switch
	bool isMS;
	// ߹ԤιԿ
	unsigned int ln;
	// ߥ
	unsigned int pos;
	// ϥХåե
	std::string linebuf;
};
//---------------------------------------------------------------------------
// Υȡ󤬤뤫
inline bool TKawariLexer::hasNext(void){
	return !pp->eof();
}
//---------------------------------------------------------------------------
inline void TKawariLexer::ResetModeSwitch(void){
	pp->ResetModeSwitch();
}
//---------------------------------------------------------------------------
inline void TKawariLexer::error(const std::string &message){
	logger.GetStream(kawari_log::LOG_ERROR) << getFileName() << " " << getLineNo()
		<< ": error: " << message << std::endl;
}
//---------------------------------------------------------------------------
inline void TKawariLexer::warning(const std::string &message){
	logger.GetStream(kawari_log::LOG_WARNING) << getFileName() << " " << getLineNo()
		<< ": warning: " << message << std::endl;
}
//---------------------------------------------------------------------------
inline bool TKawariPreProcessor::peek(char &ch){
	bool ret = getch(ch);
	unget();
	return ret;
}
//---------------------------------------------------------------------------
inline bool TKawariPreProcessor::getch(char &ch){
	if (pos>=linebuf.size())
		if (!processNextLine())
			return false;
	ch=linebuf[pos++];
	return true;
}
//---------------------------------------------------------------------------
inline bool TKawariPreProcessor::unget (void){
	if (pos==0) return false;
	pos--;
	return true;
}
//---------------------------------------------------------------------------
inline bool TKawariPreProcessor::eof (void){
	return ((pos>=linebuf.size())&&(is.eof()));
}
//---------------------------------------------------------------------------
#endif  // LEXER_H__
