/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.asJava.classes;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/asJava/ultraLightClasses")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class UltraLightClassLoadingTestGenerated extends AbstractUltraLightClassLoadingTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInUltraLightClasses() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/asJava/ultraLightClasses"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
    }

    @TestMetadata("annotations.kt")
    public void testAnnotations() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/annotations.kt");
    }

    @TestMetadata("classModifiers.kt")
    public void testClassModifiers() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/classModifiers.kt");
    }

    @TestMetadata("constructors.kt")
    public void testConstructors() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/constructors.kt");
    }

    @TestMetadata("coroutines.kt")
    public void testCoroutines() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/coroutines.kt");
    }

    @TestMetadata("dataClasses.kt")
    public void testDataClasses() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/dataClasses.kt");
    }

    @TestMetadata("delegatesWithAnnotations.kt")
    public void testDelegatesWithAnnotations() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/delegatesWithAnnotations.kt");
    }

    @TestMetadata("delegatingToInterfaces.kt")
    public void testDelegatingToInterfaces() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/delegatingToInterfaces.kt");
    }

    @TestMetadata("enums.kt")
    public void testEnums() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/enums.kt");
    }

    @TestMetadata("generics.kt")
    public void testGenerics() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/generics.kt");
    }

    @TestMetadata("implementingKotlinCollections.kt")
    public void testImplementingKotlinCollections() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/implementingKotlinCollections.kt");
    }

    @TestMetadata("importAliases.kt")
    public void testImportAliases() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/importAliases.kt");
    }

    @TestMetadata("inferringAnonymousObjectTypes.kt")
    public void testInferringAnonymousObjectTypes() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/inferringAnonymousObjectTypes.kt");
    }

    @TestMetadata("inheritance.kt")
    public void testInheritance() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/inheritance.kt");
    }

    @TestMetadata("inlineClasses.kt")
    public void testInlineClasses() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/inlineClasses.kt");
    }

    @TestMetadata("inlineOnly.kt")
    public void testInlineOnly() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/inlineOnly.kt");
    }

    @TestMetadata("jvmField.kt")
    public void testJvmField() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/jvmField.kt");
    }

    @TestMetadata("jvmName.kt")
    public void testJvmName() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/jvmName.kt");
    }

    @TestMetadata("jvmOverloads.kt")
    public void testJvmOverloads() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/jvmOverloads.kt");
    }

    @TestMetadata("jvmSynthetic.kt")
    public void testJvmSynthetic() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/jvmSynthetic.kt");
    }

    @TestMetadata("jvmWildcardAnnotations.kt")
    public void testJvmWildcardAnnotations() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/jvmWildcardAnnotations.kt");
    }

    @TestMetadata("lateinitProperty.kt")
    public void testLateinitProperty() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/lateinitProperty.kt");
    }

    @TestMetadata("objects.kt")
    public void testObjects() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/objects.kt");
    }

    @TestMetadata("properties.kt")
    public void testProperties() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/properties.kt");
    }

    @TestMetadata("simpleFunctions.kt")
    public void testSimpleFunctions() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/simpleFunctions.kt");
    }

    @TestMetadata("throwsAnnotation.kt")
    public void testThrowsAnnotation() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/throwsAnnotation.kt");
    }

    @TestMetadata("typeAliases.kt")
    public void testTypeAliases() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/typeAliases.kt");
    }

    @TestMetadata("wildcardOptimization.kt")
    public void testWildcardOptimization() throws Exception {
        runTest("compiler/testData/asJava/ultraLightClasses/wildcardOptimization.kt");
    }
}
