#!/bin/bash

if [ ! -d "src" ]; then
	echo "Usage: ./tools/`basename $0`"
	exit 1
fi

echo "Reading \"VERSION\"..."

KS_FILE_VERSION=$(sed 1!d VERSION)
KS_FULL_VERSION=$(sed 2!d VERSION)
KS_RELEASE_DATE=$(sed 3!d VERSION)

echo "Generating \"kshutdown.nsh\"..."

cat > "kshutdown.nsh" <<EOF
# Generated by $0, do not modify!
!define APP_FILE_VERSION "$KS_FILE_VERSION"
!define APP_FULL_VERSION "$KS_FULL_VERSION"
EOF

echo "Generating \"src/version.h\"..."

cat > "src/version.h" <<EOF
// Generated by $0, do not modify!
#ifndef KSHUTDOWN_VERSION_H
#define KSHUTDOWN_VERSION_H

#define KS_FILE_VERSION "$KS_FILE_VERSION"
#define KS_FULL_VERSION "$KS_FULL_VERSION"
#define KS_RELEASE_DATE "$KS_RELEASE_DATE"

#endif // KSHUTDOWN_VERSION_H
EOF

echo "File version (used in file names): \"$KS_FILE_VERSION\""
echo "Full version (used in UI)        : \"$KS_FULL_VERSION\""
echo "Release date (updated manually)  : \"$KS_RELEASE_DATE\""
