/***********************************************************************************

    Copyright (C) 2007-2018 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_APP_WINDOW_HEADER
#define LIFEOGRAPH_APP_WINDOW_HEADER

#define LIFEOGRAPH_DEVELOPMENT_VERSION


#include <gtkmm.h>

#include "helpers.hpp"
#include "settings.hpp"
#include "panel_main.hpp"
#include "panel_diary.hpp"
#include "widget_textview.hpp"
#include "dialog_export.hpp"
#include "view_entry.hpp"
#include "view_login.hpp"
#include "undo.hpp"


namespace LIFEO
{

class AppWindow : public Gtk::ApplicationWindow
{
    public:
        enum InfoResponse { RESP_OK = 10, RESP_UNDO_REMOVE_DIARY = 20 };

                                    AppWindow( BaseObjectType*,
                                               const Glib::RefPtr<Gtk::Builder>& );
                                    ~AppWindow();
        static AppWindow*           p;

        void                        update_title();

        bool                        confirm_dismiss_element( const DiaryElement*,
                                                             Gtk::Widget* = nullptr );
        Gtk::TreeRow                get_element_row( const DiaryElement* );

        void                        login();
        bool                        finish_editing( bool = true );
        void                        logout( bool );

        static void                 show_about();

        void                        show_info( Gtk::MessageType, const Glib::ustring&,
                                               const Glib::ustring& = "",
                                               InfoResponse = RESP_OK );
        void                        handle_infobar_response( int );
        void                        hide_infobar();


        bool                        write_backup();

        void                        handle_undo();
        void                        handle_redo();
        void                        handle_login();
        void                        handle_edit_enabled();
        void                        handle_logout();

        // AUTO LOGOUT FUNCTIONALITY
        bool                        handle_idle();
        void                        freeze_auto_logout();
        void                        unfreeze_auto_logout();
        void                        update_auto_logout_count_down();
        void                        disable_auto_logout_for_the_session();
        void                        reenable_auto_logout_for_the_session();
        bool                        is_auto_logout_in_use()
        { return( m_auto_logout_status == 0 ); }
        void                        handle_auto_logout_toggled();
        void                        update_toggle_auto_logout_gui( bool = false );

        bool                        on_event( GdkEvent* );

        // PANELS AND VIEWS
        PanelMain*                  panel_main{ nullptr };
        PanelDiary*                 panel_diary{ nullptr };
        PanelExtra*                 panel_extra{ nullptr };

        ViewLogin*                  m_view_login{ nullptr };
        DiaryView*                  m_diary_view{ nullptr };
        EntryView*                  m_entry_view{ nullptr };
        TagView*                    m_tag_view{ nullptr };
        CategoryTagsView*           m_ctg_tags_view{ nullptr };
        ChapterView*                m_chapter_view{ nullptr };
        FilterView*                 m_filter_view{ nullptr };

        Gtk::HeaderBar*             m_Hb_main;

    protected:
        bool                        on_delete_event( GdkEventAny* );

        // WIDGETS
        Gtk::Box*                   m_Bx_main;
        Gtk::Stack*                 m_St_main{ nullptr };
        Gtk::InfoBar*               m_IB_info;
        Gtk::Label*                 m_L_info;
        Gtk::Button*                m_B_info;

        Gtk::Paned*                 m_paned_entry{ nullptr };
        Gtk::Paned*                 m_paned_main{ nullptr };

        sigc::connection            m_connection_backup;

        int                         m_seconds_remaining{ LOGOUT_COUNTDOWN + 1 };
        sigc::connection            m_connection_timeout;
        int                         m_auto_logout_status{ 1 }; // reflects the result of all factors
        InfoResponse                m_resp_cur; // FIXME: a most unfortunate solution!!
        bool                        m_flag_info_is_visible{ false };

        // ACTIONS
        Glib::RefPtr< Gtk::Action > m_action_undo;
        Glib::RefPtr< Gtk::Action > m_action_redo;

        Glib::RefPtr< Gio::SimpleAction > m_A_toggle_auto_logout;
        Glib::RefPtr< Gio::SimpleAction > m_A_logout_wo_saving;
        Glib::RefPtr< Gio::SimpleAction > m_A_show_preferences;
        Glib::RefPtr< Gio::SimpleAction > m_A_enable_editing;
};

} // end of namespace LIFEO

#endif
