package tests::UICommandWidgetTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;
use Lire::Test::CursesUIDriver;
use Curses::UI;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    my $spec = new Lire::Config::ConfigSpec();
    $spec->add( new Lire::Config::CommandSpec( 'name' => 'cmd_param' ) );
    $self->{'cmd_param'} = $spec->get( 'cmd_param' )->instance( 'value' => 'ls');
    $self->{'spec'} = $spec;

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'cmd_widget', 'Lire::UI::CommandWidget',
                                         'value' => $self->{'cmd_param'} );
    $self->assert_isa( 'Lire::UI::ExecutableWidget', $widget );
    $self->assert_isa( 'Lire::UI::CommandWidget', $widget,  );
}

1;
