/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.transaction.xa;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.transaction.xa.XAException;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class XAExceptionTest
extends TestCase {
    public void testPublicStatics() {
        Class<?> clazz;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("XAER_OUTSIDE", new Integer(-9));
        hashMap.put("XAER_DUPID", new Integer(-8));
        hashMap.put("XAER_RMFAIL", new Integer(-7));
        hashMap.put("XAER_PROTO", new Integer(-6));
        hashMap.put("XAER_INVAL", new Integer(-5));
        hashMap.put("XAER_NOTA", new Integer(-4));
        hashMap.put("XAER_RMERR", new Integer(-3));
        hashMap.put("XAER_ASYNC", new Integer(-2));
        hashMap.put("XA_RDONLY", new Integer(3));
        hashMap.put("XA_RETRY", new Integer(4));
        hashMap.put("XA_HEURMIX", new Integer(5));
        hashMap.put("XA_HEURRB", new Integer(6));
        hashMap.put("XA_HEURCOM", new Integer(7));
        hashMap.put("XA_HEURHAZ", new Integer(8));
        hashMap.put("XA_NOMIGRATE", new Integer(9));
        hashMap.put("XA_RBEND", new Integer(107));
        hashMap.put("XA_RBTRANSIENT", new Integer(107));
        hashMap.put("XA_RBTIMEOUT", new Integer(106));
        hashMap.put("XA_RBPROTO", new Integer(105));
        hashMap.put("XA_RBOTHER", new Integer(104));
        hashMap.put("XA_RBINTEGRITY", new Integer(103));
        hashMap.put("XA_RBDEADLOCK", new Integer(102));
        hashMap.put("XA_RBCOMMFAIL", new Integer(101));
        hashMap.put("XA_RBROLLBACK", new Integer(100));
        hashMap.put("XA_RBBASE", new Integer(100));
        try {
            clazz = Class.forName("javax.transaction.xa.XAException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            XAExceptionTest.fail((String)"javax.transaction.xa.XAException class not found!");
            return;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 25;
        int n2 = 0;
        Field[] fieldArray2 = fieldArray;
        int n3 = 0;
        int n4 = fieldArray2.length;
        while (n3 < n4) {
            Field field = fieldArray2[n3];
            String string = field.getName();
            int n5 = field.getModifiers();
            if (Modifier.isPublic(n5) && Modifier.isStatic(n5)) {
                try {
                    Object object = field.get(null);
                    Object v = hashMap.get(string);
                    if (v == null) {
                        XAExceptionTest.fail((String)("Field " + string + " missing!"));
                    }
                    XAExceptionTest.assertEquals((String)("Field " + string + " value mismatch: "), v, (Object)object);
                    XAExceptionTest.assertEquals((String)("Field " + string + " modifier mismatch: "), (int)n, (int)n5);
                    ++n2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    XAExceptionTest.fail((String)("Illegal access to Field " + string));
                }
            }
            ++n3;
        }
    }

    public void testXAExceptionint() {
        int[] nArray = new int[7];
        nArray[0] = Integer.MIN_VALUE;
        nArray[1] = Integer.MAX_VALUE;
        nArray[3] = 1856939228;
        nArray[4] = -217759650;
        nArray[5] = -1808025128;
        nArray[6] = -69857128;
        int[] nArray2 = nArray;
        String[] stringArray = new String[7];
        Exception[] exceptionArray = new Exception[7];
        int n = nArray2.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                XAException xAException = new XAException(nArray2[n2]);
                if (exceptionArray[n2] != null) {
                    XAExceptionTest.fail();
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(n2) + "  Final state mismatch"), (String)xAException.getMessage(), (String)stringArray[n2]);
            }
            catch (Exception exception) {
                if (exceptionArray[n2] == null) {
                    XAExceptionTest.fail((String)(String.valueOf(n2) + "Unexpected exception"));
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(n2) + "Exception mismatch"), exception.getClass(), exceptionArray[n2].getClass());
                XAExceptionTest.assertEquals((String)(String.valueOf(n2) + "Exception mismatch"), (String)exception.getMessage(), (String)exceptionArray[n2].getMessage());
            }
            ++n2;
        }
    }

    public void testXAExceptionString() {
        String[] stringArray;
        String[] stringArray2 = new String[8];
        stringArray2[0] = "a";
        stringArray2[1] = "1";
        stringArray2[2] = "valid1";
        stringArray2[3] = "----";
        stringArray2[4] = "&valid*";
        stringArray2[6] = "";
        stringArray2[7] = "\u0000";
        String[] stringArray3 = stringArray = stringArray2;
        Exception[] exceptionArray = new Exception[8];
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                XAException xAException = new XAException(stringArray[n2]);
                if (exceptionArray[n2] != null) {
                    XAExceptionTest.fail();
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(n2) + "  Final state mismatch"), (String)xAException.getMessage(), (String)stringArray3[n2]);
            }
            catch (Exception exception) {
                if (exceptionArray[n2] == null) {
                    XAExceptionTest.fail((String)(String.valueOf(n2) + "Unexpected exception"));
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(n2) + "Exception mismatch"), exception.getClass(), exceptionArray[n2].getClass());
                XAExceptionTest.assertEquals((String)(String.valueOf(n2) + "Exception mismatch"), (String)exception.getMessage(), (String)exceptionArray[n2].getMessage());
            }
            ++n2;
        }
    }

    public void testXAException() {
        String[] stringArray = new String[1];
        Exception[] exceptionArray = new Exception[1];
        int n = 1;
        int n2 = 0;
        while (n2 < n) {
            try {
                XAException xAException = new XAException();
                if (exceptionArray[n2] != null) {
                    XAExceptionTest.fail();
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(n2) + "  Final state mismatch"), (String)xAException.getMessage(), (String)stringArray[n2]);
            }
            catch (Exception exception) {
                if (exceptionArray[n2] == null) {
                    XAExceptionTest.fail((String)(String.valueOf(n2) + "Unexpected exception"));
                }
                XAExceptionTest.assertEquals((String)(String.valueOf(n2) + "Exception mismatch"), exception.getClass(), exceptionArray[n2].getClass());
                XAExceptionTest.assertEquals((String)(String.valueOf(n2) + "Exception mismatch"), (String)exception.getMessage(), (String)exceptionArray[n2].getMessage());
            }
            ++n2;
        }
    }

    public void testPublicFields() {
        int n = 1;
        XAException xAException = new XAException();
        xAException.errorCode = n;
        XAExceptionTest.assertEquals((String)"Public field mismatch: ", (int)xAException.errorCode, (int)n);
    }
}

