/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__SYNCHRONIZED_HPP)
#include <Synchronized.hpp>
#endif

#if   !defined(__CORELINUXGUARDPOOL_HPP)
#include <CoreLinuxGuardPool.hpp>
#endif

namespace   corelinux
{
   //
   // Default constructor
   //

   Synchronized::Synchronized( void )
   {
      ;  // do nothing
   }

   //
   // Copy constructor
   //

   Synchronized::Synchronized( SynchronizedCref )
   {
      ;  // do nothing
   }

   //
   // Virtual Destructor
   //

   Synchronized::~Synchronized( void )
   {
      ;  // do nothing
   }

   //
   // Operator assignment
   //

   SynchronizedRef Synchronized::operator=( SynchronizedCref )
   {
      return ( *this );
   }

   //
   // Equality operator
   //

   bool  Synchronized::operator==( SynchronizedCref aSynch ) const
   {
      return ( this == &aSynch );
   }

   //
   // The reason for living
   //

   Synchronized::Guard Synchronized::access( void ) const throw(SemaphoreException)
   {
      Guard aGuard((SynchronizedPtr)this);
      return aGuard;
   }

   //
   // Default Guard Constructor
   //

   Synchronized::Guard::Guard( void  )
      :
      theSynchronized( NULLPTR )
   {

   }

   //
   // Default Guard call
   //

   Synchronized::Guard::Guard( SynchronizedPtr aSynchPtr )
      :
      theSynchronized( aSynchPtr )
   {
      CoreLinuxGuardPool::lock( theSynchronized );
   }

   //
   // Copy constructor
   //

   Synchronized::Guard::Guard( GuardCref aGuard )
      :
      theSynchronized( aGuard.theSynchronized )
   {
      aGuard.theSynchronized = NULLPTR;
   }

   //
   // Assignment operator never called
   //

   Synchronized::GuardRef Synchronized::Guard::operator=
      ( 
         GuardCref 
      )
   {
      return (*this);
   }

   //
   // Destructor
   //

   Synchronized::Guard::~Guard( void  )
   {
      this->release();
   }

   void Synchronized::Guard::release( void )
   {
      if( theSynchronized != NULLPTR )
      {
         CoreLinuxGuardPool::release( theSynchronized );
         theSynchronized = NULLPTR;
      }
      else
      {
         ; // do nothing
      }
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.4 $
   $Date: 2000/06/06 12:04:12 $
   $Locker:  $
*/


