/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__EX21_HPP)
#define  __EX21_HPP

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__ABSTRACTSEMAPHORE_HPP)
#include <corelinux/AbstractSemaphore.hpp>
#endif

#if   !defined(__MUTEXSEMAPHOREGROUP_HPP)
#include <corelinux/MutexSemaphoreGroup.hpp>
#endif

#if   !defined(__MEMORY_HPP)
#include <corelinux/Memory.hpp>
#endif

using namespace corelinux;

//
// Type declarations
//

struct   _TransferBlock
{
   Int   theTotalSize;
   Int   theEntrySize;
   Char  theData[1];
};

DECLARE_TYPE( struct _TransferBlock, TransferBlock );

//
// Constants
//

const CharCptr  theSemName = {"ex21sem"};
const CharCptr  theMemName = {"ex21mem"};

static   SemaphoreIdentifier     theServerSemId(0);
static   SemaphoreIdentifier     theClientSemId(1);


#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/06/05 02:39:42 $
   $Locker:  $
*/

