/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Locale;

import javax.servlet.http.HttpSession;

import junit.framework.TestCase;
import net.noderunner.http.ContentType;
import net.noderunner.http.ServerRequest;

public class HttpServletRequestImplTest extends TestCase {
	
	HttpServletRequestImpl req;
	String euro = "\u20AC";
	Socket socket;
	String uri = "/?a=b&c=d";

	public void setUp() throws Exception {
		String s= 
			"GET " + uri + " HTTP/1.1" + "\r\n" + 
			"Content-Length: 3" +  "\r\n" +
			"Content-Type: text/xml; encoding=UTF-8" +  "\r\n" +
			"x-Date: " + new HttpDateFormat().format(new Date()) + "\r\n" +
			"\r\n" +
			euro + "\r\n";
		ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes("UTF-8"));
		ServerRequest sreq = new ServerRequest(is);
    	req = new HttpServletRequestImpl(sreq);
    	ServerSocket ss = new ServerSocket(0);
		req.serverSocket(ss);
    	socket = new Socket("localhost", ss.getLocalPort());
		req.remoteAddress((InetSocketAddress)socket.getLocalSocketAddress());
		ss.close();
	}
	
	public void tearDown() throws Exception {
		socket.close();
	}
	
	public void testSimple2() throws Exception {
		assertEquals(null, req.getAuthType());
		assertEquals(uri, req.getRequestURI());
		assertEquals(uri, req.getRequestURL().toString());
		assertEquals(0, req.getCookies().length);
		assertEquals(3, req.getContentLength());
		assertEquals("UTF-8", req.getCharacterEncoding());
		assertEquals(euro, req.getReader().readLine());
		assertEquals("text", ContentType.parse(req.getContentType()).getType());
		req.getLocalAddr();
		req.getLocalName();
		assertEquals(2, req.getParameterMap().size());
		assertEquals("b", req.getParameter("a"));
		assertEquals(null, req.getParameter("notHere"));
		req.getParameterNames();
		assertEquals("b", req.getParameterValues("a")[0]);
		
		req.setAttribute("key", "val");
		assertEquals("val", req.getAttribute("key"));
		assertEquals(true, req.getAttributeNames().hasMoreElements());
		req.removeAttribute("key");
		assertEquals(null, req.getAttribute("key"));
		req.setCharacterEncoding("ASCII");
		assertEquals(socket.getPort(), req.getServerPort());
		
		assertEquals(Locale.getDefault(), req.getLocale());
		assertEquals(Locale.getDefault(), req.getLocales().nextElement());
		
		assertEquals(false, req.isSecure());
		assertTrue(req.getDateHeader("x-Date") <= System.currentTimeMillis());
		assertEquals("3", req.getHeader("Content-length"));
		assertEquals(3, req.getIntHeader("Content-length"));
		assertEquals(true, req.getHeaderNames().hasMoreElements());
		
		assertEquals(false, req.isUserInRole("user"));
		assertEquals(null, req.getUserPrincipal());
		
		assertEquals(null, req.getSession(false));
		HttpSession session = req.getSession();
		assertSame(session, req.getSession(false));
		assertSame(session, req.getSession(true));
		
		assertEquals(-1, req.getInputStream().read());
	}
	
}
