package org.jboss.test.managed.factory.support.mcf;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;

/**
 * A LocalDataSourceDeploymentMetaData.
 * 
 * @author <a href="weston.price@jboss.org">Weston Price</a>
 * @version $Revision: 1.1 $
 */
@XmlType(name="local-tx-datasource")
@XmlAccessorType(XmlAccessType.FIELD)
@ManagementObject(componentType=@ManagementComponent(type="DataSource",subtype="LocalTx"))
public class LocalDataSourceDeploymentMetaData extends NonXADataSourceDeploymentMetaData
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -1513179292986405426L;

   public LocalDataSourceDeploymentMetaData()
   {
      setLocalTransactions(true);
      setTransactionSupportMetaData(ManagedConnectionFactoryTransactionSupportMetaData.LOCAL);
   }

   @Override
   public Boolean getLocalTransactions()
   {
      return Boolean.TRUE;
   }

}
