#ifndef FILELOGGER_H_
#define FILELOGGER_H_

#include "BaseLogger.h"

#include <stdio.h>
#include <jni.h>
#include <zlib.h>


class GZFileLogger : public BaseLogger
{
public:
	GZFileLogger();
	virtual ~GZFileLogger();
	
	/** returns TRUE if the file could be opened OK, FALSE otherwise */
	short openFile(char * name);
	
	void closeFile()
	{
		isOpened=0;
		gzclose(outFile);
	}
	
	gzFile outFile;
	
	int write(const void * buffer, size_t len) const
	{
		return gzwrite(outFile,buffer,len);
	}
	
	
private:
    int lastReturnOperation;
    char * fileName;
    short isOpened;
	
	
};

#endif /*FILELOGGER_H_*/
