/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import sun.misc.REException;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveStream;
import sun.net.www.http.PosterOutputStream;
import sun.security.action.GetPropertyAction;

public class HttpClient
extends NetworkClient {
    protected boolean cachedHttpClient = false;
    private boolean inCache;
    MessageHeader requests;
    PosterOutputStream poster = null;
    boolean failedOnce = false;
    private static RegexpPool nonProxyHostsPool = null;
    private static String nonProxyHostsSource = null;
    private static final int HTTP_CONTINUE = 100;
    static final int httpPortNumber = 80;
    public static String proxyHost = null;
    public static int proxyPort = 80;
    private String instProxy = null;
    private int instProxyPort = -1;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    protected String host;
    protected int port;
    protected static KeepAliveCache kac = new KeepAliveCache();
    private static boolean keepAliveProp = true;
    volatile boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout = 0;
    protected URL url;
    public boolean reuse = false;

    protected int getDefaultPort() {
        return 80;
    }

    public static synchronized void resetProperties() {
    }

    int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    private String getProxyHost() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
        if (string == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private int getProxyPort() {
        final int[] nArray = new int[]{0};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                nArray[0] = System.getProperty("http.proxyHost") != null ? Integer.getInteger("http.proxyPort", 80).intValue() : Integer.getInteger("proxyPort", 80).intValue();
                return null;
            }
        });
        return nArray[0];
    }

    public boolean getHttpKeepAliveSet() {
        return keepAliveProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchNonProxyHosts(String string) {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("http.nonProxyHosts"));
            if (string2 == null) {
                nonProxyHostsPool = null;
            } else if (!string2.equals(nonProxyHostsSource)) {
                RegexpPool regexpPool = new RegexpPool();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        regexpPool.add(stringTokenizer.nextToken().toLowerCase(), Boolean.TRUE);
                    }
                }
                catch (REException rEException) {
                    System.err.println("Error in http.nonProxyHosts system property:  " + rEException);
                }
                nonProxyHostsPool = regexpPool;
            }
            nonProxyHostsSource = string2;
        }
        if (nonProxyHostsPool == null) {
            return false;
        }
        return nonProxyHostsPool.match(string) != null;
    }

    protected HttpClient() {
    }

    private HttpClient(URL uRL) throws IOException {
        this(uRL, null, -1, false);
    }

    protected HttpClient(URL uRL, boolean bl) throws IOException {
        this(uRL, null, -1, bl);
    }

    public HttpClient(URL uRL, String string, int n) throws IOException {
        this(uRL, string, n, false);
    }

    private HttpClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.proxyDisabled = bl;
        if (!bl) {
            this.instProxy = string;
            this.instProxyPort = n < 0 ? this.getDefaultPort() : n;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            this.host = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.host = uRL.getHost();
        }
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.openServer();
    }

    public static HttpClient New(URL uRL) throws IOException {
        return HttpClient.New(uRL, true);
    }

    public static HttpClient New(URL uRL, boolean bl) throws IOException {
        return HttpClient.New(uRL, null, -1, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient New(URL uRL, String string, int n, boolean bl) throws IOException {
        Object object;
        HttpClient httpClient = null;
        if (bl && (httpClient = (HttpClient)kac.get(uRL, null)) != null) {
            object = httpClient;
            synchronized (object) {
                httpClient.cachedHttpClient = true;
                httpClient.inCache = false;
            }
        }
        if (httpClient == null) {
            httpClient = new HttpClient(uRL, string, n);
        } else {
            object = System.getSecurityManager();
            if (object != null) {
                ((SecurityManager)object).checkConnect(uRL.getHost(), uRL.getPort());
            }
            httpClient.url = uRL;
        }
        return httpClient;
    }

    public void finished() {
        if (this.reuse) {
            return;
        }
        --this.keepAliveConnections;
        if (this.keepAliveConnections > 0 && this.isKeepingAlive() && !this.serverOutput.checkError()) {
            this.putInKeepAliveCache();
        } else {
            this.closeServer();
        }
    }

    protected synchronized void putInKeepAliveCache() {
        if (this.inCache) {
            return;
        }
        this.inCache = true;
        kac.put(this.url, null, this);
    }

    public void closeIdleConnection() {
        HttpClient httpClient = (HttpClient)kac.get(this.url, null);
        if (httpClient != null) {
            httpClient.closeServer();
        }
    }

    public void openServer(String string, int n) throws IOException {
        this.serverSocket = this.doConnect(string, n);
        try {
            this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()), false, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + " encoding not found");
        }
        this.serverSocket.setTcpNoDelay(true);
    }

    public boolean needsTunneling() {
        return false;
    }

    public boolean isCachedConnection() {
        return this.cachedHttpClient;
    }

    public void afterConnect() throws IOException, UnknownHostException {
    }

    private synchronized void privilegedOpenServer(final String string, final int n) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.openServer(string, n);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void superOpenServer(String string, int n) throws IOException, UnknownHostException {
        super.openServer(string, n);
    }

    private synchronized void privilegedSuperOpenServer(final String string, final int n) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.superOpenServer(string, n);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private boolean isLoopback(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.equalsIgnoreCase("localhost")) {
            return true;
        }
        if (!Character.isDigit(string.charAt(0))) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return false;
            }
            int n2 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return false;
                }
                n2 = n2 * 10 + c - 48;
                if (++i >= cArray.length) break;
                c = cArray[i];
            }
            if (n2 > 255) {
                return false;
            }
            if (bl) {
                bl = false;
                if (n2 != 127) {
                    return false;
                }
            }
            ++n;
        }
        return n == 4 && !string.endsWith(".");
    }

    protected synchronized void openServer() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        if (this.keepingAlive) {
            return;
        }
        String string = this.url.getHost().toLowerCase();
        boolean bl = this.isLoopback(string);
        if (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https")) {
            if (this.instProxy != null && !bl) {
                this.privilegedOpenServer(this.instProxy, this.instProxyPort);
                this.usingProxy = true;
                return;
            }
            String string2 = this.getProxyHost();
            if (!(string2 == null || this.proxyDisabled || bl || this.matchNonProxyHosts(string) || this.matchNonProxyHosts(this.host))) {
                try {
                    int n = this.getProxyPort();
                    this.privilegedOpenServer(string2, n);
                    this.instProxy = string2;
                    this.instProxyPort = n;
                    this.usingProxy = true;
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.openServer(this.host, this.port);
            this.usingProxy = false;
            return;
        }
        if (this.instProxy != null && !bl) {
            this.privilegedSuperOpenServer(this.instProxy, this.instProxyPort);
            this.usingProxy = true;
            return;
        }
        String string3 = this.getProxyHost();
        if (!(string3 == null || this.proxyDisabled || bl || this.matchNonProxyHosts(string) || this.matchNonProxyHosts(this.host))) {
            try {
                int n = this.getProxyPort();
                this.privilegedSuperOpenServer(string3, n);
                this.instProxy = string3;
                this.instProxyPort = n;
                this.usingProxy = true;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.openServer(this.host, this.port);
        this.usingProxy = false;
    }

    public String getURLFile() throws IOException {
        String string = this.url.getFile();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (this.usingProxy) {
            string = this.url.toExternalForm();
        }
        if (string.indexOf(10) == -1) {
            return string;
        }
        throw new MalformedURLException("Illegal character in URL");
    }

    public void writeRequests(MessageHeader messageHeader) {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public void writeRequests(MessageHeader messageHeader, PosterOutputStream posterOutputStream) throws IOException {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.poster = posterOutputStream;
        if (this.poster != null) {
            this.poster.writeTo(this.serverOutput);
        }
        this.serverOutput.flush();
    }

    public boolean parseHTTP(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        try {
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            return this.parseHTTPHeader(messageHeader, progressEntry);
        }
        catch (IOException iOException) {
            this.closeServer();
            if (!this.failedOnce && this.requests != null) {
                this.failedOnce = true;
                this.openServer();
                this.writeRequests(this.requests, this.poster);
                return this.parseHTTP(messageHeader, progressEntry);
            }
            throw iOException;
        }
    }

    public int setTimeout(int n) throws SocketException {
        int n2 = this.serverSocket.getSoTimeout();
        this.serverSocket.setSoTimeout(n);
        return n2;
    }

    private boolean parseHTTPHeader(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        int n;
        int n2;
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean bl = false;
        byte[] byArray = new byte[8];
        this.serverInput.mark(10);
        for (n = 0; n < 8 && (n2 = this.serverInput.read(byArray, n, 8 - n)) >= 0; n += n2) {
        }
        String string = null;
        bl = byArray[0] == 72 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 80 && byArray[4] == 47 && byArray[5] == 49 && byArray[6] == 46;
        this.serverInput.reset();
        if (bl) {
            messageHeader.parseHeader(this.serverInput);
            if (this.usingProxy) {
                string = messageHeader.findValue("Proxy-Connection");
            }
            if (string == null) {
                string = messageHeader.findValue("Connection");
            }
            if (string != null && string.toLowerCase().equals("keep-alive")) {
                HeaderParser headerParser = new HeaderParser(messageHeader.findValue("Keep-Alive"));
                if (headerParser != null) {
                    this.keepAliveConnections = headerParser.findInt("max", this.usingProxy ? 50 : 5);
                    this.keepAliveTimeout = headerParser.findInt("timeout", this.usingProxy ? 60 : 5);
                }
            } else if (byArray[7] != 48) {
                this.keepAliveConnections = string != null ? 1 : 5;
            }
        } else {
            if (n != 8) {
                if (!this.failedOnce && this.requests != null) {
                    this.failedOnce = true;
                    this.closeServer();
                    this.openServer();
                    this.writeRequests(this.requests, this.poster);
                    return this.parseHTTP(messageHeader, progressEntry);
                }
                throw new SocketException("Unexpected end of file from server");
            }
            messageHeader.set("Content-type", "unknown/unknown");
        }
        n = -1;
        try {
            string = messageHeader.getValue(0);
            int n3 = string.indexOf(32);
            while (string.charAt(n3) == ' ') {
                ++n3;
            }
            n = Integer.parseInt(string.substring(n3, n3 + 3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 100) {
            messageHeader.reset();
            return this.parseHTTPHeader(messageHeader, progressEntry);
        }
        int n4 = -1;
        String string2 = null;
        try {
            string2 = messageHeader.findValue("Transfer-Encoding");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null && string2.equalsIgnoreCase("chunked")) {
            this.serverInput = new ChunkedInputStream(this.serverInput, this, messageHeader);
            if (this.keepAliveConnections < 0) {
                this.keepAliveConnections = 1;
            }
            this.keepingAlive = true;
            this.failedOnce = false;
        } else {
            try {
                n4 = Integer.parseInt(messageHeader.findValue("content-length"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.keepAliveConnections > 1 && (n4 >= 0 || n == 304 || n == 204)) {
                this.keepingAlive = true;
            } else if (this.keepingAlive) {
                this.keepingAlive = false;
            }
        }
        if (n4 > 0) {
            progressEntry.setType(this.url.getFile(), messageHeader.findValue("content-type"));
            progressEntry.update(0, n4);
            if (this.isKeepingAlive()) {
                this.serverInput = new KeepAliveStream(this.serverInput, progressEntry, this);
                this.failedOnce = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, progressEntry);
            }
        } else {
            ProgressData.pdata.unregister(progressEntry);
        }
        return bl;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.url + ")";
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    protected void finalize() throws Throwable {
    }

    public void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return this.instProxy;
    }

    public int getProxyPortUsed() {
        return this.instProxyPort;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("http.keepAlive");
            }
        });
        keepAliveProp = string != null ? Boolean.valueOf(string) : true;
    }
}

