/* carray3d.h
 */
#ifndef OSL_MISC_CARRAY3D_H
#define OSL_MISC_CARRAY3D_H

#include "osl/misc/carray.h"
#include "osl/misc/carray2d.h"
namespace osl
{
  namespace misc
  {
    template <class T, size_t Capacity1, size_t Capacity2, size_t Capacity3>
    struct CArray3d 
      : public CArray<CArray2d<T,Capacity2,Capacity3>,Capacity1>
    {
      typedef CArray<CArray2d<T,Capacity2,Capacity3>,Capacity1> base_t;
      void fill(T value=T()){
	for (size_t i=0; i<Capacity1; i++)
	  base_t::operator[](i).fill(value);
      }
    };
  }
  using misc::CArray3d;
}

#endif /* OSL_MISC_CARRAY3D_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
