/* kakinoki.h
 */
#ifndef OSL_KAKINOKI_H
#define OSL_KAKINOKI_H

#include "osl/record/record.h"
#include "osl/state/numEffectState.h"
#include <boost/shared_ptr.hpp>
#include <string>
#include <iosfwd>
#include <stdexcept>

namespace osl
{
  namespace record
  {
    namespace kakinoki
    {
      Move strToMove(const std::string&, const SimpleState&, 
		     Move last_move=Move());
      std::pair<Player,Ptype> strToPiece(const std::string&);

      class InputStream : public IRecordStream
      {
      private:
	std::istream& is;
	SimpleState state;
        boost::shared_ptr<RecordVisitor> rv;
      public:
	InputStream(std::istream& is);
	InputStream(std::istream& is, boost::shared_ptr<RecordVisitor> rv);
	virtual ~InputStream();

	virtual void load(Record*);
	const SimpleState& getState() const { return state;}
      };

      class KakinokiFile
      {
      private:
	Record rec;
      public:
	KakinokiFile(const std::string& filename);
	~KakinokiFile();

	Record const& getRecord() const;
	const NumEffectState getInitialState() const;

	static bool isKakinokiFile(const std::string& filename);
      };

      struct KakinokiIOError : public std::runtime_error
      {
	KakinokiIOError(const std::string& w) : std::runtime_error(w)
	{
	}
      };
    } // namespace kakinoki
  }
  using record::kakinoki::KakinokiFile;
  using record::kakinoki::KakinokiIOError;
}

#endif /* OSL_KAKINOKI_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
