/**
 * centering3x3.t.cc
 */
#include "osl/centering3x3.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;

class Centering3x3Test : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(Centering3x3Test);
  CPPUNIT_TEST(test11);
  CPPUNIT_TEST(test22);
  CPPUNIT_TEST(testXY);
  CPPUNIT_TEST_SUITE_END();
public:
  void testXY();
  void test11();
  void test22();
};

CPPUNIT_TEST_SUITE_REGISTRATION(Centering3x3Test);

void Centering3x3Test::test11()
{
  CPPUNIT_ASSERT_EQUAL(Square(2,2), 
		       Centering3x3::adjustCenter(Square(1,1)));
}
void Centering3x3Test::test22()
{
  CPPUNIT_ASSERT_EQUAL(Square(2,2), 
		       Centering3x3::adjustCenter(Square(2,2)));
}


void Centering3x3Test::testXY()
{
  for (int y=0; y<=10; ++y)
  {
    for (int x=0; x<=10; ++x)
    {
      const Square target = Square(x,y);
      if (target.isOnBoard())
      {
	CPPUNIT_ASSERT_EQUAL(Centering3x3::adjustCenterNaive(target),
			     Centering3x3::adjustCenter(target));
      }
      else
      {
	CPPUNIT_ASSERT(Centering3x3::adjustCenter(target).isPieceStand());
      }
    }
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
