#include "osl/checkmate/proofDisproof.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
using namespace osl;
using namespace osl::checkmate;

class ProofDisproofTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(ProofDisproofTest);
  CPPUNIT_TEST(testFinal);
  CPPUNIT_TEST(testOrder);
  CPPUNIT_TEST_SUITE_END();
 public:
  void testFinal();
  void testOrder();
};

CPPUNIT_TEST_SUITE_REGISTRATION(ProofDisproofTest);

void ProofDisproofTest::testOrder()
{
  CPPUNIT_ASSERT(ProofDisproof::PawnCheckmate().isBetterForAttack(ProofDisproof::NoCheckmate()));
  CPPUNIT_ASSERT(ProofDisproof::LoopDetection().isBetterForAttack(ProofDisproof::PawnCheckmate()));
  CPPUNIT_ASSERT(ProofDisproof::Unknown ().isBetterForAttack(ProofDisproof::LoopDetection()));
  CPPUNIT_ASSERT(ProofDisproof::NoEscape     ().isBetterForAttack(ProofDisproof::Unknown()));
  // (1) 下の(2)との両立が難しいのでアルゴリズムで対処する
  // SafeMoveFilter 導入したので大丈夫のはず?
  // CPPUNIT_ASSERT(isBetterForAttack(Checkmate, NoEscape));

  CPPUNIT_ASSERT(ProofDisproof::NoCheckmate  ().isBetterForDefense(ProofDisproof::PawnCheckmate()));
  CPPUNIT_ASSERT(ProofDisproof::PawnCheckmate().isBetterForDefense(ProofDisproof::LoopDetection()));
  CPPUNIT_ASSERT(ProofDisproof::LoopDetection().isBetterForDefense(ProofDisproof::Unknown()));
  CPPUNIT_ASSERT(ProofDisproof::Unknown      ().isBetterForDefense(ProofDisproof::Checkmate()));
  // (2) NoEscape の手はルール上指せないので Checkmate の方が好ましいとしておく
  CPPUNIT_ASSERT(ProofDisproof::Checkmate().isBetterForDefense(ProofDisproof::NoEscape()));

  CPPUNIT_ASSERT(ProofDisproof::NoCheckmate().isBetterForAttack(ProofDisproof::Bottom()));
  CPPUNIT_ASSERT(ProofDisproof::Checkmate  ().isBetterForAttack(ProofDisproof::Bottom()));

  CPPUNIT_ASSERT(ProofDisproof::NoCheckmate().isBetterForDefense(ProofDisproof::Bottom()));
  CPPUNIT_ASSERT(ProofDisproof::Checkmate  ().isBetterForDefense(ProofDisproof::Bottom()));
}

void ProofDisproofTest::testFinal()
{
  CPPUNIT_ASSERT(ProofDisproof::NoCheckmate().isFinal());
  CPPUNIT_ASSERT(ProofDisproof::Checkmate  ().isFinal());

  CPPUNIT_ASSERT(ProofDisproof::PawnCheckmate().proof() > 0);
  CPPUNIT_ASSERT(ProofDisproof::PawnCheckmate().disproof() == 0);
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
