#include "osl/player.h"
#include "osl/oslConfig.h"
#include <iostream>
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
using namespace osl;

class playerTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE( playerTest );
  CPPUNIT_TEST( testAlt );
  CPPUNIT_TEST( testShow );
  CPPUNIT_TEST_SUITE_END();
 public:
  void testAlt();
  void testShow();
  void testLinkError();
};

CPPUNIT_TEST_SUITE_REGISTRATION(playerTest);

void playerTest::testAlt(){
  CPPUNIT_ASSERT( alt(BLACK)==WHITE );
  CPPUNIT_ASSERT( alt(WHITE)==BLACK );
}

void playerTest::testShow(){
  if (OslConfig::verbose())
  {
    std::cout << BLACK << std::endl;
    std::cout << WHITE << std::endl;
  }
}

void playerTest::testLinkError()
{
#if 0
  int a = BLACK + 1;
  int b = 1 - WHITE;
  int b = 3 * WHITE == BLACK ? 1 : -1;
#endif
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
