#include "osl/record/opening/bookInMemory.h"
#include "osl/state/numEffectState.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>

class BookInMemoryTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE(BookInMemoryTest);
  CPPUNIT_TEST(testInstance);
  CPPUNIT_TEST(testFind);
  CPPUNIT_TEST_SUITE_END();
public:
  void testInstance();
  void testFind();
};

CPPUNIT_TEST_SUITE_REGISTRATION(BookInMemoryTest);
using namespace osl;

void BookInMemoryTest::testInstance()
{
  const BookInMemory& book = BookInMemory::instance();
  CPPUNIT_ASSERT(book.size() < 100000); // do not consume too much memory
}

void BookInMemoryTest::testFind()
{
  const BookInMemory& book = BookInMemory::instance();
  NumEffectState initial;
  HashKey key(initial);
  MoveVector moves;
  book.find(key, moves);
  CPPUNIT_ASSERT(! moves.empty());
  const Move m76fu(Square(7,7), Square(7,6), PAWN, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT_EQUAL(m76fu, moves[0]);
  
  moves.clear();
  book.find(key.newMakeMove(m76fu), moves);
  CPPUNIT_ASSERT(! moves.empty());
  const Move m34fu(Square(3,3), Square(3,4), PAWN, PTYPE_EMPTY, false, WHITE);
  CPPUNIT_ASSERT_EQUAL(m34fu, moves[0]);
}

// ;;; local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
