
# Osmium example programs

The programs in this directory are intended as examples for developers. They
contain extensive comments explaining what's going on. Note that the examples
only cover a small part of what Osmium can do, you should also read the manuals
and API documentation.

All programs can be run without arguments and they will tell you how to use
them.

## Very simple examples

* [`osmium_read`](./osmium_read.cpp)
* [`osmium_count`](./osmium_count.cpp)
* [`osmium_debug`](./osmium_debug.cpp)
* [`osmium_tiles`](./osmium_tiles.cpp)

## Still reasonably simple examples

* [`osmium_amenity_list`](./osmium_amenity_list.cpp)
* [`osmium_read_with_progress`](./osmium_read_with_progress.cpp)
* [`osmium_filter_discussions`](./osmium_filter_discussions.cpp)
* [`osmium_convert`](./osmium_convert.cpp)
* [`osmium_pub_names`](./osmium_pub_names.cpp)
* [`osmium_road_length`](./osmium_road_length.cpp)

## More advanced examples

* [`osmium_area_test`](./osmium_area_test.cpp)
* [`osmium_create_pois`](./osmium_create_pois.cpp)
* [`osmium_tags_filter`](./osmium_tags_filter.cpp)

## Even more advanced examples

* [`osmium_change_tags`](./osmium_change_tags.cpp)
* [`osmium_location_cache_create`](./osmium_location_cache_create.cpp)
* [`osmium_location_cache_use`](./osmium_location_cache_use.cpp)
* [`osmium_dump_internal`](./osmium_dump_internal.cpp)
* [`osmium_index_lookup`](./osmium_index_lookup.cpp)

## License

The code in these example files is released into the Public Domain. Feel free
to copy the code and build on it.

