/* This code comes right from the msXpertSuite software project.
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QObject>
#include <QString>
#include <QWidget>
#include <QBrush>
#include <QColor>
#include <QVector>


/////////////////////// QCustomPlot
#include <qcustomplot.h>


/////////////////////// Local includes
#include "../../exportinmportconfig.h"
#include "basecolormapplotwidget.h"


namespace pappso
{


class PMSPP_LIB_DECL DriftSpecMassSpecColorMapPlotWidget
  : public BaseColorMapPlotWidget
{
  Q_OBJECT;

  public:
  explicit DriftSpecMassSpecColorMapPlotWidget(QWidget *parent,
                                               const QString &x_axis_label,
                                               const QString &y_axis_label);

  virtual ~DriftSpecMassSpecColorMapPlotWidget();

  virtual void keyPressEvent(QKeyEvent *event) override;
  virtual void keyReleaseEvent(QKeyEvent *event) override;

  virtual void mouseMoveHandler(QMouseEvent *event) override;

  virtual void mousePressHandler(QMouseEvent *event) override;
  virtual void mouseReleaseHandler(QMouseEvent *event) override;

  virtual void mouseMoveHandlerNotDraggingCursor() override;
  virtual void mouseMoveHandlerDraggingCursor() override;

  signals:

  // Here we have signals that are specific of the mass spectrum-oriented
  // version of the plot widget.

  protected:
};


} // namespace pappso
