/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.conf.ModifiableProperty;
import com.mysql.cj.api.conf.PropertyDefinition;
import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.jdbc.JdbcPropertySet;
import com.mysql.cj.core.conf.DefaultPropertySet;
import com.mysql.cj.core.conf.PropertyDefinitions;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcPropertySetImpl
extends DefaultPropertySet
implements JdbcPropertySet {
    private static final long serialVersionUID = -8223499903182568260L;

    @Override
    public <T> ModifiableProperty<T> getJdbcModifiableProperty(String name) throws SQLException {
        try {
            return this.getModifiableProperty(name);
        }
        catch (CJException ex) {
            throw SQLExceptionsMapping.translateException(ex);
        }
    }

    @Override
    public void postInitialization() {
        String testEncoding;
        if (this.getIntegerReadableProperty("maxRows").getValue() == 0) {
            super.getModifiableProperty("maxRows").setValue(-1, null);
        }
        if ((testEncoding = this.getStringReadableProperty("characterEncoding").getValue()) != null) {
            String testString = "abc";
            StringUtils.getBytes(testString, testEncoding);
        }
        if (this.getBooleanReadableProperty("useCursorFetch").getValue().booleanValue()) {
            super.getModifiableProperty("useServerPrepStmts").setValue(true);
        }
    }

    @Override
    public DriverPropertyInfo[] exposeAsDriverPropertyInfo(Properties info, int slotsToReserve) throws SQLException {
        this.initializeProperties(info);
        int numProperties = PropertyDefinitions.PROPERTY_NAME_TO_PROPERTY_DEFINITION.keySet().size();
        int listSize = numProperties + slotsToReserve;
        DriverPropertyInfo[] driverProperties = new DriverPropertyInfo[listSize];
        int i2 = slotsToReserve;
        for (String propName : PropertyDefinitions.PROPERTY_NAME_TO_PROPERTY_DEFINITION.keySet()) {
            ReadableProperty propToExpose = this.getReadableProperty(propName);
            if (info != null) {
                propToExpose.initializeFrom(info, null);
            }
            driverProperties[i2++] = this.getAsDriverPropertyInfo(propToExpose);
        }
        return driverProperties;
    }

    private DriverPropertyInfo getAsDriverPropertyInfo(ReadableProperty<?> pr) {
        PropertyDefinition pdef = pr.getPropertyDefinition();
        DriverPropertyInfo dpi = new DriverPropertyInfo(pdef.getName(), null);
        dpi.choices = pdef.getAllowableValues();
        dpi.value = pr.getStringValue() != null ? pr.getStringValue() : null;
        dpi.required = false;
        dpi.description = pdef.getDescription();
        return dpi;
    }
}

