/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.plugins.enforcer.internal;

import java.util.function.Supplier;

import org.apache.maven.plugin.logging.Log;

/**
 * EnforcerLogger implementation for {@code WARN} execution level
 *
 * @author Slawomir Jaranowski
 * @since 3.2.0
 */
public class EnforcerLoggerWarn extends AbstractEnforcerLogger {

    public EnforcerLoggerWarn(Log log) {
        super(log);
    }

    @Override
    public void warnOrError(CharSequence message) {
        log.warn(message);
    }

    @Override
    public void warnOrError(Supplier<CharSequence> messageSupplier) {
        if (log.isWarnEnabled()) {
            log.warn(messageSupplier.get());
        }
    }
}
