#include "linear.h"
#include "helpers.h"
#include <math.h>



EXPORT int linear_model(igame, timediff, paddle_action)
struct gameplay *igame;
float timediff;
int (*paddle_action)(const float[2], struct gameball *);
{
	int lasttouch= (-1);
	if (igame->status != gamestatus_running) return PONG_ARGINVALID;
	// motion
	for (int idx= 0; idx <= 1; idx++)
		igame->ball.pos[idx]+= igame->ball.dir[idx] * timediff;
	// reflections (in the right order)
	int condition= PONG_SUCCESS;
	while (outside(&igame->ball)) {
		if (outby(igame->ball.pos[0]) * igame->ball.dir[0] > outby(igame->ball.pos[1]) * igame->ball.dir[1]) {
			// determine where the ball had passed the paddle
			int border= (igame->ball.pos[0] > .5f);
			if (fabs(igame->ball.dir[0]) < GAME_NUM_EPS)
				return PONG_INTERROR;

			// try avoiding endless loops caused by paddle implementation issues
			if (lasttouch == border) return PONG_INTERROR;
			lasttouch= border;

			float crosstime= ( ((float)border) - igame->ball.pos[0] ) /igame->ball.dir[0]; 	// solve linear equation
			if (crosstime >GAME_NUM_EPS)
				return PONG_INTERROR; 	// back through time
			if (hit(&igame->pad[border], igame->ball.pos[1] + igame->ball.dir[1] *crosstime)) {
				// bounce off the paddle
				float cpos_abs= igame->ball.pos[1] + igame->ball.dir[1] *crosstime;
				float where[2]= { border, 0.5 };	// x coordinate

				if (igame->pad[border].size >0) 	// y coordinate relative to its size
					where[1]= (cpos_abs
						- igame->pad[border].mean + igame->pad[border].size/2)
						/ igame->pad[border].size;

				if ((condition= paddle_action(where, &igame->ball)) != PONG_SUCCESS)
					return condition;
				// compute the new ball position after the direction and velocity have been set by paddle_action()
				where[1]= cpos_abs;
				for (int idx= 0; idx<= 1; idx++) 	// forward from the time of collision based on the new motion vector
					igame->ball.pos[idx]= where[idx] + igame->ball.dir[idx] *(-crosstime);

				condition= PONG_PADHIT;
				continue;
			}
			// end the game
			igame->pad_attr[!border].score++; 	// <-- the model decides on the scoring system
			return PONG_SCORE;
		}
		else {
			// bounce off the wall
			int border= (igame->ball.dir[1] > 0);
			igame->ball.pos[1]= (2.f * (float)border) - igame->ball.pos[1];
			igame->ball.dir[1]*= (-1.f);

			// try avoiding endless loops caused by paddle implementation issues
			if (lasttouch == border+2) return PONG_INTERROR;
			lasttouch= border+2;
		}
	}
	return condition;
}

