// Copyright (c) Microsoft Open Technologies, Inc. All rights reserved. See License.txt in the project root for license information.

namespace System.Data.Entity.Core.Metadata.Edm
{
    /// <summary>
    ///     Represents the list of possible actions for delete operation
    /// </summary>
    public enum OperationAction
    {
        /// <summary>
        ///     no action
        /// </summary>
        None,

        /// <summary>
        ///     Cascade to other ends
        /// </summary>
        Cascade,

        /// <summary>
        ///     Do not allow if other ends are not empty
        /// </summary>
        Restrict,
    }
}
